/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.scheduler2;

import java.util.Date;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.scheduler.DateEvaluator;
import jp.ossc.nimbus.service.scheduler.DateKey;
import jp.ossc.nimbus.service.scheduler2.DateKeyConditionScheduleMakerServiceMBean;
import jp.ossc.nimbus.service.scheduler2.DefaultScheduleMakerService;
import jp.ossc.nimbus.service.scheduler2.ScheduleMakeException;
import jp.ossc.nimbus.service.scheduler2.ScheduleMaster;

public class DateKeyConditionScheduleMakerService
extends DefaultScheduleMakerService
implements DateKeyConditionScheduleMakerServiceMBean {
    private static final long serialVersionUID = 1985942168084980639L;
    private String dateKeyStr;
    private DateKey dateKey;
    private ServiceName dateEvaluatorServiceName;
    private DateEvaluator dateEvaluator;

    public void setDateKey(String key) {
        this.dateKeyStr = key;
    }

    public String getDateKey() {
        return this.dateKeyStr;
    }

    public void setDateEvaluatorServiceName(ServiceName name) {
        this.dateEvaluatorServiceName = name;
    }

    public ServiceName getDateEvaluatorServiceName() {
        return this.dateEvaluatorServiceName;
    }

    public void startService() throws Exception {
        if (this.dateEvaluatorServiceName != null) {
            this.dateEvaluator = (DateEvaluator)ServiceManagerFactory.getServiceObject(this.dateEvaluatorServiceName);
        }
        this.dateKey = new DateKey(this.dateKeyStr, this.dateEvaluator);
        super.startService();
    }

    public void setDateEvaluator(DateEvaluator evaluator) {
        this.dateEvaluator = evaluator;
    }

    protected boolean isNecessaryMake(Date date, ScheduleMaster master) throws ScheduleMakeException {
        try {
            return this.dateKey.equalsDate(date);
        }
        catch (Exception e) {
            throw new ScheduleMakeException(e);
        }
    }
}

