/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.resource.datasource;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import jp.ossc.nimbus.service.resource.datasource.AbstNimbusStatement;
import jp.ossc.nimbus.service.resource.datasource.NimbusResultSet;

public class NimbusStatement
extends AbstNimbusStatement
implements Statement {
    protected boolean mIsOpen = true;
    final String BATCH_SEPARATOR = System.getProperty("line.separator");
    protected final String PF_FOOTER = "[ms]";
    protected final String PF_KEY_HEADER = ":Performance";
    protected ArrayList mBatchArray = new ArrayList();

    public NimbusStatement(Statement st) {
        super(st);
        this.mStatement = st;
    }

    public void cancel() throws SQLException {
        this.mStatement.cancel();
    }

    public void clearBatch() throws SQLException {
        this.mStatement.clearBatch();
        if (this.journalService != null) {
            this.mBatchArray.clear();
        }
    }

    public void close() throws SQLException {
        for (int cnt = 0; cnt < this.mResultSetList.size(); ++cnt) {
            ResultSet tmp = (ResultSet)this.mResultSetList.get(cnt);
            tmp.close();
        }
        this.mResultSetList.clear();
        if (this.mIsOpen) {
            this.mStatement.close();
            this.mIsOpen = false;
        }
        if (this.journalService != null) {
            this.mBatchArray.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] executeBatch() throws SQLException {
        long startTime = 0L;
        long endTime = 0L;
        String sqlID = null;
        if (this.journalService != null) {
            sqlID = this.getSequenceNo();
            StringBuffer buff = new StringBuffer();
            for (int i = 0; i < this.mBatchArray.size(); ++i) {
                String sql = (String)this.mBatchArray.get(i);
                buff.append(sql);
                buff.append(this.BATCH_SEPARATOR);
            }
            this.journalService.addInfo(sqlID, (Object)buff.toString(), this.journalLevel);
            this.mBatchArray.clear();
        }
        int[] ret = null;
        startTime = System.currentTimeMillis();
        try {
            ret = this.mStatement.executeBatch();
            Object var10_7 = null;
        }
        catch (Throwable throwable) {
            Object var10_8 = null;
            endTime = System.currentTimeMillis();
            if (this.performanceService != null) {
                this.performanceService.entry(this.makeBatchAllSqlKey(this.mBatchArray), endTime - startTime);
            }
            if (this.journalService != null) {
                this.journalService.addInfo(sqlID + ":Performance", (Object)(new Long(endTime - startTime) + "[ms]"), this.journalLevel);
            }
            throw throwable;
        }
        endTime = System.currentTimeMillis();
        if (this.performanceService != null) {
            this.performanceService.entry(this.makeBatchAllSqlKey(this.mBatchArray), endTime - startTime);
        }
        if (this.journalService != null) {
            this.journalService.addInfo(sqlID + ":Performance", (Object)(new Long(endTime - startTime) + "[ms]"), this.journalLevel);
        }
        return ret;
    }

    protected String makeBatchAllSqlKey(ArrayList arr) {
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < arr.size(); ++i) {
            buff.append(arr.get(i));
        }
        return buff.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate(String arg0) throws SQLException {
        int n;
        long startTime = 0L;
        long endTime = 0L;
        String sqlID = null;
        if (this.journalService != null) {
            sqlID = this.getSequenceNo();
            this.journalService.addInfo(sqlID, (Object)arg0, this.journalLevel);
        }
        startTime = System.currentTimeMillis();
        try {
            n = this.mStatement.executeUpdate(arg0);
            Object var9_6 = null;
        }
        catch (Throwable throwable) {
            block6: {
                Object var9_7 = null;
                endTime = System.currentTimeMillis();
                if (this.performanceService != null) {
                    this.performanceService.entry(arg0, endTime - startTime);
                }
                if (this.journalService == null) break block6;
                this.journalService.addInfo(sqlID + ":Performance", (Object)(new Long(endTime - startTime) + "[ms]"), this.journalLevel);
            }
            throw throwable;
        }
        endTime = System.currentTimeMillis();
        if (this.performanceService != null) {
            this.performanceService.entry(arg0, endTime - startTime);
        }
        if (this.journalService != null) {
            this.journalService.addInfo(sqlID + ":Performance", (Object)(new Long(endTime - startTime) + "[ms]"), this.journalLevel);
        }
        return n;
    }

    public void addBatch(String arg0) throws SQLException {
        if (this.journalService != null) {
            this.mBatchArray.add(arg0);
        }
        this.mStatement.addBatch(arg0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(String arg0) throws SQLException {
        boolean bl;
        long startTime = 0L;
        long endTime = 0L;
        String sqlID = null;
        if (this.journalService != null) {
            sqlID = this.getSequenceNo();
            this.journalService.addInfo(sqlID, (Object)arg0, this.journalLevel);
        }
        startTime = System.currentTimeMillis();
        try {
            bl = this.mStatement.execute(arg0);
            Object var9_6 = null;
        }
        catch (Throwable throwable) {
            block6: {
                Object var9_7 = null;
                endTime = System.currentTimeMillis();
                if (this.performanceService != null) {
                    this.performanceService.entry(arg0, endTime - startTime);
                }
                if (this.journalService == null) break block6;
                this.journalService.addInfo(sqlID + ":Performance", (Object)(new Long(endTime - startTime) + "[ms]"), this.journalLevel);
            }
            throw throwable;
        }
        endTime = System.currentTimeMillis();
        if (this.performanceService != null) {
            this.performanceService.entry(arg0, endTime - startTime);
        }
        if (this.journalService != null) {
            this.journalService.addInfo(sqlID + ":Performance", (Object)(new Long(endTime - startTime) + "[ms]"), this.journalLevel);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate(String arg0, int arg1) throws SQLException {
        int n;
        long startTime = 0L;
        long endTime = 0L;
        String sqlID = null;
        if (this.journalService != null) {
            sqlID = this.getSequenceNo();
            this.journalService.addInfo(sqlID, (Object)arg0, this.journalLevel);
        }
        startTime = System.currentTimeMillis();
        try {
            n = this.mStatement.executeUpdate(arg0, arg1);
            Object var10_7 = null;
        }
        catch (Throwable throwable) {
            block6: {
                Object var10_8 = null;
                endTime = System.currentTimeMillis();
                if (this.performanceService != null) {
                    this.performanceService.entry(arg0, endTime - startTime);
                }
                if (this.journalService == null) break block6;
                this.journalService.addInfo(sqlID + ":Performance", (Object)(new Long(endTime - startTime) + "[ms]"), this.journalLevel);
            }
            throw throwable;
        }
        endTime = System.currentTimeMillis();
        if (this.performanceService != null) {
            this.performanceService.entry(arg0, endTime - startTime);
        }
        if (this.journalService != null) {
            this.journalService.addInfo(sqlID + ":Performance", (Object)(new Long(endTime - startTime) + "[ms]"), this.journalLevel);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(String arg0, int arg1) throws SQLException {
        boolean bl;
        long startTime = 0L;
        long endTime = 0L;
        String sqlID = null;
        if (this.journalService != null) {
            sqlID = this.getSequenceNo();
            this.journalService.addInfo(sqlID, (Object)arg0, this.journalLevel);
        }
        if (this.performanceService != null) {
            startTime = System.currentTimeMillis();
        }
        try {
            bl = this.mStatement.execute(arg0, arg1);
            Object var10_7 = null;
        }
        catch (Throwable throwable) {
            block7: {
                Object var10_8 = null;
                endTime = System.currentTimeMillis();
                if (this.performanceService != null) {
                    this.performanceService.entry(arg0, endTime - startTime);
                }
                if (this.journalService == null) break block7;
                this.journalService.addInfo(sqlID + ":Performance", (Object)(new Long(endTime - startTime) + "[ms]"), this.journalLevel);
            }
            throw throwable;
        }
        endTime = System.currentTimeMillis();
        if (this.performanceService != null) {
            this.performanceService.entry(arg0, endTime - startTime);
        }
        if (this.journalService != null) {
            this.journalService.addInfo(sqlID + ":Performance", (Object)(new Long(endTime - startTime) + "[ms]"), this.journalLevel);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate(String arg0, int[] arg1) throws SQLException {
        int n;
        long startTime = 0L;
        long endTime = 0L;
        String sqlID = null;
        if (this.journalService != null) {
            sqlID = this.getSequenceNo();
            this.journalService.addInfo(sqlID, (Object)arg0, this.journalLevel);
        }
        startTime = System.currentTimeMillis();
        try {
            n = this.mStatement.executeUpdate(arg0, arg1);
            Object var10_7 = null;
        }
        catch (Throwable throwable) {
            block6: {
                Object var10_8 = null;
                endTime = System.currentTimeMillis();
                if (this.performanceService != null) {
                    this.performanceService.entry(arg0, endTime - startTime);
                }
                if (this.journalService == null) break block6;
                this.journalService.addInfo(sqlID + ":Performance", (Object)(new Long(endTime - startTime) + "[ms]"), this.journalLevel);
            }
            throw throwable;
        }
        endTime = System.currentTimeMillis();
        if (this.performanceService != null) {
            this.performanceService.entry(arg0, endTime - startTime);
        }
        if (this.journalService != null) {
            this.journalService.addInfo(sqlID + ":Performance", (Object)(new Long(endTime - startTime) + "[ms]"), this.journalLevel);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(String arg0, int[] arg1) throws SQLException {
        boolean bl;
        long startTime = 0L;
        long endTime = 0L;
        String sqlID = null;
        if (this.journalService != null) {
            sqlID = this.getSequenceNo();
            this.journalService.addInfo(sqlID, (Object)arg0, this.journalLevel);
        }
        startTime = System.currentTimeMillis();
        try {
            bl = this.mStatement.execute(arg0, arg1);
            Object var10_7 = null;
        }
        catch (Throwable throwable) {
            block6: {
                Object var10_8 = null;
                endTime = System.currentTimeMillis();
                if (this.performanceService != null) {
                    this.performanceService.entry(arg0, endTime - startTime);
                }
                if (this.journalService == null) break block6;
                this.journalService.addInfo(sqlID + ":Performance", (Object)(new Long(endTime - startTime) + "[ms]"), this.journalLevel);
            }
            throw throwable;
        }
        endTime = System.currentTimeMillis();
        if (this.performanceService != null) {
            this.performanceService.entry(arg0, endTime - startTime);
        }
        if (this.journalService != null) {
            this.journalService.addInfo(sqlID + ":Performance", (Object)(new Long(endTime - startTime) + "[ms]"), this.journalLevel);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate(String arg0, String[] arg1) throws SQLException {
        int n;
        long startTime = 0L;
        long endTime = 0L;
        String sqlID = null;
        if (this.journalService != null) {
            sqlID = this.getSequenceNo();
            this.journalService.addInfo(sqlID, (Object)arg0, this.journalLevel);
        }
        startTime = System.currentTimeMillis();
        try {
            n = this.mStatement.executeUpdate(arg0, arg1);
            Object var10_7 = null;
        }
        catch (Throwable throwable) {
            block6: {
                Object var10_8 = null;
                endTime = System.currentTimeMillis();
                if (this.performanceService != null) {
                    this.performanceService.entry(arg0, endTime - startTime);
                }
                if (this.journalService == null) break block6;
                this.journalService.addInfo(sqlID + ":Performance", (Object)(new Long(endTime - startTime) + "[ms]"), this.journalLevel);
            }
            throw throwable;
        }
        endTime = System.currentTimeMillis();
        if (this.performanceService != null) {
            this.performanceService.entry(arg0, endTime - startTime);
        }
        if (this.journalService != null) {
            this.journalService.addInfo(sqlID + ":Performance", (Object)(new Long(endTime - startTime) + "[ms]"), this.journalLevel);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(String arg0, String[] arg1) throws SQLException {
        boolean bl;
        long startTime = 0L;
        long endTime = 0L;
        String sqlID = null;
        if (this.journalService != null) {
            sqlID = this.getSequenceNo();
            this.journalService.addInfo(sqlID, (Object)arg0, this.journalLevel);
        }
        startTime = System.currentTimeMillis();
        try {
            bl = this.mStatement.execute(arg0, arg1);
            Object var10_7 = null;
        }
        catch (Throwable throwable) {
            block6: {
                Object var10_8 = null;
                endTime = System.currentTimeMillis();
                if (this.performanceService != null) {
                    this.performanceService.entry(arg0, endTime - startTime);
                }
                if (this.journalService == null) break block6;
                this.journalService.addInfo(sqlID + ":Performance", (Object)(new Long(endTime - startTime) + "[ms]"), this.journalLevel);
            }
            throw throwable;
        }
        endTime = System.currentTimeMillis();
        if (this.performanceService != null) {
            this.performanceService.entry(arg0, endTime - startTime);
        }
        if (this.journalService != null) {
            this.journalService.addInfo(sqlID + ":Performance", (Object)(new Long(endTime - startTime) + "[ms]"), this.journalLevel);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet executeQuery(String arg0) throws SQLException {
        long startTime = 0L;
        long endTime = 0L;
        String sqlID = null;
        if (this.journalService != null) {
            sqlID = this.getSequenceNo();
            this.journalService.addInfo(sqlID, (Object)arg0, this.journalLevel);
        }
        startTime = System.currentTimeMillis();
        NimbusResultSet nret = null;
        try {
            ResultSet ret = this.mStatement.executeQuery(arg0);
            nret = new NimbusResultSet(ret);
            this.mResultSetList.add(nret);
            Object var10_7 = null;
        }
        catch (Throwable throwable) {
            Object var10_8 = null;
            endTime = System.currentTimeMillis();
            if (this.performanceService != null) {
                this.performanceService.entry(arg0, endTime - startTime);
            }
            if (this.journalService != null) {
                this.journalService.addInfo(sqlID + ":Performance", (Object)(new Long(endTime - startTime) + "[ms]"), this.journalLevel);
            }
            throw throwable;
        }
        endTime = System.currentTimeMillis();
        if (this.performanceService != null) {
            this.performanceService.entry(arg0, endTime - startTime);
        }
        if (this.journalService != null) {
            this.journalService.addInfo(sqlID + ":Performance", (Object)(new Long(endTime - startTime) + "[ms]"), this.journalLevel);
        }
        return nret;
    }
}

