/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.publish.udp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.net.SocketFactory;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceBaseMBean;
import jp.ossc.nimbus.core.ServiceManager;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.daemon.Daemon;
import jp.ossc.nimbus.daemon.DaemonControl;
import jp.ossc.nimbus.daemon.DaemonRunnable;
import jp.ossc.nimbus.service.io.Externalizer;
import jp.ossc.nimbus.service.publish.ClientConnection;
import jp.ossc.nimbus.service.publish.ConnectException;
import jp.ossc.nimbus.service.publish.MessageListener;
import jp.ossc.nimbus.service.publish.MessageSendException;
import jp.ossc.nimbus.service.publish.tcp.AddMessage;
import jp.ossc.nimbus.service.publish.tcp.ByeMessage;
import jp.ossc.nimbus.service.publish.tcp.ClientMessage;
import jp.ossc.nimbus.service.publish.tcp.RemoveMessage;
import jp.ossc.nimbus.service.publish.tcp.StartReceiveMessage;
import jp.ossc.nimbus.service.publish.tcp.StopReceiveMessage;
import jp.ossc.nimbus.service.publish.udp.IdMessage;
import jp.ossc.nimbus.service.publish.udp.InterpolateRequestMessage;
import jp.ossc.nimbus.service.publish.udp.InterpolateResponseMessage;
import jp.ossc.nimbus.service.publish.udp.MessageId;
import jp.ossc.nimbus.service.publish.udp.MessageImpl;
import jp.ossc.nimbus.service.publish.udp.MulticastMessageImpl;
import jp.ossc.nimbus.service.publish.udp.RequestReplyMessage;
import jp.ossc.nimbus.service.publish.udp.ServerMessage;
import jp.ossc.nimbus.service.publish.udp.Window;
import jp.ossc.nimbus.service.publish.udp.WindowId;
import jp.ossc.nimbus.service.queue.DefaultQueueService;
import jp.ossc.nimbus.util.SynchronizeMonitor;
import jp.ossc.nimbus.util.WaitSynchronizeMonitor;

public class ClientConnectionImpl
implements ClientConnection,
Serializable {
    private static final long serialVersionUID = 1542561082447814032L;
    public static final String BIND_ADDRESS_PROPERTY = "jp.ossc.nimbus.service.publish.udp.bindAddress";
    public static final String BIND_PORT_PROPERTY = "jp.ossc.nimbus.service.publish.udp.bindPort";
    private String address;
    private int port;
    private SocketFactory socketFactory;
    private String receiveAddress;
    private int receivePort;
    private Externalizer externalizer;
    private String bindAddressPropertyName = "jp.ossc.nimbus.service.publish.udp.bindAddress";
    private String bindPortPropertyName = "jp.ossc.nimbus.service.publish.udp.bindPort";
    private String serverCloseMessageId;
    private String receiveWarnMessageId;
    private String receiveErrorMessageId;
    private String messageLostErrorMessageId;
    private int reconnectCount;
    private long reconnectInterval;
    private long reconnectBufferTime;
    private int windowSize;
    private long missingWindowTimeout;
    private int missingWindowCount;
    private long newMessagePollingInterval;
    private ServiceName serverServiceName;
    private long responseTimeout = -1L;
    private transient Socket socket;
    private transient InetAddress receiveGroup;
    private transient DatagramSocket receiveSocket;
    private transient Map subjects;
    private transient MessageListener messageListener;
    private transient Daemon packetReceiveDaemon;
    private transient Daemon replyReceiveDaemon;
    private transient Daemon messageReceiveDaemon;
    private transient Daemon missingWindowCheckDaemon;
    private transient DefaultQueueService receivePacketQueue;
    private transient boolean isClosing;
    private transient boolean isConnected;
    private transient boolean isReconnecting;
    private transient Object id;
    private transient String serviceManagerName;
    private transient ServiceName serviceName;
    private transient long receiveCount;
    private transient long receivePacketCount;
    private transient long onMessageProcessTime;
    private transient long noContinuousMessageCount;
    private transient long wasteWindowCount;
    private transient long missingWindowRequestCount;
    private transient long missingWindowRequestTimeoutCount;
    private transient long missingWindowResponseTime;
    private transient long newMessagePollingCount;
    private transient long newMessagePollingTimeoutCount;
    private transient long newMessagePollingResponseTime;
    private transient long lostCount;
    private transient int requestId;
    private transient boolean isStartReceive;
    private transient int maxMissingWindowSize;

    public ClientConnectionImpl(String address, int port, SocketFactory factory, String receiveAddress, int receivePort, Externalizer ext, ServiceName serverServiceName) {
        this.address = address;
        this.port = port;
        this.socketFactory = factory;
        this.receiveAddress = receiveAddress;
        this.receivePort = receivePort;
        this.externalizer = ext;
        this.serverServiceName = serverServiceName;
    }

    public void setBindAddressPropertyName(String name) {
        this.bindAddressPropertyName = name;
    }

    public String getBindAddressPropertyName() {
        return this.bindAddressPropertyName;
    }

    public void setBindPortPropertyName(String name) {
        this.bindPortPropertyName = name;
    }

    public String getBindPortPropertyName() {
        return this.bindPortPropertyName;
    }

    public void setServerCloseMessageId(String id) {
        this.serverCloseMessageId = id;
    }

    public String getServerCloseMessageId() {
        return this.serverCloseMessageId;
    }

    public void setReceiveWarnMessageId(String id) {
        this.receiveWarnMessageId = id;
    }

    public String getReceiveWarnMessageId() {
        return this.receiveWarnMessageId;
    }

    public void setReceiveErrorMessageId(String id) {
        this.receiveErrorMessageId = id;
    }

    public String getReceiveErrorMessageId() {
        return this.receiveErrorMessageId;
    }

    public void setMessageLostErrorMessageId(String id) {
        this.messageLostErrorMessageId = id;
    }

    public String getMessageLostErrorMessageId() {
        return this.messageLostErrorMessageId;
    }

    public void setReconnectCount(int count) {
        this.reconnectCount = count;
    }

    public int getReconnectCount() {
        return this.reconnectCount;
    }

    public void setReconnectInterval(long interval) {
        this.reconnectInterval = interval;
    }

    public long getReconnectInterval() {
        return this.reconnectInterval;
    }

    public void setReconnectBufferTime(long time) {
        this.reconnectBufferTime = time;
    }

    public long getReconnectBufferTime() {
        return this.reconnectBufferTime;
    }

    public void setWindowSize(int bytes) {
        this.windowSize = bytes;
    }

    public int getWindowSize() {
        return this.windowSize;
    }

    public void setMissingWindowTimeout(long interval) {
        this.missingWindowTimeout = interval;
    }

    public long getMissingWindowTimeout() {
        return this.missingWindowTimeout;
    }

    public void setMissingWindowCount(int count) {
        this.missingWindowCount = count;
    }

    public int getMissingWindowCount() {
        return this.missingWindowCount;
    }

    public void setNewMessagePollingInterval(long interval) {
        this.newMessagePollingInterval = interval;
    }

    public long getNewMessagePollingInterval() {
        return this.newMessagePollingInterval;
    }

    public void setResponseTimeout(long timeout) {
        this.responseTimeout = timeout;
    }

    public long getResponseTimeout() {
        return this.responseTimeout;
    }

    private String getProperty(String name) {
        String prop = System.getProperty(name);
        if (prop == null) {
            prop = ServiceManagerFactory.getProperty(name);
        }
        return prop;
    }

    private InetAddress getBindAddress() throws UnknownHostException {
        String bindAddress = this.getProperty(this.bindAddressPropertyName);
        InetAddress address = null;
        address = bindAddress == null ? InetAddress.getLocalHost() : InetAddress.getByName(bindAddress);
        return address;
    }

    private int getBindPort() throws NumberFormatException {
        String bindPort = this.getProperty(this.bindPortPropertyName);
        int port = 0;
        if (bindPort != null) {
            port = Integer.parseInt(bindPort);
        }
        return port;
    }

    public void setServiceManagerName(String name) {
        this.serviceManagerName = name;
    }

    public void connect() throws ConnectException {
        this.connect(null);
    }

    public void connect(Object id) throws ConnectException {
        this.connect(id, false);
    }

    private synchronized void connect(Object id, boolean isReconnect) throws ConnectException {
        block32: {
            if (this.socket != null) {
                return;
            }
            this.isConnected = false;
            try {
                ServiceManager manager;
                block31: {
                    try {
                        this.socket = this.socketFactory == null ? new Socket(this.address, this.port, this.getBindAddress(), this.getBindPort()) : this.socketFactory.createSocket(this.address, this.port, this.getBindAddress(), this.getBindPort());
                        if (this.responseTimeout > 0L) {
                            this.socket.setSoTimeout((int)this.responseTimeout);
                        }
                        if (isReconnect) break block31;
                        if (this.receiveAddress != null) {
                            this.receiveGroup = InetAddress.getByName(this.receiveAddress);
                            InetSocketAddress address = new InetSocketAddress(this.getBindAddress(), this.receivePort);
                            DatagramSocket datagramSocket = this.receiveSocket = this.receiveGroup.isMulticastAddress() ? new MulticastSocket(address) : new DatagramSocket(address);
                            if (this.receiveGroup.isMulticastAddress()) {
                                ((MulticastSocket)this.receiveSocket).joinGroup(this.receiveGroup);
                            }
                        } else {
                            this.receiveSocket = new DatagramSocket(new InetSocketAddress(this.getBindAddress(), this.receivePort));
                            if (this.receivePort == 0) {
                                this.receivePort = this.receiveSocket.getLocalPort();
                            }
                        }
                        if (this.receiveSocket == null) break block31;
                        try {
                            int receiveBufferSize = this.receiveSocket.getReceiveBufferSize();
                            if (receiveBufferSize < this.windowSize) {
                                this.receiveSocket.setReceiveBufferSize(this.windowSize);
                            }
                        }
                        catch (SocketException e) {}
                    }
                    catch (UnknownHostException e) {
                        throw new ConnectException(e);
                    }
                    catch (NumberFormatException e) {
                        throw new ConnectException(e);
                    }
                    catch (IOException e) {
                        throw new ConnectException(e);
                    }
                }
                if (this.receivePacketQueue == null) {
                    this.receivePacketQueue = new DefaultQueueService();
                    try {
                        this.receivePacketQueue.create();
                        this.receivePacketQueue.start();
                    }
                    catch (Exception e) {
                        throw new ConnectException(e);
                    }
                }
                if (this.packetReceiveDaemon == null) {
                    this.packetReceiveDaemon = new Daemon(new PacketReceiver());
                    this.packetReceiveDaemon.setDaemon(true);
                    this.packetReceiveDaemon.setName("Nimbus Publish(UDP) ClientConnection SocketReader " + this.receiveSocket.getLocalSocketAddress());
                    this.packetReceiveDaemon.start();
                }
                if (this.replyReceiveDaemon == null) {
                    this.replyReceiveDaemon = new Daemon(new ReplyReceiver());
                    this.replyReceiveDaemon.setDaemon(true);
                    this.replyReceiveDaemon.setName("Nimbus Publish(UDP) ClientConnection ReplyReceiver " + this.receiveSocket.getLocalSocketAddress());
                    this.replyReceiveDaemon.start();
                }
                if (this.messageReceiveDaemon == null) {
                    this.messageReceiveDaemon = new Daemon(new MessageReceiver());
                    this.messageReceiveDaemon.setDaemon(true);
                    this.messageReceiveDaemon.setName("Nimbus Publish(UDP) ClientConnection MessageReceiver " + this.receiveSocket.getLocalSocketAddress());
                }
                if (this.missingWindowCheckDaemon == null) {
                    this.missingWindowCheckDaemon = new Daemon(new MissingWindowChecker((MessageReceiver)this.messageReceiveDaemon.getDaemonRunnable()));
                    this.missingWindowCheckDaemon.setDaemon(true);
                    this.missingWindowCheckDaemon.setName("Nimbus Publish(UDP) ClientConnection MissingWindowChecker " + this.receiveSocket.getLocalSocketAddress());
                    ((MessageReceiver)this.messageReceiveDaemon.getDaemonRunnable()).setMissingWindowChecker((MissingWindowChecker)this.missingWindowCheckDaemon.getDaemonRunnable());
                }
                this.messageReceiveDaemon.start();
                this.missingWindowCheckDaemon.start();
                this.id = id == null ? this.socket.getLocalSocketAddress() : id;
                try {
                    IdMessage message = new IdMessage(this.id);
                    message.setReceivePort(this.receivePort);
                    this.send(message);
                }
                catch (IOException e) {
                    throw new ConnectException(e);
                }
                if (this.serverServiceName == null || (manager = ServiceManagerFactory.findManager(this.serviceManagerName == null ? this.serverServiceName.getServiceManagerName() : this.serviceManagerName)) == null) break block32;
                ClientConnectionService ccs = new ClientConnectionService();
                try {
                    String name = this.serverServiceName.getServiceName() + '$' + this.receiveSocket.getLocalSocketAddress();
                    name = name.replaceAll(":", "\\$");
                    if (!manager.isRegisteredService(name) && manager.registerService(name, ccs)) {
                        this.serviceName = ccs.getServiceNameObject();
                        manager.createService(ccs.getServiceName());
                        manager.startService(ccs.getServiceName());
                    }
                }
                catch (Exception e) {
                    throw new ConnectException(e);
                }
            }
            catch (ConnectException e) {
                if (this.socket != null) {
                    try {
                        this.socket.close();
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                    this.socket = null;
                }
                if (!isReconnect && this.receiveSocket != null) {
                    this.receiveSocket.close();
                    this.receiveSocket = null;
                }
                throw e;
            }
        }
        this.isConnected = true;
    }

    public void addSubject(String subject) throws MessageSendException {
        this.addSubject(subject, null);
    }

    public void addSubject(String subject, String[] keys) throws MessageSendException {
        Set<Object> keySet;
        if (this.socket == null) {
            throw new MessageSendException("Not connected.");
        }
        if (subject == null) {
            return;
        }
        try {
            this.send(new AddMessage(subject, keys));
        }
        catch (SocketTimeoutException e) {
            throw new MessageSendException(e);
        }
        catch (SocketException e) {
            throw new MessageSendException(e);
        }
        catch (IOException e) {
            throw new MessageSendException(e);
        }
        if (this.subjects == null) {
            this.subjects = Collections.synchronizedMap(new HashMap());
        }
        if ((keySet = (Set<Object>)this.subjects.get(subject)) == null) {
            keySet = Collections.synchronizedSet(new HashSet());
            this.subjects.put(subject, keySet);
        }
        if (keys == null) {
            keySet.add(null);
        } else {
            for (int i = 0; i < keys.length; ++i) {
                keySet.add(keys[i]);
            }
        }
    }

    public void removeSubject(String subject) throws MessageSendException {
        this.removeSubject(subject, null);
    }

    public void removeSubject(String subject, String[] keys) throws MessageSendException {
        Set keySet;
        if (this.socket == null) {
            throw new MessageSendException("Not connected.");
        }
        if (subject == null) {
            return;
        }
        try {
            this.send(new RemoveMessage(subject, keys));
        }
        catch (SocketTimeoutException e) {
            throw new MessageSendException(e);
        }
        catch (SocketException e) {
            throw new MessageSendException(e);
        }
        catch (IOException e) {
            throw new MessageSendException(e);
        }
        if (this.subjects != null && (keySet = (Set)this.subjects.get(subject)) != null) {
            if (keys == null) {
                keySet.remove(null);
            } else {
                for (int i = 0; i < keys.length; ++i) {
                    keySet.remove(keys[i]);
                }
            }
            if (keySet.size() == 0) {
                this.subjects.remove(subject);
            }
        }
    }

    public void startReceive() throws MessageSendException {
        this.startReceive(-1L);
    }

    public void startReceive(long from) throws MessageSendException {
        this.startReceive(from, false);
    }

    private void startReceive(long from, boolean isRestart) throws MessageSendException {
        if (this.socket == null) {
            throw new MessageSendException("Not connected.");
        }
        if (!isRestart && this.isStartReceive) {
            return;
        }
        try {
            this.isStartReceive = true;
            this.send(new StartReceiveMessage(from));
        }
        catch (SocketTimeoutException e) {
            this.isStartReceive = false;
            throw new MessageSendException(e);
        }
        catch (SocketException e) {
            this.isStartReceive = false;
            throw new MessageSendException(e);
        }
        catch (IOException e) {
            this.isStartReceive = false;
            throw new MessageSendException(e);
        }
    }

    public boolean isStartReceive() {
        return this.isStartReceive;
    }

    public void stopReceive() throws MessageSendException {
        if (this.socket == null) {
            throw new MessageSendException("Not connected.");
        }
        if (!this.isStartReceive) {
            return;
        }
        try {
            this.send(new StopReceiveMessage());
            this.isStartReceive = false;
        }
        catch (SocketTimeoutException e) {
            throw new MessageSendException(e);
        }
        catch (SocketException e) {
            throw new MessageSendException(e);
        }
        catch (IOException e) {
            throw new MessageSendException(e);
        }
    }

    public Set getSubjects() {
        return this.subjects == null ? new HashSet() : this.subjects.keySet();
    }

    public Set getKeys(String subject) {
        if (this.subjects == null) {
            return new HashSet();
        }
        Set keySet = (Set)this.subjects.get(subject);
        return keySet == null ? new HashSet() : keySet;
    }

    private void send(ClientMessage message) throws IOException {
        try {
            this.send(message, false);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServerMessage send(ClientMessage message, boolean reply) throws IOException, ClassNotFoundException {
        if (reply) {
            ClientConnectionImpl clientConnectionImpl = this;
            synchronized (clientConnectionImpl) {
                ((RequestReplyMessage)((Object)message)).setRequestId(this.requestId++);
            }
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (this.externalizer == null) {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(message);
            oos.flush();
        } else {
            this.externalizer.writeExternal((Object)message, baos);
        }
        byte[] bytes = baos.toByteArray();
        ReplyReceiver replyReceiver = null;
        if (reply) {
            replyReceiver = (ReplyReceiver)this.replyReceiveDaemon.getDaemonRunnable();
            replyReceiver.initReply();
        }
        ClientConnectionImpl clientConnectionImpl = this;
        synchronized (clientConnectionImpl) {
            DataOutputStream dos = new DataOutputStream(this.socket.getOutputStream());
            dos.writeInt(bytes.length);
            dos.write(bytes);
            dos.flush();
        }
        if (reply) {
            return replyReceiver.getReply((RequestReplyMessage)((Object)message), this.responseTimeout);
        }
        return null;
    }

    public void setMessageListener(MessageListener listener) {
        this.messageListener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void reconnect() throws ConnectException, MessageSendException {
        boolean isNowReconnecting = this.isReconnecting;
        ClientConnectionImpl clientConnectionImpl = this;
        synchronized (clientConnectionImpl) {
            if (isNowReconnecting) {
                return;
            }
            this.isReconnecting = true;
            try {
                if (this.socket != null) {
                    try {
                        this.socket.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    this.socket = null;
                }
                ((MessageReceiver)this.messageReceiveDaemon.getDaemonRunnable()).reset();
                int tryCount = 0;
                boolean isSuccess = false;
                while (!isSuccess) {
                    block26: {
                        block25: {
                            ++tryCount;
                            try {
                                this.connect(this.id, true);
                                if (this.subjects == null) break block25;
                                Object[] subjectArray = this.subjects.keySet().toArray();
                                for (int i = 0; i < subjectArray.length; ++i) {
                                    Object subject = subjectArray[i];
                                    Set keySet = (Set)this.subjects.get(subject);
                                    if (keySet == null) continue;
                                    String[] keys = keySet.toArray(new String[keySet.size()]);
                                    boolean containsNull = false;
                                    ArrayList<String> keyList = new ArrayList<String>();
                                    for (int j = 0; j < keys.length; ++j) {
                                        if (keys[j] == null) {
                                            containsNull = true;
                                            continue;
                                        }
                                        keyList.add(keys[j]);
                                    }
                                    if (containsNull) {
                                        this.addSubject((String)subject);
                                        keys = keyList.toArray(new String[keyList.size()]);
                                    }
                                    if (keys == null || keys.length == 0) continue;
                                    this.addSubject((String)subject, keys);
                                }
                            }
                            catch (ConnectException e) {
                                if (tryCount >= this.reconnectCount) {
                                    throw e;
                                }
                                if (this.receiveWarnMessageId != null) {
                                    ServiceManagerFactory.getLogger().write(this.receiveWarnMessageId, new Object[]{this}, (Throwable)e);
                                }
                                break block26;
                            }
                            catch (MessageSendException e) {
                                if (tryCount >= this.reconnectCount) {
                                    throw e;
                                }
                                if (this.receiveWarnMessageId != null) {
                                    ServiceManagerFactory.getLogger().write(this.receiveWarnMessageId, new Object[]{this}, (Throwable)e);
                                }
                                break block26;
                            }
                        }
                        if (this.isStartReceive) {
                            long time = -1L;
                            MessageId latestMessageId = ((MessageReceiver)this.messageReceiveDaemon.getDaemonRunnable()).getLatestMessageId();
                            if (latestMessageId != null) {
                                time = ((MessageReceiver)this.messageReceiveDaemon.getDaemonRunnable()).getLatestMessageReceiveTime() - this.reconnectBufferTime;
                            }
                            this.startReceive(time, true);
                        }
                        isSuccess = true;
                    }
                    if (isSuccess || this.reconnectInterval <= 0L) continue;
                    try {
                        Thread.sleep(this.reconnectInterval);
                    }
                    catch (InterruptedException e) {
                        throw new ConnectException(e);
                    }
                }
                return;
            }
            finally {
                this.isReconnecting = false;
            }
        }
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public Object getId() {
        return this.id;
    }

    public synchronized void close() {
        this.isClosing = true;
        this.isConnected = false;
        if (this.serviceName != null) {
            ServiceManagerFactory.unregisterService(this.serviceName.getServiceManagerName(), this.serviceName.getServiceName());
            this.serviceName = null;
        }
        if (this.missingWindowCheckDaemon != null) {
            this.missingWindowCheckDaemon.stopNoWait();
            this.missingWindowCheckDaemon = null;
        }
        if (this.messageReceiveDaemon != null) {
            this.messageReceiveDaemon.stopNoWait();
            this.messageReceiveDaemon = null;
        }
        if (this.replyReceiveDaemon != null) {
            this.replyReceiveDaemon.stopNoWait();
            this.replyReceiveDaemon = null;
        }
        if (this.socket != null) {
            try {
                this.send(new ByeMessage());
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.socket = null;
        }
        if (this.packetReceiveDaemon != null) {
            this.packetReceiveDaemon.stopNoWait();
            this.packetReceiveDaemon = null;
            this.receivePacketQueue.stop();
            this.receivePacketQueue.destroy();
            this.receivePacketQueue = null;
        }
        if (this.receiveSocket != null) {
            this.receiveGroup = null;
            this.receiveSocket.close();
            this.receiveSocket = null;
        }
        this.isClosing = false;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(super.toString());
        buf.append('{');
        buf.append("id=").append(this.id);
        buf.append(", receiveAddress=").append(this.receiveAddress);
        buf.append(", receivePort=").append(this.receivePort);
        buf.append(", localAddress=").append(this.socket == null ? null : this.socket.getLocalSocketAddress());
        buf.append(", remoteAddress=").append(this.socket == null ? null : this.socket.getRemoteSocketAddress());
        buf.append(", subject=").append(this.subjects);
        buf.append('}');
        return buf.toString();
    }

    public static interface ClientConnectionServiceMBean
    extends ServiceBaseMBean {
        public void setReconnectCount(int var1);

        public int getReconnectCount();

        public void setReconnectInterval(long var1);

        public long getReconnectInterval();

        public void setReconnectBufferTime(long var1);

        public long getReconnectBufferTime();

        public int getWindowSize();

        public void setMissingWindowTimeout(long var1);

        public long getMissingWindowTimeout();

        public void setMissingWindowCount(int var1);

        public int getMissingWindowCount();

        public void setNewMessagePollingInterval(long var1);

        public long getNewMessagePollingInterval();

        public long getResponseTimeout();

        public SocketAddress getLocalSocketAddress();

        public SocketAddress getRemoteSocketAddress();

        public SocketAddress getReceiveSocketAddress();

        public Set getSubjects();

        public Set getKeys(String var1);

        public long getReceiveCount();

        public long getReceivePacketCount();

        public long getAverageOnMessageProcessTime();

        public long getMissingWindowRequestCount();

        public long getMissingWindowRequestTimeoutCount();

        public long getAverageMissingWindowResponseTime();

        public long getNewMessagePollingCount();

        public long getNewMessagePollingTimeoutCount();

        public long getAverageNewMessagePollingResponseTime();

        public long getNoContinuousMessageCount();

        public long getWasteWindowCount();

        public long getLostCount();

        public void resetCount();

        public long getReceivePacketQueueCount();

        public long getReceivePacketQueueCountDelta();

        public long getReceivePacketQueueLastPushedTimeMillis();

        public Date getReceivePacketQueueLastPushedTime();

        public long getReceivePacketQueueDepth();

        public long getReceivePacketQueueDepthDelta();

        public long getReceivePacketQueueMaxDepth();

        public MessageId getLatestMessageId();

        public Date getLatestMessageReceiveTime();

        public int getMissingWindowSize();

        public int getMaxMissingWindowSize();

        public void connect() throws ConnectException;

        public void connect(Object var1) throws ConnectException;

        public void startReceive() throws MessageSendException;

        public void startReceive(long var1) throws MessageSendException;

        public void stopReceive() throws MessageSendException;

        public boolean isStartReceive();

        public void addSubject(String var1) throws MessageSendException;

        public void addSubject(String var1, String[] var2) throws MessageSendException;

        public void removeSubject(String var1) throws MessageSendException;

        public void removeSubject(String var1, String[] var2) throws MessageSendException;

        public void reconnect() throws ConnectException, MessageSendException;

        public boolean isConnected();

        public void close();
    }

    public class ClientConnectionService
    extends ServiceBase
    implements ClientConnectionServiceMBean {
        private static final long serialVersionUID = 5243807973535652312L;

        public void setReconnectCount(int count) {
            ClientConnectionImpl.this.setReconnectCount(count);
        }

        public int getReconnectCount() {
            return ClientConnectionImpl.this.getReconnectCount();
        }

        public void setReconnectInterval(long interval) {
            ClientConnectionImpl.this.setReconnectInterval(interval);
        }

        public long getReconnectInterval() {
            return ClientConnectionImpl.this.getReconnectInterval();
        }

        public void setReconnectBufferTime(long time) {
            ClientConnectionImpl.this.setReconnectBufferTime(time);
        }

        public long getReconnectBufferTime() {
            return ClientConnectionImpl.this.getReconnectBufferTime();
        }

        public int getWindowSize() {
            return ClientConnectionImpl.this.getWindowSize();
        }

        public void setMissingWindowTimeout(long interval) {
            ClientConnectionImpl.this.setMissingWindowTimeout(interval);
        }

        public long getMissingWindowTimeout() {
            return ClientConnectionImpl.this.getMissingWindowTimeout();
        }

        public void setMissingWindowCount(int count) {
            ClientConnectionImpl.this.setMissingWindowCount(count);
        }

        public int getMissingWindowCount() {
            return ClientConnectionImpl.this.getMissingWindowCount();
        }

        public void setNewMessagePollingInterval(long interval) {
            ClientConnectionImpl.this.setNewMessagePollingInterval(interval);
        }

        public long getNewMessagePollingInterval() {
            return ClientConnectionImpl.this.getNewMessagePollingInterval();
        }

        public long getResponseTimeout() {
            return ClientConnectionImpl.this.getResponseTimeout();
        }

        public Set getSubjects() {
            return ClientConnectionImpl.this.getSubjects();
        }

        public Set getKeys(String subject) {
            return ClientConnectionImpl.this.getKeys(subject);
        }

        public long getReceiveCount() {
            return ClientConnectionImpl.this.receiveCount;
        }

        public long getReceivePacketCount() {
            return ClientConnectionImpl.this.receivePacketCount;
        }

        public void resetCount() {
            ClientConnectionImpl.this.receiveCount = 0L;
            ClientConnectionImpl.this.receivePacketCount = 0L;
            ClientConnectionImpl.this.onMessageProcessTime = 0L;
            ClientConnectionImpl.this.noContinuousMessageCount = 0L;
            ClientConnectionImpl.this.wasteWindowCount = 0L;
            ClientConnectionImpl.this.missingWindowRequestCount = 0L;
            ClientConnectionImpl.this.missingWindowRequestTimeoutCount = 0L;
            ClientConnectionImpl.this.missingWindowResponseTime = 0L;
            ClientConnectionImpl.this.newMessagePollingCount = 0L;
            ClientConnectionImpl.this.newMessagePollingTimeoutCount = 0L;
            ClientConnectionImpl.this.newMessagePollingResponseTime = 0L;
            ClientConnectionImpl.this.lostCount = 0L;
        }

        public long getAverageOnMessageProcessTime() {
            return ClientConnectionImpl.this.receiveCount == 0L ? 0L : ClientConnectionImpl.this.onMessageProcessTime / ClientConnectionImpl.this.receiveCount;
        }

        public long getMissingWindowRequestCount() {
            return ClientConnectionImpl.this.missingWindowRequestCount;
        }

        public long getMissingWindowRequestTimeoutCount() {
            return ClientConnectionImpl.this.missingWindowRequestTimeoutCount;
        }

        public long getAverageMissingWindowResponseTime() {
            return ClientConnectionImpl.this.missingWindowRequestCount == 0L ? 0L : ClientConnectionImpl.this.missingWindowResponseTime / ClientConnectionImpl.this.missingWindowRequestCount;
        }

        public long getNewMessagePollingCount() {
            return ClientConnectionImpl.this.newMessagePollingCount;
        }

        public long getNewMessagePollingTimeoutCount() {
            return ClientConnectionImpl.this.newMessagePollingTimeoutCount;
        }

        public long getAverageNewMessagePollingResponseTime() {
            return ClientConnectionImpl.this.newMessagePollingCount == 0L ? 0L : ClientConnectionImpl.this.newMessagePollingResponseTime / ClientConnectionImpl.this.newMessagePollingCount;
        }

        public SocketAddress getLocalSocketAddress() {
            return ClientConnectionImpl.this.socket.getLocalSocketAddress();
        }

        public SocketAddress getRemoteSocketAddress() {
            return ClientConnectionImpl.this.socket.getRemoteSocketAddress();
        }

        public SocketAddress getReceiveSocketAddress() {
            return ClientConnectionImpl.this.receiveSocket.getLocalSocketAddress();
        }

        public long getReceivePacketQueueCount() {
            return ClientConnectionImpl.this.receivePacketQueue == null ? 0L : ClientConnectionImpl.this.receivePacketQueue.getCount();
        }

        public long getReceivePacketQueueCountDelta() {
            return ClientConnectionImpl.this.receivePacketQueue == null ? 0L : ClientConnectionImpl.this.receivePacketQueue.getCountDelta();
        }

        public long getReceivePacketQueueLastPushedTimeMillis() {
            return ClientConnectionImpl.this.receivePacketQueue == null ? 0L : ClientConnectionImpl.this.receivePacketQueue.getLastPushedTimeMillis();
        }

        public Date getReceivePacketQueueLastPushedTime() {
            return ClientConnectionImpl.this.receivePacketQueue == null ? null : ClientConnectionImpl.this.receivePacketQueue.getLastPushedTime();
        }

        public long getReceivePacketQueueDepth() {
            return ClientConnectionImpl.this.receivePacketQueue == null ? 0L : ClientConnectionImpl.this.receivePacketQueue.getDepth();
        }

        public long getReceivePacketQueueDepthDelta() {
            return ClientConnectionImpl.this.receivePacketQueue == null ? 0L : ClientConnectionImpl.this.receivePacketQueue.getDepthDelta();
        }

        public long getReceivePacketQueueMaxDepth() {
            return ClientConnectionImpl.this.receivePacketQueue == null ? 0L : ClientConnectionImpl.this.receivePacketQueue.getMaxDepth();
        }

        public long getNoContinuousMessageCount() {
            return ClientConnectionImpl.this.noContinuousMessageCount;
        }

        public long getWasteWindowCount() {
            return ClientConnectionImpl.this.wasteWindowCount;
        }

        public long getLostCount() {
            return ClientConnectionImpl.this.lostCount;
        }

        public MessageId getLatestMessageId() {
            return ClientConnectionImpl.this.messageReceiveDaemon == null ? null : ((MessageReceiver)ClientConnectionImpl.this.messageReceiveDaemon.getDaemonRunnable()).getLatestMessageId();
        }

        public Date getLatestMessageReceiveTime() {
            return ClientConnectionImpl.this.messageReceiveDaemon == null ? null : new Date(((MessageReceiver)ClientConnectionImpl.this.messageReceiveDaemon.getDaemonRunnable()).getLatestMessageReceiveTime());
        }

        public int getMissingWindowSize() {
            return ClientConnectionImpl.this.messageReceiveDaemon == null ? 0 : ((MessageReceiver)ClientConnectionImpl.this.messageReceiveDaemon.getDaemonRunnable()).getMissingWindowSize();
        }

        public int getMaxMissingWindowSize() {
            return ClientConnectionImpl.this.maxMissingWindowSize;
        }

        public void connect() throws ConnectException {
            ClientConnectionImpl.this.connect();
        }

        public void connect(Object id) throws ConnectException {
            ClientConnectionImpl.this.connect(id);
        }

        public void startReceive() throws MessageSendException {
            ClientConnectionImpl.this.startReceive();
        }

        public void startReceive(long from) throws MessageSendException {
            ClientConnectionImpl.this.startReceive(from);
        }

        public void stopReceive() throws MessageSendException {
            ClientConnectionImpl.this.stopReceive();
        }

        public boolean isStartReceive() {
            return ClientConnectionImpl.this.isStartReceive();
        }

        public void addSubject(String subject) throws MessageSendException {
            ClientConnectionImpl.this.addSubject(subject);
        }

        public void addSubject(String subject, String[] keys) throws MessageSendException {
            ClientConnectionImpl.this.addSubject(subject, keys);
        }

        public void removeSubject(String subject) throws MessageSendException {
            ClientConnectionImpl.this.removeSubject(subject);
        }

        public void removeSubject(String subject, String[] keys) throws MessageSendException {
            ClientConnectionImpl.this.removeSubject(subject, keys);
        }

        public void reconnect() throws ConnectException, MessageSendException {
            ClientConnectionImpl.this.reconnect();
            if (ClientConnectionImpl.this.packetReceiveDaemon != null && ClientConnectionImpl.this.packetReceiveDaemon.isSusupend()) {
                ClientConnectionImpl.this.packetReceiveDaemon.resume();
            }
        }

        public boolean isConnected() {
            return ClientConnectionImpl.this.isConnected();
        }

        public void close() {
            ClientConnectionImpl.this.close();
        }
    }

    private class MissingWindowChecker
    implements DaemonRunnable {
        private long lastCheckTime;
        private long lastPollingTime;
        private MessageReceiver messageReceiver;
        private SynchronizeMonitor monitor = new WaitSynchronizeMonitor();

        public MissingWindowChecker(MessageReceiver receiver) {
            this.messageReceiver = receiver;
        }

        public void notifyChecker() {
            if (this.monitor.isWait()) {
                this.monitor.notifyMonitor();
            }
        }

        public boolean onStart() {
            return true;
        }

        public boolean onStop() {
            return true;
        }

        public boolean onSuspend() {
            return true;
        }

        public boolean onResume() {
            return true;
        }

        public Object provide(DaemonControl ctrl) throws Throwable {
            long waitTime = ClientConnectionImpl.this.missingWindowTimeout;
            if (this.lastCheckTime != 0L) {
                long checkInterval = System.currentTimeMillis() - this.lastCheckTime;
                waitTime -= checkInterval;
            }
            if (waitTime > 0L) {
                this.monitor.initAndWaitMonitor(waitTime);
            }
            return null;
        }

        public void consume(Object paramObj, DaemonControl ctrl) throws Throwable {
            block34: {
                try {
                    this.lastCheckTime = System.currentTimeMillis();
                    ArrayList<Window> missingWindows = null;
                    if (this.messageReceiver.getMissingWindowSize() == 0) {
                        List ws;
                        MessageId latestMessageId = this.messageReceiver.getLatestMessageId();
                        if (latestMessageId == null) {
                            return;
                        }
                        if (ClientConnectionImpl.this.missingWindowTimeout > this.lastCheckTime - this.messageReceiver.getLatestMessageReceiveTime() || ClientConnectionImpl.this.newMessagePollingInterval > this.lastCheckTime - this.lastPollingTime) {
                            return;
                        }
                        this.lastPollingTime = this.lastCheckTime;
                        InterpolateRequestMessage request = new InterpolateRequestMessage();
                        request.setLatestMessageId(latestMessageId);
                        InterpolateResponseMessage response = null;
                        long start = System.currentTimeMillis();
                        try {
                            ClientConnectionImpl.this.newMessagePollingCount++;
                            response = (InterpolateResponseMessage)ClientConnectionImpl.this.send(request, true);
                        }
                        catch (SocketTimeoutException e) {
                            ClientConnectionImpl.this.newMessagePollingTimeoutCount++;
                        }
                        ClientConnectionImpl.this.newMessagePollingResponseTime += System.currentTimeMillis() - start;
                        List list = ws = response == null ? null : response.getWindows();
                        if (ws != null) {
                            missingWindows = new ArrayList();
                            missingWindows.addAll(ws);
                        }
                    } else {
                        MessageId lastMessageId = this.messageReceiver.getLatestMessageId();
                        List windows = this.messageReceiver.getMissingWindows();
                        MessageId currentFirstMessageId = null;
                        if (lastMessageId == null && windows.size() != 0) {
                            currentFirstMessageId = ((Window)windows.get(0)).toMessageId();
                        }
                        List missingMessageIds = null;
                        List missingWindowIds = null;
                        boolean isMissingWindowCount = false;
                        for (int i = 0; i < windows.size(); ++i) {
                            long missingTime;
                            Window window = (Window)windows.get(i);
                            if (!isMissingWindowCount && (missingTime = this.lastCheckTime - window.getReceiveTime()) < ClientConnectionImpl.this.missingWindowTimeout) {
                                if (i != 0 || ClientConnectionImpl.this.missingWindowCount == 0 || windows.size() <= ClientConnectionImpl.this.missingWindowCount) break;
                                isMissingWindowCount = true;
                            }
                            if (lastMessageId != null) {
                                missingMessageIds = lastMessageId.createMissingIds(window, missingMessageIds);
                            }
                            lastMessageId = window.toMessageId();
                            if (window.isComplete() || window.isLost()) continue;
                            missingWindowIds = window.getMissingWindowIds(missingWindowIds);
                        }
                        if (currentFirstMessageId != null || missingMessageIds != null || missingWindowIds != null) {
                            InterpolateRequestMessage request = new InterpolateRequestMessage();
                            if (currentFirstMessageId != null) {
                                request.setCurrentFirstMessageId(currentFirstMessageId);
                            }
                            if (missingMessageIds != null) {
                                request.setMessageIds(missingMessageIds.toArray(new MessageId[missingMessageIds.size()]));
                            }
                            if (missingWindowIds != null) {
                                request.setWindowIds(missingWindowIds.toArray(new WindowId[missingWindowIds.size()]));
                            }
                            InterpolateResponseMessage response = null;
                            long start = System.currentTimeMillis();
                            try {
                                ClientConnectionImpl.this.missingWindowRequestCount++;
                                response = (InterpolateResponseMessage)ClientConnectionImpl.this.send(request, true);
                            }
                            catch (SocketTimeoutException e) {
                                ClientConnectionImpl.this.missingWindowRequestTimeoutCount++;
                            }
                            ClientConnectionImpl.this.missingWindowResponseTime += System.currentTimeMillis() - start;
                            if (response != null) {
                                MessageId id;
                                int imax;
                                List ws;
                                missingWindows = new ArrayList<Window>();
                                ArrayList<MessageId> lostIds = new ArrayList<MessageId>();
                                HashSet<MessageId> lostMessageIds = new HashSet<MessageId>();
                                if (currentFirstMessageId != null && (ws = response.getWindows()) != null) {
                                    missingWindows.addAll(ws);
                                }
                                if (missingMessageIds != null) {
                                    imax = missingMessageIds.size();
                                    for (int i = 0; i < imax; ++i) {
                                        id = (MessageId)missingMessageIds.get(i);
                                        List ws2 = response.getWindows(id);
                                        if (ws2 == null) {
                                            lostIds.add(id);
                                            lostMessageIds.add(id);
                                            Window w = new Window();
                                            w.sequence = id.sequence;
                                            w.setWindowCount((short)1);
                                            w.setLost(true);
                                            missingWindows.add(w);
                                            continue;
                                        }
                                        missingWindows.addAll(ws2);
                                    }
                                }
                                if (missingWindowIds != null) {
                                    imax = missingWindowIds.size();
                                    for (int i = 0; i < imax; ++i) {
                                        id = (WindowId)missingWindowIds.get(i);
                                        Window window = response.getWindow((WindowId)id);
                                        if (window == null) {
                                            lostIds.add(id);
                                            lostMessageIds.add(((WindowId)id).toMessageId());
                                            Window exists = this.messageReceiver.getMissingWindow(((WindowId)id).toMessageId());
                                            Window w = new Window();
                                            w.sequence = ((WindowId)id).sequence;
                                            w.windowNo = ((WindowId)id).windowNo;
                                            w.setWindowCount(exists == null ? (short)1 : exists.getWindowCount());
                                            w.setLost(true);
                                            missingWindows.add(w);
                                            continue;
                                        }
                                        missingWindows.add(window);
                                    }
                                }
                                if (lostIds.size() != 0 && ClientConnectionImpl.this.messageLostErrorMessageId != null) {
                                    ClientConnectionImpl.this.lostCount += lostMessageIds.size();
                                    ServiceManagerFactory.getLogger().write(ClientConnectionImpl.this.messageLostErrorMessageId, new Object[]{ClientConnectionImpl.this, lostIds});
                                }
                            }
                        }
                    }
                    if (missingWindows != null && missingWindows.size() != 0) {
                        Collections.sort(missingWindows);
                        int imax = missingWindows.size();
                        for (int i = 0; i < imax; ++i) {
                            Window window = (Window)missingWindows.get(i);
                            this.messageReceiver.receiveWindow(window);
                        }
                        ClientConnectionImpl.this.receivePacketQueue.push(null);
                    }
                }
                catch (IOException e) {
                    if (ClientConnectionImpl.this.isClosing || !ClientConnectionImpl.this.isConnected) {
                        return;
                    }
                    if (ClientConnectionImpl.this.receiveWarnMessageId != null) {
                        ServiceManagerFactory.getLogger().write(ClientConnectionImpl.this.receiveWarnMessageId, new Object[]{ClientConnectionImpl.this}, (Throwable)e);
                    }
                }
                catch (ClassNotFoundException e) {
                    if (ClientConnectionImpl.this.isClosing || !ClientConnectionImpl.this.isConnected) {
                        return;
                    }
                    if (ClientConnectionImpl.this.receiveWarnMessageId == null) break block34;
                    ServiceManagerFactory.getLogger().write(ClientConnectionImpl.this.receiveWarnMessageId, new Object[]{ClientConnectionImpl.this}, (Throwable)e);
                }
            }
        }

        public void garbage() {
        }
    }

    private class MessageReceiver
    implements DaemonRunnable {
        public MessageId latestMessageId;
        public long latestMessageReceiveTime;
        public SortedMap missingWindowMap = Collections.synchronizedSortedMap(new TreeMap());
        private MissingWindowChecker missingWindowChecker;

        private MessageReceiver() {
        }

        public void setMissingWindowChecker(MissingWindowChecker checker) {
            this.missingWindowChecker = checker;
        }

        public boolean onStart() {
            return true;
        }

        public boolean onStop() {
            return true;
        }

        public boolean onSuspend() {
            return true;
        }

        public boolean onResume() {
            return true;
        }

        public Object provide(DaemonControl ctrl) throws Throwable {
            return ClientConnectionImpl.this.receivePacketQueue.get(1000L);
        }

        public void consume(Object paramObj, DaemonControl ctrl) throws Throwable {
            if (ClientConnectionImpl.this.messageListener == null) {
                return;
            }
            DatagramPacket packet = (DatagramPacket)paramObj;
            Window window = null;
            try {
                if (packet != null) {
                    ByteArrayInputStream bais = new ByteArrayInputStream(packet.getData());
                    DataInputStream dis = new DataInputStream(bais);
                    window = new Window();
                    window.read(dis);
                }
                this.receiveWindow(window);
            }
            catch (IOException e) {
                if (!ClientConnectionImpl.this.isClosing && ClientConnectionImpl.this.isConnected && ClientConnectionImpl.this.receiveErrorMessageId != null) {
                    ServiceManagerFactory.getLogger().write(ClientConnectionImpl.this.receiveErrorMessageId, new Object[]{ClientConnectionImpl.this}, (Throwable)e);
                }
                return;
            }
            catch (ClassNotFoundException e) {
                if (!ClientConnectionImpl.this.isClosing && ClientConnectionImpl.this.isConnected && ClientConnectionImpl.this.receiveErrorMessageId != null) {
                    ServiceManagerFactory.getLogger().write(ClientConnectionImpl.this.receiveErrorMessageId, new Object[]{ClientConnectionImpl.this}, (Throwable)e);
                }
                return;
            }
        }

        public synchronized void receiveWindow(Window window) throws IOException, ClassNotFoundException {
            MessageImpl message = null;
            while ((message = this.retrieveMessage(window)) != null) {
                window = null;
                this.handleMessage(message);
            }
        }

        private void handleMessage(MessageImpl message) {
            if (message == null || message.isLost()) {
                return;
            }
            ClientConnectionImpl.this.receiveCount++;
            long sTime = System.currentTimeMillis();
            ClientConnectionImpl.this.messageListener.onMessage(message);
            ClientConnectionImpl.this.onMessageProcessTime += System.currentTimeMillis() - sTime;
        }

        private void checkMissingWindowTimeout() {
            if (this.missingWindowMap.size() == 0) {
                return;
            }
            if (ClientConnectionImpl.this.missingWindowCount != 0 && this.missingWindowMap.size() > ClientConnectionImpl.this.missingWindowCount) {
                this.missingWindowChecker.notifyChecker();
                return;
            }
            MessageId firstId = (MessageId)this.missingWindowMap.firstKey();
            Window window = (Window)this.missingWindowMap.get(firstId);
            if (window == null) {
                return;
            }
            if (ClientConnectionImpl.this.missingWindowTimeout < System.currentTimeMillis() - window.getReceiveTime()) {
                this.missingWindowChecker.notifyChecker();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private MessageImpl retrieveMessage(Window window) throws IOException, ClassNotFoundException {
            SortedMap sortedMap;
            MulticastMessageImpl multicastMessage;
            MessageId id = window == null ? null : window.toMessageId();
            MessageImpl message = null;
            if (window == null) {
                if (this.missingWindowMap.size() == 0) {
                    return null;
                }
                id = (MessageId)this.missingWindowMap.firstKey();
                window = (Window)this.missingWindowMap.get(id);
                if (!window.isComplete() && !window.isLost()) return null;
                message = window.getMessage(ClientConnectionImpl.this.externalizer);
            } else if (window.isComplete()) {
                message = window.getMessage(ClientConnectionImpl.this.externalizer);
            } else {
                Window w = (Window)this.missingWindowMap.get(id);
                if (w == null) {
                    if (this.latestMessageId == null || this.latestMessageId.compareTo(id) < 0) {
                        SortedMap sortedMap2 = this.missingWindowMap;
                        synchronized (sortedMap2) {
                            this.missingWindowMap.put(id, window);
                            if (ClientConnectionImpl.this.maxMissingWindowSize < this.missingWindowMap.size()) {
                                ClientConnectionImpl.this.maxMissingWindowSize = this.missingWindowMap.size();
                            }
                        }
                        this.checkMissingWindowTimeout();
                        return null;
                    }
                    ClientConnectionImpl.this.wasteWindowCount++;
                    return null;
                }
                if (!w.addWindow(window)) return null;
                return this.retrieveMessage(null);
            }
            if (message == null) {
                return null;
            }
            if (ClientConnectionImpl.this.receiveAddress != null && !(multicastMessage = (MulticastMessageImpl)message).containsId(ClientConnectionImpl.this.id)) {
                SortedMap sortedMap3 = this.missingWindowMap;
                synchronized (sortedMap3) {
                    this.missingWindowMap.remove(id);
                    return this.retrieveMessage(null);
                }
            }
            if (this.latestMessageId == null) {
                if (!message.isFirst()) {
                    if (this.missingWindowMap.containsKey(id)) return null;
                    sortedMap = this.missingWindowMap;
                    synchronized (sortedMap) {
                        this.missingWindowMap.put(id, window);
                        if (ClientConnectionImpl.this.maxMissingWindowSize < this.missingWindowMap.size()) {
                            ClientConnectionImpl.this.maxMissingWindowSize = this.missingWindowMap.size();
                        }
                    }
                    this.checkMissingWindowTimeout();
                    return null;
                }
            } else {
                if (this.latestMessageId.compareTo(id) >= 0) {
                    ClientConnectionImpl.this.wasteWindowCount++;
                    sortedMap = this.missingWindowMap;
                    synchronized (sortedMap) {
                        this.missingWindowMap.remove(id);
                        return null;
                    }
                }
                if (!this.latestMessageId.isNext(message)) {
                    ClientConnectionImpl.this.noContinuousMessageCount++;
                    if (window == null || this.missingWindowMap.containsKey(id)) return null;
                    sortedMap = this.missingWindowMap;
                    synchronized (sortedMap) {
                        this.missingWindowMap.put(id, window);
                        if (ClientConnectionImpl.this.maxMissingWindowSize < this.missingWindowMap.size()) {
                            ClientConnectionImpl.this.maxMissingWindowSize = this.missingWindowMap.size();
                        }
                    }
                    this.checkMissingWindowTimeout();
                    return this.retrieveMessage(null);
                }
            }
            sortedMap = this.missingWindowMap;
            synchronized (sortedMap) {
                this.missingWindowMap.remove(id);
            }
            this.latestMessageReceiveTime = message.getReceiveTime();
            this.latestMessageId = id;
            return message;
        }

        private synchronized void reset() {
            this.latestMessageId = null;
            this.missingWindowMap.clear();
        }

        public void garbage() {
        }

        public int getMissingWindowSize() {
            return this.missingWindowMap.size();
        }

        public Window getMissingWindow(MessageId id) {
            return (Window)this.missingWindowMap.get(id);
        }

        public MessageId getLatestMessageId() {
            return this.latestMessageId;
        }

        public long getLatestMessageReceiveTime() {
            return this.latestMessageReceiveTime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List getMissingWindows() {
            if (this.missingWindowMap.size() == 0) {
                return new ArrayList();
            }
            SortedMap sortedMap = this.missingWindowMap;
            synchronized (sortedMap) {
                return new ArrayList(this.missingWindowMap.values());
            }
        }
    }

    private class PacketReceiver
    implements DaemonRunnable {
        private PacketReceiver() {
        }

        public boolean onStart() {
            return true;
        }

        public boolean onStop() {
            return true;
        }

        public boolean onSuspend() {
            return true;
        }

        public boolean onResume() {
            return true;
        }

        public Object provide(DaemonControl ctrl) throws Throwable {
            try {
                byte[] buf = new byte[ClientConnectionImpl.this.windowSize];
                DatagramPacket packet = new DatagramPacket(buf, buf.length);
                ClientConnectionImpl.this.receiveSocket.receive(packet);
                return packet;
            }
            catch (SocketException e) {
                if (ClientConnectionImpl.this.isClosing || !ClientConnectionImpl.this.isConnected) {
                    return null;
                }
                if (ClientConnectionImpl.this.receiveErrorMessageId != null) {
                    ServiceManagerFactory.getLogger().write(ClientConnectionImpl.this.receiveErrorMessageId, new Object[]{ClientConnectionImpl.this}, (Throwable)e);
                }
                ClientConnectionImpl.this.close();
                return null;
            }
            catch (EOFException e) {
                if (ClientConnectionImpl.this.isClosing || !ClientConnectionImpl.this.isConnected) {
                    return null;
                }
                if (ClientConnectionImpl.this.receiveErrorMessageId != null) {
                    ServiceManagerFactory.getLogger().write(ClientConnectionImpl.this.receiveErrorMessageId, new Object[]{ClientConnectionImpl.this}, (Throwable)e);
                }
                ClientConnectionImpl.this.close();
                return null;
            }
            catch (IOException e) {
                if (ClientConnectionImpl.this.isClosing || !ClientConnectionImpl.this.isConnected) {
                    return null;
                }
                if (ClientConnectionImpl.this.receiveWarnMessageId != null) {
                    ServiceManagerFactory.getLogger().write(ClientConnectionImpl.this.receiveWarnMessageId, new Object[]{ClientConnectionImpl.this}, (Throwable)e);
                }
                return null;
            }
        }

        public void consume(Object paramObj, DaemonControl ctrl) throws Throwable {
            if (paramObj == null || ClientConnectionImpl.this.receivePacketQueue == null || ClientConnectionImpl.this.messageListener == null || !ClientConnectionImpl.this.isStartReceive) {
                return;
            }
            ClientConnectionImpl.this.receivePacketCount++;
            DatagramPacket packet = (DatagramPacket)paramObj;
            ClientConnectionImpl.this.receivePacketQueue.push(packet);
        }

        public void garbage() {
        }
    }

    private class ReplyReceiver
    implements DaemonRunnable {
        public SynchronizeMonitor replyMonitor = new WaitSynchronizeMonitor();
        public List replyMessages = Collections.synchronizedList(new ArrayList());

        private ReplyReceiver() {
        }

        public boolean onStart() {
            return true;
        }

        public boolean onStop() {
            return true;
        }

        public boolean onSuspend() {
            return true;
        }

        public boolean onResume() {
            return true;
        }

        public Object provide(DaemonControl ctrl) throws Throwable {
            try {
                DataInputStream dis = new DataInputStream(ClientConnectionImpl.this.socket.getInputStream());
                int length = dis.readInt();
                ServerMessage message = null;
                if (length > 0) {
                    byte[] dataBytes = new byte[length];
                    dis.readFully(dataBytes, 0, length);
                    ByteArrayInputStream is = new ByteArrayInputStream(dataBytes);
                    if (ClientConnectionImpl.this.externalizer == null) {
                        ObjectInputStream ois = new ObjectInputStream(is);
                        message = (ServerMessage)ois.readObject();
                    } else {
                        message = (ServerMessage)ClientConnectionImpl.this.externalizer.readExternal(is);
                    }
                } else {
                    return null;
                }
                if (message != null && message.getMessageType() == 2) {
                    if (ClientConnectionImpl.this.serverCloseMessageId != null) {
                        ServiceManagerFactory.getLogger().write(ClientConnectionImpl.this.serverCloseMessageId, new Object[]{ClientConnectionImpl.this});
                    }
                    ClientConnectionImpl.this.close();
                    return null;
                }
                return message;
            }
            catch (SocketTimeoutException e) {
                return null;
            }
            catch (SocketException e) {
                this.replyMessages.add(e);
                this.replyMonitor.notifyAllMonitor();
                if (ClientConnectionImpl.this.isClosing || !ClientConnectionImpl.this.isConnected) {
                    return null;
                }
                if (ClientConnectionImpl.this.reconnectCount > 0) {
                    try {
                        ClientConnectionImpl.this.reconnect();
                        return null;
                    }
                    catch (ConnectException e2) {
                    }
                    catch (MessageSendException e2) {
                        // empty catch block
                    }
                }
                if (ClientConnectionImpl.this.receiveErrorMessageId != null) {
                    ServiceManagerFactory.getLogger().write(ClientConnectionImpl.this.receiveErrorMessageId, new Object[]{ClientConnectionImpl.this}, (Throwable)e);
                }
                ClientConnectionImpl.this.close();
                return null;
            }
            catch (EOFException e) {
                this.replyMessages.add(e);
                this.replyMonitor.notifyAllMonitor();
                if (ClientConnectionImpl.this.isClosing || !ClientConnectionImpl.this.isConnected) {
                    return null;
                }
                if (ClientConnectionImpl.this.reconnectCount > 0) {
                    try {
                        ClientConnectionImpl.this.reconnect();
                        return null;
                    }
                    catch (ConnectException e2) {
                    }
                    catch (MessageSendException messageSendException) {
                        // empty catch block
                    }
                }
                if (ClientConnectionImpl.this.receiveErrorMessageId != null) {
                    ServiceManagerFactory.getLogger().write(ClientConnectionImpl.this.receiveErrorMessageId, new Object[]{ClientConnectionImpl.this}, (Throwable)e);
                }
                ClientConnectionImpl.this.close();
                return null;
            }
            catch (ClassNotFoundException e) {
                return e;
            }
            catch (IOException e) {
                return e;
            }
        }

        public void consume(Object paramObj, DaemonControl ctrl) throws Throwable {
            if (paramObj == null) {
                return;
            }
            this.replyMessages.add(paramObj);
            this.replyMonitor.notifyAllMonitor();
        }

        public void garbage() {
        }

        public void initReply() {
            this.replyMonitor.initMonitor();
        }

        public ServerMessage getReply(RequestReplyMessage request, long timeout) throws IOException, ClassNotFoundException {
            long start = System.currentTimeMillis();
            Object response = null;
            long wait = timeout;
            do {
                if (this.replyMessages.size() != 0) {
                    response = this.replyMessages.remove(0);
                } else {
                    try {
                        if (wait == 0L) {
                            this.replyMonitor.waitMonitor();
                        } else {
                            this.replyMonitor.waitMonitor(wait);
                        }
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                    if (this.replyMessages.size() != 0) {
                        response = this.replyMessages.remove(0);
                    }
                }
                if (response != null && response instanceof RequestReplyMessage) {
                    if (request.compareRequestId(response) > 0) {
                        this.replyMonitor.initMonitor();
                        wait -= System.currentTimeMillis() - start;
                        continue;
                    }
                    wait = 0L;
                    continue;
                }
                wait = 0L;
            } while (wait > 0L);
            if (response == null) {
                throw new SocketTimeoutException("wait_time=" + (System.currentTimeMillis() - start) + "[ms]");
            }
            if (response instanceof ServerMessage) {
                return response;
            }
            if (response instanceof IOException) {
                throw (IOException)response;
            }
            if (response instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)response;
            }
            return null;
        }
    }
}

