/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.publish.tcp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import jp.ossc.nimbus.service.io.Externalizer;
import jp.ossc.nimbus.service.publish.Message;
import jp.ossc.nimbus.service.publish.MessageException;

public class MessageImpl
implements Message,
Externalizable {
    private transient String subject;
    private Map subjectMap = new LinkedHashMap();
    private Object object;
    private transient byte[] bytes;
    private transient long sendTime;
    private transient long receiveTime;
    private boolean isServerClose;
    private transient Set destinationIds;
    private transient byte[] serializedBytes;

    public MessageImpl() {
    }

    public MessageImpl(boolean isServerClose) {
        this.isServerClose = isServerClose;
    }

    public String getSubject() {
        Set subjects = this.getSubjects();
        if (subjects.size() == 0) {
            return null;
        }
        if (this.subject == null) {
            this.subject = (String)subjects.iterator().next();
        }
        return this.subject;
    }

    public Set getSubjects() {
        return this.subjectMap.keySet();
    }

    public void setSubject(String sbj, String key) {
        if (this.subjectMap.size() == 0) {
            this.subject = sbj;
        }
        this.subjectMap.put(sbj, key);
    }

    public String getKey(String sbj) {
        return (String)this.subjectMap.get(sbj);
    }

    public String getKey() {
        return this.getKey(this.getSubject());
    }

    public void setObject(Object obj) throws MessageException {
        this.object = obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getObject() throws MessageException {
        if (this.object != null || this.serializedBytes == null) return this.object;
        byte[] byArray = this.serializedBytes;
        synchronized (this.serializedBytes) {
            if (this.object != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return this.object;
            }
            try {
                ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(this.serializedBytes));
                this.object = ois.readObject();
            }
            catch (IOException e) {
                throw new MessageException(e);
            }
            catch (ClassNotFoundException e) {
                throw new MessageException(e);
            }
            return this.object;
        }
    }

    public void setSerializedBytes(byte[] bytes) {
        this.serializedBytes = bytes;
    }

    public byte[] getSerializedBytes() {
        return this.serializedBytes;
    }

    public long getSendTime() {
        return this.sendTime;
    }

    public void setSendTime(long time) {
        this.sendTime = time;
    }

    public long getReceiveTime() {
        return this.receiveTime;
    }

    public void setServerClose(boolean isServerClose) {
        this.isServerClose = isServerClose;
    }

    public boolean isServerClose() {
        return this.isServerClose;
    }

    public Set getDestinationIds() {
        return this.destinationIds;
    }

    public void setDestinationIds(Set ids) {
        this.destinationIds = ids;
    }

    public void addDestinationId(Object id) {
        if (id == null) {
            return;
        }
        if (this.destinationIds == null) {
            this.destinationIds = new HashSet();
        }
        if (id instanceof Collection) {
            this.destinationIds.addAll((Collection)id);
        } else {
            this.destinationIds.add(id);
        }
    }

    public void removeDestinationId(Object id) {
        if (this.destinationIds == null) {
            return;
        }
        this.destinationIds.remove(id);
    }

    public void clearDestinationIds() {
        if (this.destinationIds == null) {
            return;
        }
        this.destinationIds.clear();
    }

    public boolean containsDestinationId(Object id) {
        if (this.destinationIds == null || this.destinationIds.size() == 0) {
            return true;
        }
        if (id instanceof Collection) {
            Iterator itr = ((Collection)id).iterator();
            while (itr.hasNext()) {
                if (!this.destinationIds.contains(itr.next())) continue;
                return true;
            }
            return false;
        }
        return this.destinationIds.contains(id);
    }

    public synchronized void write(OutputStream out, Externalizer ext) throws IOException {
        if (this.bytes == null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            if (ext == null) {
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(this);
                oos.flush();
            } else {
                ext.writeExternal((Object)this, baos);
            }
            this.bytes = baos.toByteArray();
        }
        out.write(this.bytes);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(super.toString());
        buf.append('{');
        buf.append("subjectMap=").append(this.subjectMap);
        buf.append(", object=").append(this.object);
        buf.append('}');
        return buf.toString();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeBoolean(this.isServerClose);
        out.writeObject(this.subjectMap);
        if (this.serializedBytes == null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(this.object);
            oos.flush();
            out.writeObject(baos.toByteArray());
        } else {
            out.writeObject(this.serializedBytes);
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.isServerClose = in.readBoolean();
        this.subjectMap = (Map)in.readObject();
        this.serializedBytes = (byte[])in.readObject();
        this.receiveTime = System.currentTimeMillis();
    }
}

