/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.publish.tcp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.net.SocketFactory;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceBaseMBean;
import jp.ossc.nimbus.core.ServiceManager;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.daemon.Daemon;
import jp.ossc.nimbus.daemon.DaemonControl;
import jp.ossc.nimbus.daemon.DaemonRunnable;
import jp.ossc.nimbus.service.io.Externalizer;
import jp.ossc.nimbus.service.publish.ClientConnection;
import jp.ossc.nimbus.service.publish.ConnectException;
import jp.ossc.nimbus.service.publish.Message;
import jp.ossc.nimbus.service.publish.MessageCommunicateException;
import jp.ossc.nimbus.service.publish.MessageListener;
import jp.ossc.nimbus.service.publish.MessageSendException;
import jp.ossc.nimbus.service.publish.tcp.AddMessage;
import jp.ossc.nimbus.service.publish.tcp.ByeMessage;
import jp.ossc.nimbus.service.publish.tcp.ClientMessage;
import jp.ossc.nimbus.service.publish.tcp.IdMessage;
import jp.ossc.nimbus.service.publish.tcp.MessageImpl;
import jp.ossc.nimbus.service.publish.tcp.RemoveMessage;
import jp.ossc.nimbus.service.publish.tcp.StartReceiveMessage;
import jp.ossc.nimbus.service.publish.tcp.StopReceiveMessage;

public class ClientConnectionImpl
implements ClientConnection,
DaemonRunnable,
Serializable {
    private static final long serialVersionUID = 1030521584023804873L;
    public static final String BIND_ADDRESS_PROPERTY = "jp.ossc.nimbus.service.publish.tcp.bindAddress";
    public static final String BIND_PORT_PROPERTY = "jp.ossc.nimbus.service.publish.tcp.bindPort";
    private String address;
    private int port;
    private SocketFactory socketFactory;
    private Externalizer externalizer;
    private String bindAddressPropertyName = "jp.ossc.nimbus.service.publish.tcp.bindAddress";
    private String bindPortPropertyName = "jp.ossc.nimbus.service.publish.tcp.bindPort";
    private String serverCloseMessageId;
    private String receiveWarnMessageId;
    private String receiveErrorMessageId;
    private int reconnectCount;
    private long reconnectInterval;
    private long reconnectBufferTime;
    private ServiceName serverServiceName;
    private transient Socket socket;
    private transient Map subjects;
    private transient MessageListener messageListener;
    private transient Daemon messageReceiveDaemon;
    private transient boolean isClosing;
    private transient boolean isConnected;
    private transient boolean isReconnecting;
    private transient Object id;
    private transient String serviceManagerName;
    private transient ServiceName serviceName;
    private transient long receiveCount;
    private transient long receiveProcessTime;
    private transient long onMessageProcessTime;
    private transient boolean isStartReceive;
    private transient Message latestMessage;
    private long startTime;

    public ClientConnectionImpl(String address, int port, SocketFactory factory, Externalizer ext, ServiceName serverServiceName) {
        this.address = address;
        this.port = port;
        this.socketFactory = factory;
        this.externalizer = ext;
        this.serverServiceName = serverServiceName;
    }

    public void setBindAddressPropertyName(String name) {
        this.bindAddressPropertyName = name;
    }

    public String getBindAddressPropertyName() {
        return this.bindAddressPropertyName;
    }

    public void setBindPortPropertyName(String name) {
        this.bindPortPropertyName = name;
    }

    public String getBindPortPropertyName() {
        return this.bindPortPropertyName;
    }

    public void setServerCloseMessageId(String id) {
        this.serverCloseMessageId = id;
    }

    public String getServerCloseMessageId() {
        return this.serverCloseMessageId;
    }

    public void setReceiveWarnMessageId(String id) {
        this.receiveWarnMessageId = id;
    }

    public String getReceiveWarnMessageId() {
        return this.receiveWarnMessageId;
    }

    public void setReceiveErrorMessageId(String id) {
        this.receiveErrorMessageId = id;
    }

    public String getReceiveErrorMessageId() {
        return this.receiveErrorMessageId;
    }

    public void setReconnectCount(int count) {
        this.reconnectCount = count;
    }

    public int getReconnectCount() {
        return this.reconnectCount;
    }

    public void setReconnectInterval(long interval) {
        this.reconnectInterval = interval;
    }

    public long getReconnectInterval() {
        return this.reconnectInterval;
    }

    public void setReconnectBufferTime(long time) {
        this.reconnectBufferTime = time;
    }

    public long getReconnectBufferTime() {
        return this.reconnectBufferTime;
    }

    private String getProperty(String name) {
        String prop = System.getProperty(name);
        if (prop == null) {
            prop = ServiceManagerFactory.getProperty(name);
        }
        return prop;
    }

    private InetAddress getBindAddress() throws UnknownHostException {
        String bindAddress = this.getProperty(this.bindAddressPropertyName);
        InetAddress address = null;
        address = bindAddress == null ? InetAddress.getLocalHost() : InetAddress.getByName(bindAddress);
        return address;
    }

    private int getBindPort() throws NumberFormatException {
        String bindPort = this.getProperty(this.bindPortPropertyName);
        int port = 0;
        if (bindPort != null) {
            port = Integer.parseInt(bindPort);
        }
        return port;
    }

    public void setServiceManagerName(String name) {
        this.serviceManagerName = name;
    }

    public void connect() throws ConnectException {
        this.connect(null);
    }

    public synchronized void connect(Object id) throws ConnectException {
        block16: {
            if (this.socket != null) {
                return;
            }
            this.isConnected = false;
            InetAddress bindAddress = null;
            int bindPort = 0;
            try {
                bindAddress = this.getBindAddress();
                bindPort = this.getBindPort();
                this.socket = this.socketFactory == null ? new Socket(this.address, this.port, bindAddress, bindPort) : this.socketFactory.createSocket(this.address, this.port, bindAddress, bindPort);
            }
            catch (UnknownHostException e) {
                throw new ConnectException("address=" + this.address + ", port=" + this.port + ", bindAddress=" + bindAddress + ", bindPort=" + bindPort, e);
            }
            catch (NumberFormatException e) {
                throw new ConnectException(e);
            }
            catch (IOException e) {
                throw new ConnectException("address=" + this.address + ", port=" + this.port + ", bindAddress=" + bindAddress + ", bindPort=" + bindPort, e);
            }
            try {
                ServiceManager manager;
                if (this.messageReceiveDaemon == null) {
                    this.messageReceiveDaemon = new Daemon(this);
                    this.messageReceiveDaemon.setDaemon(true);
                    this.messageReceiveDaemon.setName("Nimbus Publish(TCP) ClientConnection SocketReader " + this.socket.getLocalSocketAddress());
                    this.messageReceiveDaemon.start();
                }
                this.id = id == null ? this.socket.getLocalSocketAddress() : id;
                try {
                    this.send(new IdMessage(this.id));
                }
                catch (IOException e) {
                    throw new ConnectException(e);
                }
                if (this.serviceManagerName == null || this.serverServiceName == null || (manager = ServiceManagerFactory.findManager(this.serviceManagerName)) == null) break block16;
                ClientConnectionService ccs = new ClientConnectionService();
                try {
                    String name = this.serverServiceName.getServiceName() + '$' + this.socket.getLocalSocketAddress();
                    name = name.replaceAll(":", "\\$");
                    if (!manager.isRegisteredService(name) && manager.registerService(name, ccs)) {
                        this.serviceName = ccs.getServiceNameObject();
                        manager.createService(ccs.getServiceName());
                        manager.startService(ccs.getServiceName());
                    }
                }
                catch (Exception e) {
                    throw new ConnectException(e);
                }
            }
            catch (ConnectException e) {
                if (this.socket != null) {
                    try {
                        this.socket.close();
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                    this.socket = null;
                }
                throw e;
            }
        }
        this.isConnected = true;
    }

    public void addSubject(String subject) throws MessageSendException {
        this.addSubject(subject, null);
    }

    public void addSubject(String subject, String[] keys) throws MessageSendException {
        Set<Object> keySet;
        if (this.socket == null) {
            throw new MessageSendException("Not connected.");
        }
        if (subject == null) {
            return;
        }
        try {
            this.send(new AddMessage(subject, keys));
        }
        catch (SocketTimeoutException e) {
            throw new MessageSendException(e);
        }
        catch (SocketException e) {
            throw new MessageSendException(e);
        }
        catch (IOException e) {
            throw new MessageSendException(e);
        }
        if (this.subjects == null) {
            this.subjects = Collections.synchronizedMap(new HashMap());
        }
        if ((keySet = (Set<Object>)this.subjects.get(subject)) == null) {
            keySet = Collections.synchronizedSet(new HashSet());
            this.subjects.put(subject, keySet);
        }
        if (keys == null) {
            keySet.add(null);
        } else {
            for (int i = 0; i < keys.length; ++i) {
                keySet.add(keys[i]);
            }
        }
    }

    public void removeSubject(String subject) throws MessageSendException {
        this.removeSubject(subject, null);
    }

    public void removeSubject(String subject, String[] keys) throws MessageSendException {
        Set keySet;
        if (this.socket == null) {
            throw new MessageSendException("Not connected.");
        }
        if (subject == null) {
            return;
        }
        try {
            this.send(new RemoveMessage(subject, keys));
        }
        catch (SocketTimeoutException e) {
            throw new MessageSendException(e);
        }
        catch (SocketException e) {
            throw new MessageSendException(e);
        }
        catch (IOException e) {
            throw new MessageSendException(e);
        }
        if (this.subjects != null && (keySet = (Set)this.subjects.get(subject)) != null) {
            if (keys == null) {
                keySet.remove(null);
            } else {
                for (int i = 0; i < keys.length; ++i) {
                    keySet.remove(keys[i]);
                }
            }
            if (keySet.size() == 0) {
                this.subjects.remove(subject);
            }
        }
    }

    public void startReceive() throws MessageSendException {
        this.startReceive(-1L);
    }

    public void startReceive(long from) throws MessageSendException {
        this.startReceive(from, false);
    }

    private void startReceive(long from, boolean isRestart) throws MessageSendException {
        if (this.socket == null) {
            throw new MessageSendException("Not connected.");
        }
        if (!isRestart && this.isStartReceive) {
            return;
        }
        try {
            this.send(new StartReceiveMessage(from));
            this.isStartReceive = true;
        }
        catch (SocketTimeoutException e) {
            throw new MessageSendException(e);
        }
        catch (SocketException e) {
            throw new MessageSendException(e);
        }
        catch (IOException e) {
            throw new MessageSendException(e);
        }
    }

    public boolean isStartReceive() {
        return this.isStartReceive;
    }

    public void stopReceive() throws MessageSendException {
        if (this.socket == null) {
            throw new MessageSendException("Not connected.");
        }
        if (!this.isStartReceive) {
            return;
        }
        try {
            this.send(new StopReceiveMessage());
            this.isStartReceive = false;
        }
        catch (SocketTimeoutException e) {
            throw new MessageSendException(e);
        }
        catch (SocketException e) {
            throw new MessageSendException(e);
        }
        catch (IOException e) {
            throw new MessageSendException(e);
        }
    }

    public Set getSubjects() {
        return this.subjects == null ? new HashSet() : this.subjects.keySet();
    }

    public Set getKeys(String subject) {
        if (this.subjects == null) {
            return new HashSet();
        }
        Set keySet = (Set)this.subjects.get(subject);
        return keySet == null ? new HashSet() : keySet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void send(ClientMessage message) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (this.externalizer == null) {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(message);
            oos.flush();
        } else {
            this.externalizer.writeExternal((Object)message, baos);
        }
        byte[] bytes = baos.toByteArray();
        ClientConnectionImpl clientConnectionImpl = this;
        synchronized (clientConnectionImpl) {
            DataOutputStream dos = new DataOutputStream(this.socket.getOutputStream());
            dos.writeInt(bytes.length);
            dos.write(bytes);
            dos.flush();
        }
    }

    public void setMessageListener(MessageListener listener) {
        this.messageListener = listener;
    }

    private Message receive() throws MessageCommunicateException {
        if (this.socket == null) {
            return null;
        }
        int length = 0;
        byte[] bytes = null;
        try {
            DataInputStream dis = new DataInputStream(this.socket.getInputStream());
            length = dis.readInt();
            if (length <= 0) {
                return null;
            }
            bytes = new byte[length];
            dis.readFully(bytes, 0, length);
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            MessageImpl message = null;
            if (this.externalizer == null) {
                ObjectInputStream ois = new ObjectInputStream(bais);
                message = (MessageImpl)ois.readObject();
            } else {
                message = (MessageImpl)this.externalizer.readExternal(bais);
            }
            if (message != null && message.isServerClose()) {
                if (this.serverCloseMessageId != null) {
                    ServiceManagerFactory.getLogger().write(this.serverCloseMessageId, new Object[]{this});
                }
                this.close();
                return null;
            }
            return message;
        }
        catch (SocketTimeoutException e) {
            return null;
        }
        catch (SocketException e) {
            if (this.isClosing || !this.isConnected) {
                return null;
            }
            if (this.reconnectCount > 0) {
                if (this.receiveWarnMessageId != null) {
                    ServiceManagerFactory.getLogger().write(this.receiveWarnMessageId, new Object[]{this}, (Throwable)e);
                }
                this.reconnect();
                return this.receive();
            }
            throw new MessageCommunicateException(e);
        }
        catch (EOFException e) {
            if (this.isClosing || !this.isConnected) {
                return null;
            }
            if (this.reconnectCount > 0) {
                if (this.receiveWarnMessageId != null) {
                    ServiceManagerFactory.getLogger().write(this.receiveWarnMessageId, new Object[]{this}, (Throwable)e);
                }
                this.reconnect();
                return this.receive();
            }
            if (length == 0) {
                this.close();
                return null;
            }
            throw new MessageCommunicateException("length=" + length + ", bytes=" + (bytes == null ? "null" : Integer.toString(bytes.length)), e);
        }
        catch (IOException e) {
            if (this.isClosing || !this.isConnected) {
                return null;
            }
            throw new MessageCommunicateException(e);
        }
        catch (ClassNotFoundException e) {
            if (this.isClosing || !this.isConnected) {
                return null;
            }
            throw new MessageCommunicateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void reconnect() throws ConnectException, MessageSendException {
        boolean isNowReconnecting = this.isReconnecting;
        ClientConnectionImpl clientConnectionImpl = this;
        synchronized (clientConnectionImpl) {
            if (isNowReconnecting) {
                return;
            }
            this.isReconnecting = true;
            try {
                if (this.socket != null) {
                    try {
                        this.socket.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    this.socket = null;
                }
                int tryCount = 0;
                boolean isSuccess = false;
                while (!isSuccess) {
                    block26: {
                        block25: {
                            ++tryCount;
                            try {
                                this.connect(this.id);
                                if (this.subjects == null) break block25;
                                Object[] subjectArray = this.subjects.keySet().toArray();
                                for (int i = 0; i < subjectArray.length; ++i) {
                                    Object subject = subjectArray[i];
                                    Set keySet = (Set)this.subjects.get(subject);
                                    if (keySet == null) continue;
                                    String[] keys = keySet.toArray(new String[keySet.size()]);
                                    boolean containsNull = false;
                                    ArrayList<String> keyList = new ArrayList<String>();
                                    for (int j = 0; j < keys.length; ++j) {
                                        if (keys[j] == null) {
                                            containsNull = true;
                                            continue;
                                        }
                                        keyList.add(keys[j]);
                                    }
                                    if (containsNull) {
                                        this.addSubject((String)subject);
                                        keys = keyList.toArray(new String[keyList.size()]);
                                    }
                                    if (keys == null || keys.length == 0) continue;
                                    this.addSubject((String)subject, keys);
                                }
                            }
                            catch (ConnectException e) {
                                if (tryCount >= this.reconnectCount) {
                                    throw e;
                                }
                                if (this.receiveWarnMessageId != null) {
                                    ServiceManagerFactory.getLogger().write(this.receiveWarnMessageId, new Object[]{this}, (Throwable)e);
                                }
                                break block26;
                            }
                            catch (MessageSendException e) {
                                if (tryCount >= this.reconnectCount) {
                                    throw e;
                                }
                                if (this.receiveWarnMessageId != null) {
                                    ServiceManagerFactory.getLogger().write(this.receiveWarnMessageId, new Object[]{this}, (Throwable)e);
                                }
                                break block26;
                            }
                        }
                        if (this.isStartReceive) {
                            long time = -1L;
                            if (this.latestMessage != null) {
                                time = this.latestMessage.getReceiveTime() - this.reconnectBufferTime;
                            }
                            this.startReceive(time, true);
                        }
                        isSuccess = true;
                    }
                    if (isSuccess || this.reconnectInterval <= 0L) continue;
                    try {
                        Thread.sleep(this.reconnectInterval);
                    }
                    catch (InterruptedException e) {
                        throw new ConnectException(e);
                    }
                }
                return;
            }
            finally {
                this.isReconnecting = false;
            }
        }
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public Object getId() {
        return this.id;
    }

    public synchronized void close() {
        this.isClosing = true;
        if (this.serviceName != null) {
            ServiceManagerFactory.unregisterService(this.serviceName.getServiceManagerName(), this.serviceName.getServiceName());
            this.serviceName = null;
        }
        if (this.messageReceiveDaemon != null) {
            this.messageReceiveDaemon.stopNoWait();
            this.messageReceiveDaemon = null;
        }
        if (this.socket != null) {
            try {
                this.send(new ByeMessage());
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.socket = null;
        }
        this.isClosing = false;
        this.isConnected = false;
    }

    public boolean onStart() {
        return true;
    }

    public boolean onStop() {
        return true;
    }

    public boolean onSuspend() {
        return true;
    }

    public boolean onResume() {
        return true;
    }

    public Object provide(DaemonControl ctrl) throws Throwable {
        this.startTime = System.currentTimeMillis();
        try {
            return this.receive();
        }
        catch (MessageCommunicateException e) {
            if (this.isClosing || !this.isConnected) {
                return null;
            }
            if (this.receiveErrorMessageId != null) {
                ServiceManagerFactory.getLogger().write(this.receiveErrorMessageId, new Object[]{this}, (Throwable)e);
            }
            this.close();
            return null;
        }
    }

    public void consume(Object paramObj, DaemonControl ctrl) throws Throwable {
        if (paramObj == null || this.messageListener == null) {
            return;
        }
        this.latestMessage = (Message)paramObj;
        ++this.receiveCount;
        this.receiveProcessTime += System.currentTimeMillis() - this.startTime;
        long sTime = System.currentTimeMillis();
        this.messageListener.onMessage((Message)paramObj);
        this.onMessageProcessTime += System.currentTimeMillis() - sTime;
    }

    public void garbage() {
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(super.toString());
        buf.append('{');
        buf.append("id=").append(this.id);
        buf.append(", localAddress=").append(this.socket == null ? null : this.socket.getLocalSocketAddress());
        buf.append(", remoteAddress=").append(this.socket == null ? null : this.socket.getRemoteSocketAddress());
        buf.append(", subject=").append(this.subjects);
        buf.append('}');
        return buf.toString();
    }

    public static interface ClientConnectionServiceMBean
    extends ServiceBaseMBean {
        public SocketAddress getLocalSocketAddress();

        public SocketAddress getRemoteSocketAddress();

        public Set getSubjects();

        public Set getKeys(String var1);

        public long getReceiveCount();

        public long getAverageReceiveProcessTime();

        public long getAverageOnMessageProcessTime();

        public void resetCount();

        public void connect() throws ConnectException;

        public void connect(Object var1) throws ConnectException;

        public void startReceive() throws MessageSendException;

        public void startReceive(long var1) throws MessageSendException;

        public void stopReceive() throws MessageSendException;

        public boolean isStartReceive();

        public void addSubject(String var1) throws MessageSendException;

        public void addSubject(String var1, String[] var2) throws MessageSendException;

        public void removeSubject(String var1) throws MessageSendException;

        public void removeSubject(String var1, String[] var2) throws MessageSendException;

        public void reconnect() throws ConnectException, MessageSendException;

        public boolean isConnected();

        public void close();
    }

    public class ClientConnectionService
    extends ServiceBase
    implements ClientConnectionServiceMBean {
        private static final long serialVersionUID = -1877859730776359843L;

        public Set getSubjects() {
            return ClientConnectionImpl.this.getSubjects();
        }

        public Set getKeys(String subject) {
            return ClientConnectionImpl.this.getKeys(subject);
        }

        public long getReceiveCount() {
            return ClientConnectionImpl.this.receiveCount;
        }

        public void resetCount() {
            ClientConnectionImpl.this.receiveCount = 0L;
            ClientConnectionImpl.this.receiveProcessTime = 0L;
            ClientConnectionImpl.this.onMessageProcessTime = 0L;
        }

        public long getAverageReceiveProcessTime() {
            return ClientConnectionImpl.this.receiveCount == 0L ? 0L : ClientConnectionImpl.this.receiveProcessTime / ClientConnectionImpl.this.receiveCount;
        }

        public long getAverageOnMessageProcessTime() {
            return ClientConnectionImpl.this.receiveCount == 0L ? 0L : ClientConnectionImpl.this.onMessageProcessTime / ClientConnectionImpl.this.receiveCount;
        }

        public SocketAddress getLocalSocketAddress() {
            return ClientConnectionImpl.this.socket.getLocalSocketAddress();
        }

        public SocketAddress getRemoteSocketAddress() {
            return ClientConnectionImpl.this.socket.getRemoteSocketAddress();
        }

        public void connect() throws ConnectException {
            ClientConnectionImpl.this.connect();
        }

        public void connect(Object id) throws ConnectException {
            ClientConnectionImpl.this.connect(id);
        }

        public void startReceive() throws MessageSendException {
            ClientConnectionImpl.this.startReceive();
        }

        public void startReceive(long from) throws MessageSendException {
            ClientConnectionImpl.this.startReceive(from);
        }

        public void stopReceive() throws MessageSendException {
            ClientConnectionImpl.this.stopReceive();
        }

        public boolean isStartReceive() {
            return ClientConnectionImpl.this.isStartReceive();
        }

        public void addSubject(String subject) throws MessageSendException {
            ClientConnectionImpl.this.addSubject(subject);
        }

        public void addSubject(String subject, String[] keys) throws MessageSendException {
            ClientConnectionImpl.this.addSubject(subject, keys);
        }

        public void removeSubject(String subject) throws MessageSendException {
            ClientConnectionImpl.this.removeSubject(subject);
        }

        public void removeSubject(String subject, String[] keys) throws MessageSendException {
            ClientConnectionImpl.this.removeSubject(subject, keys);
        }

        public void reconnect() throws ConnectException, MessageSendException {
            ClientConnectionImpl.this.reconnect();
        }

        public boolean isConnected() {
            return ClientConnectionImpl.this.isConnected();
        }

        public void close() {
            ClientConnectionImpl.this.close();
        }
    }
}

