/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.publish;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import jp.ossc.nimbus.core.Service;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.publish.ClientConnection;
import jp.ossc.nimbus.service.publish.ClientConnectionFactory;
import jp.ossc.nimbus.service.publish.ConnectException;
import jp.ossc.nimbus.service.publish.Message;
import jp.ossc.nimbus.service.publish.MessageListener;
import jp.ossc.nimbus.service.publish.MessageReceiver;
import jp.ossc.nimbus.service.publish.MessageReceiverServiceMBean;
import jp.ossc.nimbus.service.publish.MessageSendException;
import jp.ossc.nimbus.service.queue.AbstractDistributedQueueSelectorService;
import jp.ossc.nimbus.service.queue.DistributedQueueHandlerContainerService;
import jp.ossc.nimbus.service.queue.QueueHandler;
import jp.ossc.nimbus.service.queue.QueueHandlerContainer;
import jp.ossc.nimbus.service.queue.QueueHandlerContainerService;
import jp.ossc.nimbus.service.repository.Repository;

public class MessageReceiverService
extends ServiceBase
implements MessageReceiver,
MessageListener,
MessageReceiverServiceMBean {
    private static final long serialVersionUID = -8671211095557547090L;
    protected String clientConnectionFactoryJndiName = "publish/ClientConnectionFactory";
    protected ServiceName jndiRepositoryServiceName;
    protected ServiceName clientConnectionFactoryServiceName;
    protected boolean isStartReceiveOnStart;
    protected ServiceName messageQueueFactoryServiceName;
    protected int messageQueueDistributedSize;
    protected ServiceName messageListenerQueueFactoryServiceName;
    protected int messageListenerQueueDistributedSize;
    protected Map registeredListenerMap;
    protected boolean isConnectOnStart = true;
    protected WrappedClientConnection clientConnection;
    protected Map subjectMap;
    protected Map listenerSubjectMap;
    protected MessageDistributedQueueSelector messageQueueSelector;
    protected QueueHandlerContainer messageQueueHandlerContainer;
    protected MessageListenerDistributedQueueSelector messageListenerQueueSelector;
    protected DistributedQueueHandlerContainerService messageListenerQueueHandlerContainer;

    public void setClientConnectionFactoryJndiName(String name) {
        this.clientConnectionFactoryJndiName = name;
    }

    public String getClientConnectionFactoryJndiName() {
        return this.clientConnectionFactoryJndiName;
    }

    public void setJndiRepositoryServiceName(ServiceName name) {
        this.jndiRepositoryServiceName = name;
    }

    public ServiceName getJndiRepositoryServiceName() {
        return this.jndiRepositoryServiceName;
    }

    public void setClientConnectionFactoryServiceName(ServiceName name) {
        this.clientConnectionFactoryServiceName = name;
    }

    public ServiceName getClientConnectionFactoryServiceName() {
        return this.clientConnectionFactoryServiceName;
    }

    public void setMessageQueueFactoryServiceName(ServiceName name) {
        this.messageQueueFactoryServiceName = name;
    }

    public ServiceName getMessageQueueFactoryServiceName() {
        return this.messageQueueFactoryServiceName;
    }

    public void setMessageQueueDistributedSize(int size) {
        this.messageQueueDistributedSize = size;
    }

    public int getMessageQueueDistributedSize() {
        return this.messageQueueDistributedSize;
    }

    public void setMessageListenerQueueFactoryServiceName(ServiceName name) {
        this.messageListenerQueueFactoryServiceName = name;
    }

    public ServiceName getMessageListenerQueueFactoryServiceName() {
        return this.messageListenerQueueFactoryServiceName;
    }

    public void setMessageListenerQueueDistributedSize(int size) {
        this.messageListenerQueueDistributedSize = size;
    }

    public int getMessageListenerQueueDistributedSize() {
        return this.messageListenerQueueDistributedSize;
    }

    public boolean isConnectOnStart() {
        return this.isConnectOnStart;
    }

    public void setConnectOnStart(boolean isConnect) {
        this.isConnectOnStart = isConnect;
    }

    public boolean isStartReceiveOnStart() {
        return this.isStartReceiveOnStart;
    }

    public void setStartReceiveOnStart(boolean isStart) {
        this.isStartReceiveOnStart = isStart;
    }

    public void addMessageListenerServiceName(ServiceName listener, String subject) {
        this.addMessageListenerServiceName(listener, subject, null);
    }

    public void addMessageListenerServiceName(ServiceName listener, String subject, String[] keys) {
        this.addMessageListener(listener, subject, keys);
    }

    public void addMessageListener(MessageListener listener, String subject) {
        this.addMessageListener(listener, subject, null);
    }

    public void addMessageListener(MessageListener listener, String subject, String[] keys) {
        this.addMessageListener((Object)listener, subject, keys);
    }

    protected void addMessageListener(Object listener, String subject, String[] keys) {
        Set<Object> keySet;
        Map subjectMap = (Map)this.registeredListenerMap.get(listener);
        if (subjectMap == null) {
            subjectMap = Collections.synchronizedMap(new HashMap());
            this.registeredListenerMap.put(listener, subjectMap);
        }
        if ((keySet = (Set<Object>)subjectMap.get(subject)) == null) {
            keySet = Collections.synchronizedSet(new HashSet());
            subjectMap.put(subject, keySet);
        }
        if (keys == null) {
            keySet.add(null);
        } else {
            for (int i = 0; i < keys.length; ++i) {
                keySet.add(keys[i]);
            }
        }
    }

    public long getMessageQueueCount() {
        return this.messageQueueHandlerContainer == null ? 0L : this.messageQueueHandlerContainer.getCount();
    }

    public long getMessageQueueDepth() {
        return this.messageQueueHandlerContainer == null ? 0L : (long)this.messageQueueHandlerContainer.size();
    }

    public long getMessageQueueAverageHandleProcessTime() {
        return this.messageQueueHandlerContainer == null ? 0L : this.messageQueueHandlerContainer.getAverageHandleProcessTime();
    }

    public long getgetMessageListenerQueueCount() {
        return this.messageListenerQueueHandlerContainer == null ? 0L : this.messageListenerQueueHandlerContainer.getCount();
    }

    public long getMessageListenerQueueDepth() {
        return this.messageListenerQueueHandlerContainer == null ? 0L : (long)this.messageListenerQueueHandlerContainer.size();
    }

    public long getMessageListenerQueueAverageHandleProcessTime() {
        return this.messageListenerQueueHandlerContainer == null ? 0L : this.messageListenerQueueHandlerContainer.getAverageHandleProcessTime();
    }

    public void createService() throws Exception {
        this.subjectMap = Collections.synchronizedMap(new HashMap());
        this.registeredListenerMap = Collections.synchronizedMap(new HashMap());
        this.listenerSubjectMap = Collections.synchronizedMap(new HashMap());
    }

    public void startService() throws Exception {
        ServiceBase queueHandlerContainer;
        if (this.messageQueueDistributedSize > 1) {
            this.messageQueueSelector = new MessageDistributedQueueSelector();
            this.messageQueueSelector.create();
            this.messageQueueSelector.setDistributedSize(this.messageQueueDistributedSize);
            if (this.messageQueueFactoryServiceName != null) {
                this.messageQueueSelector.setQueueFactoryServiceName(this.messageQueueFactoryServiceName);
            }
            this.messageQueueSelector.start();
            queueHandlerContainer = new DistributedQueueHandlerContainerService();
            queueHandlerContainer.create();
            ((DistributedQueueHandlerContainerService)queueHandlerContainer).setDistributedQueueSelector(this.messageQueueSelector);
            ((DistributedQueueHandlerContainerService)queueHandlerContainer).setQueueHandler(new MessageQueueHandler());
            queueHandlerContainer.start();
            this.messageQueueHandlerContainer = queueHandlerContainer;
        } else if (this.messageQueueDistributedSize == 1) {
            queueHandlerContainer = new QueueHandlerContainerService();
            queueHandlerContainer.create();
            ((QueueHandlerContainerService)queueHandlerContainer).setQueueServiceName(this.messageQueueFactoryServiceName);
            ((QueueHandlerContainerService)queueHandlerContainer).setQueueHandler(new MessageQueueHandler());
            queueHandlerContainer.start();
            this.messageQueueHandlerContainer = queueHandlerContainer;
        }
        if (this.messageListenerQueueDistributedSize > 0) {
            this.messageListenerQueueSelector = new MessageListenerDistributedQueueSelector();
            this.messageListenerQueueSelector.create();
            this.messageListenerQueueSelector.setDistributedSize(this.messageListenerQueueDistributedSize);
            if (this.messageListenerQueueFactoryServiceName != null) {
                this.messageListenerQueueSelector.setQueueFactoryServiceName(this.messageListenerQueueFactoryServiceName);
            }
            this.messageListenerQueueSelector.start();
            this.messageListenerQueueHandlerContainer = new DistributedQueueHandlerContainerService();
            this.messageListenerQueueHandlerContainer.create();
            this.messageListenerQueueHandlerContainer.setDistributedQueueSelector(this.messageListenerQueueSelector);
            this.messageListenerQueueHandlerContainer.setQueueHandler(new MessageListenerQueueHandler());
            this.messageListenerQueueHandlerContainer.start();
        }
        this.clientConnection = new WrappedClientConnection();
        if (this.isConnectOnStart) {
            this.connect();
        }
        if (this.registeredListenerMap.size() != 0) {
            Iterator listenerEntries = this.registeredListenerMap.entrySet().iterator();
            while (listenerEntries.hasNext()) {
                Map.Entry listenerEntry = listenerEntries.next();
                Object listenerObj = listenerEntry.getKey();
                MessageListener listener = null;
                listener = listenerObj instanceof ServiceName ? (MessageListener)ServiceManagerFactory.getServiceObject((ServiceName)listenerObj) : (MessageListener)listenerObj;
                Map subjectMap = (Map)listenerEntry.getValue();
                Iterator subjectEntries = subjectMap.entrySet().iterator();
                while (subjectEntries.hasNext()) {
                    Map.Entry subjectEntry = subjectEntries.next();
                    String subject = (String)subjectEntry.getKey();
                    Set keySet = (Set)subjectEntry.getValue();
                    if (keySet.remove(null)) {
                        this.addSubject(listener, subject);
                    }
                    this.addSubject(listener, subject, keySet.toArray(new String[keySet.size()]));
                }
            }
        }
        if (this.isStartReceiveOnStart) {
            this.startReceive();
        }
    }

    public void stopService() throws Exception {
        if (this.clientConnection != null) {
            this.clientConnection.close();
            this.clientConnection = null;
        }
        if (this.messageQueueHandlerContainer != null) {
            ((Service)((Object)this.messageQueueHandlerContainer)).stop();
            ((Service)((Object)this.messageQueueHandlerContainer)).destroy();
            this.messageQueueHandlerContainer = null;
        }
        if (this.messageQueueSelector != null) {
            this.messageQueueSelector.stop();
            this.messageQueueSelector.destroy();
            this.messageQueueSelector = null;
        }
        if (this.messageListenerQueueHandlerContainer != null) {
            this.messageListenerQueueHandlerContainer.stop();
            this.messageListenerQueueHandlerContainer.destroy();
            this.messageListenerQueueHandlerContainer = null;
        }
        if (this.messageListenerQueueSelector != null) {
            this.messageListenerQueueSelector.stop();
            this.messageListenerQueueSelector.destroy();
            this.messageListenerQueueSelector = null;
        }
        if (this.subjectMap != null) {
            this.subjectMap.clear();
        }
        if (this.listenerSubjectMap != null) {
            this.listenerSubjectMap.clear();
        }
    }

    public void destroyService() throws Exception {
        this.subjectMap = null;
        this.registeredListenerMap = null;
        this.listenerSubjectMap = null;
    }

    public void connect() throws Exception {
        if (this.clientConnection.getClientConnection() != null) {
            return;
        }
        ClientConnectionFactory clientConnectionFactory = null;
        if (this.clientConnectionFactoryServiceName != null) {
            clientConnectionFactory = (ClientConnectionFactory)ServiceManagerFactory.getServiceObject(this.clientConnectionFactoryServiceName);
        } else if (this.clientConnectionFactoryJndiName != null) {
            if (this.jndiRepositoryServiceName == null) {
                throw new IllegalArgumentException("JndiRepositoryServiceName is null.");
            }
            Repository repository = (Repository)ServiceManagerFactory.getServiceObject(this.jndiRepositoryServiceName);
            clientConnectionFactory = (ClientConnectionFactory)repository.get(this.clientConnectionFactoryJndiName);
            if (clientConnectionFactory == null) {
                throw new IllegalArgumentException("ClientConnectionFactory is null from " + this.jndiRepositoryServiceName);
            }
        }
        this.clientConnection.setServiceManagerName(this.getServiceManagerName());
        this.clientConnection.setClientConnection(clientConnectionFactory.getClientConnection());
        this.clientConnection.connect();
        this.clientConnection.setMessageListener(this);
    }

    public void close() {
        this.clientConnection.close();
    }

    public ClientConnection getClientConnection() {
        return this.clientConnection == null ? this.clientConnection : (this.clientConnection.getClientConnection() == null ? this.clientConnection : this.clientConnection.getClientConnection());
    }

    public boolean isConnected() {
        return this.clientConnection == null ? false : this.clientConnection.isConnected();
    }

    public void startReceive() throws MessageSendException {
        this.startReceive(-1L);
    }

    public void startReceive(long from) throws MessageSendException {
        this.clientConnection.startReceive(from);
    }

    public void stopReceive() throws MessageSendException {
        this.clientConnection.stopReceive();
        this.clientConnection.setMessageListener(null);
    }

    public boolean isStartReceive() {
        return this.clientConnection == null ? false : this.clientConnection.isStartReceive();
    }

    public void addSubject(MessageListener listener, String subject) throws MessageSendException {
        this.addSubject(listener, subject, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSubject(MessageListener listener, String subject, String[] keys) throws MessageSendException {
        Set<Object> keySet;
        Subject sbj = null;
        Map map = this.subjectMap;
        synchronized (map) {
            sbj = (Subject)this.subjectMap.get(subject);
            if (sbj == null) {
                sbj = new Subject(subject);
                this.subjectMap.put(subject, sbj);
            }
        }
        sbj.registKeys(listener, keys);
        Map subjects = (Map)this.listenerSubjectMap.get(listener);
        if (subjects == null) {
            subjects = Collections.synchronizedMap(new HashMap());
            this.listenerSubjectMap.put(listener, subjects);
        }
        if ((keySet = (Set<Object>)subjects.get(subject)) == null) {
            keySet = Collections.synchronizedSet(new HashSet());
            subjects.put(subject, keySet);
        }
        if (keys == null) {
            keySet.add(null);
        } else {
            for (int i = 0; i < keys.length; ++i) {
                keySet.add(keys[i]);
            }
        }
    }

    public void removeSubject(MessageListener listener, String subject) throws MessageSendException {
        this.removeSubject(listener, subject, null);
    }

    public void removeSubject(MessageListener listener, String subject, String[] keys) throws MessageSendException {
        Set keySet;
        Subject sbj = (Subject)this.subjectMap.get(subject);
        if (sbj == null) {
            return;
        }
        sbj.unregistKeys(listener, keys);
        Map subjects = (Map)this.listenerSubjectMap.get(listener);
        if (subjects != null && (keySet = (Set)subjects.get(subject)) != null) {
            if (keys == null) {
                keySet.remove(null);
            } else {
                for (int i = 0; i < keys.length; ++i) {
                    keySet.remove(keys[i]);
                }
            }
            if (keySet.size() == 0) {
                subjects.remove(subject);
                if (subjects.size() == 0) {
                    this.listenerSubjectMap.remove(listener);
                }
            }
        }
    }

    public void removeMessageListener(MessageListener listener) throws MessageSendException {
        if (this.subjectMap == null || this.subjectMap.size() == 0) {
            return;
        }
        Subject[] subjects = this.subjectMap.values().toArray(new Subject[this.subjectMap.size()]);
        for (int i = 0; i < subjects.length; ++i) {
            subjects[i].removeMessageListener(listener);
        }
        this.listenerSubjectMap.remove(listener);
    }

    public Set getSubjects(MessageListener listener) {
        Map subjects = (Map)this.listenerSubjectMap.get(listener);
        return subjects == null ? new HashSet() : subjects.keySet();
    }

    public Set getKeys(MessageListener listener, String subject) {
        Map subjects = (Map)this.listenerSubjectMap.get(listener);
        if (subjects == null) {
            return new HashSet();
        }
        Set keySet = (Set)subjects.get(subject);
        return keySet == null ? new HashSet() : keySet;
    }

    public void onMessage(Message message) {
        if (message == null) {
            return;
        }
        if (this.messageQueueHandlerContainer == null) {
            this.handleMessage(message);
        } else {
            this.messageQueueHandlerContainer.push(message);
        }
    }

    protected void handleMessage(Message message) {
        Iterator sbjs = message.getSubjects().iterator();
        while (sbjs.hasNext()) {
            String sbj = (String)sbjs.next();
            Subject subject = (Subject)this.subjectMap.get(sbj);
            if (subject == null || !subject.existsMessageListener(message)) continue;
            subject.onMessage(message);
            return;
        }
    }

    public Set getSubjectNameSet() {
        if (this.subjectMap == null || this.subjectMap.size() == 0) {
            return new HashSet();
        }
        return this.subjectMap.keySet();
    }

    public long getReceiveCount() {
        if (this.subjectMap == null || this.subjectMap.size() == 0) {
            return 0L;
        }
        Subject[] subjects = this.subjectMap.values().toArray(new Subject[this.subjectMap.size()]);
        long count = 0L;
        for (int i = 0; i < subjects.length; ++i) {
            count += subjects[i].getReceiveCount();
        }
        return count;
    }

    public long getReceiveCount(String subject) {
        if (this.subjectMap == null || this.subjectMap.size() == 0) {
            return 0L;
        }
        Subject sbj = (Subject)this.subjectMap.get(subject);
        if (sbj == null) {
            return 0L;
        }
        return sbj.getReceiveCount();
    }

    public void resetReceiveCount() {
        if (this.subjectMap == null || this.subjectMap.size() == 0) {
            return;
        }
        Subject[] subjects = this.subjectMap.values().toArray(new Subject[this.subjectMap.size()]);
        for (int i = 0; i < subjects.length; ++i) {
            subjects[i].resetReceiveCount();
        }
    }

    public void resetReceiveCount(String subject) {
        if (this.subjectMap == null || this.subjectMap.size() == 0) {
            return;
        }
        Subject sbj = (Subject)this.subjectMap.get(subject);
        if (sbj == null) {
            return;
        }
        sbj.resetReceiveCount();
    }

    public Set getSubjects() {
        return this.clientConnection == null ? new HashSet() : this.clientConnection.getSubjects();
    }

    public Set getKeys(String subject) {
        return this.clientConnection == null ? new HashSet() : this.clientConnection.getKeys(subject);
    }

    public int getMessageListenerSize() {
        HashSet result = new HashSet();
        Subject[] subjects = this.subjectMap.values().toArray(new Subject[this.subjectMap.size()]);
        for (int i = 0; i < subjects.length; ++i) {
            result.addAll(subjects[i].getMessageListeners());
        }
        return result.size();
    }

    public Object getId() {
        return this.clientConnection == null ? null : this.clientConnection.getId();
    }

    protected class WrappedClientConnection
    implements ClientConnection {
        protected ClientConnection clientConnection;
        protected boolean isConnected;
        protected Object id;
        protected Map subjects;
        protected Map removedSubjects;
        protected MessageListener messageListener;
        protected String serviceManagerName;
        protected boolean isStartReceive;
        protected long fromTime;

        public ClientConnection getClientConnection() {
            return this.clientConnection;
        }

        public void setClientConnection(ClientConnection con) throws ConnectException, MessageSendException {
            this.clientConnection = con;
            if (this.clientConnection == null) {
                return;
            }
            if (this.isConnected) {
                int j;
                ArrayList<String> keyList;
                boolean containsNull;
                String[] keys;
                Set keySet;
                Object subject;
                int i;
                Object[] subjectArray;
                if (this.id == null) {
                    this.clientConnection.setServiceManagerName(this.serviceManagerName);
                    this.clientConnection.connect();
                } else {
                    this.clientConnection.setServiceManagerName(this.serviceManagerName);
                    this.clientConnection.connect(this.id);
                }
                if (this.messageListener != null) {
                    this.clientConnection.setMessageListener(this.messageListener);
                }
                if (this.subjects != null) {
                    subjectArray = this.subjects.keySet().toArray();
                    for (i = 0; i < subjectArray.length; ++i) {
                        subject = subjectArray[i];
                        keySet = (Set)this.subjects.get(subject);
                        if (keySet == null) continue;
                        keys = keySet.toArray(new String[keySet.size()]);
                        containsNull = false;
                        keyList = new ArrayList<String>();
                        for (j = 0; j < keys.length; ++j) {
                            if (keys[j] == null) {
                                containsNull = true;
                                continue;
                            }
                            keyList.add(keys[j]);
                        }
                        if (containsNull) {
                            this.clientConnection.addSubject((String)subject);
                            keys = keyList.toArray(new String[keyList.size()]);
                        }
                        if (keys == null || keys.length == 0) continue;
                        this.clientConnection.addSubject((String)subject, keys);
                    }
                }
                if (this.isStartReceive) {
                    this.clientConnection.startReceive(this.fromTime);
                }
                if (this.removedSubjects != null) {
                    subjectArray = this.removedSubjects.keySet().toArray();
                    for (i = 0; i < subjectArray.length; ++i) {
                        subject = subjectArray[i];
                        keySet = (Set)this.removedSubjects.get(subject);
                        if (keySet == null) continue;
                        keys = keySet.toArray(new String[keySet.size()]);
                        containsNull = false;
                        keyList = new ArrayList();
                        for (j = 0; j < keys.length; ++j) {
                            if (keys[j] == null) {
                                containsNull = true;
                                continue;
                            }
                            keyList.add(keys[j]);
                        }
                        if (containsNull) {
                            this.clientConnection.removeSubject((String)subject);
                            keySet.remove(null);
                            keys = keyList.toArray(new String[keyList.size()]);
                        }
                        if (keys == null || keys.length == 0) continue;
                        this.clientConnection.removeSubject((String)subject, keys);
                        this.removedSubjects.remove(subject);
                    }
                }
            } else if (this.clientConnection.isConnected()) {
                this.clientConnection.close();
            }
        }

        public void setServiceManagerName(String name) {
            this.serviceManagerName = name;
        }

        public void connect() throws ConnectException {
            if (this.clientConnection != null) {
                this.clientConnection.setServiceManagerName(this.serviceManagerName);
                this.clientConnection.connect();
                if (this.isStartReceive) {
                    try {
                        this.clientConnection.startReceive(this.fromTime);
                    }
                    catch (MessageSendException e) {
                        throw new ConnectException(e);
                    }
                }
                this.id = this.clientConnection.getId();
            } else {
                this.id = null;
            }
            this.isConnected = true;
        }

        public void connect(Object id) throws ConnectException {
            if (this.clientConnection != null) {
                this.clientConnection.setServiceManagerName(this.serviceManagerName);
                this.clientConnection.connect(id);
                if (this.isStartReceive) {
                    try {
                        this.clientConnection.startReceive(this.fromTime);
                    }
                    catch (MessageSendException e) {
                        throw new ConnectException(e);
                    }
                }
                this.id = this.clientConnection.getId();
            } else {
                this.id = id;
            }
            this.isConnected = true;
        }

        public void addSubject(String subject) throws MessageSendException {
            this.addSubject(subject, null);
        }

        public void addSubject(String subject, String[] keys) throws MessageSendException {
            Set<Object> keySet;
            if (this.clientConnection != null) {
                this.clientConnection.addSubject(subject, keys);
            }
            if (this.subjects == null) {
                this.subjects = Collections.synchronizedMap(new HashMap());
            }
            if ((keySet = (Set<Object>)this.subjects.get(subject)) == null) {
                keySet = Collections.synchronizedSet(new HashSet());
                this.subjects.put(subject, keySet);
            }
            if (keys == null) {
                keySet.add(null);
            } else {
                for (int i = 0; i < keys.length; ++i) {
                    keySet.add(keys[i]);
                }
            }
        }

        public void removeSubject(String subject) throws MessageSendException {
            this.removeSubject(subject, null);
        }

        public void removeSubject(String subject, String[] keys) throws MessageSendException {
            int i;
            Set<String> keySet;
            if (this.clientConnection != null) {
                this.clientConnection.removeSubject(subject, keys);
            }
            if (this.subjects != null && (keySet = (Set<String>)this.subjects.get(subject)) != null) {
                if (keys == null) {
                    keySet.remove(null);
                } else {
                    for (i = 0; i < keys.length; ++i) {
                        keySet.remove(keys[i]);
                    }
                }
                if (keySet.size() == 0) {
                    this.subjects.remove(subject);
                }
            }
            if (this.clientConnection == null) {
                if (this.removedSubjects == null) {
                    this.removedSubjects = Collections.synchronizedMap(new HashMap());
                }
                if ((keySet = (Set)this.removedSubjects.get(subject)) == null) {
                    keySet = Collections.synchronizedSet(new HashSet());
                    this.removedSubjects.put(subject, keySet);
                }
                if (keys == null) {
                    keySet.add(null);
                } else {
                    for (i = 0; i < keys.length; ++i) {
                        keySet.add(keys[i]);
                    }
                }
            }
        }

        public void startReceive() throws MessageSendException {
            this.startReceive(-1L);
        }

        public synchronized void startReceive(long from) throws MessageSendException {
            if (this.isStartReceive) {
                return;
            }
            if (this.clientConnection != null) {
                this.clientConnection.startReceive(from);
            }
            this.fromTime = from;
            this.isStartReceive = true;
        }

        public boolean isStartReceive() {
            if (this.clientConnection != null) {
                return this.clientConnection.isStartReceive();
            }
            return this.isStartReceive;
        }

        public synchronized void stopReceive() throws MessageSendException {
            if (this.clientConnection != null) {
                this.clientConnection.stopReceive();
            }
            this.isStartReceive = false;
        }

        public Set getSubjects() {
            return this.subjects == null ? new HashSet() : this.subjects.keySet();
        }

        public Set getKeys(String subject) {
            if (this.subjects == null) {
                return new HashSet();
            }
            Set keySet = (Set)this.subjects.get(subject);
            return keySet == null ? new HashSet() : keySet;
        }

        public void setMessageListener(MessageListener listener) {
            if (this.clientConnection != null) {
                this.clientConnection.setMessageListener(listener);
            }
            this.messageListener = listener;
        }

        public boolean isConnected() {
            return this.isConnected;
        }

        public Object getId() {
            return this.clientConnection == null ? this.id : this.clientConnection.getId();
        }

        public void close() {
            if (this.clientConnection != null) {
                this.clientConnection.close();
                this.clientConnection = null;
            }
            this.isConnected = false;
        }
    }

    protected class MessageListenerQueueHandler
    implements QueueHandler {
        protected MessageListenerQueueHandler() {
        }

        public void handleDequeuedObject(Object obj) throws Throwable {
            if (obj == null) {
                return;
            }
            Object[] params = (Object[])obj;
            ((MessageListener)params[0]).onMessage((Message)params[1]);
        }

        public boolean handleError(Object obj, Throwable th) throws Throwable {
            throw th;
        }

        public void handleRetryOver(Object obj, Throwable th) throws Throwable {
            throw th;
        }
    }

    protected class MessageQueueHandler
    implements QueueHandler {
        protected MessageQueueHandler() {
        }

        public void handleDequeuedObject(Object obj) throws Throwable {
            if (obj == null) {
                return;
            }
            Message message = (Message)obj;
            MessageReceiverService.this.handleMessage(message);
        }

        public boolean handleError(Object obj, Throwable th) throws Throwable {
            throw th;
        }

        public void handleRetryOver(Object obj, Throwable th) throws Throwable {
            throw th;
        }
    }

    protected class MessageDistributedQueueSelector
    extends AbstractDistributedQueueSelectorService {
        private static final long serialVersionUID = -6963601802280281499L;

        protected MessageDistributedQueueSelector() {
        }

        protected Object getKey(Object obj) {
            return ((Message)obj).getKey();
        }
    }

    protected class MessageListenerDistributedQueueSelector
    extends AbstractDistributedQueueSelectorService {
        private static final long serialVersionUID = -5979153990079771192L;

        protected MessageListenerDistributedQueueSelector() {
        }

        protected Object getKey(Object obj) {
            return ((Object[])obj)[0];
        }
    }

    protected class Subject {
        protected String subject;
        protected Map keyAndMessageListenerMap = Collections.synchronizedMap(new HashMap());
        protected Map unmodifiedKeyAndMessageListenerMap = new HashMap();
        protected long receiveCount;

        public Subject(String subject) {
            this.subject = subject;
        }

        public void onMessage(Message message) {
            Set listeners = this.getMessageListeners(message);
            if (listeners == null || listeners.size() == 0) {
                return;
            }
            ++this.receiveCount;
            MessageListener[] array = listeners.toArray(new MessageListener[listeners.size()]);
            for (int i = 0; i < array.length; ++i) {
                if (MessageReceiverService.this.messageListenerQueueHandlerContainer == null) {
                    array[i].onMessage(message);
                    continue;
                }
                MessageReceiverService.this.messageListenerQueueHandlerContainer.push(new Object[]{array[i], message});
            }
        }

        public boolean existsMessageListener(Message message) {
            Set listeners = null;
            Map localKeyAndMessageListenerMap = this.unmodifiedKeyAndMessageListenerMap;
            if (localKeyAndMessageListenerMap.containsKey(null) && (listeners = (Set)localKeyAndMessageListenerMap.get(null)) != null && listeners.size() != 0) {
                return true;
            }
            String key = message.getKey(this.subject);
            if (localKeyAndMessageListenerMap.containsKey(key)) {
                listeners = (Set)localKeyAndMessageListenerMap.get(key);
            }
            return listeners != null && listeners.size() != 0;
        }

        protected Set getMessageListeners(Message message) {
            String key;
            HashSet result = null;
            Map localKeyAndMessageListenerMap = this.unmodifiedKeyAndMessageListenerMap;
            if (localKeyAndMessageListenerMap.containsKey(null)) {
                result = (HashSet)localKeyAndMessageListenerMap.get(null);
            }
            if (localKeyAndMessageListenerMap.containsKey(key = message.getKey(this.subject))) {
                if (result == null) {
                    result = (Set)localKeyAndMessageListenerMap.get(key);
                } else {
                    result = new HashSet(result);
                    result.addAll((Set)localKeyAndMessageListenerMap.get(key));
                }
            }
            return result;
        }

        public Set getMessageListeners() {
            HashSet result = new HashSet();
            Map localKeyAndMessageListenerMap = this.unmodifiedKeyAndMessageListenerMap;
            Set[] sets = localKeyAndMessageListenerMap.values().toArray(new Set[localKeyAndMessageListenerMap.size()]);
            for (int i = 0; i < sets.length; ++i) {
                result.addAll(sets[i]);
            }
            return result;
        }

        public synchronized void registKeys(MessageListener listener, String[] keys) throws MessageSendException {
            if (MessageReceiverService.this.clientConnection == null) {
                throw new MessageSendException("ClientConnection is null.");
            }
            boolean isModified = false;
            if (keys == null || keys.length == 0) {
                Set<MessageListener> listeners = (Set<MessageListener>)this.keyAndMessageListenerMap.get(null);
                boolean isFirst = false;
                if (listeners == null) {
                    listeners = Collections.synchronizedSet(new HashSet());
                    this.keyAndMessageListenerMap.put(null, listeners);
                    isFirst = true;
                }
                isModified = listeners.add(listener);
                if (MessageReceiverService.this.clientConnection != null && (isModified || isFirst)) {
                    try {
                        MessageReceiverService.this.clientConnection.addSubject(this.subject);
                    }
                    catch (MessageSendException e) {
                        this.keyAndMessageListenerMap.remove(null);
                        throw e;
                    }
                }
            } else {
                HashSet<String> firstKeySet = new HashSet<String>();
                for (int i = 0; i < keys.length; ++i) {
                    Set<MessageListener> listeners = (Set<MessageListener>)this.keyAndMessageListenerMap.get(keys[i]);
                    if (listeners == null) {
                        listeners = Collections.synchronizedSet(new HashSet());
                        this.keyAndMessageListenerMap.put(keys[i], listeners);
                        firstKeySet.add(keys[i]);
                    }
                    isModified |= listeners.add(listener);
                }
                if (MessageReceiverService.this.clientConnection != null && firstKeySet.size() != 0) {
                    try {
                        MessageReceiverService.this.clientConnection.addSubject(this.subject, firstKeySet.toArray(new String[firstKeySet.size()]));
                    }
                    catch (MessageSendException e) {
                        for (int i = 0; i < keys.length; ++i) {
                            this.keyAndMessageListenerMap.remove(keys[i]);
                        }
                        throw e;
                    }
                }
            }
            if (isModified) {
                this.updateUnmodifiedKeyAndMessageListenerMap();
            }
        }

        public synchronized void unregistKeys(MessageListener listener, String[] keys) throws MessageSendException {
            if (MessageReceiverService.this.clientConnection == null) {
                throw new MessageSendException("ClientConnection is null.");
            }
            boolean isModified = false;
            if (keys == null || keys.length == 0) {
                Set listeners = (Set)this.keyAndMessageListenerMap.get(null);
                if (listeners == null) {
                    return;
                }
                isModified = listeners.remove(listener);
                if (isModified && MessageReceiverService.this.clientConnection != null && listeners.size() == 0) {
                    try {
                        MessageReceiverService.this.clientConnection.removeSubject(this.subject);
                    }
                    catch (MessageSendException e) {
                        listeners.add(listener);
                        throw e;
                    }
                    this.keyAndMessageListenerMap.remove(null);
                }
            } else {
                HashSet<String> lastKeySet = new HashSet<String>();
                for (int i = 0; i < keys.length; ++i) {
                    Set listeners = (Set)this.keyAndMessageListenerMap.get(keys[i]);
                    if (listeners == null) continue;
                    isModified |= listeners.remove(listener);
                    if (listeners.size() != 0) continue;
                    this.keyAndMessageListenerMap.remove(keys[i]);
                    lastKeySet.add(keys[i]);
                }
                if (isModified && MessageReceiverService.this.clientConnection != null && lastKeySet.size() != 0) {
                    try {
                        MessageReceiverService.this.clientConnection.removeSubject(this.subject, lastKeySet.toArray(new String[lastKeySet.size()]));
                    }
                    catch (MessageSendException e) {
                        for (int i = 0; i < keys.length; ++i) {
                            Set<MessageListener> listeners = (Set<MessageListener>)this.keyAndMessageListenerMap.get(keys[i]);
                            if (listeners == null) {
                                listeners = Collections.synchronizedSet(new HashSet());
                                this.keyAndMessageListenerMap.put(keys[i], listeners);
                            }
                            listeners.add(listener);
                        }
                        throw e;
                    }
                }
            }
            if (isModified) {
                this.updateUnmodifiedKeyAndMessageListenerMap();
            }
        }

        public synchronized void removeMessageListener(MessageListener listener) throws MessageSendException {
            if (this.keyAndMessageListenerMap.size() == 0) {
                return;
            }
            String[] keys = this.keyAndMessageListenerMap.keySet().toArray(new String[this.keyAndMessageListenerMap.size()]);
            HashSet<String> lastKeySet = new HashSet<String>();
            HashSet<String> removeKeySet = new HashSet<String>();
            boolean isModified = false;
            for (int i = 0; i < keys.length; ++i) {
                Set listeners = (Set)this.keyAndMessageListenerMap.get(keys[i]);
                isModified |= listeners.remove(listener);
                if (listeners.size() == 0) {
                    this.keyAndMessageListenerMap.remove(keys[i]);
                    lastKeySet.add(keys[i]);
                }
                removeKeySet.add(keys[i]);
            }
            if (isModified && MessageReceiverService.this.clientConnection != null && lastKeySet.size() != 0) {
                try {
                    MessageReceiverService.this.clientConnection.removeSubject(this.subject, lastKeySet.toArray(new String[lastKeySet.size()]));
                }
                catch (MessageSendException e) {
                    keys = removeKeySet.toArray(new String[removeKeySet.size()]);
                    for (int i = 0; i < keys.length; ++i) {
                        Set<MessageListener> listeners = (Set<MessageListener>)this.keyAndMessageListenerMap.get(keys[i]);
                        if (listeners == null) {
                            listeners = Collections.synchronizedSet(new HashSet());
                            this.keyAndMessageListenerMap.put(keys[i], listeners);
                        }
                        listeners.add(listener);
                    }
                    throw e;
                }
            }
            if (isModified) {
                this.updateUnmodifiedKeyAndMessageListenerMap();
            }
        }

        protected void updateUnmodifiedKeyAndMessageListenerMap() {
            HashMap newUnmodifiedKeyAndMessageListenerMap = new HashMap();
            String[] keys = this.keyAndMessageListenerMap.keySet().toArray(new String[this.keyAndMessageListenerMap.size()]);
            for (int i = 0; i < keys.length; ++i) {
                Set listeners = (Set)this.keyAndMessageListenerMap.get(keys[i]);
                newUnmodifiedKeyAndMessageListenerMap.put(keys[i], new HashSet(listeners));
            }
            this.unmodifiedKeyAndMessageListenerMap = newUnmodifiedKeyAndMessageListenerMap;
        }

        public long getReceiveCount() {
            return this.receiveCount;
        }

        public void resetReceiveCount() {
            this.receiveCount = 0L;
        }
    }
}

