/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.publish;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.publish.ClientConnection;
import jp.ossc.nimbus.service.publish.ClientConnectionFactory;
import jp.ossc.nimbus.service.publish.ConnectionCreateException;
import jp.ossc.nimbus.service.publish.GroupClientConnectionFactoryImpl;
import jp.ossc.nimbus.service.publish.GroupClientConnectionFactoryServiceMBean;
import jp.ossc.nimbus.service.repository.Repository;

public class GroupClientConnectionFactoryService
extends ServiceBase
implements ClientConnectionFactory,
GroupClientConnectionFactoryServiceMBean {
    private static final long serialVersionUID = 8761164179460557198L;
    private ServiceName jndiRepositoryServiceName;
    private Repository jndiRepository;
    private Map subjectMap;
    private GroupClientConnectionFactoryImpl clientConnectionFactory;

    public void setJndiRepositoryServiceName(ServiceName name) {
        this.jndiRepositoryServiceName = name;
    }

    public ServiceName getJndiRepositoryServiceName() {
        return this.jndiRepositoryServiceName;
    }

    public void addSubjectMapping(SubjectMapping mapping) {
        ArrayList<SubjectMapping> mappings = (ArrayList<SubjectMapping>)this.subjectMap.get(mapping.getSubject());
        if (mappings == null) {
            mappings = new ArrayList<SubjectMapping>();
            this.subjectMap.put(mapping.getSubject(), mappings);
        }
        mappings.add(mapping);
    }

    public List getSubjectMappings(String subject) {
        return this.subjectMap == null ? null : (List)this.subjectMap.get(subject);
    }

    public Map getSubjectMappingMap() {
        return this.subjectMap;
    }

    public Repository getJndiRepository() {
        return this.jndiRepository;
    }

    public void setJndiRepository(Repository repository) {
        this.jndiRepository = repository;
    }

    public void createService() throws Exception {
        this.subjectMap = Collections.synchronizedMap(new LinkedHashMap());
    }

    public void startService() throws Exception {
        if (this.subjectMap.size() == 0) {
            throw new IllegalArgumentException("SubjectMappings is null.");
        }
        this.clientConnectionFactory = new GroupClientConnectionFactoryImpl();
        Iterator mappingsItr = this.subjectMap.values().iterator();
        while (mappingsItr.hasNext()) {
            List mappings = (List)mappingsItr.next();
            int imax = mappings.size();
            for (int i = 0; i < imax; ++i) {
                SubjectMapping mapping = (SubjectMapping)mappings.get(i);
                ClientConnectionFactory ccFactory = mapping.getClientConnectionFactory();
                if (ccFactory == null && mapping.getClientConnectionFactoryServiceName() != null) {
                    ccFactory = (ClientConnectionFactory)ServiceManagerFactory.getServiceObject(mapping.getClientConnectionFactoryServiceName());
                }
                if (ccFactory == null && mapping.getClientConnectionFactoryJndiName() != null) {
                    Repository jndiRepository = mapping.getJndiRepository();
                    if (jndiRepository == null && mapping.getJndiRepositoryServiceName() != null) {
                        jndiRepository = (Repository)ServiceManagerFactory.getServiceObject(mapping.getJndiRepositoryServiceName());
                    }
                    if (jndiRepository == null && this.getJndiRepository() != null) {
                        jndiRepository = this.getJndiRepository();
                    }
                    if (jndiRepository == null && this.getJndiRepositoryServiceName() != null) {
                        jndiRepository = (Repository)ServiceManagerFactory.getServiceObject(this.getJndiRepositoryServiceName());
                    }
                    if (jndiRepository == null) {
                        throw new IllegalArgumentException("JndiRepository is null." + mapping);
                    }
                    ccFactory = (ClientConnectionFactory)jndiRepository.get(mapping.getClientConnectionFactoryJndiName());
                }
                if (ccFactory == null) {
                    throw new IllegalArgumentException("ClientConnectionFactory is null." + mapping);
                }
                this.clientConnectionFactory.addClientConnectionFactory(mapping.getSubject(), mapping.getKeyPattern(), ccFactory);
            }
        }
    }

    public void stopService() throws Exception {
        this.clientConnectionFactory = null;
    }

    public ClientConnection getClientConnection() throws ConnectionCreateException, RemoteException {
        return this.clientConnectionFactory.getClientConnection();
    }

    public int getClientCount() throws RemoteException {
        return this.clientConnectionFactory.getClientCount();
    }

    public static class SubjectMapping
    implements Serializable {
        private static final long serialVersionUID = 8529777551111325296L;
        private String subject;
        private Pattern keyPattern;
        private String clientConnectionFactoryJndiName;
        private ServiceName clientConnectionFactoryServiceName;
        private ClientConnectionFactory clientConnectionFactory;
        private ServiceName jndiRepositoryServiceName;
        private Repository jndiRepository;

        public void setSubject(String subject) {
            this.subject = subject;
        }

        public String getSubject() {
            return this.subject;
        }

        public void setKey(String pattern) {
            this.keyPattern = Pattern.compile(pattern);
        }

        public String getKey() {
            return this.keyPattern == null ? null : this.keyPattern.pattern();
        }

        public Pattern getKeyPattern() {
            return this.keyPattern;
        }

        public void setKeyPattern(Pattern pattern) {
            this.keyPattern = pattern;
        }

        public void setClientConnectionFactoryJndiName(String name) {
            this.clientConnectionFactoryJndiName = name;
        }

        public String getClientConnectionFactoryJndiName() {
            return this.clientConnectionFactoryJndiName;
        }

        public void setClientConnectionFactoryServiceName(ServiceName name) {
            this.clientConnectionFactoryServiceName = name;
        }

        public ServiceName getClientConnectionFactoryServiceName() {
            return this.clientConnectionFactoryServiceName;
        }

        public void setClientConnectionFactory(ClientConnectionFactory factory) {
            this.clientConnectionFactory = factory;
        }

        public ClientConnectionFactory getClientConnectionFactory() {
            return this.clientConnectionFactory;
        }

        public void setJndiRepositoryServiceName(ServiceName name) {
            this.jndiRepositoryServiceName = name;
        }

        public ServiceName getJndiRepositoryServiceName() {
            return this.jndiRepositoryServiceName;
        }

        public Repository getJndiRepository() {
            return this.jndiRepository;
        }

        public void setJndiRepository(Repository repository) {
            this.jndiRepository = repository;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer(super.toString());
            buf.append('{');
            buf.append("subject=").append(this.subject);
            buf.append(", key=").append(this.keyPattern == null ? null : this.keyPattern.pattern());
            buf.append(", clientConnectionFactoryJndiName=").append(this.clientConnectionFactoryJndiName);
            buf.append(", clientConnectionFactoryServiceName=").append(this.clientConnectionFactoryServiceName);
            buf.append(", clientConnectionFactory=").append(this.clientConnectionFactory);
            buf.append(", jndiRepositoryServiceName=").append(this.jndiRepositoryServiceName);
            buf.append(", jndiRepository=").append(this.jndiRepository);
            buf.append('}');
            return buf.toString();
        }
    }
}

