/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.publish;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.ossc.nimbus.service.publish.Message;
import jp.ossc.nimbus.service.publish.MessageCreateException;
import jp.ossc.nimbus.service.publish.MessageException;
import jp.ossc.nimbus.service.publish.MessageSendException;
import jp.ossc.nimbus.service.publish.ServerConnection;
import jp.ossc.nimbus.service.publish.ServerConnectionListener;

public class DistributedServerConnectionImpl
implements ServerConnection {
    private ServerConnection templateConnection;
    private List connectionList = new ArrayList();
    private Map connctionMap = Collections.synchronizedMap(new HashMap());

    public void addServerConnection(ServerConnection connection) {
        if (this.templateConnection == null) {
            this.templateConnection = connection;
        }
        this.connectionList.add(new ServerConnectionImpl(connection));
    }

    public Message createMessage(String subject, String key) throws MessageCreateException {
        return this.templateConnection.createMessage(subject, key);
    }

    public Message castMessage(Message message) throws MessageException {
        return this.templateConnection.castMessage(message);
    }

    private synchronized ServerConnection selectConnection(Message message) {
        ServerConnectionImpl connection = (ServerConnectionImpl)this.connctionMap.get(message.getKey());
        if (connection == null) {
            Collections.sort(this.connectionList);
            connection = (ServerConnectionImpl)this.connectionList.get(0);
            connection.addKey(message.getKey());
            this.connctionMap.put(message.getKey(), connection);
        }
        return connection;
    }

    public void send(Message message) throws MessageSendException {
        this.selectConnection(message).send(message);
    }

    public void sendAsynch(Message message) throws MessageSendException {
        this.selectConnection(message).sendAsynch(message);
    }

    public void addServerConnectionListener(ServerConnectionListener listener) {
        this.templateConnection.addServerConnectionListener(listener);
    }

    public void removeServerConnectionListener(ServerConnectionListener listener) {
        this.templateConnection.removeServerConnectionListener(listener);
    }

    public int getClientCount() {
        int result = 0;
        for (int i = 0; i < this.connectionList.size(); ++i) {
            result += ((ServerConnectionImpl)this.connectionList.get(i)).getClientCount();
        }
        return result;
    }

    public Set getClientIds() {
        HashSet result = new HashSet();
        for (int i = 0; i < this.connectionList.size(); ++i) {
            result.addAll(((ServerConnectionImpl)this.connectionList.get(i)).getClientIds());
        }
        return result;
    }

    public Set getReceiveClientIds(Message message) {
        HashSet result = new HashSet();
        for (int i = 0; i < this.connectionList.size(); ++i) {
            result.addAll(((ServerConnectionImpl)this.connectionList.get(i)).getReceiveClientIds(message));
        }
        return result;
    }

    public Set getSubjects(Object id) {
        HashSet result = null;
        for (int i = 0; i < this.connectionList.size(); ++i) {
            Set subjects = ((ServerConnectionImpl)this.connectionList.get(i)).getSubjects(id);
            if (subjects == null) continue;
            if (result == null) {
                result = new HashSet();
            }
            result.addAll(subjects);
        }
        return result;
    }

    public Set getKeys(Object id, String subject) {
        HashSet result = null;
        for (int i = 0; i < this.connectionList.size(); ++i) {
            Set keys = ((ServerConnectionImpl)this.connectionList.get(i)).getKeys(id, subject);
            if (keys == null) continue;
            if (result == null) {
                result = new HashSet();
            }
            result.addAll(keys);
        }
        return result;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(super.toString());
        buf.append('{');
        buf.append("connectionList=").append(this.connectionList);
        buf.append('}');
        return buf.toString();
    }

    private static class ServerConnectionImpl
    implements ServerConnection,
    Comparable {
        private int count;
        private Set keySet = Collections.synchronizedSet(new HashSet());
        private ServerConnection connection;

        public ServerConnectionImpl(ServerConnection connection) {
            this.connection = connection;
        }

        public void addKey(String key) {
            this.keySet.add(key);
        }

        public Message createMessage(String subject, String key) throws MessageCreateException {
            return this.connection.createMessage(subject, key);
        }

        public Message castMessage(Message message) throws MessageException {
            return this.connection.castMessage(message);
        }

        public void send(Message message) throws MessageSendException {
            this.connection.send(message);
            ++this.count;
        }

        public void sendAsynch(Message message) throws MessageSendException {
            this.connection.sendAsynch(message);
            ++this.count;
        }

        public void addServerConnectionListener(ServerConnectionListener listener) {
            this.connection.addServerConnectionListener(listener);
        }

        public void removeServerConnectionListener(ServerConnectionListener listener) {
            this.connection.removeServerConnectionListener(listener);
        }

        public int getClientCount() {
            return this.connection.getClientCount();
        }

        public Set getClientIds() {
            return this.connection.getClientIds();
        }

        public Set getReceiveClientIds(Message message) {
            return this.connection.getReceiveClientIds(message);
        }

        public Set getSubjects(Object id) {
            return this.connection.getSubjects(id);
        }

        public Set getKeys(Object id, String subject) {
            return this.connection.getKeys(id, subject);
        }

        public int compareTo(Object o) {
            ServerConnectionImpl cmp = (ServerConnectionImpl)o;
            if (cmp.count > this.count) {
                return -1;
            }
            if (cmp.count < this.count) {
                return 1;
            }
            if (cmp.keySet.size() > this.keySet.size()) {
                return -1;
            }
            if (cmp.keySet.size() < this.keySet.size()) {
                return 1;
            }
            return 0;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer(super.toString());
            buf.append('{');
            buf.append("connection=").append(this.connection);
            buf.append(", count=").append(this.count);
            buf.append(", keySet=").append(this.keySet);
            buf.append('}');
            return buf.toString();
        }
    }
}

