/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.proxy.invoker;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import javax.ejb.CreateException;
import javax.naming.NamingException;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.aop.InvocationContext;
import jp.ossc.nimbus.service.aop.Invoker;
import jp.ossc.nimbus.service.aop.MethodInvocationContext;
import jp.ossc.nimbus.service.ejb.EJBFactory;
import jp.ossc.nimbus.service.proxy.RemoteServerInvoker;
import jp.ossc.nimbus.service.proxy.RemoteServiceCallException;
import jp.ossc.nimbus.service.proxy.invoker.RemoteClientEJBCallInvokerServiceMBean;

public class RemoteClientEJBCallInvokerService
extends ServiceBase
implements Invoker,
Serializable,
RemoteClientEJBCallInvokerServiceMBean {
    private static final long serialVersionUID = -7734676901899009764L;
    private ServiceName ejbFactoryServiceName;
    private EJBFactory ejbFactory;
    private String jndiName;
    private ServiceName remoteServiceName;

    public void setEJBFactoryServiceName(ServiceName name) {
        this.ejbFactoryServiceName = name;
    }

    public ServiceName getEJBFactoryServiceName() {
        return this.ejbFactoryServiceName;
    }

    public void setRemoteServerEJBJndiName(String name) {
        this.jndiName = name;
    }

    public String getRemoteServerEJBJndiName() {
        return this.jndiName;
    }

    public void setRemoteServiceName(ServiceName name) {
        this.remoteServiceName = name;
    }

    public ServiceName getRemoteServiceName() {
        return this.remoteServiceName;
    }

    public void setEjbFactory(EJBFactory ejbFactory) {
        this.ejbFactory = ejbFactory;
    }

    public void startService() throws Exception {
        if (this.ejbFactoryServiceName != null) {
            this.ejbFactory = (EJBFactory)ServiceManagerFactory.getServiceObject(this.ejbFactoryServiceName);
        }
        if (this.ejbFactory == null) {
            throw new IllegalArgumentException("EjbFactoryServiceName or EjbFactory must be specified.");
        }
        if (this.jndiName == null) {
            throw new IllegalArgumentException("jndiName must be specified.");
        }
    }

    public Object invoke(InvocationContext context) throws Throwable {
        MethodInvocationContext methodContext = (MethodInvocationContext)context;
        try {
            RemoteServerInvoker serverInvoker = (RemoteServerInvoker)this.ejbFactory.get(this.jndiName);
            if (this.remoteServiceName != null) {
                methodContext.setTargetObject(this.remoteServiceName);
            }
            return serverInvoker.invoke(context);
        }
        catch (NamingException e) {
            throw new RemoteServiceCallException(e);
        }
        catch (CreateException e) {
            throw new RemoteServiceCallException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RemoteServiceCallException(e);
        }
        catch (IllegalAccessException e) {
            throw new RemoteServiceCallException(e);
        }
        catch (InvocationTargetException e) {
            throw new RemoteServiceCallException(e.getTargetException());
        }
    }
}

