/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.log;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.log.CommonsLogFactory;
import jp.ossc.nimbus.service.log.DefaultCommonsLogFactoryServiceMBean;
import jp.ossc.nimbus.service.log.LogEnqueuedRecord;
import jp.ossc.nimbus.service.log.LogMessageRecord;
import jp.ossc.nimbus.service.log.LogMessageRecordImpl;
import jp.ossc.nimbus.service.log.LogService;
import jp.ossc.nimbus.service.log.NimbusLogFactory;
import jp.ossc.nimbus.service.message.MessageRecordFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogConfigurationException;
import org.apache.commons.logging.LogFactory;

public class DefaultCommonsLogFactoryService
extends LogService
implements CommonsLogFactory,
DefaultCommonsLogFactoryServiceMBean {
    private static final long serialVersionUID = 7172007959847003109L;
    private static final String DCLF_ = "DCLF_";
    private static final String DCLF_0 = "DCLF_0";
    private static final String DCLF_00 = "DCLF_00";
    private static final String DCLF_000 = "DCLF_000";
    private static final String DCLF_0000 = "DCLF_0000";
    private static final String DCLF_00001 = "DCLF_00001";
    private Set enabledClientSet = new HashSet();
    private boolean isCommonsTraceEnabled = false;
    private boolean isCommonsDebugEnabled = false;
    private boolean isCommonsInfoEnabled = true;
    private boolean isCommonsWarnEnabled = true;
    private boolean isCommonsErrorEnabled = true;
    private boolean isCommonsFatalEnabled = true;
    private ServiceName commonsTraceMessageWriterServiceName;
    private ServiceName commonsDebugMessageWriterServiceName;
    private ServiceName commonsInfoMessageWriterServiceName;
    private ServiceName commonsWarnMessageWriterServiceName;
    private ServiceName commonsErrorMessageWriterServiceName;
    private ServiceName commonsFatalMessageWriterServiceName;
    private ServiceName commonsTraceRecordFactoryServiceName;
    private ServiceName commonsDebugRecordFactoryServiceName;
    private ServiceName commonsInfoRecordFactoryServiceName;
    private ServiceName commonsWarnRecordFactoryServiceName;
    private ServiceName commonsErrorRecordFactoryServiceName;
    private ServiceName commonsFatalRecordFactoryServiceName;
    private Map logInstances;
    private Map attributes;
    static /* synthetic */ Class class$jp$ossc$nimbus$service$log$DefaultCommonsLogFactoryService;

    public void createService() throws Exception {
        super.createService();
        this.logInstances = Collections.synchronizedMap(new HashMap());
        this.attributes = Collections.synchronizedMap(new HashMap());
    }

    public void startService() throws Exception {
        this.defaultFormat = "%DATE%,%CLIENT%,%PRIORITY%,%MESSAGE%";
        super.startService();
        LogFactory logFactory = LogFactory.getFactory();
        if (logFactory instanceof NimbusLogFactory) {
            ((NimbusLogFactory)logFactory).setCommonsLogFactory(this);
        }
    }

    protected void initDefaultCategory() throws Exception {
        super.initDefaultCategory();
        this.addDefaultCategory(this.getDefaultMessageWriterService(), this.getDefaultWritableRecordFactoryService(), this.getCommonsTraceMessageWriterServiceName(), this.getCommonsTraceWritableRecordFactoryServiceName(), "jp.ossc.nimbus.service.log.DefaultCommonsLogService.CATEGORY_COMMONS_TRACE", 0, 9, "TRACE", this.isCommonsTraceEnabled());
        this.addDefaultCategory(this.getDefaultMessageWriterService(), this.getDefaultWritableRecordFactoryService(), this.getCommonsDebugMessageWriterServiceName(), this.getCommonsDebugWritableRecordFactoryServiceName(), "jp.ossc.nimbus.service.log.DefaultCommonsLogService.CATEGORY_COMMONS_DEBUG", 10, 19, "DEBUG", this.isCommonsDebugEnabled());
        this.addDefaultCategory(this.getDefaultMessageWriterService(), this.getDefaultWritableRecordFactoryService(), this.getCommonsInfoMessageWriterServiceName(), this.getCommonsInfoWritableRecordFactoryServiceName(), "jp.ossc.nimbus.service.log.DefaultCommonsLogService.CATEGORY_COMMONS_INFO", 20, 29, "INFO", this.isCommonsInfoEnabled());
        this.addDefaultCategory(this.getDefaultMessageWriterService(), this.getDefaultWritableRecordFactoryService(), this.getCommonsWarnMessageWriterServiceName(), this.getCommonsWarnWritableRecordFactoryServiceName(), "jp.ossc.nimbus.service.log.DefaultCommonsLogService.CATEGORY_COMMONS_WARN", 30, 39, "WARN", this.isCommonsWarnEnabled());
        this.addDefaultCategory(this.getDefaultMessageWriterService(), this.getDefaultWritableRecordFactoryService(), this.getCommonsErrorMessageWriterServiceName(), this.getCommonsErrorWritableRecordFactoryServiceName(), "jp.ossc.nimbus.service.log.DefaultCommonsLogService.CATEGORY_COMMONS_ERROR", 40, 49, "ERROR", this.isCommonsErrorEnabled());
        this.addDefaultCategory(this.getDefaultMessageWriterService(), this.getDefaultWritableRecordFactoryService(), this.getCommonsFatalMessageWriterServiceName(), this.getCommonsFatalWritableRecordFactoryServiceName(), "jp.ossc.nimbus.service.log.DefaultCommonsLogService.CATEGORY_COMMONS_FATAL", 50, 59, "FATAL", this.isCommonsFatalEnabled());
    }

    public void stopService() {
        super.stopService();
        this.release();
        LogFactory logFactory = LogFactory.getFactory();
        if (logFactory instanceof NimbusLogFactory) {
            ((NimbusLogFactory)logFactory).setCommonsLogFactory(null);
        }
    }

    public Log getInstance(Class clazz) throws LogConfigurationException {
        if (this.logInstances == null) {
            MessageRecordFactory message = this.getMessageRecordFactory();
            throw new LogConfigurationException(message.findMessage(DCLF_00001));
        }
        if (this.logInstances.containsKey(clazz)) {
            return (Log)this.logInstances.get(clazz);
        }
        CommonsLog log = new CommonsLog(clazz);
        this.logInstances.put(clazz, log);
        if (!this.enabledClientSet.isEmpty()) {
            log.setEnabled(this.containsEnabledClient(log));
        }
        return log;
    }

    public Log getInstance(String name) throws LogConfigurationException {
        if (this.logInstances == null) {
            MessageRecordFactory message = this.getMessageRecordFactory();
            throw new LogConfigurationException(message.findMessage(DCLF_00001));
        }
        if (this.logInstances.containsKey(name)) {
            return (Log)this.logInstances.get(name);
        }
        CommonsLog log = new CommonsLog(name);
        this.logInstances.put(name, log);
        if (!this.enabledClientSet.isEmpty()) {
            log.setEnabled(this.containsEnabledClient(log));
        }
        return log;
    }

    public void release() {
        if (this.logInstances != null) {
            this.logInstances.clear();
        }
    }

    public Object getAttribute(String name) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(name);
    }

    public String[] getAttributeNames() {
        if (this.attributes == null) {
            return new String[0];
        }
        return this.attributes.keySet().toArray(new String[this.attributes.size()]);
    }

    public void removeAttribute(String name) {
        if (this.attributes == null) {
            return;
        }
        this.attributes.remove(name);
    }

    public void setAttribute(String name, Object value) {
        if (this.attributes == null) {
            return;
        }
        this.attributes.put(name, value);
    }

    protected void postDequeue(LogEnqueuedRecord dequeuedRecord) {
        super.postDequeue(dequeuedRecord);
        LogMessageRecord messageRecord = dequeuedRecord.getLogMessageRecord();
        if (messageRecord instanceof CommonsLogMessageRecord) {
            dequeuedRecord.addWritableElement("CLIENT", ((CommonsLogMessageRecord)messageRecord).getShortClientKey());
        }
    }

    public void setEnabledClients(String[] clients) {
        if (clients != null) {
            this.enabledClientSet.clear();
            int max = clients.length;
            for (int i = 0; i < max; ++i) {
                this.enabledClientSet.add(clients[i]);
            }
        }
        if (this.logInstances != null) {
            Iterator keys = this.logInstances.keySet().iterator();
            while (keys.hasNext()) {
                Object key = keys.next();
                CommonsLog log = (CommonsLog)this.logInstances.get(key);
                if (this.enabledClientSet.isEmpty()) {
                    log.setEnabled(true);
                    continue;
                }
                log.setEnabled(this.containsEnabledClient(log));
            }
        }
    }

    private boolean containsEnabledClient(CommonsLog log) {
        String key = log.getClientKey();
        if (this.enabledClientSet.contains(key)) {
            return true;
        }
        Iterator enabledClients = this.enabledClientSet.iterator();
        while (enabledClients.hasNext()) {
            String match;
            String enabledClient = (String)enabledClients.next();
            int length = enabledClient.length();
            if (length == 0 || enabledClient.charAt(length - 1) != '*' || !key.startsWith(match = enabledClient.substring(0, length - 1))) continue;
            return true;
        }
        return false;
    }

    public String[] getEnabledClients() {
        return this.enabledClientSet.toArray(new String[this.enabledClientSet.size()]);
    }

    public void setCommonsTraceEnabled(boolean isEnabled) {
        this.isCommonsTraceEnabled = isEnabled;
        this.setEnabled("jp.ossc.nimbus.service.log.DefaultCommonsLogService.CATEGORY_COMMONS_TRACE", isEnabled);
    }

    public boolean isCommonsTraceEnabled() {
        return this.isEnabled("jp.ossc.nimbus.service.log.DefaultCommonsLogService.CATEGORY_COMMONS_TRACE", this.isCommonsTraceEnabled);
    }

    public void setCommonsDebugEnabled(boolean isEnabled) {
        this.isCommonsDebugEnabled = isEnabled;
        this.setEnabled("jp.ossc.nimbus.service.log.DefaultCommonsLogService.CATEGORY_COMMONS_DEBUG", isEnabled);
    }

    public boolean isCommonsDebugEnabled() {
        return this.isEnabled("jp.ossc.nimbus.service.log.DefaultCommonsLogService.CATEGORY_COMMONS_DEBUG", this.isCommonsDebugEnabled);
    }

    public void setCommonsInfoEnabled(boolean isEnabled) {
        this.isCommonsInfoEnabled = isEnabled;
        this.setEnabled("jp.ossc.nimbus.service.log.DefaultCommonsLogService.CATEGORY_COMMONS_INFO", isEnabled);
    }

    public boolean isCommonsInfoEnabled() {
        return this.isEnabled("jp.ossc.nimbus.service.log.DefaultCommonsLogService.CATEGORY_COMMONS_INFO", this.isCommonsInfoEnabled);
    }

    public void setCommonsWarnEnabled(boolean isEnabled) {
        this.isCommonsWarnEnabled = isEnabled;
        this.setEnabled("jp.ossc.nimbus.service.log.DefaultCommonsLogService.CATEGORY_COMMONS_WARN", isEnabled);
    }

    public boolean isCommonsWarnEnabled() {
        return this.isEnabled("jp.ossc.nimbus.service.log.DefaultCommonsLogService.CATEGORY_COMMONS_WARN", this.isCommonsWarnEnabled);
    }

    public void setCommonsErrorEnabled(boolean isEnabled) {
        this.isCommonsErrorEnabled = isEnabled;
        this.setEnabled("jp.ossc.nimbus.service.log.DefaultCommonsLogService.CATEGORY_COMMONS_ERROR", isEnabled);
    }

    public boolean isCommonsErrorEnabled() {
        return this.isEnabled("jp.ossc.nimbus.service.log.DefaultCommonsLogService.CATEGORY_COMMONS_ERROR", this.isCommonsErrorEnabled);
    }

    public void setCommonsFatalEnabled(boolean isEnabled) {
        this.isCommonsFatalEnabled = isEnabled;
        this.setEnabled("jp.ossc.nimbus.service.log.DefaultCommonsLogService.CATEGORY_COMMONS_FATAL", isEnabled);
    }

    public boolean isCommonsFatalEnabled() {
        return this.isEnabled("jp.ossc.nimbus.service.log.DefaultCommonsLogService.CATEGORY_COMMONS_FATAL", this.isCommonsFatalEnabled);
    }

    public void setCommonsTraceMessageWriterServiceName(ServiceName name) {
        this.commonsTraceMessageWriterServiceName = name;
    }

    public ServiceName getCommonsTraceMessageWriterServiceName() {
        return this.commonsTraceMessageWriterServiceName;
    }

    public void setCommonsDebugMessageWriterServiceName(ServiceName name) {
        this.commonsDebugMessageWriterServiceName = name;
    }

    public ServiceName getCommonsDebugMessageWriterServiceName() {
        return this.commonsDebugMessageWriterServiceName;
    }

    public void setCommonsInfoMessageWriterServiceName(ServiceName name) {
        this.commonsInfoMessageWriterServiceName = name;
    }

    public ServiceName getCommonsInfoMessageWriterServiceName() {
        return this.commonsInfoMessageWriterServiceName;
    }

    public void setCommonsWarnMessageWriterServiceName(ServiceName name) {
        this.commonsWarnMessageWriterServiceName = name;
    }

    public ServiceName getCommonsWarnMessageWriterServiceName() {
        return this.commonsWarnMessageWriterServiceName;
    }

    public void setCommonsErrorMessageWriterServiceName(ServiceName name) {
        this.commonsErrorMessageWriterServiceName = name;
    }

    public ServiceName getCommonsErrorMessageWriterServiceName() {
        return this.commonsErrorMessageWriterServiceName;
    }

    public void setCommonsFatalMessageWriterServiceName(ServiceName name) {
        this.commonsFatalMessageWriterServiceName = name;
    }

    public ServiceName getCommonsFatalMessageWriterServiceName() {
        return this.commonsFatalMessageWriterServiceName;
    }

    public void setCommonsTraceWritableRecordFactoryServiceName(ServiceName name) {
        this.commonsTraceRecordFactoryServiceName = name;
    }

    public ServiceName getCommonsTraceWritableRecordFactoryServiceName() {
        return this.commonsTraceRecordFactoryServiceName;
    }

    public void setCommonsDebugWritableRecordFactoryServiceName(ServiceName name) {
        this.commonsDebugRecordFactoryServiceName = name;
    }

    public ServiceName getCommonsDebugWritableRecordFactoryServiceName() {
        return this.commonsDebugRecordFactoryServiceName;
    }

    public void setCommonsInfoWritableRecordFactoryServiceName(ServiceName name) {
        this.commonsInfoRecordFactoryServiceName = name;
    }

    public ServiceName getCommonsInfoWritableRecordFactoryServiceName() {
        return this.commonsInfoRecordFactoryServiceName;
    }

    public void setCommonsWarnWritableRecordFactoryServiceName(ServiceName name) {
        this.commonsWarnRecordFactoryServiceName = name;
    }

    public ServiceName getCommonsWarnWritableRecordFactoryServiceName() {
        return this.commonsWarnRecordFactoryServiceName;
    }

    public void setCommonsErrorWritableRecordFactoryServiceName(ServiceName name) {
        this.commonsErrorRecordFactoryServiceName = name;
    }

    public ServiceName getCommonsErrorWritableRecordFactoryServiceName() {
        return this.commonsErrorRecordFactoryServiceName;
    }

    public void setCommonsFatalWritableRecordFactoryServiceName(ServiceName name) {
        this.commonsFatalRecordFactoryServiceName = name;
    }

    public ServiceName getCommonsFatalWritableRecordFactoryServiceName() {
        return this.commonsFatalRecordFactoryServiceName;
    }

    private class CommonsLog
    implements Log,
    Serializable {
        private static final long serialVersionUID = 6075471555520523752L;
        private final String clientKey;
        private String shortClientKey;
        private boolean isEnabled = true;

        public CommonsLog() {
            this(class$jp$ossc$nimbus$service$log$DefaultCommonsLogFactoryService == null ? (class$jp$ossc$nimbus$service$log$DefaultCommonsLogFactoryService = DefaultCommonsLogFactoryService.class$("jp.ossc.nimbus.service.log.DefaultCommonsLogFactoryService")) : class$jp$ossc$nimbus$service$log$DefaultCommonsLogFactoryService);
        }

        public CommonsLog(Class clazz) {
            this(clazz.getName());
            String className = clazz.getName();
            int index = className.lastIndexOf(46);
            this.shortClientKey = index == -1 ? className : className.substring(index + 1);
        }

        public CommonsLog(String name) {
            this.clientKey = name;
        }

        public String getClientKey() {
            return this.clientKey;
        }

        public String getShortClientKey() {
            return this.shortClientKey == null ? this.clientKey : this.shortClientKey;
        }

        public void setEnabled(boolean enable) {
            this.isEnabled = enable;
        }

        public boolean isEnabled() {
            return this.isEnabled;
        }

        private LogMessageRecord createLogMessageRecord(String category, int priority, Object message, CommonsLog logger) {
            CommonsLogMessageRecord record = new CommonsLogMessageRecord(logger);
            record.addCategory(category);
            record.setPriority(priority);
            record.setMessageCode("");
            record.addMessage(message != null ? message.toString() : null);
            record.setFactory(DefaultCommonsLogFactoryService.this.getMessageRecordFactoryService());
            return record;
        }

        private void write(String category, int priority, Object message) {
            if (!this.isEnabled()) {
                return;
            }
            LogMessageRecord messageRecord = this.createLogMessageRecord(category, priority, message, this);
            if (!DefaultCommonsLogFactoryService.this.isWrite(messageRecord)) {
                return;
            }
            DefaultCommonsLogFactoryService.this.write(messageRecord, null, (String)null, null);
        }

        private void write(String category, int priority, Object message, Throwable t) {
            if (!this.isEnabled()) {
                return;
            }
            LogMessageRecord messageRecord = this.createLogMessageRecord(category, priority, message, this);
            if (!DefaultCommonsLogFactoryService.this.isWrite(messageRecord)) {
                return;
            }
            DefaultCommonsLogFactoryService.this.write(messageRecord, null, (String)null, t);
        }

        public void trace(Object message) {
            this.write("jp.ossc.nimbus.service.log.DefaultCommonsLogService.CATEGORY_COMMONS_TRACE", 5, message);
        }

        public void trace(Object message, Throwable t) {
            this.write("jp.ossc.nimbus.service.log.DefaultCommonsLogService.CATEGORY_COMMONS_TRACE", 5, message, t);
        }

        public void debug(Object message) {
            this.write("jp.ossc.nimbus.service.log.DefaultCommonsLogService.CATEGORY_COMMONS_DEBUG", 15, message);
        }

        public void debug(Object message, Throwable t) {
            this.write("jp.ossc.nimbus.service.log.DefaultCommonsLogService.CATEGORY_COMMONS_DEBUG", 15, message, t);
        }

        public void info(Object message) {
            this.write("jp.ossc.nimbus.service.log.DefaultCommonsLogService.CATEGORY_COMMONS_INFO", 25, message);
        }

        public void info(Object message, Throwable t) {
            this.write("jp.ossc.nimbus.service.log.DefaultCommonsLogService.CATEGORY_COMMONS_INFO", 25, message, t);
        }

        public void warn(Object message) {
            this.write("jp.ossc.nimbus.service.log.DefaultCommonsLogService.CATEGORY_COMMONS_WARN", 35, message);
        }

        public void warn(Object message, Throwable t) {
            this.write("jp.ossc.nimbus.service.log.DefaultCommonsLogService.CATEGORY_COMMONS_WARN", 35, message, t);
        }

        public void error(Object message) {
            this.write("jp.ossc.nimbus.service.log.DefaultCommonsLogService.CATEGORY_COMMONS_ERROR", 45, message);
        }

        public void error(Object message, Throwable t) {
            this.write("jp.ossc.nimbus.service.log.DefaultCommonsLogService.CATEGORY_COMMONS_ERROR", 45, message, t);
        }

        public void fatal(Object message) {
            this.write("jp.ossc.nimbus.service.log.DefaultCommonsLogService.CATEGORY_COMMONS_FATAL", 55, message);
        }

        public void fatal(Object message, Throwable t) {
            this.write("jp.ossc.nimbus.service.log.DefaultCommonsLogService.CATEGORY_COMMONS_FATAL", 55, message, t);
        }

        public boolean isTraceEnabled() {
            return DefaultCommonsLogFactoryService.this.isCommonsTraceEnabled();
        }

        public boolean isDebugEnabled() {
            return DefaultCommonsLogFactoryService.this.isCommonsDebugEnabled();
        }

        public boolean isInfoEnabled() {
            return DefaultCommonsLogFactoryService.this.isCommonsInfoEnabled();
        }

        public boolean isWarnEnabled() {
            return DefaultCommonsLogFactoryService.this.isCommonsWarnEnabled();
        }

        public boolean isErrorEnabled() {
            return DefaultCommonsLogFactoryService.this.isCommonsErrorEnabled();
        }

        public boolean isFatalEnabled() {
            return DefaultCommonsLogFactoryService.this.isCommonsFatalEnabled();
        }
    }

    private static class CommonsLogMessageRecord
    extends LogMessageRecordImpl
    implements Serializable {
        private static final long serialVersionUID = 7967745897491812488L;
        private final String clientKey;
        private final String shortClientKey;

        public CommonsLogMessageRecord(CommonsLog logger) {
            this.clientKey = logger.getClientKey();
            this.shortClientKey = logger.getShortClientKey();
        }

        public String getClientKey() {
            return this.clientKey;
        }

        public String getShortClientKey() {
            return this.shortClientKey;
        }
    }
}

