/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.journal.editor;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletRequest;
import jp.ossc.nimbus.service.journal.editor.JSONJournalEditorService;
import jp.ossc.nimbus.service.journal.editor.ServletRequestJSONJournalEditorServiceMBean;
import jp.ossc.nimbus.service.journal.editorfinder.EditorFinder;

public class ServletRequestJSONJournalEditorService
extends JSONJournalEditorService
implements ServletRequestJSONJournalEditorServiceMBean {
    private static final long serialVersionUID = 2065586363258892183L;
    protected String[] secretAttributes;
    protected Set secretAttributeSet;
    protected String[] enabledAttributes;
    protected Set enabledAttributeSet;
    protected String[] disabledAttributes;
    protected Set disabledAttributeSet;
    protected String[] secretParameters;
    protected Set secretParameterSet;
    protected String[] enabledParameters;
    protected Set enabledParameterSet;
    protected String[] disabledParameters;
    protected Set disabledParameterSet;

    public void setSecretAttributes(String[] names) {
        this.secretAttributes = names;
    }

    public String[] getSecretAttributes() {
        return this.secretAttributes;
    }

    public void setEnabledAttributes(String[] names) {
        this.enabledAttributes = names;
    }

    public String[] getEnabledAttributes() {
        return this.enabledAttributes;
    }

    public void setDisabledAttributes(String[] names) {
        this.disabledAttributes = names;
    }

    public String[] getDisabledAttributes() {
        return this.disabledAttributes;
    }

    public void setSecretParameters(String[] names) {
        this.secretParameters = names;
    }

    public String[] getSecretParameters() {
        return this.secretParameters;
    }

    public void setEnabledParameters(String[] names) {
        this.enabledParameters = names;
    }

    public String[] getEnabledParameters() {
        return this.enabledParameters;
    }

    public void setDisabledParameters(String[] names) {
        this.disabledParameters = names;
    }

    public String[] getDisabledParameters() {
        return this.disabledParameters;
    }

    public void startService() throws Exception {
        int i;
        if (this.secretAttributes != null && this.secretAttributes.length != 0) {
            this.secretAttributeSet = new HashSet(this.secretAttributes.length);
            for (i = 0; i < this.secretAttributes.length; ++i) {
                this.secretAttributeSet.add(this.secretAttributes[i]);
            }
        }
        if (this.enabledAttributes != null && this.enabledAttributes.length != 0) {
            this.enabledAttributeSet = new HashSet(this.enabledAttributes.length);
            for (i = 0; i < this.enabledAttributes.length; ++i) {
                this.enabledAttributeSet.add(this.enabledAttributes[i]);
            }
        }
        if (this.disabledAttributes != null && this.disabledAttributes.length != 0) {
            this.disabledAttributeSet = new HashSet(this.disabledAttributes.length);
            for (i = 0; i < this.disabledAttributes.length; ++i) {
                this.disabledAttributeSet.add(this.disabledAttributes[i]);
            }
        }
        if (this.secretParameters != null && this.secretParameters.length != 0) {
            this.secretParameterSet = new HashSet(this.secretParameters.length);
            for (i = 0; i < this.secretParameters.length; ++i) {
                this.secretParameterSet.add(this.secretParameters[i]);
            }
        }
        if (this.enabledParameters != null && this.enabledParameters.length != 0) {
            this.enabledParameterSet = new HashSet(this.enabledParameters.length);
            for (i = 0; i < this.enabledParameters.length; ++i) {
                this.enabledParameterSet.add(this.enabledParameters[i]);
            }
        }
        if (this.disabledParameters != null && this.disabledParameters.length != 0) {
            this.disabledParameterSet = new HashSet(this.disabledParameters.length);
            for (i = 0; i < this.disabledParameters.length; ++i) {
                this.disabledParameterSet.add(this.disabledParameters[i]);
            }
        }
    }

    protected boolean isOutputAttribute(String name) {
        if (name != null && this.disabledAttributeSet != null && this.disabledAttributeSet.contains(name)) {
            return false;
        }
        return name == null || this.enabledAttributeSet == null || this.enabledAttributeSet.contains(name);
    }

    protected boolean isSecretAttribute(String name) {
        return name != null && this.secretAttributeSet != null && this.secretAttributeSet.contains(name);
    }

    protected boolean isOutputParameter(String name) {
        if (name != null && this.disabledParameterSet != null && this.disabledParameterSet.contains(name)) {
            return false;
        }
        return name == null || this.enabledParameterSet == null || this.enabledParameterSet.contains(name);
    }

    protected boolean isSecretParameter(String name) {
        return name != null && this.secretParameterSet != null && this.secretParameterSet.contains(name);
    }

    protected StringBuffer appendUnknownValue(StringBuffer buf, EditorFinder finder, Class type, Object value) {
        if (!(value instanceof ServletRequest)) {
            return super.appendUnknownValue(buf, finder, type, value);
        }
        ServletRequest request = (ServletRequest)value;
        buf.append("{");
        this.appendServletRequest(buf, finder, request, false);
        buf.append("}");
        return buf;
    }

    protected boolean appendServletRequest(StringBuffer buf, EditorFinder finder, ServletRequest request, boolean isAppended) {
        isAppended |= this.appendSentServer(buf, finder, request, isAppended);
        isAppended |= this.appendReceivedServer(buf, finder, request, isAppended);
        isAppended |= this.appendHost(buf, finder, request, isAppended);
        isAppended |= this.appendProtocol(buf, finder, request, isAppended);
        isAppended |= this.appendScheme(buf, finder, request, isAppended);
        isAppended |= this.appendLocale(buf, finder, request, isAppended);
        isAppended |= this.appendContentType(buf, finder, request, isAppended);
        isAppended |= this.appendContentLength(buf, finder, request, isAppended);
        isAppended |= this.appendCharacterEncoding(buf, finder, request, isAppended);
        isAppended |= this.appendAttributes(buf, finder, request, isAppended);
        isAppended |= this.appendParameters(buf, finder, request, isAppended);
        return isAppended;
    }

    protected boolean appendSentServer(StringBuffer buf, EditorFinder finder, ServletRequest request, boolean isAppended) {
        if (this.isOutputProperty("SentServer")) {
            if (isAppended) {
                buf.append(",");
            }
            this.appendProperty(buf, finder, "SentServer", request.getRemoteAddr() + ":" + request.getRemotePort());
            return true;
        }
        return false;
    }

    protected boolean appendReceivedServer(StringBuffer buf, EditorFinder finder, ServletRequest request, boolean isAppended) {
        if (this.isOutputProperty("ReceivedServer")) {
            if (isAppended) {
                buf.append(",");
            }
            this.appendProperty(buf, finder, "ReceivedServer", request.getLocalAddr() + ":" + request.getLocalPort() + "(" + request.getLocalName() + ")");
            return true;
        }
        return false;
    }

    protected boolean appendHost(StringBuffer buf, EditorFinder finder, ServletRequest request, boolean isAppended) {
        if (this.isOutputProperty("Host")) {
            if (isAppended) {
                buf.append(",");
            }
            this.appendProperty(buf, finder, "Host", request.getServerName() + ":" + request.getServerPort());
            return true;
        }
        return false;
    }

    protected boolean appendProtocol(StringBuffer buf, EditorFinder finder, ServletRequest request, boolean isAppended) {
        if (this.isOutputProperty("Protocol")) {
            if (isAppended) {
                buf.append(",");
            }
            this.appendProperty(buf, finder, "Protocol", request.getProtocol());
            return true;
        }
        return false;
    }

    protected boolean appendScheme(StringBuffer buf, EditorFinder finder, ServletRequest request, boolean isAppended) {
        if (this.isOutputProperty("Scheme")) {
            if (isAppended) {
                buf.append(",");
            }
            this.appendProperty(buf, finder, "Scheme", request.getScheme());
            return true;
        }
        return false;
    }

    protected boolean appendLocale(StringBuffer buf, EditorFinder finder, ServletRequest request, boolean isAppended) {
        if (this.isOutputProperty("Locale")) {
            if (isAppended) {
                buf.append(",");
            }
            this.appendName(buf, "Locale");
            buf.append(":");
            this.appendArray(buf, finder, request.getLocales());
            return true;
        }
        return false;
    }

    protected boolean appendContentType(StringBuffer buf, EditorFinder finder, ServletRequest request, boolean isAppended) {
        if (this.isOutputProperty("ContentType")) {
            if (isAppended) {
                buf.append(",");
            }
            this.appendProperty(buf, finder, "ContentType", request.getContentType());
            return true;
        }
        return false;
    }

    protected boolean appendContentLength(StringBuffer buf, EditorFinder finder, ServletRequest request, boolean isAppended) {
        if (this.isOutputProperty("ContentLength")) {
            if (isAppended) {
                buf.append(",");
            }
            this.appendProperty(buf, finder, "ContentLength", new Integer(request.getContentLength()));
            return true;
        }
        return false;
    }

    protected boolean appendCharacterEncoding(StringBuffer buf, EditorFinder finder, ServletRequest request, boolean isAppended) {
        if (this.isOutputProperty("CharacterEncoding")) {
            if (isAppended) {
                buf.append(",");
            }
            this.appendProperty(buf, finder, "CharacterEncoding", request.getCharacterEncoding());
            return true;
        }
        return false;
    }

    protected boolean appendAttributes(StringBuffer buf, EditorFinder finder, ServletRequest request, boolean isAppended) {
        if (this.isOutputProperty("Attributes")) {
            if (isAppended) {
                buf.append(",");
            }
            this.appendName(buf, "Attributes");
            buf.append(":");
            buf.append("{");
            Enumeration names = request.getAttributeNames();
            boolean isOutput = false;
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                if (!this.isOutputAttribute(name)) continue;
                if (isOutput) {
                    buf.append(",");
                }
                isOutput = true;
                this.appendName(buf, name);
                buf.append(":");
                if (this.isSecretAttribute(name)) {
                    this.appendValue(buf, finder, null, this.secretString);
                    continue;
                }
                this.appendValue(buf, finder, null, request.getAttribute(name));
            }
            buf.append("}");
            return true;
        }
        return false;
    }

    protected boolean appendParameters(StringBuffer buf, EditorFinder finder, ServletRequest request, boolean isAppended) {
        if (this.isOutputProperty("Parameters")) {
            if (isAppended) {
                buf.append(",");
            }
            this.appendName(buf, "Parameters");
            buf.append(":");
            buf.append("{");
            Enumeration names = request.getParameterNames();
            boolean isOutput = false;
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                if (!this.isOutputParameter(name)) continue;
                if (isOutput) {
                    buf.append(",");
                }
                isOutput = true;
                this.appendName(buf, name);
                buf.append(":");
                if (this.isSecretParameter(name)) {
                    this.appendValue(buf, finder, null, this.secretString);
                    continue;
                }
                this.appendArray(buf, finder, request.getParameterValues(name));
            }
            buf.append("}");
            return true;
        }
        return false;
    }
}

