/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.journal.editor;

import java.io.Serializable;
import java.util.List;
import jp.ossc.nimbus.service.journal.editor.BlockJournalEditorServiceBase;
import jp.ossc.nimbus.service.journal.editor.ListJournalEditorServiceMBean;
import jp.ossc.nimbus.service.journal.editorfinder.EditorFinder;

public class ListJournalEditorService
extends BlockJournalEditorServiceBase
implements ListJournalEditorServiceMBean,
Serializable {
    private static final long serialVersionUID = -8798740768642559809L;
    protected static final String MAX_SIZE_OVER = "...";
    protected static final String HEADER = "[List]";
    protected int maxSize = -1;

    public ListJournalEditorService() {
        this.setHeader(HEADER);
    }

    public void setMaxSize(int max) {
        this.maxSize = max;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    protected boolean processBlock(EditorFinder finder, Object key, Object value, StringBuffer buf) {
        List list = (List)value;
        this.makeListFormat(finder, key, list, buf);
        return true;
    }

    protected StringBuffer makeListFormat(EditorFinder finder, Object key, List list, StringBuffer buf) {
        int max;
        int size = list.size();
        if (size == 0) {
            buf.append("[]");
            return buf;
        }
        buf.append('[');
        buf.append(this.getLineSeparator());
        StringBuffer subBuf = new StringBuffer();
        int n = max = this.maxSize > 0 && this.maxSize < size ? this.maxSize : size;
        for (int i = 0; i <= max; ++i) {
            if (i != max) {
                Object element = list.get(i);
                this.makeObjectFormat(finder, null, element, subBuf);
                subBuf.append(this.getLineSeparator());
                continue;
            }
            if (list.size() <= max) continue;
            subBuf.append(MAX_SIZE_OVER);
            subBuf.append(this.getLineSeparator());
        }
        this.addIndent(subBuf);
        buf.append(subBuf);
        return buf.append(']');
    }
}

