/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.journal.editor;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import jp.ossc.nimbus.service.journal.editor.JournalHttpServletResponseWrapper;
import jp.ossc.nimbus.service.journal.editor.JournalHttpServletResponseWrapperJSONJournalEditorServiceMBean;
import jp.ossc.nimbus.service.journal.editor.ServletResponseJSONJournalEditorService;
import jp.ossc.nimbus.service.journal.editorfinder.EditorFinder;

public class JournalHttpServletResponseWrapperJSONJournalEditorService
extends ServletResponseJSONJournalEditorService
implements JournalHttpServletResponseWrapperJSONJournalEditorServiceMBean {
    private static final long serialVersionUID = 7207260794456214813L;
    protected String[] secretHeaders;
    protected Set secretHeaderSet;
    protected String[] enabledHeaders;
    protected Set enabledHeaderSet;
    protected String[] disabledHeaders;
    protected Set disabledHeaderSet;
    protected String[] secretCookies;
    protected Set secretCookieSet;
    protected String[] enabledCookies;
    protected Set enabledCookieSet;
    protected String[] disabledCookies;
    protected Set disabledCookieSet;

    public void setSecretHeaders(String[] names) {
        this.secretHeaders = names;
    }

    public String[] getSecretHeaders() {
        return this.secretHeaders;
    }

    public void setEnabledHeaders(String[] names) {
        this.enabledHeaders = names;
    }

    public String[] getEnabledHeaders() {
        return this.enabledHeaders;
    }

    public void setDisabledHeaders(String[] names) {
        this.disabledHeaders = names;
    }

    public String[] getDisabledHeaders() {
        return this.disabledHeaders;
    }

    public void setSecretCookies(String[] names) {
        this.secretCookies = names;
    }

    public String[] getSecretCookies() {
        return this.secretCookies;
    }

    public void setEnabledCookies(String[] names) {
        this.enabledCookies = names;
    }

    public String[] getEnabledCookies() {
        return this.enabledCookies;
    }

    public void setDisabledCookies(String[] names) {
        this.disabledCookies = names;
    }

    public String[] getDisabledCookies() {
        return this.disabledCookies;
    }

    public void startService() throws Exception {
        int i;
        super.startService();
        if (this.secretHeaders != null && this.secretHeaders.length != 0) {
            this.secretHeaderSet = new HashSet(this.secretHeaders.length);
            for (i = 0; i < this.secretHeaders.length; ++i) {
                this.secretHeaderSet.add(this.secretHeaders[i]);
            }
        }
        if (this.enabledHeaders != null && this.enabledHeaders.length != 0) {
            this.enabledHeaderSet = new HashSet(this.enabledHeaders.length);
            for (i = 0; i < this.enabledHeaders.length; ++i) {
                this.enabledHeaderSet.add(this.enabledHeaders[i]);
            }
        }
        if (this.disabledHeaders != null && this.disabledHeaders.length != 0) {
            this.disabledHeaderSet = new HashSet(this.disabledHeaders.length);
            for (i = 0; i < this.disabledHeaders.length; ++i) {
                this.disabledHeaderSet.add(this.disabledHeaders[i]);
            }
        }
        if (this.secretCookies != null && this.secretCookies.length != 0) {
            this.secretCookieSet = new HashSet(this.secretCookies.length);
            for (i = 0; i < this.secretCookies.length; ++i) {
                this.secretCookieSet.add(this.secretCookies[i]);
            }
        }
        if (this.enabledCookies != null && this.enabledCookies.length != 0) {
            this.enabledCookieSet = new HashSet(this.enabledCookies.length);
            for (i = 0; i < this.enabledCookies.length; ++i) {
                this.enabledCookieSet.add(this.enabledCookies[i]);
            }
        }
        if (this.disabledCookies != null && this.disabledCookies.length != 0) {
            this.disabledCookieSet = new HashSet(this.disabledCookies.length);
            for (i = 0; i < this.disabledCookies.length; ++i) {
                this.disabledCookieSet.add(this.disabledCookies[i]);
            }
        }
    }

    protected boolean isOutputHeader(String name) {
        if (name != null && this.disabledHeaderSet != null && this.disabledHeaderSet.contains(name)) {
            return false;
        }
        return name == null || this.enabledHeaderSet == null || this.enabledHeaderSet.contains(name);
    }

    protected boolean isSecretHeader(String name) {
        return name != null && this.secretHeaderSet != null && this.secretHeaderSet.contains(name);
    }

    protected boolean isOutputCookie(String name) {
        if (name != null && this.disabledCookieSet != null && this.disabledCookieSet.contains(name)) {
            return false;
        }
        return name == null || this.enabledCookieSet == null || this.enabledCookieSet.contains(name);
    }

    protected boolean isSecretCookie(String name) {
        return name != null && this.secretCookieSet != null && this.secretCookieSet.contains(name);
    }

    protected StringBuffer appendUnknownValue(StringBuffer buf, EditorFinder finder, Class type, Object value) {
        if (!(value instanceof JournalHttpServletResponseWrapper)) {
            return super.appendUnknownValue(buf, finder, type, value);
        }
        JournalHttpServletResponseWrapper response = (JournalHttpServletResponseWrapper)value;
        buf.append("{");
        boolean isAppended = this.appendServletResponse(buf, finder, (ServletResponse)response, false);
        this.appendJournalHttpServletResponseWrapper(buf, finder, response, isAppended);
        buf.append("}");
        return buf;
    }

    protected boolean appendJournalHttpServletResponseWrapper(StringBuffer buf, EditorFinder finder, JournalHttpServletResponseWrapper response, boolean isAppended) {
        isAppended |= this.appendContentLength(buf, finder, response, isAppended);
        isAppended |= this.appendContent(buf, finder, response, isAppended);
        isAppended |= this.appendHeaders(buf, finder, response, isAppended);
        isAppended |= this.appendCookies(buf, finder, response, isAppended);
        isAppended |= this.appendStatus(buf, finder, response, isAppended);
        isAppended |= this.appendStatusMessage(buf, finder, response, isAppended);
        isAppended |= this.appendIsSentError(buf, finder, response, isAppended);
        isAppended |= this.appendRedirectLocation(buf, finder, response, isAppended);
        return isAppended;
    }

    protected boolean appendContentLength(StringBuffer buf, EditorFinder finder, JournalHttpServletResponseWrapper response, boolean isAppended) {
        if (this.isOutputProperty("ContentLength")) {
            if (isAppended) {
                buf.append(",");
            }
            this.appendProperty(buf, finder, "ContentLength", new Integer(response.getContentLength()));
            return true;
        }
        return false;
    }

    protected boolean appendContent(StringBuffer buf, EditorFinder finder, JournalHttpServletResponseWrapper response, boolean isAppended) {
        if (this.isOutputProperty("Content")) {
            if (isAppended) {
                buf.append(",");
            }
            this.appendProperty(buf, finder, "Content", response.getContent());
            return true;
        }
        return false;
    }

    protected boolean appendHeaders(StringBuffer buf, EditorFinder finder, JournalHttpServletResponseWrapper response, boolean isAppended) {
        if (this.isOutputProperty("Header")) {
            if (isAppended) {
                buf.append(",");
            }
            this.appendName(buf, "Header");
            buf.append(":");
            buf.append("{");
            boolean isOutput = false;
            Iterator names = response.getHeaderNames();
            while (names.hasNext()) {
                String name = (String)names.next();
                if (!this.isOutputHeader(name)) continue;
                if (isOutput) {
                    buf.append(",");
                }
                isOutput = true;
                this.appendName(buf, name);
                buf.append(":");
                if (this.isSecretHeader(name)) {
                    this.appendValue(buf, finder, null, this.secretString);
                    continue;
                }
                this.appendArray(buf, finder, response.getHeaders(name));
            }
            buf.append("}");
            return true;
        }
        return false;
    }

    protected boolean appendCookies(StringBuffer buf, EditorFinder finder, JournalHttpServletResponseWrapper response, boolean isAppended) {
        if (this.isOutputProperty("Header")) {
            if (isAppended) {
                buf.append(",");
            }
            this.appendName(buf, "Header");
            buf.append(":");
            buf.append("{");
            boolean isOutput = false;
            Cookie[] cookies = response.getCookies();
            for (int i = 0; i < cookies.length; ++i) {
                Cookie cookie = cookies[i];
                String name = cookie.getName();
                if (!this.isOutputCookie(name)) continue;
                if (isOutput) {
                    buf.append(",");
                }
                isOutput = true;
                this.appendName(buf, name);
                buf.append(":");
                boolean isOutputCookie = false;
                buf.append("{");
                if (this.isOutputProperty("CookieValue")) {
                    if (this.isSecretCookie(name)) {
                        this.appendProperty(buf, finder, "CookieValue", this.secretString);
                    } else {
                        this.appendProperty(buf, finder, "CookieValue", cookie.getValue());
                    }
                    isOutputCookie = true;
                }
                if (this.isOutputProperty("CookieComment")) {
                    if (isOutputCookie) {
                        buf.append(",");
                    }
                    this.appendProperty(buf, finder, "CookieComment", cookie.getComment());
                    isOutputCookie = true;
                }
                if (this.isOutputProperty("CookieDomain")) {
                    if (isOutputCookie) {
                        buf.append(",");
                    }
                    this.appendProperty(buf, finder, "CookieDomain", cookie.getDomain());
                    isOutputCookie = true;
                }
                if (this.isOutputProperty("CookieMaxAge")) {
                    if (isOutputCookie) {
                        buf.append(",");
                    }
                    this.appendProperty(buf, finder, "CookieMaxAge", new Integer(cookie.getMaxAge()));
                    isOutputCookie = true;
                }
                if (this.isOutputProperty("CookiePath")) {
                    if (isOutputCookie) {
                        buf.append(",");
                    }
                    this.appendProperty(buf, finder, "CookiePath", cookie.getPath());
                    isOutputCookie = true;
                }
                if (this.isOutputProperty("CookieSecure")) {
                    if (isOutputCookie) {
                        buf.append(",");
                    }
                    this.appendProperty(buf, finder, "CookieSecure", cookie.getSecure() ? Boolean.TRUE : Boolean.FALSE);
                    isOutputCookie = true;
                }
                if (this.isOutputProperty("CookieVersion")) {
                    if (isOutputCookie) {
                        buf.append(",");
                    }
                    this.appendProperty(buf, finder, "CookieVersion", new Integer(cookie.getVersion()));
                    isOutputCookie = true;
                }
                buf.append("}");
            }
            buf.append("}");
            return true;
        }
        return false;
    }

    protected boolean appendStatus(StringBuffer buf, EditorFinder finder, JournalHttpServletResponseWrapper response, boolean isAppended) {
        if (this.isOutputProperty("Status")) {
            if (isAppended) {
                buf.append(",");
            }
            this.appendProperty(buf, finder, "Status", new Integer(response.getStatus()));
            return true;
        }
        return false;
    }

    protected boolean appendStatusMessage(StringBuffer buf, EditorFinder finder, JournalHttpServletResponseWrapper response, boolean isAppended) {
        if (this.isOutputProperty("StatusMessage")) {
            if (isAppended) {
                buf.append(",");
            }
            this.appendProperty(buf, finder, "StatusMessage", response.getStatusMessage());
            return true;
        }
        return false;
    }

    protected boolean appendIsSentError(StringBuffer buf, EditorFinder finder, JournalHttpServletResponseWrapper response, boolean isAppended) {
        if (this.isOutputProperty("IsSentError")) {
            if (isAppended) {
                buf.append(",");
            }
            this.appendProperty(buf, finder, "IsSentError", response.isSentError() ? Boolean.TRUE : Boolean.FALSE);
            return true;
        }
        return false;
    }

    protected boolean appendRedirectLocation(StringBuffer buf, EditorFinder finder, JournalHttpServletResponseWrapper response, boolean isAppended) {
        if (this.isOutputProperty("RedirectLocation")) {
            if (isAppended) {
                buf.append(",");
            }
            this.appendProperty(buf, finder, "RedirectLocation", response.getRedirectLocation());
            return true;
        }
        return false;
    }
}

