/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.jms;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import jp.ossc.nimbus.service.jms.ReconnectableMessageProducer;
import jp.ossc.nimbus.service.jms.ReconnectableSession;

public class ReconnectableTopicPublisher
extends ReconnectableMessageProducer
implements TopicPublisher {
    public ReconnectableTopicPublisher(ReconnectableSession session, Destination destination) throws JMSException {
        super(session, destination);
    }

    protected MessageProducer createMessageProducer(ReconnectableSession session, Destination destination) throws JMSException {
        this.destination = destination;
        return ((TopicSession)session.getRealSession()).createPublisher((Topic)destination);
    }

    public Destination getDestination() throws JMSException {
        return this.getTopic();
    }

    public Topic getTopic() throws JMSException {
        return ((TopicPublisher)this.messageProducer).getTopic();
    }

    public void publish(Message message) throws JMSException {
        ((TopicPublisher)this.messageProducer).publish(message);
    }

    public void publish(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        ((TopicPublisher)this.messageProducer).publish(message, deliveryMode, priority, timeToLive);
    }

    public void publish(Topic topic, Message message) throws JMSException {
        ((TopicPublisher)this.messageProducer).publish(topic, message);
    }

    public void publish(Topic topic, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        ((TopicPublisher)this.messageProducer).publish(topic, message, deliveryMode, priority, timeToLive);
    }
}

