/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.graph;

import java.awt.Font;
import java.util.ArrayList;
import java.util.List;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.graph.ChartCondition;
import jp.ossc.nimbus.service.graph.JFreeChartCreateException;
import jp.ossc.nimbus.service.graph.JFreeChartFactory;
import jp.ossc.nimbus.service.graph.JFreeChartFactoryServiceMBean;
import jp.ossc.nimbus.service.graph.PlotCreateException;
import jp.ossc.nimbus.service.graph.PlotFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.title.LegendTitle;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.title.Title;

public class JFreeChartFactoryService
extends ServiceBase
implements JFreeChartFactory,
JFreeChartFactoryServiceMBean {
    private static final long serialVersionUID = -7164526648533773901L;
    private JFreeChart tmpJFreeChart;
    private ServiceName plotFactoryServiceName;
    private PlotFactory plotFactory;
    private List subtitles;
    private boolean createLegend = true;

    public void createService() throws Exception {
        this.tmpJFreeChart = new JFreeChart((Plot)new XYPlot());
        this.subtitles = new ArrayList();
    }

    public void startService() throws Exception {
        if (this.plotFactoryServiceName == null) {
            throw new IllegalArgumentException("PlotFactory ServiceName must be specified.");
        }
        this.plotFactory = (PlotFactory)ServiceManagerFactory.getServiceObject(this.plotFactoryServiceName);
    }

    public void stopService() throws Exception {
        this.subtitles.clear();
    }

    public void destroyService() throws Exception {
        this.tmpJFreeChart = null;
        this.subtitles = null;
    }

    public JFreeChart getJFreeChart() {
        return this.tmpJFreeChart;
    }

    public JFreeChart createChart(ChartCondition chartCondition) throws JFreeChartCreateException {
        JFreeChart chart;
        block14: {
            Plot plot = null;
            try {
                plot = this.plotFactory.createPlot(chartCondition.getPlotConditions());
            }
            catch (PlotCreateException e) {
                throw new JFreeChartCreateException(e);
            }
            chart = this.copyJFreeChart(plot);
            if (chartCondition.getTitle() != null && (chartCondition.getTitleFontName() != null || chartCondition.getTitleFontStyle() != Integer.MIN_VALUE || chartCondition.getTitleFontSize() != Integer.MIN_VALUE)) {
                Font newFont = null;
                TextTitle orgTitle = chart.getTitle();
                if (orgTitle != null) {
                    newFont = this.mergeFont(orgTitle.getFont(), chartCondition.getTitleFontName(), chartCondition.getTitleFontStyle(), chartCondition.getTitleFontSize());
                }
                if (newFont != null) {
                    chart.setTitle(new TextTitle(chartCondition.getTitle(), newFont));
                } else {
                    chart.setTitle(chartCondition.getTitle());
                }
            } else if (chartCondition.getTitle() != null) {
                chart.setTitle(chartCondition.getTitle());
            }
            if (chart.getSubtitleCount() <= 0) break block14;
            List subList = chart.getSubtitles();
            String defaultFontName = chartCondition.getDefaultSubtitleFontName();
            int defaultFontStyle = chartCondition.getDefaultSubtitleFontStyle();
            int defaultFontSize = chartCondition.getDefaultSubtitleFontSize();
            if (defaultFontName != null || defaultFontStyle != Integer.MIN_VALUE || defaultFontSize != Integer.MIN_VALUE) {
                for (int i = 0; i < subList.size(); ++i) {
                    Object subtitle = subList.get(i);
                    if (subtitle instanceof LegendTitle) {
                        LegendTitle legendTitle = (LegendTitle)subtitle;
                        legendTitle.setItemFont(this.mergeFont(legendTitle.getItemFont(), defaultFontName, defaultFontStyle, defaultFontSize));
                        continue;
                    }
                    if (!(subtitle instanceof TextTitle)) continue;
                    TextTitle textTitle = (TextTitle)subtitle;
                    textTitle.setFont(this.mergeFont(textTitle.getFont(), defaultFontName, defaultFontStyle, defaultFontSize));
                }
            } else {
                for (int i = 0; i < subList.size(); ++i) {
                    String subFontName = chartCondition.getSubtitleFontName(i);
                    int subFontStyle = chartCondition.getSubtitleFontStyle(i);
                    int subFontSize = chartCondition.getSubtitleFontSize(i);
                    if (subFontName == null && subFontStyle == Integer.MIN_VALUE && subFontSize == Integer.MIN_VALUE) continue;
                    Title subtitle = chart.getSubtitle(i);
                    if (subtitle instanceof LegendTitle) {
                        LegendTitle legendTitle = (LegendTitle)subtitle;
                        legendTitle.setItemFont(this.mergeFont(legendTitle.getItemFont(), subFontName, subFontStyle, subFontSize));
                        continue;
                    }
                    if (!(subtitle instanceof TextTitle)) continue;
                    TextTitle textTitle = (TextTitle)subtitle;
                    textTitle.setFont(this.mergeFont(textTitle.getFont(), subFontName, subFontStyle, subFontSize));
                }
            }
        }
        return chart;
    }

    private Font mergeFont(Font orgFont, String fontName, int fontStyle, int fontSize) {
        if (orgFont == null) {
            return new Font(fontName, fontStyle, fontSize);
        }
        String newName = orgFont.getName();
        int newStyle = orgFont.getStyle();
        int newSize = orgFont.getSize();
        if (fontName != null) {
            newName = fontName;
        }
        if (fontStyle != Integer.MIN_VALUE) {
            newStyle = fontStyle;
        }
        if (fontSize != Integer.MIN_VALUE) {
            newSize = fontSize;
        }
        return new Font(newName, newStyle, newSize);
    }

    private JFreeChart copyJFreeChart(Plot plot) {
        JFreeChart chart = new JFreeChart(null, null, plot, this.createLegend);
        chart.setAntiAlias(this.tmpJFreeChart.getAntiAlias());
        chart.setBackgroundImage(this.tmpJFreeChart.getBackgroundImage());
        chart.setBackgroundImageAlignment(this.tmpJFreeChart.getBackgroundImageAlignment());
        chart.setBackgroundImageAlpha(this.tmpJFreeChart.getBackgroundImageAlpha());
        chart.setBackgroundPaint(this.tmpJFreeChart.getBackgroundPaint());
        chart.setBorderPaint(this.tmpJFreeChart.getBorderPaint());
        chart.setBorderStroke(this.tmpJFreeChart.getBorderStroke());
        chart.setBorderVisible(this.tmpJFreeChart.isBorderVisible());
        chart.setNotify(this.tmpJFreeChart.isNotify());
        chart.setPadding(this.tmpJFreeChart.getPadding());
        chart.setRenderingHints(this.tmpJFreeChart.getRenderingHints());
        if (this.subtitles.size() > 0) {
            chart.setSubtitles(this.subtitles);
        }
        chart.setTitle(this.tmpJFreeChart.getTitle());
        if (chart.getLegend() != null) {
            chart.getLegend().setItemFont(this.tmpJFreeChart.getLegend().getItemFont());
        }
        return chart;
    }

    public ServiceName getPlotFactoryServiceName() {
        return this.plotFactoryServiceName;
    }

    public void setPlotFactoryServiceName(ServiceName serviceName) {
        this.plotFactoryServiceName = serviceName;
    }

    public void addSubtitle(Title title) {
        this.subtitles.add(title);
    }

    public void setCreateLegend(boolean createLegend) {
        this.createLegend = createLegend;
    }
}

