/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.ga;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Random;
import jp.ossc.nimbus.service.ga.ConvergenceCondition;
import jp.ossc.nimbus.service.ga.Generation;
import jp.ossc.nimbus.service.ga.Genom;
import jp.ossc.nimbus.service.ga.Seed;
import jp.ossc.nimbus.service.ga.SeedMatchMaker;
import jp.ossc.nimbus.service.queue.AsynchContext;
import jp.ossc.nimbus.service.queue.DefaultQueueService;
import jp.ossc.nimbus.service.queue.QueueHandler;
import jp.ossc.nimbus.service.queue.QueueHandlerContainer;
import jp.ossc.nimbus.service.queue.QueueHandlerContainerService;

public class DefaultGeneration
implements Generation {
    protected int generationNo = 1;
    protected Seed[] seeds;
    protected QueueHandlerContainer queueHandlerContainer;
    protected ConvergenceCondition convergenceCondition;
    protected ConvergenceCondition.ConvergenceConditionResult convergenceConditionResult;
    protected boolean fitnessOrder = false;

    public void setConvergenceCondition(ConvergenceCondition condition) {
        this.convergenceCondition = condition;
    }

    public void setQueueHandlerContainer(QueueHandlerContainer qhc) {
        this.queueHandlerContainer = qhc;
    }

    public QueueHandlerContainer getQueueHandlerContainer() {
        return this.queueHandlerContainer;
    }

    public void setFitnessOrder(boolean isAsc) {
        this.fitnessOrder = isAsc;
    }

    public boolean getFitnessOrder() {
        return this.fitnessOrder;
    }

    public int getGenerationNo() {
        return this.generationNo;
    }

    public void init(Random random, Seed seed, int num) {
        this.seeds = new Seed[num];
        for (int i = 0; i < num; ++i) {
            this.seeds[i] = seed.cloneSeed();
            Genom genom = this.seeds[i].getGenom();
            genom.random(random);
        }
    }

    public void setSeeds(Seed[] seeds) {
        this.seeds = seeds;
    }

    public Seed[] getSeeds() {
        return this.seeds;
    }

    public void compete() throws Exception {
        this.compete(1, -1L);
    }

    public void compete(int threadNum, long timeout) throws Exception {
        if (this.queueHandlerContainer == null && threadNum < 2) {
            for (int i = 0; i < this.seeds.length; ++i) {
                if (this.seeds[i].getFitness() != null) continue;
                this.seeds[i].fit(this);
            }
        } else {
            int i;
            long start = System.currentTimeMillis();
            QueueHandlerContainer qhc = this.queueHandlerContainer;
            if (qhc == null) {
                QueueHandlerContainerService service = new QueueHandlerContainerService();
                service.create();
                service.setQueueHandler(new FitHandler());
                service.setQueueHandlerSize(threadNum);
                service.start();
                qhc = service;
            } else if (qhc.getQueueHandler() == null) {
                qhc.setQueueHandler(new FitHandler());
            }
            DefaultQueueService responseQueue = new DefaultQueueService();
            responseQueue.create();
            responseQueue.start();
            for (i = 0; i < this.seeds.length; ++i) {
                qhc.push(new AsynchContext(new Object[]{this, this.seeds[i]}, responseQueue));
            }
            for (i = 0; i < this.seeds.length; ++i) {
                long currentTimeout = timeout - (System.currentTimeMillis() - start);
                AsynchContext ctx = (AsynchContext)responseQueue.get(currentTimeout);
                if (ctx == null) {
                    throw new Exception("Compete timeout.");
                }
                try {
                    ctx.checkError();
                    continue;
                }
                catch (Exception e) {
                    throw e;
                }
                catch (Throwable th) {
                    throw (Error)th;
                }
            }
        }
        Arrays.sort(this.seeds, new SeedComparator(this.fitnessOrder));
    }

    public Generation next(Random random, SeedMatchMaker matchMaker) {
        Seed[] pair;
        this.convergenceConditionResult = this.convergenceCondition.checkConvergence(this, this.convergenceConditionResult);
        if (this.convergenceConditionResult.isConverged()) {
            return null;
        }
        DefaultGeneration generation = new DefaultGeneration();
        generation.queueHandlerContainer = this.queueHandlerContainer;
        generation.convergenceCondition = this.convergenceCondition;
        generation.convergenceConditionResult = this.convergenceConditionResult;
        generation.fitnessOrder = this.fitnessOrder;
        generation.generationNo = this.generationNo + 1;
        Seed[] newSeeds = new Seed[this.seeds.length];
        SeedMatchMaker.MatchMakeResult mmResult = null;
        for (int i = 0; i < this.seeds.length && (pair = (mmResult = matchMaker.matchMake(random, this, i, mmResult)).getPair()) != null; ++i) {
            if (pair[1] != null) {
                newSeeds[i] = pair[0].cloneSeed();
                newSeeds[i].getGenom().crossover(random, pair[1].getGenom());
                continue;
            }
            newSeeds[i] = pair[0];
        }
        generation.setSeeds(newSeeds);
        return generation;
    }

    public Seed getSurvivor() {
        return this.seeds == null || this.seeds.length == 0 ? null : this.seeds[0];
    }

    protected static class SeedComparator
    implements Comparator {
        protected boolean isAsc;

        public SeedComparator(boolean isAsc) {
            this.isAsc = isAsc;
        }

        public int compare(Object o1, Object o2) {
            Seed seed1 = (Seed)o1;
            Seed seed2 = (Seed)o2;
            Comparable comp1 = (Comparable)((Object)seed1.getFitness());
            Comparable comp2 = (Comparable)((Object)seed2.getFitness());
            if (comp1 == null && comp2 == null) {
                return 0;
            }
            if (comp1 == null) {
                return 1;
            }
            if (comp2 == null) {
                return -1;
            }
            int comp = comp1.compareTo(comp2);
            return this.isAsc ? comp : -comp;
        }
    }

    protected static class FitHandler
    implements QueueHandler {
        protected FitHandler() {
        }

        public void handleDequeuedObject(Object obj) throws Throwable {
            if (obj == null) {
                return;
            }
            AsynchContext ctx = (AsynchContext)obj;
            Object[] param = (Object[])ctx.getInput();
            Generation generation = (Generation)param[0];
            Seed seed = (Seed)param[1];
            if (seed.getFitness() == null) {
                seed.fit(generation);
            }
            ctx.getResponseQueue().push(ctx);
        }

        public boolean handleError(Object obj, Throwable th) throws Throwable {
            return true;
        }

        public void handleRetryOver(Object obj, Throwable th) throws Throwable {
            AsynchContext ctx = (AsynchContext)obj;
            ctx.setThrowable(th);
            ctx.getResponseQueue().push(ctx);
        }
    }
}

