/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.ga;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import jp.ossc.nimbus.service.ga.AbstractGene;
import jp.ossc.nimbus.service.ga.Gene;

public class ComplexGene
extends AbstractGene {
    public static final int CROSSOVER_SINGLE_POINT = 1;
    public static final int CROSSOVER_TWO_POINT = 2;
    public static final int CROSSOVER_UNIFORM_POINT = 3;
    public static final int CROSSOVER_ALL_POINT = 4;

    public ComplexGene() {
        this.crossoverType = 4;
    }

    public Gene getGene(String name) {
        Map params = (Map)this.getValue();
        return params == null ? null : (Gene)params.get(name);
    }

    public void setGene(String name, Gene gene) {
        LinkedHashMap<String, Gene> params = (LinkedHashMap<String, Gene>)this.getValue();
        if (params == null) {
            params = new LinkedHashMap<String, Gene>();
            this.setValue(params);
        }
        if (gene instanceof AbstractGene) {
            ((AbstractGene)gene).setName(name);
        }
        params.put(name, gene);
    }

    public void addGene(Gene gene) {
        LinkedHashMap<String, Gene> params = (LinkedHashMap<String, Gene>)this.getValue();
        if (params == null) {
            params = new LinkedHashMap<String, Gene>();
            this.setValue(params);
        }
        params.put(gene.getName(), gene);
    }

    public void random(Random random) {
        Map params = (Map)this.getValue();
        if (params != null) {
            Iterator itr = params.values().iterator();
            while (itr.hasNext()) {
                ((Gene)itr.next()).random(random);
            }
        }
    }

    public void crossover(Random random, Gene gene) {
        ComplexGene compGene = (ComplexGene)gene;
        switch (this.crossoverType) {
            case 1: {
                this.crossoverBySinglePoint(random, compGene);
                break;
            }
            case 2: {
                this.crossoverByTwoPoint(random, compGene);
                break;
            }
            case 3: {
                this.crossoverByUniformPoint(random, compGene);
                break;
            }
            default: {
                this.crossoverByAllPoint(random, compGene);
            }
        }
    }

    protected void crossoverBySinglePoint(Random random, ComplexGene gene) {
        Map params = (Map)this.getValue();
        if (params != null) {
            int crossoverPoint = 0;
            if (params.size() < 2) {
                this.crossoverByAllPoint(random, gene);
                return;
            }
            crossoverPoint = params.size() == 2 ? 1 : random.nextInt(params.size() - 1) + 1;
            Object[] paramArray = params.values().toArray();
            int start = 0;
            int end = 0;
            if (random.nextBoolean()) {
                start = 0;
                end = crossoverPoint;
            } else {
                start = crossoverPoint;
                end = paramArray.length;
            }
            for (int i = start; i < end; ++i) {
                Gene param = (Gene)paramArray[i];
                param.crossover(random, gene.getGene(param.getName()));
            }
        }
    }

    protected void crossoverByTwoPoint(Random random, ComplexGene gene) {
        Map params = (Map)this.getValue();
        if (params != null) {
            int crossoverPoint1 = 0;
            int crossoverPoint2 = 0;
            if (params.size() < 3) {
                this.crossoverBySinglePoint(random, gene);
                return;
            }
            if (params.size() == 3) {
                crossoverPoint1 = 1;
                crossoverPoint2 = 2;
            } else {
                crossoverPoint1 = random.nextInt(params.size() - 2) + 1;
                crossoverPoint2 = random.nextInt(params.size() - 1 - crossoverPoint1) + crossoverPoint1 + 1;
            }
            int section = random.nextInt(3);
            int start = 0;
            int end = 0;
            Object[] paramArray = params.values().toArray();
            switch (section) {
                case 0: {
                    start = 0;
                    end = crossoverPoint1;
                }
                case 1: {
                    start = crossoverPoint1;
                    end = crossoverPoint2;
                }
                case 2: {
                    start = crossoverPoint2;
                    end = paramArray.length;
                }
            }
            for (int i = start; i < end; ++i) {
                Gene param = (Gene)paramArray[i];
                param.crossover(random, gene.getGene(param.getName()));
            }
        }
    }

    protected void crossoverByUniformPoint(Random random, ComplexGene gene) {
        Map params = (Map)this.getValue();
        if (params != null) {
            Iterator itr = params.values().iterator();
            while (itr.hasNext()) {
                Gene param = (Gene)itr.next();
                if (!random.nextBoolean()) continue;
                param.crossover(random, gene.getGene(param.getName()));
            }
        }
    }

    protected void crossoverByAllPoint(Random random, ComplexGene gene) {
        Map params = (Map)this.getValue();
        if (params != null) {
            Iterator itr = params.values().iterator();
            while (itr.hasNext()) {
                Gene param = (Gene)itr.next();
                param.crossover(random, gene.getGene(param.getName()));
            }
        }
    }

    protected String toValueString() {
        Map params = (Map)this.getValue();
        if (params == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        buf.append('[');
        Iterator itr = params.values().iterator();
        while (itr.hasNext()) {
            buf.append(itr.next());
            if (!itr.hasNext()) continue;
            buf.append(',');
        }
        buf.append(']');
        return buf.toString();
    }

    public Gene cloneGene() {
        ComplexGene clone = (ComplexGene)super.cloneGene();
        if (this.value != null) {
            Map params = (Map)this.getValue();
            LinkedHashMap<String, Gene> cloneParams = new LinkedHashMap<String, Gene>();
            Iterator itr = params.values().iterator();
            while (itr.hasNext()) {
                Gene param = (Gene)itr.next();
                cloneParams.put(param.getName(), param.cloneGene());
            }
            clone.value = cloneParams;
        }
        return clone;
    }

    public int hashCode() {
        int hashCode = this.name == null ? 0 : this.name.hashCode();
        Map params = (Map)this.getValue();
        if (params != null) {
            Iterator itr = params.values().iterator();
            while (itr.hasNext()) {
                hashCode += itr.next().hashCode();
            }
        }
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof ComplexGene)) {
            return false;
        }
        ComplexGene gene = (ComplexGene)obj;
        if (this.name != null && gene.getName() == null || this.name == null && gene.getName() != null || this.name != null && !this.name.equals(gene.getName())) {
            return false;
        }
        Map params = (Map)this.getValue();
        Map compParams = (Map)gene.getValue();
        if (params == null && compParams != null || params != null && compParams == null || params != null && !((Object)params.keySet()).equals(compParams.keySet())) {
            return false;
        }
        if (params != null) {
            Iterator itr = params.values().iterator();
            while (itr.hasNext()) {
                Gene param = (Gene)itr.next();
                if (param.equals(compParams.get(param.getName()))) continue;
                return false;
            }
        }
        return true;
    }
}

