/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.ga;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Random;
import jp.ossc.nimbus.service.ga.Gene;

public abstract class AbstractGene
implements Gene,
Cloneable,
Externalizable {
    protected String name;
    protected Object value;
    protected int crossoverType;
    protected int mutateType;
    protected float mutateRate;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public void setCrossoverType(int type) {
        this.crossoverType = type;
    }

    public int getCrossoverType() {
        return this.crossoverType;
    }

    public void setMutateType(int type) {
        this.mutateType = type;
    }

    public int getMutateType() {
        return this.mutateType;
    }

    public void setMutateRate(float rate) {
        this.mutateRate = rate;
    }

    public float getMutateRate() {
        return this.mutateRate;
    }

    protected boolean isMutate(Random random) {
        return this.mutateRate > 0.0f && random.nextFloat() <= this.mutateRate;
    }

    public Gene cloneGene() {
        AbstractGene clone = null;
        try {
            clone = (AbstractGene)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
        clone.name = this.name;
        clone.value = this.value;
        return clone;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.crossoverType);
        out.writeInt(this.mutateType);
        out.writeFloat(this.mutateRate);
        out.writeObject(this.name);
        out.writeObject(this.value);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.crossoverType = in.readInt();
        this.mutateType = in.readInt();
        this.mutateRate = in.readFloat();
        this.name = (String)in.readObject();
        this.value = in.readObject();
    }

    protected String toValueString() {
        return this.getValue() == null ? null : this.getValue().toString();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append('{');
        buf.append("name=").append(this.name);
        buf.append(", value=").append(this.toValueString());
        buf.append('}');
        return buf.toString();
    }

    public int hashCode() {
        int hashCode = this.name == null ? 0 : this.name.hashCode();
        return hashCode += this.value == null ? 0 : this.value.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof Gene)) {
            return false;
        }
        Gene gene = (Gene)obj;
        if (this.name != null && gene.getName() == null || this.name == null && gene.getName() != null || this.name != null && !this.name.equals(gene.getName())) {
            return false;
        }
        return !(this.value != null && gene.getValue() == null || this.value == null && gene.getValue() != null) && (this.value == null || this.value.equals(gene.getValue()));
    }
}

