/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.ftp.ftpclient;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;
import jp.ossc.nimbus.beans.NoSuchPropertyException;
import jp.ossc.nimbus.beans.PropertyAccess;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.service.ftp.FTPClient;
import jp.ossc.nimbus.service.ftp.FTPClientFactory;
import jp.ossc.nimbus.service.ftp.FTPException;
import jp.ossc.nimbus.service.ftp.ftpclient.FTPClientFactoryServiceMBean;
import jp.ossc.nimbus.service.ftp.ftpclient.FTPClientImpl;
import org.apache.commons.net.ftp.FTPFileListParser;

public class FTPClientFactoryService
extends ServiceBase
implements FTPClientFactory,
FTPClientFactoryServiceMBean {
    private static final long serialVersionUID = 1823861487346954556L;
    private int soTimeout = -1;
    private int soLinger = -1;
    private Boolean isTcpNoDelay;
    private ServerSocketFactory serverSocketFactory;
    private SocketFactory socketFactory;
    private String hostName;
    private int port = -1;
    private String bindAddress;
    private int localPort = -1;
    private String userName;
    private String password = "";
    private FTPFileListParser ftpFileListParser;
    private File homeDir;
    private boolean isJavaRegexEnabled = false;
    private boolean isPassive = false;
    private Map ftpClientProps = Collections.synchronizedMap(new HashMap());

    public void setSoTimeout(int timeout) {
        this.soTimeout = timeout;
    }

    public int getSoTimeout() {
        return this.soTimeout;
    }

    public void setSoLinger(int time) {
        this.soLinger = time;
    }

    public int getSoLinger() {
        return this.soLinger;
    }

    public void setTcpNoDelay(boolean noDelay) {
        this.isTcpNoDelay = noDelay ? Boolean.TRUE : Boolean.FALSE;
    }

    public boolean isTcpNoDelay() {
        return this.isTcpNoDelay == null ? false : this.isTcpNoDelay;
    }

    public void setServerSocketFactory(ServerSocketFactory factory) {
        this.serverSocketFactory = factory;
    }

    public ServerSocketFactory getServerSocketFactory() {
        return this.serverSocketFactory;
    }

    public void setSocketFactory(SocketFactory factory) {
        this.socketFactory = factory;
    }

    public SocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    public void setHostName(String addr) {
        this.hostName = addr;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public void setBindAddress(String addr) {
        this.bindAddress = addr;
    }

    public String getBindAddress() {
        return this.bindAddress;
    }

    public void setLocalPort(int port) {
        this.localPort = port;
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public void setUserName(String name) {
        this.userName = name;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public void setFTPFileListParser(FTPFileListParser parser) {
        this.ftpFileListParser = parser;
    }

    public FTPFileListParser getFTPFileListParser() {
        return this.ftpFileListParser;
    }

    public void setHomeDirectory(File dir) {
        this.homeDir = dir;
    }

    public File getHomeDirectory() {
        return this.homeDir;
    }

    public void setJavaRegexEnabled(boolean isEnabled) {
        this.isJavaRegexEnabled = isEnabled;
    }

    public boolean isJavaRegexEnabled() {
        return this.isJavaRegexEnabled;
    }

    public void setPassive(boolean isPassive) {
        this.isPassive = isPassive;
    }

    public boolean isPassive() {
        return this.isPassive;
    }

    public void setFTPClientProperty(String name, Object value) {
        this.ftpClientProps.put(name, value);
    }

    public Object getFTPClientProperty(String name) {
        return this.ftpClientProps.get(name);
    }

    public void removeTPClientProperty(String name) {
        this.ftpClientProps.remove(name);
    }

    public void clearFTPClientProperties() {
        this.ftpClientProps.clear();
    }

    public Map getFTPClientProperties() {
        return this.ftpClientProps;
    }

    public FTPClient createFTPClient() throws FTPException {
        org.apache.commons.net.ftp.FTPClient ftpClient;
        block32: {
            ftpClient = new org.apache.commons.net.ftp.FTPClient();
            try {
                if (this.soTimeout >= 0) {
                    ftpClient.setSoTimeout(this.soTimeout);
                }
                if (this.soLinger >= 0) {
                    ftpClient.setSoLinger(true, this.soLinger);
                }
                if (this.isTcpNoDelay != null) {
                    ftpClient.setTcpNoDelay(this.isTcpNoDelay.booleanValue());
                }
                if (this.serverSocketFactory != null || this.socketFactory != null) {
                    ftpClient.setSocketFactory((org.apache.commons.net.SocketFactory)new SocketFactoryImpl(this.socketFactory, this.serverSocketFactory));
                }
                if (this.ftpClientProps.size() == 0) break block32;
                PropertyAccess access = PropertyAccess.getInstance(true);
                String[] names = this.ftpClientProps.keySet().toArray(new String[this.ftpClientProps.size()]);
                try {
                    for (int i = 0; i < names.length; ++i) {
                        access.set(ftpClient, names[i], this.ftpClientProps.get(names[i]));
                    }
                }
                catch (IllegalArgumentException e) {
                    throw new FTPException(e);
                }
                catch (NoSuchPropertyException e) {
                    throw new FTPException(e);
                }
                catch (InvocationTargetException e) {
                    throw new FTPException(e.getTargetException());
                }
            }
            catch (SocketException e) {
                throw new FTPException(e);
            }
        }
        FTPClientImpl client = new FTPClientImpl(ftpClient);
        if (this.ftpFileListParser != null) {
            client.setFTPFileListParser(this.ftpFileListParser);
        }
        if (this.homeDir != null) {
            client.setHomeDirectory(this.homeDir);
        } else if (System.getProperty("user.home") != null) {
            client.setHomeDirectory(new File(System.getProperty("user.home")));
        }
        client.setJavaRegexEnabled(this.isJavaRegexEnabled);
        if (this.hostName != null) {
            if (this.port >= 0) {
                if (this.bindAddress != null) {
                    if (this.localPort >= 0) {
                        client.connect(this.hostName, this.port, this.bindAddress, this.localPort);
                    } else {
                        client.connect(this.hostName, this.port, this.bindAddress, 0);
                    }
                } else if (this.localPort >= 0) {
                    client.connect(this.hostName, this.port, "localhost", this.localPort);
                } else {
                    client.connect(this.hostName, this.port);
                }
            } else if (this.bindAddress != null) {
                if (this.localPort >= 0) {
                    client.connect(this.hostName, 21, this.bindAddress, this.localPort);
                } else {
                    client.connect(this.hostName, 21, this.bindAddress, 0);
                }
            } else if (this.localPort >= 0) {
                client.connect(this.hostName, 21, "localhost", this.localPort);
            } else {
                client.connect(this.hostName);
            }
            if (this.userName != null) {
                client.login(this.userName, this.password);
            }
            if (this.isPassive) {
                client.passive();
            }
        }
        return client;
    }

    private class SocketFactoryImpl
    implements org.apache.commons.net.SocketFactory {
        private SocketFactory socketFactory;
        private ServerSocketFactory serverSocketFactory;

        public SocketFactoryImpl(SocketFactory socketFactory, ServerSocketFactory serverSocketFactory) {
            this.socketFactory = socketFactory == null ? SocketFactory.getDefault() : socketFactory;
            this.serverSocketFactory = serverSocketFactory == null ? ServerSocketFactory.getDefault() : serverSocketFactory;
        }

        public Socket createSocket(String host, int port) throws UnknownHostException, IOException {
            return this.socketFactory.createSocket(host, port);
        }

        public Socket createSocket(InetAddress address, int port) throws IOException {
            return this.socketFactory.createSocket(address, port);
        }

        public Socket createSocket(String host, int port, InetAddress localAddr, int localPort) throws UnknownHostException, IOException {
            return this.socketFactory.createSocket(host, port, localAddr, localPort);
        }

        public Socket createSocket(InetAddress addr, int port, InetAddress localAddr, int localPort) throws IOException {
            return this.socketFactory.createSocket(addr, port, localAddr, localPort);
        }

        public ServerSocket createServerSocket(int port) throws IOException {
            return this.serverSocketFactory.createServerSocket(port);
        }

        public ServerSocket createServerSocket(int port, int backlog) throws IOException {
            return this.serverSocketFactory.createServerSocket(port, backlog);
        }

        public ServerSocket createServerSocket(int port, int backlog, InetAddress bindAddr) throws IOException {
            return this.serverSocketFactory.createServerSocket(port, backlog, bindAddr);
        }
    }
}

