/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.ejb;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ejb.CreateException;
import javax.ejb.EJBObject;
import javax.naming.NamingException;
import jp.ossc.nimbus.beans.ServiceNameEditor;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.ejb.EJBFactory;
import jp.ossc.nimbus.service.ejb.GroupEJBFactoryServiceMBean;

public class GroupEJBFactoryService
extends ServiceBase
implements EJBFactory,
GroupEJBFactoryServiceMBean {
    private static final long serialVersionUID = -7631019481698232485L;
    private Properties nameAndEJBFactoryServiceNameMapping;
    private Map nameAndEJBFactoryMap;
    private ServiceName defaultEJBFactoryServiceName;
    private EJBFactory defaultEJBFactory;

    public void setNameAndEJBFactoryServiceNameMapping(Properties mapping) {
        this.nameAndEJBFactoryServiceNameMapping = mapping;
    }

    public Properties getNameAndEJBFactoryServiceNameMapping() {
        return this.nameAndEJBFactoryServiceNameMapping;
    }

    public void setDefaultEJBFactoryServiceName(ServiceName name) {
        this.defaultEJBFactoryServiceName = name;
    }

    public ServiceName getDefaultEJBFactoryServiceName() {
        return this.defaultEJBFactoryServiceName;
    }

    public void createService() throws Exception {
        this.nameAndEJBFactoryMap = new HashMap();
    }

    public void startService() throws Exception {
        if (this.nameAndEJBFactoryServiceNameMapping == null || this.nameAndEJBFactoryServiceNameMapping.size() == 0) {
            throw new IllegalArgumentException("nameAndEJBFactoryServiceNameMapping must be specified.");
        }
        ServiceNameEditor editor = new ServiceNameEditor();
        editor.setServiceManagerName(this.getServiceManagerName());
        Iterator<Object> names = this.nameAndEJBFactoryServiceNameMapping.keySet().iterator();
        while (names.hasNext()) {
            String name = (String)names.next();
            Pattern pattern = Pattern.compile(name);
            String serviceNameStr = this.nameAndEJBFactoryServiceNameMapping.getProperty(name);
            editor.setAsText(serviceNameStr);
            ServiceName serviceName = (ServiceName)editor.getValue();
            this.nameAndEJBFactoryMap.put(pattern, (EJBFactory)ServiceManagerFactory.getServiceObject(serviceName));
        }
        if (this.defaultEJBFactoryServiceName != null) {
            this.defaultEJBFactory = (EJBFactory)ServiceManagerFactory.getServiceObject(this.defaultEJBFactoryServiceName);
        }
    }

    public void stopService() throws Exception {
        this.nameAndEJBFactoryMap.clear();
        this.defaultEJBFactory = null;
    }

    public void destroyService() throws Exception {
        this.nameAndEJBFactoryMap = null;
    }

    public EJBObject get(String name) throws NamingException, CreateException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        EJBFactory factory = this.findEJBFactory(name);
        if (factory == null) {
            return null;
        }
        return factory.get(name);
    }

    public EJBObject get(String name, Object[] params) throws NamingException, CreateException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        EJBFactory factory = this.findEJBFactory(name);
        if (factory == null) {
            return null;
        }
        return factory.get(name, params);
    }

    public EJBObject get(String name, Class homeType) throws NamingException, CreateException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        EJBFactory factory = this.findEJBFactory(name);
        if (factory == null) {
            return null;
        }
        return factory.get(name, homeType);
    }

    public EJBObject get(String name, Class homeType, Class[] paramTypes, Object[] params) throws NamingException, CreateException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        EJBFactory factory = this.findEJBFactory(name);
        if (factory == null) {
            return null;
        }
        return factory.get(name, homeType, paramTypes, params);
    }

    public EJBObject get(String name, Class homeType, Class remoteType, Class[] paramTypes, Object[] params) throws NamingException, CreateException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        EJBFactory factory = this.findEJBFactory(name);
        if (factory == null) {
            return null;
        }
        return factory.get(name, homeType, remoteType, paramTypes, params);
    }

    public void invalidate(String name) {
        EJBFactory factory = this.findEJBFactory(name);
        if (factory == null) {
            return;
        }
        factory.invalidate(name);
    }

    public void invalidate() {
        if (this.nameAndEJBFactoryMap == null) {
            return;
        }
        Iterator factories = this.nameAndEJBFactoryMap.values().iterator();
        while (factories.hasNext()) {
            EJBFactory factory = (EJBFactory)factories.next();
            factory.invalidate();
        }
    }

    protected EJBFactory findEJBFactory(String name) {
        if (this.nameAndEJBFactoryMap == null) {
            return null;
        }
        Iterator names = this.nameAndEJBFactoryMap.keySet().iterator();
        while (names.hasNext()) {
            Pattern namePattern = (Pattern)names.next();
            Matcher matcher = namePattern.matcher(name);
            if (!matcher.matches()) continue;
            return (EJBFactory)this.nameAndEJBFactoryMap.get(namePattern);
        }
        return this.defaultEJBFactory;
    }
}

