/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.context;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.cache.CacheMap;
import jp.ossc.nimbus.service.context.ContextStore;
import jp.ossc.nimbus.service.context.DistributedSharedContext;
import jp.ossc.nimbus.service.context.DistributedSharedContextServiceMBean;
import jp.ossc.nimbus.service.context.MD5HashSharedContextKeyDistributorService;
import jp.ossc.nimbus.service.context.SharedContextIllegalIndexException;
import jp.ossc.nimbus.service.context.SharedContextKeyDistributor;
import jp.ossc.nimbus.service.context.SharedContextSendException;
import jp.ossc.nimbus.service.context.SharedContextService;
import jp.ossc.nimbus.service.context.SharedContextTimeoutException;
import jp.ossc.nimbus.service.context.SharedContextUpdateListener;
import jp.ossc.nimbus.service.context.SharedContextValueDifference;
import jp.ossc.nimbus.service.interpreter.EvaluateException;
import jp.ossc.nimbus.service.keepalive.ClusterListener;
import jp.ossc.nimbus.service.keepalive.ClusterService;
import jp.ossc.nimbus.service.publish.Message;
import jp.ossc.nimbus.service.publish.MessageException;
import jp.ossc.nimbus.service.publish.MessageReceiver;
import jp.ossc.nimbus.service.publish.MessageSendException;
import jp.ossc.nimbus.service.publish.RequestMessageListener;
import jp.ossc.nimbus.service.publish.RequestServerConnection;
import jp.ossc.nimbus.service.publish.ServerConnectionFactory;
import jp.ossc.nimbus.util.SynchronizeMonitor;
import jp.ossc.nimbus.util.WaitSynchronizeMonitor;

public class DistributedSharedContextService
extends ServiceBase
implements DistributedSharedContext,
RequestMessageListener,
ClusterListener,
DistributedSharedContextServiceMBean {
    private static final long serialVersionUID = -8599934979277211223L;
    private ServiceName requestConnectionFactoryServiceName;
    private ServiceName clientCacheMapServiceName;
    private ServiceName serverCacheMapServiceName;
    private ServiceName clusterServiceName;
    private ServiceName sharedContextKeyDistributorServiceName;
    private SharedContextKeyDistributor keyDistributor;
    private ServiceName contextStoreServiceName;
    private ContextStore contextStore;
    private ServiceName interpreterServiceName;
    private int executeThreadSize;
    private ServiceName executeQueueServiceName;
    private String subject = "DistributedSharedContext";
    private String clientSubject;
    private boolean isClient;
    private long synchronizeTimeout = 10000L;
    private long rehashTimeout = 10000L;
    private long defaultTimeout = 1000L;
    private boolean isLoadKeyOnStart;
    private boolean isClearBeforeSave = true;
    private int distributedSize = 2;
    private int replicationSize = 2;
    private RequestServerConnection serverConnection;
    private MessageReceiver messageReceiver;
    private ClusterService cluster;
    private Message targetMessage;
    private SharedContextService[] sharedContextArray;
    private DistributeInfo distributeInfo;
    private boolean isRehashEnabled = true;
    private boolean isManagedDataNode;
    private List updateListeners;
    private ServiceName[] sharedContextUpdateListenerServiceNames;
    private Map keyIndexMap;

    public void setSharedContextKeyDistributorServiceName(ServiceName name) {
        this.sharedContextKeyDistributorServiceName = name;
    }

    public ServiceName getSharedContextKeyDistributorServiceName() {
        return this.sharedContextKeyDistributorServiceName;
    }

    public void setDistributedSize(int size) throws IllegalArgumentException {
        if (size <= 1) {
            throw new IllegalArgumentException("DistributedSize must be 2 or more." + size);
        }
        this.distributedSize = size;
    }

    public int getDistributedSize() {
        return this.distributedSize;
    }

    public void setReplicationSize(int size) throws IllegalArgumentException {
        if (size <= 0) {
            throw new IllegalArgumentException("ReplicationSize must be 1 or more." + size);
        }
        this.replicationSize = size;
    }

    public int getReplicationSize() {
        return this.replicationSize;
    }

    public void setRequestConnectionFactoryServiceName(ServiceName name) {
        this.requestConnectionFactoryServiceName = name;
    }

    public ServiceName getRequestConnectionFactoryServiceName() {
        return this.requestConnectionFactoryServiceName;
    }

    public void setClusterServiceName(ServiceName name) {
        this.clusterServiceName = name;
    }

    public ServiceName getClusterServiceName() {
        return this.clusterServiceName;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setClient(boolean isClient) throws SharedContextSendException, SharedContextTimeoutException {
        if (this.isClient == isClient) {
            return;
        }
        this.isClient = isClient;
        if (this.getState() == 3) {
            try {
                this.messageReceiver.removeMessageListener(this);
                this.messageReceiver.addSubject(this, isClient ? this.clientSubject : this.subject);
            }
            catch (MessageSendException e) {
                throw new SharedContextSendException(e);
            }
            this.synchronize();
        }
    }

    public boolean isClient() {
        return this.isClient;
    }

    public void setRehashEnabled(boolean isEnabled) throws SharedContextSendException, SharedContextTimeoutException {
        if (this.getState() == 3) {
            try {
                Message message = this.serverConnection.createMessage(this.subject, Integer.toString(7));
                message.setSubject(this.clientSubject, null);
                Set receiveClients = this.serverConnection.getReceiveClientIds(message);
                if (receiveClients.size() != 0) {
                    message.setObject(new DistributedSharedContextEvent(7, isEnabled ? Boolean.TRUE : Boolean.FALSE));
                    Message[] responses = this.serverConnection.request(message, this.isClient ? this.clientSubject : this.subject, null, 0, this.defaultTimeout);
                    if (responses == null || responses.length == 0) {
                        throw new SharedContextTimeoutException();
                    }
                }
            }
            catch (MessageException e) {
                throw new SharedContextSendException(e);
            }
            catch (MessageSendException e) {
                throw new SharedContextSendException(e);
            }
        }
        this.isRehashEnabled = isEnabled;
    }

    public boolean isRehashEnabled() {
        return this.isRehashEnabled;
    }

    public void setClientCacheMapServiceName(ServiceName name) {
        this.clientCacheMapServiceName = name;
    }

    public ServiceName getClientCacheMapServiceName() {
        return this.clientCacheMapServiceName;
    }

    public void setServerCacheMapServiceName(ServiceName name) {
        this.serverCacheMapServiceName = name;
    }

    public ServiceName getServerCacheMapServiceName() {
        return this.serverCacheMapServiceName;
    }

    public void setContextStoreServiceName(ServiceName name) {
        this.contextStoreServiceName = name;
    }

    public ServiceName getContextStoreServiceName() {
        return this.contextStoreServiceName;
    }

    public void setInterpreterServiceName(ServiceName name) {
        this.interpreterServiceName = name;
    }

    public ServiceName getInterpreterServiceName() {
        return this.interpreterServiceName;
    }

    public void setExecuteThreadSize(int size) {
        this.executeThreadSize = size;
    }

    public int getExecuteThreadSize() {
        return this.executeThreadSize;
    }

    public void setExecuteQueueServiceName(ServiceName name) {
        this.executeQueueServiceName = name;
    }

    public ServiceName getExecuteQueueServiceName() {
        return this.executeQueueServiceName;
    }

    public void setLoadKeyOnStart(boolean isLoad) {
        this.isLoadKeyOnStart = isLoad;
    }

    public boolean isLoadKeyOnStart() {
        return this.isLoadKeyOnStart;
    }

    public void setClearBeforeSave(boolean isClear) {
        this.isClearBeforeSave = isClear;
    }

    public boolean isClearBeforeSave() {
        return this.isClearBeforeSave;
    }

    public void setSynchronizeTimeout(long timeout) {
        this.synchronizeTimeout = timeout;
    }

    public long getSynchronizeTimeout() {
        return this.synchronizeTimeout;
    }

    public void setRehashTimeout(long timeout) {
        this.rehashTimeout = timeout;
    }

    public long getRehashTimeout() {
        return this.rehashTimeout;
    }

    public void setDefaultTimeout(long timeout) {
        this.defaultTimeout = timeout;
    }

    public long getDefaultTimeout() {
        return this.defaultTimeout;
    }

    public void setManagedDataNode(boolean isManage) {
        this.isManagedDataNode = isManage;
    }

    public boolean isManagedDataNode() {
        return this.isManagedDataNode;
    }

    public void setSharedContextUpdateListenerServiceNames(ServiceName[] names) {
        this.sharedContextUpdateListenerServiceNames = names;
    }

    public ServiceName[] getSharedContextUpdateListenerServiceNames() {
        return this.sharedContextUpdateListenerServiceNames;
    }

    public void setKeyIndex(String name, String[] keyProps) {
        this.keyIndexMap.put(name, keyProps);
        if (this.getState() == 3) {
            for (int i = 0; i < this.sharedContextArray.length; ++i) {
                this.sharedContextArray[i].setKeyIndex(name, keyProps);
            }
        }
    }

    public void createService() throws Exception {
        this.keyIndexMap = Collections.synchronizedMap(new HashMap());
    }

    public void startService() throws Exception {
        if (this.sharedContextKeyDistributorServiceName == null) {
            MD5HashSharedContextKeyDistributorService defaultKeyDistributor = new MD5HashSharedContextKeyDistributorService();
            defaultKeyDistributor.create();
            defaultKeyDistributor.start();
            this.keyDistributor = defaultKeyDistributor;
        } else {
            this.keyDistributor = (SharedContextKeyDistributor)ServiceManagerFactory.getServiceObject(this.sharedContextKeyDistributorServiceName);
        }
        if (this.contextStoreServiceName != null) {
            this.contextStore = (ContextStore)ServiceManagerFactory.getServiceObject(this.contextStoreServiceName);
        }
        if (this.requestConnectionFactoryServiceName == null) {
            throw new IllegalArgumentException("RequestConnectionFactoryServiceName must be specified.");
        }
        if (this.sharedContextUpdateListenerServiceNames != null) {
            for (int i = 0; i < this.sharedContextUpdateListenerServiceNames.length; ++i) {
                this.addSharedContextUpdateListener((SharedContextUpdateListener)ServiceManagerFactory.getServiceObject(this.sharedContextUpdateListenerServiceNames[i]));
            }
        }
        ServerConnectionFactory factory = (ServerConnectionFactory)ServiceManagerFactory.getServiceObject(this.requestConnectionFactoryServiceName);
        this.serverConnection = (RequestServerConnection)factory.getServerConnection();
        this.messageReceiver = (MessageReceiver)ServiceManagerFactory.getServiceObject(this.requestConnectionFactoryServiceName);
        this.clientSubject = this.subject + ".Client";
        this.targetMessage = this.serverConnection.createMessage(this.subject, null);
        this.messageReceiver.addSubject(this, this.isClient ? this.clientSubject : this.subject);
        if (this.clusterServiceName == null) {
            throw new IllegalArgumentException("ClusterServiceName must be specified.");
        }
        this.cluster = (ClusterService)ServiceManagerFactory.getServiceObject(this.clusterServiceName);
        this.sharedContextArray = new SharedContextService[this.distributedSize];
        for (int i = 0; i < this.sharedContextArray.length; ++i) {
            this.sharedContextArray[i] = new SharedContextService();
            if (this.isManagedDataNode) {
                this.sharedContextArray[i].setServiceManagerName(this.getServiceManagerName());
                this.sharedContextArray[i].setServiceName(this.getServiceName() + '$' + i);
            }
            this.sharedContextArray[i].create();
            this.sharedContextArray[i].setRequestConnectionFactoryServiceName(this.requestConnectionFactoryServiceName);
            this.sharedContextArray[i].setClusterServiceName(this.clusterServiceName);
            if (this.clientCacheMapServiceName != null) {
                this.sharedContextArray[i].setClientCacheMap((CacheMap)ServiceManagerFactory.getServiceObject(this.clientCacheMapServiceName));
            }
            if (this.serverCacheMapServiceName != null) {
                this.sharedContextArray[i].setServerCacheMap((CacheMap)ServiceManagerFactory.getServiceObject(this.serverCacheMapServiceName));
            }
            if (this.contextStoreServiceName != null) {
                this.sharedContextArray[i].setContextStoreServiceName(this.contextStoreServiceName);
            }
            if (this.interpreterServiceName != null) {
                this.sharedContextArray[i].setInterpreterServiceName(this.interpreterServiceName);
            }
            if (this.executeQueueServiceName != null) {
                this.sharedContextArray[i].setExecuteQueueServiceName(this.executeQueueServiceName);
            }
            this.sharedContextArray[i].setExecuteThreadSize(this.executeThreadSize);
            this.sharedContextArray[i].setSubject(this.subject + "$" + i);
            this.sharedContextArray[i].setClient(true);
            this.sharedContextArray[i].setSynchronizeTimeout(this.synchronizeTimeout);
            this.sharedContextArray[i].setDefaultTimeout(this.defaultTimeout);
            this.sharedContextArray[i].setSynchronizeOnStart(false);
            this.sharedContextArray[i].setSaveOnlyMain(true);
            this.sharedContextArray[i].setClearBeforeSave(false);
            this.sharedContextArray[i].setLoadOnStart(false);
            this.sharedContextArray[i].setLoadKeyOnStart(false);
            this.sharedContextArray[i].setSaveOnStop(false);
            if (this.updateListeners != null) {
                for (int j = 0; j < this.updateListeners.size(); ++j) {
                    this.sharedContextArray[i].addSharedContextUpdateListener((SharedContextUpdateListener)this.updateListeners.get(j));
                }
            }
            Iterator entries = this.keyIndexMap.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                this.sharedContextArray[i].setKeyIndex((String)entry.getKey(), (String[])entry.getValue());
            }
            this.sharedContextArray[i].start();
        }
        this.distributeInfo = new DistributeInfo(this.getId(), this.distributedSize);
        this.cluster.addClusterListener(this);
        this.rehash();
        if (this.isMain() && this.isLoadKeyOnStart) {
            this.loadKey();
        }
    }

    public void stopService() throws Exception {
        for (int i = 0; i < this.sharedContextArray.length; ++i) {
            this.sharedContextArray[i].stop();
            this.sharedContextArray[i].destroy();
        }
        if (this.messageReceiver != null) {
            this.messageReceiver.removeMessageListener(this);
        }
        if (this.cluster != null) {
            this.cluster.removeClusterListener(this);
        }
    }

    public void destroyService() throws Exception {
        this.keyIndexMap = null;
    }

    public void synchronize() throws SharedContextSendException, SharedContextTimeoutException {
        this.synchronize(this.synchronizeTimeout <= 0L ? 0L : this.synchronizeTimeout * (long)this.sharedContextArray.length);
    }

    public synchronized void synchronize(long timeout) throws SharedContextSendException, SharedContextTimeoutException {
        if (this.sharedContextArray == null || this.sharedContextArray.length == 0) {
            return;
        }
        for (int i = 0; i < this.sharedContextArray.length; ++i) {
            long start = System.currentTimeMillis();
            boolean isNoTimeout = timeout <= 0L;
            long l = timeout = isNoTimeout ? timeout : timeout - (System.currentTimeMillis() - start);
            if (!isNoTimeout && timeout < 0L) {
                throw new SharedContextTimeoutException();
            }
            this.sharedContextArray[i].synchronize(timeout);
        }
    }

    public void rehash() throws SharedContextSendException, SharedContextTimeoutException {
        this.rehash(this.rehashTimeout);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void rehash(long timeout) throws SharedContextSendException, SharedContextTimeoutException {
        if (!this.isRehashEnabled) {
            return;
        }
        if (this.isMain()) {
            try {
                Map decreaseDistributeInfos;
                Message message = this.serverConnection.createMessage(this.subject, Integer.toString(1));
                Set receiveClients = this.serverConnection.getReceiveClientIds(message);
                if (receiveClients.size() == 0) {
                    DistributeGrid grid = new DistributeGrid();
                    grid.addDistributeInfo(this.distributeInfo);
                    grid.rehash();
                    this.distributeInfo.apply(this.distributeInfo, this.sharedContextArray);
                    return;
                }
                message.setObject(new DistributedSharedContextEvent(1, new Long(timeout)));
                long start = System.currentTimeMillis();
                Message[] responses = this.serverConnection.request(message, 0, timeout);
                if (responses == null || responses.length < receiveClients.size()) throw new SharedContextTimeoutException();
                boolean isNoTimeout = timeout <= 0L;
                long l = timeout = isNoTimeout ? timeout : timeout - (System.currentTimeMillis() - start);
                if (!isNoTimeout && timeout < 0L) {
                    throw new SharedContextTimeoutException();
                }
                DistributeGrid grid = new DistributeGrid();
                grid.addDistributeInfo(this.distributeInfo);
                for (int i = 0; i < responses.length; ++i) {
                    grid.addDistributeInfo((DistributeInfo)responses[i].getObject());
                }
                grid.rehash();
                RehashResponseCallBack callback = new RehashResponseCallBack();
                Map increaseDistributeInfos = grid.getIncreaseDistributeInfos();
                DistributeInfo info = (DistributeInfo)increaseDistributeInfos.remove(this.getId());
                if (info != null) {
                    info.apply(this.distributeInfo, this.sharedContextArray);
                }
                if (increaseDistributeInfos.size() != 0) {
                    callback.setResponseCount(increaseDistributeInfos.size());
                    Iterator infos = increaseDistributeInfos.values().iterator();
                    while (infos.hasNext()) {
                        info = (DistributeInfo)infos.next();
                        Message rehashMessage = this.serverConnection.createMessage(this.subject, Integer.toString(3));
                        rehashMessage.setObject(new DistributedSharedContextEvent(3, info));
                        rehashMessage.addDestinationId(info.getId());
                        this.serverConnection.request(rehashMessage, 1, timeout, callback);
                    }
                    callback.waitResponse(timeout);
                }
                if ((info = (DistributeInfo)(decreaseDistributeInfos = grid.getDecreaseDistributeInfos()).remove(this.getId())) != null) {
                    info.apply(this.distributeInfo, this.sharedContextArray);
                }
                if (decreaseDistributeInfos.size() == 0) return;
                callback.setResponseCount(decreaseDistributeInfos.size());
                Iterator infos = decreaseDistributeInfos.values().iterator();
                while (infos.hasNext()) {
                    info = (DistributeInfo)infos.next();
                    Message rehashMessage = this.serverConnection.createMessage(this.subject, Integer.toString(3));
                    rehashMessage.setObject(new DistributedSharedContextEvent(3, info));
                    rehashMessage.addDestinationId(info.getId());
                    this.serverConnection.request(rehashMessage, 1, timeout, callback);
                }
                callback.waitResponse(timeout);
                return;
            }
            catch (MessageException e) {
                throw new SharedContextSendException(e);
            }
            catch (MessageSendException e) {
                throw new SharedContextSendException(e);
            }
        }
        try {
            Message message = this.serverConnection.createMessage(this.subject, Integer.toString(2));
            Set receiveClients = this.serverConnection.getReceiveClientIds(message);
            if (receiveClients.size() == 0) return;
            message.setObject(new DistributedSharedContextEvent(2, new Long(timeout)));
            Message[] responses = this.serverConnection.request(message, this.isClient ? this.clientSubject : this.subject, null, 1, timeout);
            if (responses == null || responses.length <= 0) throw new SharedContextTimeoutException();
            Object ret = responses[0].getObject();
            if (!(ret instanceof Throwable)) return;
            throw new SharedContextSendException((Throwable)ret);
        }
        catch (MessageException e) {
            throw new SharedContextSendException(e);
        }
        catch (MessageSendException e) {
            throw new SharedContextSendException(e);
        }
    }

    public synchronized void load() throws Exception {
        this.load(-1L);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void load(long timeout) throws Exception {
        if (this.isMain()) {
            if (this.contextStore == null) throw new UnsupportedOperationException();
            this.contextStore.load(this);
            return;
        }
        try {
            Message message = this.serverConnection.createMessage(this.subject, null);
            Set receiveClients = this.serverConnection.getReceiveClientIds(message);
            if (receiveClients.size() == 0) return;
            message.setObject(new DistributedSharedContextEvent(5));
            Message[] responses = this.serverConnection.request(message, this.isClient ? this.clientSubject : this.subject, null, 1, timeout);
            if (responses == null || responses.length <= 0) throw new SharedContextTimeoutException();
            Object ret = responses[0].getObject();
            if (!(ret instanceof Throwable)) return;
            throw new SharedContextSendException((Throwable)ret);
        }
        catch (MessageException e) {
            throw new SharedContextSendException(e);
        }
        catch (MessageSendException e) {
            throw new SharedContextSendException(e);
        }
    }

    public synchronized void load(Object key) throws Exception {
        this.load(key, -1L);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void load(Object key, long timeout) throws Exception {
        if (this.isMain()) {
            if (this.contextStore == null) throw new UnsupportedOperationException();
            this.contextStore.load(this, key);
            return;
        }
        try {
            Message message = this.serverConnection.createMessage(this.subject, key == null ? null : key.toString());
            Set receiveClients = this.serverConnection.getReceiveClientIds(message);
            if (receiveClients.size() == 0) return;
            message.setObject(new DistributedSharedContextEvent(5, key));
            Message[] responses = this.serverConnection.request(message, this.isClient ? this.clientSubject : this.subject, null, 1, timeout);
            if (responses == null || responses.length <= 0) throw new SharedContextTimeoutException();
            Object ret = responses[0].getObject();
            if (!(ret instanceof Throwable)) return;
            throw new SharedContextSendException((Throwable)ret);
        }
        catch (MessageException e) {
            throw new SharedContextSendException(e);
        }
        catch (MessageSendException e) {
            throw new SharedContextSendException(e);
        }
    }

    public synchronized void loadKey() throws Exception {
        this.loadKey(-1L);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void loadKey(long timeout) throws Exception {
        if (this.isMain()) {
            if (this.contextStore == null) throw new UnsupportedOperationException();
            this.contextStore.loadKey(this);
            return;
        }
        try {
            Message message = this.serverConnection.createMessage(this.subject, null);
            Set receiveClients = this.serverConnection.getReceiveClientIds(message);
            if (receiveClients.size() == 0) return;
            message.setObject(new DistributedSharedContextEvent(6));
            Message[] responses = this.serverConnection.request(message, this.isClient ? this.clientSubject : this.subject, null, 1, timeout);
            if (responses == null || responses.length <= 0) throw new SharedContextTimeoutException();
            Object ret = responses[0].getObject();
            if (!(ret instanceof Throwable)) return;
            throw new SharedContextSendException((Throwable)ret);
        }
        catch (MessageException e) {
            throw new SharedContextSendException(e);
        }
        catch (MessageSendException e) {
            throw new SharedContextSendException(e);
        }
    }

    public synchronized void save() throws Exception {
        this.save(-1L);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void save(long timeout) throws Exception {
        if (this.isMain()) {
            if (this.contextStore == null) throw new UnsupportedOperationException();
            if (this.isClearBeforeSave) {
                this.contextStore.clear();
            }
            for (int i = 0; i < this.sharedContextArray.length; ++i) {
                this.sharedContextArray[i].save(timeout);
            }
            return;
        } else {
            try {
                Message message = this.serverConnection.createMessage(this.subject, null);
                Set receiveClients = this.serverConnection.getReceiveClientIds(message);
                if (receiveClients.size() == 0) return;
                message.setObject(new DistributedSharedContextEvent(4, new Long(timeout)));
                Message[] responses = this.serverConnection.request(message, this.isClient ? this.clientSubject : this.subject, null, 1, timeout);
                if (responses == null || responses.length <= 0) throw new SharedContextTimeoutException();
                Object ret = responses[0].getObject();
                if (!(ret instanceof Throwable)) return;
                throw new SharedContextSendException((Throwable)ret);
            }
            catch (MessageException e) {
                throw new SharedContextSendException(e);
            }
            catch (MessageSendException e) {
                throw new SharedContextSendException(e);
            }
        }
    }

    public void save(Object key) throws Exception {
        this.save(key, -1L);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void save(Object key, long timeout) throws Exception {
        if (this.isMain()) {
            if (this.contextStore == null) throw new UnsupportedOperationException();
            this.sharedContextArray[this.getDataNodeIndex(key)].save(key, timeout);
            return;
        }
        try {
            Message message = this.serverConnection.createMessage(this.subject, key == null ? null : key.toString());
            Set receiveClients = this.serverConnection.getReceiveClientIds(message);
            if (receiveClients.size() == 0) return;
            message.setObject(new DistributedSharedContextEvent(4, new Object[]{key, new Long(timeout)}));
            Message[] responses = this.serverConnection.request(message, this.isClient ? this.clientSubject : this.subject, null, 1, timeout);
            if (responses == null || responses.length <= 0) throw new SharedContextTimeoutException();
            Object ret = responses[0].getObject();
            if (!(ret instanceof Throwable)) return;
            throw new SharedContextSendException((Throwable)ret);
        }
        catch (MessageException e) {
            throw new SharedContextSendException(e);
        }
        catch (MessageSendException e) {
            throw new SharedContextSendException(e);
        }
    }

    public void lock(Object key) throws SharedContextSendException, SharedContextTimeoutException {
        this.lock(key, this.defaultTimeout);
    }

    public void lock(Object key, long timeout) throws SharedContextSendException, SharedContextTimeoutException {
        this.sharedContextArray[this.keyDistributor.selectDataNodeIndex(key, this.sharedContextArray.length)].lock(key, timeout);
    }

    public boolean unlock(Object key) throws SharedContextSendException {
        return this.unlock(key, false);
    }

    public boolean unlock(Object key, boolean force) throws SharedContextSendException {
        return this.sharedContextArray[this.keyDistributor.selectDataNodeIndex(key, this.sharedContextArray.length)].unlock(key, force);
    }

    public Object getLockOwner(Object key) {
        return this.sharedContextArray[this.keyDistributor.selectDataNodeIndex(key, this.sharedContextArray.length)].getLockOwner(key);
    }

    public Object put(Object key, Object value) throws SharedContextSendException {
        return this.put(key, value, this.defaultTimeout);
    }

    public Object put(Object key, Object value, long timeout) throws SharedContextSendException, SharedContextTimeoutException {
        return this.sharedContextArray[this.keyDistributor.selectDataNodeIndex(key, this.sharedContextArray.length)].put(key, value, timeout);
    }

    public Object putLocal(Object key, Object value) {
        return this.sharedContextArray[this.keyDistributor.selectDataNodeIndex(key, this.sharedContextArray.length)].putLocal(key, value);
    }

    public void putAsynch(Object key, Object value) throws SharedContextSendException {
        this.sharedContextArray[this.keyDistributor.selectDataNodeIndex(key, this.sharedContextArray.length)].putAsynch(key, value);
    }

    public void update(Object key, SharedContextValueDifference diff) throws SharedContextSendException {
        this.update(key, diff, this.defaultTimeout);
    }

    public void update(Object key, SharedContextValueDifference diff, long timeout) throws SharedContextSendException, SharedContextTimeoutException {
        this.sharedContextArray[this.keyDistributor.selectDataNodeIndex(key, this.sharedContextArray.length)].update(key, diff, timeout);
    }

    public void updateLocal(Object key, SharedContextValueDifference diff) {
        this.sharedContextArray[this.keyDistributor.selectDataNodeIndex(key, this.sharedContextArray.length)].updateLocal(key, diff);
    }

    public void updateAsynch(Object key, SharedContextValueDifference diff) throws SharedContextSendException {
        this.sharedContextArray[this.keyDistributor.selectDataNodeIndex(key, this.sharedContextArray.length)].updateAsynch(key, diff);
    }

    public Object remove(Object key) throws SharedContextSendException {
        return this.remove(key, this.defaultTimeout);
    }

    public Object remove(Object key, long timeout) throws SharedContextSendException, SharedContextTimeoutException {
        return this.sharedContextArray[this.keyDistributor.selectDataNodeIndex(key, this.sharedContextArray.length)].remove(key, timeout);
    }

    public Object removeLocal(Object key) {
        return this.sharedContextArray[this.keyDistributor.selectDataNodeIndex(key, this.sharedContextArray.length)].removeLocal(key);
    }

    public void removeAsynch(Object key) throws SharedContextSendException {
        this.sharedContextArray[this.keyDistributor.selectDataNodeIndex(key, this.sharedContextArray.length)].removeAsynch(key);
    }

    public void putAll(Map t) {
        this.putAll(t, this.defaultTimeout);
    }

    public synchronized void putAll(Map t, long timeout) throws SharedContextSendException, SharedContextTimeoutException {
        Iterator entries = t.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            long start = System.currentTimeMillis();
            boolean isNoTimeout = timeout <= 0L;
            long l = timeout = isNoTimeout ? timeout : timeout - (System.currentTimeMillis() - start);
            if (!isNoTimeout && timeout < 0L) {
                throw new SharedContextTimeoutException();
            }
            this.sharedContextArray[this.keyDistributor.selectDataNodeIndex(entry.getKey(), this.sharedContextArray.length)].put(entry.getKey(), entry.getValue(), timeout);
        }
    }

    public synchronized void putAllLocal(Map t) {
        Iterator entries = t.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            this.sharedContextArray[this.keyDistributor.selectDataNodeIndex(entry.getKey(), this.sharedContextArray.length)].putLocal(entry.getKey(), entry.getValue());
        }
    }

    public synchronized void putAllAsynch(Map t) throws SharedContextSendException {
        Iterator entries = t.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            this.sharedContextArray[this.keyDistributor.selectDataNodeIndex(entry.getKey(), this.sharedContextArray.length)].putAsynch(entry.getKey(), entry.getValue());
        }
    }

    public void clear() throws SharedContextSendException {
        this.clear(this.defaultTimeout <= 0L ? 0L : this.defaultTimeout * (long)this.sharedContextArray.length);
    }

    public synchronized void clear(long timeout) throws SharedContextSendException, SharedContextTimeoutException {
        for (int i = 0; i < this.sharedContextArray.length; ++i) {
            long start = System.currentTimeMillis();
            boolean isNoTimeout = timeout <= 0L;
            long l = timeout = isNoTimeout ? timeout : timeout - (System.currentTimeMillis() - start);
            if (!isNoTimeout && timeout < 0L) {
                throw new SharedContextTimeoutException();
            }
            this.sharedContextArray[i].clear(timeout);
        }
    }

    public synchronized void clearLocal() {
        for (int i = 0; i < this.sharedContextArray.length; ++i) {
            this.sharedContextArray[i].clearLocal();
        }
    }

    public synchronized void clearAsynch() throws SharedContextSendException {
        for (int i = 0; i < this.sharedContextArray.length; ++i) {
            this.sharedContextArray[i].clearAsynch();
        }
    }

    public void analyzeKeyIndex(String name) throws SharedContextIllegalIndexException, SharedContextSendException, SharedContextTimeoutException {
        for (int i = 0; i < this.sharedContextArray.length; ++i) {
            this.sharedContextArray[i].analyzeKeyIndex(name);
        }
    }

    public Set searchByKeyIndex(String name, Object key) throws SharedContextIllegalIndexException, SharedContextSendException, SharedContextTimeoutException {
        return this.searchByKeyIndex(name, key, this.defaultTimeout);
    }

    public Set searchByKeyIndex(String name, Object key, long timeout) throws SharedContextIllegalIndexException, SharedContextSendException, SharedContextTimeoutException {
        HashSet result = new HashSet();
        for (int i = 0; i < this.sharedContextArray.length; ++i) {
            long start = System.currentTimeMillis();
            boolean isNoTimeout = timeout <= 0L;
            long l = timeout = isNoTimeout ? timeout : timeout - (System.currentTimeMillis() - start);
            if (!isNoTimeout && timeout < 0L) {
                throw new SharedContextTimeoutException();
            }
            result.addAll(this.sharedContextArray[i].searchByKeyIndex(name, key, timeout));
        }
        return result;
    }

    public Set searchByKeyIndexLocal(String name, Object key) throws SharedContextIllegalIndexException {
        HashSet result = new HashSet();
        for (int i = 0; i < this.sharedContextArray.length; ++i) {
            result.addAll(this.sharedContextArray[i].searchByKeyIndexLocal(name, key));
        }
        return result;
    }

    public Object executeInterpretQuery(String query, Map variables) throws EvaluateException, SharedContextSendException, SharedContextTimeoutException {
        HashSet<Object> result = new HashSet<Object>();
        for (int i = 0; i < this.sharedContextArray.length; ++i) {
            result.add(this.sharedContextArray[i].executeInterpretQuery(query, variables));
        }
        return result;
    }

    public Object executeInterpretQuery(String query, Map variables, long timeout) throws EvaluateException, SharedContextSendException, SharedContextTimeoutException {
        HashSet<Object> result = new HashSet<Object>();
        for (int i = 0; i < this.sharedContextArray.length; ++i) {
            long start = System.currentTimeMillis();
            boolean isNoTimeout = timeout <= 0L;
            long l = timeout = isNoTimeout ? timeout : timeout - (System.currentTimeMillis() - start);
            if (!isNoTimeout && timeout < 0L) {
                throw new SharedContextTimeoutException();
            }
            result.add(this.sharedContextArray[i].executeInterpretQuery(query, variables, timeout));
        }
        return result;
    }

    public Object get(Object key) throws SharedContextSendException {
        return this.get(key, this.defaultTimeout);
    }

    public Object get(Object key, long timeout) throws SharedContextSendException, SharedContextTimeoutException {
        return this.sharedContextArray[this.keyDistributor.selectDataNodeIndex(key, this.sharedContextArray.length)].get(key, timeout);
    }

    public Object getLocal(Object key) {
        return this.sharedContextArray[this.keyDistributor.selectDataNodeIndex(key, this.sharedContextArray.length)].getLocal(key);
    }

    public Set keySet() throws SharedContextSendException {
        return this.keySet(this.defaultTimeout <= 0L ? 0L : this.defaultTimeout * (long)this.sharedContextArray.length);
    }

    public synchronized Set keySet(long timeout) throws SharedContextSendException, SharedContextTimeoutException {
        HashSet result = new HashSet();
        for (int i = 0; i < this.sharedContextArray.length; ++i) {
            long start = System.currentTimeMillis();
            boolean isNoTimeout = timeout <= 0L;
            long l = timeout = isNoTimeout ? timeout : timeout - (System.currentTimeMillis() - start);
            if (!isNoTimeout && timeout < 0L) {
                throw new SharedContextTimeoutException();
            }
            result.addAll(this.sharedContextArray[i].keySet(timeout));
        }
        return result;
    }

    public synchronized Set keySetLocal() {
        HashSet result = new HashSet();
        for (int i = 0; i < this.sharedContextArray.length; ++i) {
            result.addAll(this.sharedContextArray[i].keySetLocal());
        }
        return result;
    }

    public int size() throws SharedContextSendException {
        return this.size(this.defaultTimeout <= 0L ? 0L : this.defaultTimeout * (long)this.sharedContextArray.length);
    }

    public synchronized int size(long timeout) throws SharedContextSendException, SharedContextTimeoutException {
        int result = 0;
        for (int i = 0; i < this.sharedContextArray.length; ++i) {
            long start = System.currentTimeMillis();
            boolean isNoTimeout = timeout <= 0L;
            long l = timeout = isNoTimeout ? timeout : timeout - (System.currentTimeMillis() - start);
            if (!isNoTimeout && timeout < 0L) {
                throw new SharedContextTimeoutException();
            }
            result += this.sharedContextArray[i].size(timeout);
        }
        return result;
    }

    public synchronized int sizeLocal() {
        int result = 0;
        for (int i = 0; i < this.sharedContextArray.length; ++i) {
            result += this.sharedContextArray[i].sizeLocal();
        }
        return result;
    }

    public boolean isEmpty() throws SharedContextSendException {
        return this.size() == 0;
    }

    public boolean isEmptyLocal() {
        return this.sizeLocal() == 0;
    }

    public boolean containsKey(Object key) throws SharedContextSendException {
        return this.containsKey(key, this.defaultTimeout);
    }

    public boolean containsKey(Object key, long timeout) throws SharedContextSendException, SharedContextTimeoutException {
        return this.sharedContextArray[this.keyDistributor.selectDataNodeIndex(key, this.sharedContextArray.length)].containsKey(key, timeout);
    }

    public boolean containsKeyLocal(Object key) {
        return this.sharedContextArray[this.keyDistributor.selectDataNodeIndex(key, this.sharedContextArray.length)].containsKeyLocal(key);
    }

    public boolean containsValue(Object value) throws SharedContextSendException {
        return this.containsValue(value, this.defaultTimeout <= 0L ? 0L : this.defaultTimeout * (long)this.sharedContextArray.length);
    }

    public boolean containsValue(Object value, long timeout) throws SharedContextSendException, SharedContextTimeoutException {
        for (int i = 0; i < this.sharedContextArray.length; ++i) {
            long start = System.currentTimeMillis();
            boolean isNoTimeout = timeout <= 0L;
            long l = timeout = isNoTimeout ? timeout : timeout - (System.currentTimeMillis() - start);
            if (!isNoTimeout && timeout < 0L) {
                throw new SharedContextTimeoutException();
            }
            if (!this.sharedContextArray[i].containsValue(value, timeout)) continue;
            return true;
        }
        return false;
    }

    public boolean containsValueLocal(Object value) {
        for (int i = 0; i < this.sharedContextArray.length; ++i) {
            if (!this.sharedContextArray[i].containsValueLocal(value)) continue;
            return true;
        }
        return false;
    }

    public Collection values() {
        throw new UnsupportedOperationException();
    }

    public Collection valuesLocal() {
        ArrayList result = new ArrayList();
        for (int i = 0; i < this.sharedContextArray.length; ++i) {
            result.addAll(this.sharedContextArray[i].valuesLocal());
        }
        return result;
    }

    public Map all() {
        throw new UnsupportedOperationException();
    }

    public Map allLocal() {
        HashMap result = new HashMap();
        for (int i = 0; i < this.sharedContextArray.length; ++i) {
            result.putAll(this.sharedContextArray[i].allLocal());
        }
        return result;
    }

    public Set entrySet() {
        throw new UnsupportedOperationException();
    }

    public Set entrySetLocal() {
        LinkedHashSet result = new LinkedHashSet();
        for (int i = 0; i < this.sharedContextArray.length; ++i) {
            result.addAll(this.sharedContextArray[i].entrySetLocal());
        }
        return result;
    }

    public int getDataNodeIndex(Object key) {
        return this.keyDistributor.selectDataNodeIndex(key, this.sharedContextArray.length);
    }

    public int size(int nodeIndex) throws SharedContextSendException, SharedContextTimeoutException {
        return this.sharedContextArray[nodeIndex].size();
    }

    public Set keySet(int nodeIndex) throws SharedContextSendException, SharedContextTimeoutException {
        return this.sharedContextArray[nodeIndex].keySet();
    }

    public boolean isClient(int nodeIndex) {
        return this.sharedContextArray[nodeIndex].isClient();
    }

    public boolean isMain(int nodeIndex) {
        return this.sharedContextArray[nodeIndex].isMain();
    }

    public void addSharedContextUpdateListener(SharedContextUpdateListener listener) {
        if (this.updateListeners == null) {
            this.updateListeners = Collections.synchronizedList(new ArrayList());
        }
        if (!this.updateListeners.contains(listener)) {
            this.updateListeners.add(listener);
        }
        if (this.sharedContextArray != null) {
            for (int i = 0; i < this.sharedContextArray.length; ++i) {
                this.sharedContextArray[i].addSharedContextUpdateListener(listener);
            }
        }
    }

    public void removeSharedContextUpdateListener(SharedContextUpdateListener listener) {
        if (this.updateListeners == null) {
            return;
        }
        this.updateListeners.remove(listener);
        if (this.sharedContextArray != null) {
            for (int i = 0; i < this.sharedContextArray.length; ++i) {
                this.sharedContextArray[i].removeSharedContextUpdateListener(listener);
            }
        }
    }

    public String displayDistributeInfo() throws SharedContextSendException, SharedContextTimeoutException {
        DistributeGrid grid = new DistributeGrid();
        try {
            Message message = this.serverConnection.createMessage(this.subject, Integer.toString(1));
            Set receiveClients = this.serverConnection.getReceiveClientIds(message);
            if (!this.isClient) {
                grid.addDistributeInfo(this.distributeInfo);
            }
            if (receiveClients.size() != 0) {
                long timeout = this.rehashTimeout;
                message.setObject(new DistributedSharedContextEvent(1, new Long(timeout)));
                long start = System.currentTimeMillis();
                Message[] responses = this.serverConnection.request(message, this.isClient ? this.clientSubject : this.subject, null, 0, timeout);
                if (responses != null && responses.length >= receiveClients.size()) {
                    boolean isNoTimeout = timeout <= 0L;
                    long l = timeout = isNoTimeout ? timeout : timeout - (System.currentTimeMillis() - start);
                    if (!isNoTimeout && timeout < 0L) {
                        throw new SharedContextTimeoutException();
                    }
                    for (int i = 0; i < responses.length; ++i) {
                        grid.addDistributeInfo((DistributeInfo)responses[i].getObject());
                    }
                }
            }
        }
        catch (MessageException e) {
            throw new SharedContextSendException(e);
        }
        catch (MessageSendException e) {
            throw new SharedContextSendException(e);
        }
        return grid.toString();
    }

    public void onMessage(Message message) {
    }

    public Message onRequestMessage(Object sourceId, int sequence, Message message, String responseSubject, String responseKey) {
        DistributedSharedContextEvent event = null;
        try {
            event = (DistributedSharedContextEvent)message.getObject();
        }
        catch (MessageException e) {
            return null;
        }
        Message result = null;
        switch (event.type) {
            case 1: {
                result = this.onGetDistributeInfo(event, responseSubject, responseKey);
                break;
            }
            case 3: {
                result = this.onRehash(event, sourceId, sequence, responseSubject, responseKey);
                break;
            }
            case 2: {
                this.onRehashRequest(event, sourceId, sequence, responseSubject, responseKey);
                break;
            }
            case 4: {
                result = this.onSave(event, sourceId, sequence, responseSubject, responseKey);
                break;
            }
            case 5: {
                result = this.onLoad(event, sourceId, sequence, responseSubject, responseKey);
                break;
            }
            case 6: {
                result = this.onLoadKey(event, sourceId, sequence, responseSubject, responseKey);
                break;
            }
            case 7: {
                result = this.onRehashSwitch(event, responseSubject, responseKey);
                break;
            }
        }
        return result;
    }

    protected Message createResponseMessage(String responseSubject, String responseKey, Object response) {
        Message result = null;
        try {
            result = this.serverConnection.createMessage(responseSubject, responseKey);
            result.setObject(response);
        }
        catch (MessageException e) {
            this.getLogger().write("DSCS_00001", new Object[]{this.isClient ? this.clientSubject : this.subject, responseSubject, responseKey, response}, (Throwable)e);
        }
        return result;
    }

    protected Message onGetDistributeInfo(DistributedSharedContextEvent event, String responseSubject, String responseKey) {
        return this.createResponseMessage(responseSubject, responseKey, this.distributeInfo);
    }

    protected Message onRehashRequest(final DistributedSharedContextEvent event, final Object sourceId, final int sequence, final String responseSubject, final String responseKey) {
        if (this.isMain()) {
            Thread rehashThread = new Thread(){

                public void run() {
                    Message response = null;
                    try {
                        DistributedSharedContextService.this.rehash((Long)event.value);
                        response = DistributedSharedContextService.this.createResponseMessage(responseSubject, responseKey, null);
                    }
                    catch (Throwable th) {
                        response = DistributedSharedContextService.this.createResponseMessage(responseSubject, responseKey, th);
                    }
                    try {
                        DistributedSharedContextService.this.serverConnection.response(sourceId, sequence, response);
                    }
                    catch (MessageSendException e) {
                        DistributedSharedContextService.this.getLogger().write("DSCS_00002", new Object[]{DistributedSharedContextService.this.isClient ? DistributedSharedContextService.this.clientSubject : DistributedSharedContextService.this.subject, response}, (Throwable)e);
                    }
                }
            };
            rehashThread.start();
        }
        return null;
    }

    protected Message onRehash(DistributedSharedContextEvent event, final Object sourceId, final int sequence, final String responseSubject, final String responseKey) {
        final DistributeInfo info = (DistributeInfo)event.value;
        Thread rehashThread = new Thread(){

            public void run() {
                Message response = null;
                try {
                    info.apply(DistributedSharedContextService.this.distributeInfo, DistributedSharedContextService.this.sharedContextArray);
                    response = DistributedSharedContextService.this.createResponseMessage(responseSubject, responseKey, null);
                }
                catch (Throwable th) {
                    response = DistributedSharedContextService.this.createResponseMessage(responseSubject, responseKey, th);
                }
                try {
                    DistributedSharedContextService.this.serverConnection.response(sourceId, sequence, response);
                }
                catch (MessageSendException e) {
                    DistributedSharedContextService.this.getLogger().write("DSCS_00002", new Object[]{DistributedSharedContextService.this.isClient ? DistributedSharedContextService.this.clientSubject : DistributedSharedContextService.this.subject, response}, (Throwable)e);
                }
            }
        };
        rehashThread.start();
        return null;
    }

    protected Message onSave(final DistributedSharedContextEvent event, final Object sourceId, final int sequence, final String responseSubject, final String responseKey) {
        if (this.isMain()) {
            Thread saveThread = new Thread(){

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public void run() {
                    Message response = null;
                    try {
                        Object param = event.value;
                        if (param instanceof Long) {
                            long timeout = (Long)param;
                            if (DistributedSharedContextService.this.contextStore == null) throw new UnsupportedOperationException();
                            if (DistributedSharedContextService.this.isClearBeforeSave) {
                                DistributedSharedContextService.this.contextStore.clear();
                            }
                            for (int i = 0; i < DistributedSharedContextService.this.sharedContextArray.length; ++i) {
                                long start = System.currentTimeMillis();
                                boolean isNoTimeout = timeout <= 0L;
                                long l = timeout = isNoTimeout ? timeout : timeout - (System.currentTimeMillis() - start);
                                if (!isNoTimeout && timeout < 0L) {
                                    throw new SharedContextTimeoutException();
                                }
                                DistributedSharedContextService.this.sharedContextArray[i].save(timeout);
                            }
                        } else {
                            Object key = ((Object[])param)[0];
                            long timeout = (Long)((Object[])param)[1];
                            if (DistributedSharedContextService.this.contextStore == null) throw new UnsupportedOperationException();
                            DistributedSharedContextService.this.sharedContextArray[DistributedSharedContextService.this.getDataNodeIndex(key)].save(key, timeout);
                        }
                        response = DistributedSharedContextService.this.createResponseMessage(responseSubject, responseKey, null);
                    }
                    catch (Throwable th) {
                        response = DistributedSharedContextService.this.createResponseMessage(responseSubject, responseKey, th);
                    }
                    try {
                        DistributedSharedContextService.this.serverConnection.response(sourceId, sequence, response);
                        return;
                    }
                    catch (MessageSendException e) {
                        DistributedSharedContextService.this.getLogger().write("DSCS_00002", new Object[]{DistributedSharedContextService.this.isClient ? DistributedSharedContextService.this.clientSubject : DistributedSharedContextService.this.subject, response}, (Throwable)e);
                    }
                }
            };
            saveThread.start();
        }
        return null;
    }

    protected synchronized Message onLoad(final DistributedSharedContextEvent event, final Object sourceId, final int sequence, final String responseSubject, final String responseKey) {
        if (this.isMain()) {
            Thread loadThread = new Thread(){

                public void run() {
                    Message response = null;
                    try {
                        if (DistributedSharedContextService.this.contextStore != null) {
                            if (event.value == null) {
                                DistributedSharedContextService.this.contextStore.load(DistributedSharedContextService.this);
                            } else {
                                DistributedSharedContextService.this.contextStore.load(DistributedSharedContextService.this, event.value);
                            }
                        } else {
                            throw new UnsupportedOperationException();
                        }
                        response = DistributedSharedContextService.this.createResponseMessage(responseSubject, responseKey, null);
                    }
                    catch (Throwable th) {
                        response = DistributedSharedContextService.this.createResponseMessage(responseSubject, responseKey, th);
                    }
                    try {
                        DistributedSharedContextService.this.serverConnection.response(sourceId, sequence, response);
                    }
                    catch (MessageSendException e) {
                        DistributedSharedContextService.this.getLogger().write("DSCS_00002", new Object[]{DistributedSharedContextService.this.isClient ? DistributedSharedContextService.this.clientSubject : DistributedSharedContextService.this.subject, response}, (Throwable)e);
                    }
                }
            };
            loadThread.start();
        }
        return null;
    }

    protected synchronized Message onLoadKey(DistributedSharedContextEvent event, final Object sourceId, final int sequence, final String responseSubject, final String responseKey) {
        if (this.isMain()) {
            Thread loadThread = new Thread(){

                public void run() {
                    Message response = null;
                    try {
                        if (DistributedSharedContextService.this.contextStore == null) {
                            throw new UnsupportedOperationException();
                        }
                        DistributedSharedContextService.this.contextStore.loadKey(DistributedSharedContextService.this);
                        response = DistributedSharedContextService.this.createResponseMessage(responseSubject, responseKey, null);
                    }
                    catch (Throwable th) {
                        response = DistributedSharedContextService.this.createResponseMessage(responseSubject, responseKey, th);
                    }
                    try {
                        DistributedSharedContextService.this.serverConnection.response(sourceId, sequence, response);
                    }
                    catch (MessageSendException e) {
                        DistributedSharedContextService.this.getLogger().write("DSCS_00002", new Object[]{DistributedSharedContextService.this.isClient ? DistributedSharedContextService.this.clientSubject : DistributedSharedContextService.this.subject, response}, (Throwable)e);
                    }
                }
            };
            loadThread.start();
        }
        return null;
    }

    protected synchronized Message onRehashSwitch(DistributedSharedContextEvent event, String responseSubject, String responseKey) {
        this.isRehashEnabled = (Boolean)event.value;
        return this.createResponseMessage(responseSubject, responseKey, null);
    }

    public boolean isMain() {
        return this.isMain(this.cluster.getMembers());
    }

    private boolean isMain(List members) {
        if (this.isClient) {
            return false;
        }
        Set targetMembers = this.serverConnection.getReceiveClientIds(this.targetMessage);
        Object myId = this.cluster.getUID();
        int imax = members.size();
        for (int i = 0; i < imax; ++i) {
            Object id = members.get(i);
            if (id.equals(myId)) {
                return true;
            }
            if (!targetMembers.contains(id)) continue;
            return false;
        }
        return true;
    }

    public Object getId() {
        return this.cluster == null ? null : this.cluster.getUID();
    }

    public Object getMainId() {
        if (this.cluster == null) {
            return null;
        }
        Object myId = this.cluster.getUID();
        List members = this.cluster.getMembers();
        Set targetMembers = this.serverConnection.getReceiveClientIds(this.targetMessage);
        int imax = members.size();
        for (int i = 0; i < imax; ++i) {
            Object id = members.get(i);
            if (id.equals(myId)) {
                return myId;
            }
            if (!targetMembers.contains(id)) continue;
            return id;
        }
        return myId;
    }

    public void memberInit(Object myId, List members) {
    }

    public void memberChange(List oldMembers, List newMembers) {
        if (this.isMain(newMembers)) {
            HashSet deadMembers = new HashSet(oldMembers);
            deadMembers.removeAll(newMembers);
            if (deadMembers.size() != 0) {
                try {
                    this.rehash();
                }
                catch (Throwable th) {
                    this.getLogger().write("DSCS_00003", new Object[]{this.isClient ? this.clientSubject : this.subject}, th);
                }
            }
        }
    }

    public void changeMain() throws Exception {
    }

    public void changeSub() {
    }

    private class RehashResponseCallBack
    implements RequestServerConnection.ResponseCallBack {
        private SynchronizeMonitor monitor = new WaitSynchronizeMonitor();
        private boolean isTimeout;
        private Throwable throwable;
        private int responseCount;
        private int currentResponseCount;

        public RehashResponseCallBack() {
            this.monitor.initMonitor();
        }

        public void setResponseCount(int count) {
            this.responseCount = count;
            this.currentResponseCount = 0;
            this.isTimeout = false;
            this.throwable = null;
        }

        public void onResponse(Message message, boolean isLast) {
            ++this.currentResponseCount;
            if (message == null) {
                this.isTimeout = true;
                this.monitor.notifyMonitor();
            } else {
                Object response = null;
                try {
                    response = message.getObject();
                }
                catch (MessageException e) {
                    this.throwable = e;
                    this.monitor.notifyMonitor();
                }
                if (response instanceof Throwable) {
                    this.throwable = (Throwable)response;
                    this.monitor.notifyMonitor();
                } else if (this.currentResponseCount >= this.responseCount) {
                    this.monitor.notifyMonitor();
                }
            }
        }

        public void waitResponse(long timeout) throws SharedContextSendException, SharedContextTimeoutException {
            try {
                if (!this.monitor.waitMonitor(timeout)) {
                    throw new SharedContextTimeoutException();
                }
            }
            catch (InterruptedException e) {
                throw new SharedContextTimeoutException();
            }
            if (this.isTimeout) {
                throw new SharedContextTimeoutException();
            }
            if (this.throwable != null) {
                if (this.throwable instanceof SharedContextSendException) {
                    throw (SharedContextSendException)this.throwable;
                }
                if (this.throwable instanceof SharedContextTimeoutException) {
                    throw (SharedContextTimeoutException)this.throwable;
                }
                throw new SharedContextSendException(this.throwable);
            }
        }
    }

    private static class DistributeInfoComparator
    implements Comparator {
        public static final Comparator INSTANCE = new DistributeInfoComparator();

        private DistributeInfoComparator() {
        }

        public int compare(Object o1, Object o2) {
            DistributeInfo d1 = (DistributeInfo)o1;
            DistributeInfo d2 = (DistributeInfo)o2;
            return d1.getServerCount() - d2.getServerCount();
        }
    }

    private class DistributeGrid {
        private int[] serverCounts;
        private final Map distributeInfos = new HashMap();
        private final Map increaseInfos = new HashMap();
        private final Map decreaseInfos = new HashMap();

        public DistributeGrid() {
            this.serverCounts = new int[DistributedSharedContextService.this.sharedContextArray.length];
        }

        public void addDistributeInfo(DistributeInfo info) {
            this.distributeInfos.put(info.getId(), info);
            for (int i = 0; i < this.serverCounts.length; ++i) {
                if (!info.isServer(i)) continue;
                int n = i;
                this.serverCounts[n] = this.serverCounts[n] + 1;
            }
        }

        public int getServerCount(int index) {
            return this.serverCounts[index];
        }

        public void rehash() {
            HashSet infoSet = new HashSet(this.distributeInfos.values());
            DistributeInfo[] infos = infoSet.toArray(new DistributeInfo[infoSet.size()]);
            block0: for (int i = 0; i < this.serverCounts.length; ++i) {
                if (this.serverCounts[i] >= DistributedSharedContextService.this.replicationSize) continue;
                Arrays.sort(infos, DistributeInfoComparator.INSTANCE);
                for (int j = 0; j < infos.length; ++j) {
                    if (infos[j].isServer(i)) continue;
                    infos[j].setServer(i);
                    int n = i;
                    this.serverCounts[n] = this.serverCounts[n] + 1;
                    this.increaseInfos.put(infos[j].getId(), infos[j]);
                    continue block0;
                }
            }
            infos = infoSet.toArray(new DistributeInfo[infoSet.size()]);
            if (infos.length > 1) {
                int diffSize = DistributedSharedContextService.this.replicationSize >= infos.length ? 0 : 1;
                while (true) {
                    Arrays.sort(infos, DistributeInfoComparator.INSTANCE);
                    DistributeInfo maxInfo = infos[infos.length - 1];
                    DistributeInfo minInfo = infos[0];
                    if (maxInfo.getServerCount() - minInfo.getServerCount() <= diffSize) break;
                    int index = maxInfo.getMaxServerIndex(minInfo);
                    maxInfo.setClient(index);
                    this.decreaseInfos.put(maxInfo.getId(), maxInfo);
                    minInfo.setServer(index);
                    this.increaseInfos.put(minInfo.getId(), minInfo);
                }
            }
        }

        public Map getIncreaseDistributeInfos() {
            return this.increaseInfos;
        }

        public Map getDecreaseDistributeInfos() {
            return this.decreaseInfos;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            DistributeInfo[] infos = this.distributeInfos.values().toArray(new DistributeInfo[this.distributeInfos.size()]);
            int imax = infos.length;
            for (int i = 0; i < imax; ++i) {
                buf.append(infos[i].getId()).append(',');
                int jmax = infos[i].size();
                for (int j = 0; j < jmax; ++j) {
                    buf.append(infos[i].isServer(j) ? "S" : "C");
                    if (j == jmax - 1) continue;
                    buf.append(',');
                }
                if (i == imax - 1) continue;
                buf.append('\n');
            }
            return buf.toString();
        }
    }

    public static class DistributeInfo
    implements Externalizable {
        private Object id;
        private boolean[] serverFlagArray;
        private int serverCount;

        public DistributeInfo() {
        }

        public DistributeInfo(Object id, int distributedSize) {
            this.id = id;
            this.serverFlagArray = new boolean[distributedSize];
        }

        public Object getId() {
            return this.id;
        }

        public void setServer(int index) {
            if (this.serverFlagArray[index]) {
                return;
            }
            this.serverFlagArray[index] = true;
            ++this.serverCount;
        }

        public void setClient(int index) {
            if (!this.serverFlagArray[index]) {
                return;
            }
            this.serverFlagArray[index] = false;
            --this.serverCount;
        }

        public boolean isServer(int index) {
            return this.serverFlagArray[index];
        }

        public int size() {
            return this.serverFlagArray.length;
        }

        public int getServerCount() {
            return this.serverCount;
        }

        public int getMaxServerIndex(DistributeInfo target) {
            if (this.getServerCount() == 0) {
                return -1;
            }
            int i = this.serverFlagArray.length;
            while (--i >= 0) {
                if (!this.serverFlagArray[i] || target.isServer(i)) continue;
                return i;
            }
            return -1;
        }

        public synchronized void apply(DistributeInfo info, SharedContextService[] contexts) throws SharedContextSendException, SharedContextTimeoutException {
            for (int i = 0; i < contexts.length; ++i) {
                boolean isClient;
                boolean bl = isClient = !this.isServer(i);
                if (isClient == contexts[i].isClient()) continue;
                contexts[i].setClient(!this.isServer(i));
                if (isClient) {
                    info.setClient(i);
                    continue;
                }
                info.setServer(i);
            }
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.id);
            out.writeInt(this.serverFlagArray.length);
            for (int i = 0; i < this.serverFlagArray.length; ++i) {
                out.write(this.serverFlagArray[i] ? 1 : 0);
            }
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.id = in.readObject();
            this.serverFlagArray = new boolean[in.readInt()];
            for (int i = 0; i < this.serverFlagArray.length; ++i) {
                boolean bl = this.serverFlagArray[i] = in.read() == 1;
                if (!this.serverFlagArray[i]) continue;
                ++this.serverCount;
            }
        }
    }

    public static class DistributedSharedContextEvent
    implements Externalizable {
        public static final byte EVENT_GET_DIST_INFO = 1;
        public static final byte EVENT_REHASH_REQUEST = 2;
        public static final byte EVENT_REHASH = 3;
        public static final byte EVENT_SAVE = 4;
        public static final byte EVENT_LOAD = 5;
        public static final byte EVENT_LOAD_KEY = 6;
        public static final byte EVENT_REHASH_SWITCH = 7;
        public byte type;
        public Object value;

        public DistributedSharedContextEvent() {
        }

        public DistributedSharedContextEvent(byte type) {
            this(type, null);
        }

        public DistributedSharedContextEvent(byte type, Object value) {
            this.type = type;
            this.value = value;
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.write(this.type);
            out.writeObject(this.value);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.type = (byte)in.read();
            this.value = in.readObject();
        }

        public String toString() {
            StringBuffer buf = new StringBuffer(super.toString());
            buf.append('{');
            buf.append("type=").append(this.type);
            buf.append(", value=").append(this.value);
            buf.append('}');
            return buf.toString();
        }
    }
}

