/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.beancontrol;

import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import jp.ossc.nimbus.service.beancontrol.BeanFlowMonitor;
import jp.ossc.nimbus.service.beancontrol.BeanFlowMonitorStopException;
import jp.ossc.nimbus.service.queue.BeanFlowAsynchContext;
import jp.ossc.nimbus.util.SynchronizeMonitor;
import jp.ossc.nimbus.util.WaitSynchronizeMonitor;

public class BeanFlowMonitorImpl
implements BeanFlowMonitor,
Serializable {
    private static final long serialVersionUID = 1596031860601490370L;
    private boolean isSuspend = false;
    private boolean isStop = false;
    private boolean isStopped = false;
    private boolean isEnd = false;
    private SynchronizeMonitor suspendLock = new WaitSynchronizeMonitor();
    private String flowName;
    private String currentFlowName;
    private String currentStepName;
    private long startTime = -1L;
    private long endTime = -1L;
    private transient Set asynchContextSet;
    private transient Set monitorSet;
    private transient Thread flowThread;

    public BeanFlowMonitorImpl() {
    }

    public BeanFlowMonitorImpl(String name) {
        this.flowName = name;
    }

    public void suspend() {
        this.isSuspend = true;
        if (this.monitorSet != null) {
            Iterator monitors = this.monitorSet.iterator();
            while (monitors.hasNext()) {
                BeanFlowMonitor monitor = (BeanFlowMonitor)monitors.next();
                monitor.suspend();
            }
        }
    }

    public boolean isSuspend() {
        return this.isSuspend;
    }

    public boolean isSuspended() {
        if (!this.suspendLock.isWait()) {
            return false;
        }
        if (this.monitorSet != null) {
            Iterator monitors = this.monitorSet.iterator();
            while (monitors.hasNext()) {
                BeanFlowMonitor monitor = (BeanFlowMonitor)monitors.next();
                if (monitor.isSuspended()) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkSuspend() throws InterruptedException {
        if (this.isSuspend) {
            SynchronizeMonitor synchronizeMonitor = this.suspendLock;
            synchronized (synchronizeMonitor) {
                if (this.isSuspend) {
                    this.suspendLock.initMonitor();
                    this.suspendLock.waitMonitor();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        SynchronizeMonitor synchronizeMonitor = this.suspendLock;
        synchronized (synchronizeMonitor) {
            this.isSuspend = false;
            this.suspendLock.notifyAllMonitor();
            if (this.monitorSet != null) {
                Iterator monitors = this.monitorSet.iterator();
                while (monitors.hasNext()) {
                    BeanFlowMonitor monitor = (BeanFlowMonitor)monitors.next();
                    monitor.resume();
                }
            }
        }
    }

    public void cancel() {
        if (this.monitorSet != null) {
            Iterator monitors = this.monitorSet.iterator();
            while (monitors.hasNext()) {
                BeanFlowMonitor monitor = (BeanFlowMonitor)monitors.next();
                monitor.cancel();
            }
        }
        if (this.asynchContextSet != null) {
            Iterator contexts = this.asynchContextSet.iterator();
            while (contexts.hasNext()) {
                BeanFlowAsynchContext context = (BeanFlowAsynchContext)contexts.next();
                context.cancel();
                contexts.remove();
            }
        }
    }

    public void stop() {
        this.isStop = true;
        if (this.monitorSet != null) {
            Iterator monitors = this.monitorSet.iterator();
            while (monitors.hasNext()) {
                BeanFlowMonitor monitor = (BeanFlowMonitor)monitors.next();
                monitor.stop();
            }
        }
        if (this.flowThread != null) {
            this.flowThread.interrupt();
        }
    }

    public boolean isStop() {
        return this.isStop;
    }

    public boolean isStopped() {
        if (!this.isStopped) {
            return false;
        }
        if (this.monitorSet != null) {
            Iterator monitors = this.monitorSet.iterator();
            while (monitors.hasNext()) {
                BeanFlowMonitor monitor = (BeanFlowMonitor)monitors.next();
                if (monitor.isStopped()) continue;
                return false;
            }
        }
        return true;
    }

    protected void checkStop() throws BeanFlowMonitorStopException {
        if (this.isStop) {
            this.isStopped = true;
            throw new BeanFlowMonitorStopException();
        }
    }

    public boolean isEnd() {
        return this.isEnd;
    }

    public String getFlowName() {
        return this.flowName;
    }

    protected void setFlowName(String name) {
        this.flowName = name;
    }

    public String getCurrentFlowName() {
        return this.currentFlowName;
    }

    protected void setCurrentFlowName(String name) {
        this.currentFlowName = name;
    }

    public String getCurrentStepName() {
        return this.currentStepName;
    }

    protected void setCurrentStepName(String name) {
        this.currentStepName = name;
    }

    public long getStartTime() {
        return this.startTime;
    }

    protected void setStartTime(long time) {
        if (this.flowName.equals(this.currentFlowName)) {
            this.startTime = time;
            this.flowThread = Thread.currentThread();
        }
    }

    public long getCurrentProcessTime() {
        if (this.startTime == -1L) {
            return 0L;
        }
        if (this.isEnd) {
            return this.endTime - this.startTime;
        }
        return System.currentTimeMillis() - this.startTime;
    }

    protected void end() {
        if (this.flowName.equals(this.currentFlowName)) {
            this.endTime = System.currentTimeMillis();
            this.currentFlowName = null;
            this.currentStepName = null;
            if (this.flowThread != null) {
                Thread.interrupted();
            }
            this.flowThread = null;
            this.isEnd = true;
        }
    }

    public void addAsynchContext(BeanFlowAsynchContext context) {
        if (this.asynchContextSet == null) {
            this.asynchContextSet = Collections.synchronizedSet(new LinkedHashSet());
        }
        this.asynchContextSet.add(context);
    }

    public void removeAsynchContext(BeanFlowAsynchContext context) {
        if (this.asynchContextSet == null) {
            return;
        }
        this.asynchContextSet.remove(context);
    }

    public void addBeanFlowMonitor(BeanFlowMonitor monitor) {
        if (this.monitorSet == null) {
            this.monitorSet = Collections.synchronizedSet(new LinkedHashSet());
        }
        this.monitorSet.add(monitor);
    }

    public void removeBeanFlowMonitor(BeanFlowMonitor monitor) {
        if (this.monitorSet == null) {
            return;
        }
        this.monitorSet.remove(monitor);
    }

    public void clear() {
        this.resume();
        this.isStop = false;
        this.isStopped = false;
        this.isEnd = false;
        this.flowName = null;
        this.currentFlowName = null;
        this.currentStepName = null;
        this.asynchContextSet = null;
        this.monitorSet = null;
        this.startTime = -1L;
        this.endTime = -1L;
        this.flowThread = null;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(super.toString());
        buf.append('{');
        buf.append("flowName=").append(this.flowName).append(',');
        buf.append("currentFlowName=").append(this.currentFlowName).append(',');
        buf.append("currentStepName=").append(this.currentStepName).append(',');
        buf.append("isSuspend=").append(this.isSuspend).append(',');
        buf.append("isStop=").append(this.isStop).append(',');
        buf.append("startTime=").append(new Date(this.startTime)).append(',');
        buf.append("currentProcessTime=").append(this.getCurrentProcessTime());
        buf.append('}');
        return buf.toString();
    }
}

