/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.aspect;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.aspect.InterceptorChainInvokerAccess;
import jp.ossc.nimbus.service.aspect.IntreceptorChainList;
import jp.ossc.nimbus.service.aspect.interfaces.Interceptor;
import jp.ossc.nimbus.service.aspect.interfaces.InterceptorChainInvoker;
import jp.ossc.nimbus.service.aspect.interfaces.InterceptorException;
import jp.ossc.nimbus.service.aspect.interfaces.TargetCheckedException;
import jp.ossc.nimbus.service.aspect.interfaces.TargetUncheckedException;
import jp.ossc.nimbus.service.aspect.util.UtilTool;
import jp.ossc.nimbus.service.log.Logger;

public class InterceptorChainInvokerAccessImpl
implements InterceptorChainInvoker,
InterceptorChainInvokerAccess {
    protected IntreceptorChainList mList = null;
    protected Iterator mIte = null;
    protected Object mCallBackObject = null;
    protected Method mCallBackmethod = null;
    protected Logger mLogger = null;

    public void setLogger(Logger logger) {
        this.mLogger = logger;
    }

    protected IntreceptorChainList getInterceptorChainList() {
        return this.mList;
    }

    public Object invokeChain(Object callBackObject, Object inputObj) throws InterceptorException, TargetCheckedException, TargetUncheckedException {
        if (this.mList == null) {
            if (this.mLogger != null) {
                this.mLogger.write("AOP__00013");
            }
            throw new InterceptorException("InterceptorChainList is null");
        }
        if (callBackObject == null) {
            if (this.mLogger != null) {
                this.mLogger.write("AOP__00014");
            }
            throw new InterceptorException("callBackObject is null");
        }
        if (this.mCallBackmethod == null) {
            if (this.mLogger != null) {
                this.mLogger.write("AOP__00015");
            }
            throw new InterceptorException("CallBackmethod is null");
        }
        if (this.mLogger != null) {
            this.mLogger.write("AOP__00008");
        }
        this.mCallBackObject = callBackObject;
        if (this.mLogger != null) {
            this.mLogger.write("AOP__00009", this.mList.size());
        }
        this.mIte = this.mList.iterator();
        Object retObject = null;
        try {
            retObject = this.invokeChain(inputObj);
        }
        catch (TargetUncheckedException e) {
            if (this.mLogger != null) {
                this.mLogger.write("AOP__00016", e);
            }
            throw e;
        }
        catch (TargetCheckedException e) {
            if (this.mLogger != null) {
                this.mLogger.write("AOP__00017", e);
            }
            throw e;
        }
        catch (InterceptorException e) {
            if (this.mLogger != null) {
                this.mLogger.write("AOP__00020", e);
            }
            throw e;
        }
        return retObject;
    }

    public Object invokeChain(Object inputObj) throws InterceptorException, TargetCheckedException, TargetUncheckedException {
        Object retObject = null;
        if (this.mIte.hasNext()) {
            ServiceName name = (ServiceName)this.mIte.next();
            Interceptor interceptor = UtilTool.getInterceptor(name);
            if (interceptor == null) {
                throw new InterceptorException("interceptor[" + name + "] is null");
            }
            if (this.mLogger != null) {
                this.mLogger.write("AOP__00010", name);
            }
            try {
                retObject = interceptor.invokeChain(inputObj, this);
            }
            catch (TargetUncheckedException e) {
                if (this.mLogger != null) {
                    this.mLogger.write("AOP__00016", e);
                }
                throw e;
            }
            catch (TargetCheckedException e) {
                if (this.mLogger != null) {
                    this.mLogger.write("AOP__00017", e);
                }
                throw e;
            }
            catch (InterceptorException e) {
                if (this.mLogger != null) {
                    this.mLogger.write("AOP__00020", e);
                }
                throw e;
            }
        }
        try {
            if (this.mLogger != null) {
                this.mLogger.write("AOP__00011", (Object)this.mCallBackmethod.getName());
            }
            retObject = this.mCallBackmethod.invoke(this.mCallBackObject, inputObj);
            if (this.mLogger != null) {
                this.mLogger.write("AOP__00012", (Object)this.mCallBackmethod.getName());
            }
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                if (this.mLogger != null) {
                    this.mLogger.write("AOP__00016", cause);
                }
                throw new TargetUncheckedException(cause);
            }
            if (cause instanceof InterceptorException) {
                throw (InterceptorException)cause;
            }
            if (cause instanceof Exception) {
                if (this.mLogger != null) {
                    this.mLogger.write("AOP__00017", cause);
                }
                throw new TargetCheckedException(cause);
            }
            if (this.mLogger != null) {
                this.mLogger.write("AOP__00018", cause);
            }
            throw new TargetUncheckedException(cause);
        }
        catch (IllegalArgumentException e) {
            if (this.mLogger != null) {
                this.mLogger.write("AOP__00019", e);
            }
            throw new InterceptorException("root callback error", e);
        }
        catch (IllegalAccessException e) {
            if (this.mLogger != null) {
                this.mLogger.write("AOP__00020", e);
            }
            throw new InterceptorException("root callback error", e);
        }
        catch (Throwable e) {
            if (this.mLogger != null) {
                this.mLogger.write("AOP__00021", e);
            }
            throw new InterceptorException("root callback error", e);
        }
        return retObject;
    }

    public void setInterceptorChainList(IntreceptorChainList interceptorChainList) {
        this.mList = interceptorChainList;
    }

    public void setCallBackmethod(Method callBackmethod) {
        this.mCallBackmethod = callBackmethod;
    }

    protected Method getCallBackmethod() {
        return this.mCallBackmethod;
    }
}

