/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.aop.interceptor.servlet;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import jp.ossc.nimbus.beans.NoSuchPropertyException;
import jp.ossc.nimbus.beans.PropertyAccess;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.aop.InterceptorChain;
import jp.ossc.nimbus.service.aop.ServletFilterInvocationContext;
import jp.ossc.nimbus.service.aop.interceptor.servlet.AuthenticateException;
import jp.ossc.nimbus.service.aop.interceptor.servlet.AuthenticateInterceptorServiceMBean;
import jp.ossc.nimbus.service.aop.interceptor.servlet.AuthenticateStore;
import jp.ossc.nimbus.service.aop.interceptor.servlet.IllegalAuthenticateException;
import jp.ossc.nimbus.service.aop.interceptor.servlet.NoAuthenticateException;
import jp.ossc.nimbus.service.aop.interceptor.servlet.ServletFilterInterceptorService;
import jp.ossc.nimbus.service.aop.interceptor.servlet.StreamExchangeInterceptorServiceMBean;
import jp.ossc.nimbus.service.context.Context;

public class AuthenticateInterceptorService
extends ServletFilterInterceptorService
implements AuthenticateInterceptorServiceMBean {
    private static final long serialVersionUID = -4298385595443568724L;
    protected String authenticatedInfoAttributeName = DEFAULT_AUTH_INFO_ATTRIBUTE_NAME;
    protected String authenticatedInfoContextKey = DEFAULT_AUTH_INFO_ATTRIBUTE_NAME;
    protected String requestObjectAttributeName = StreamExchangeInterceptorServiceMBean.DEFAULT_REQUEST_OBJECT_ATTRIBUTE_NAME;
    protected String requestObjectContextKey = StreamExchangeInterceptorServiceMBean.DEFAULT_REQUEST_OBJECT_CONTEXT_KEY;
    protected ServiceName threadContextServiceName;
    protected Context threadContext;
    protected Map authenticatedInfoMapping;
    protected PropertyAccess propertyAccess;
    protected String loginPath;
    protected String logoutPath;
    protected ServiceName authenticateStoreServiceName;
    protected AuthenticateStore authenticateStore;
    protected boolean isStoreCreate = true;
    protected boolean isStoreDestroy = true;

    public void setThreadContextServiceName(ServiceName name) {
        this.threadContextServiceName = name;
    }

    public ServiceName getThreadContextServiceName() {
        return this.threadContextServiceName;
    }

    public void setRequestObjectAttributeName(String name) {
        this.requestObjectAttributeName = name;
    }

    public String getRequestObjectAttributeName() {
        return this.requestObjectAttributeName;
    }

    public void setRequestObjectContextKey(String key) {
        this.requestObjectContextKey = key;
    }

    public String getRequestObjectContextKey() {
        return this.requestObjectContextKey;
    }

    public void setAuthenticatedInfoAttributeName(String name) {
        this.authenticatedInfoAttributeName = name;
    }

    public String getAuthenticatedInfoAttributeName() {
        return this.authenticatedInfoAttributeName;
    }

    public void setAuthenticatedInfoContextKey(String name) {
        this.authenticatedInfoContextKey = name;
    }

    public String getAuthenticatedInfoContextKey() {
        return this.authenticatedInfoContextKey;
    }

    public void setAuthenticatedInfoMapping(Map mapping) {
        this.authenticatedInfoMapping = mapping;
    }

    public Map getAuthenticatedInfoMapping() {
        return this.authenticatedInfoMapping;
    }

    public void setLoginPath(String path) {
        this.loginPath = path;
    }

    public String getLoginPath() {
        return this.loginPath;
    }

    public void setLogoutPath(String path) {
        this.logoutPath = path;
    }

    public String getLogoutPath() {
        return this.logoutPath;
    }

    public void setAuthenticateStoreServiceName(ServiceName name) {
        this.authenticateStoreServiceName = name;
    }

    public ServiceName getAuthenticateStoreServiceName() {
        return this.authenticateStoreServiceName;
    }

    public void setStoreCreate(boolean isCreate) {
        this.isStoreCreate = isCreate;
    }

    public boolean isStoreCreate() {
        return this.isStoreCreate;
    }

    public void setStoreDestroy(boolean isDestroy) {
        this.isStoreDestroy = isDestroy;
    }

    public boolean isStoreDestroy() {
        return this.isStoreDestroy;
    }

    public void setAuthenticateStore(AuthenticateStore store) {
        this.authenticateStore = store;
    }

    public AuthenticateStore getAuthenticateStore() {
        return this.authenticateStore;
    }

    public void setThreadContext(Context context) {
        this.threadContext = context;
    }

    public Context getThreadContext() {
        return this.threadContext;
    }

    public void createService() throws Exception {
        this.propertyAccess = new PropertyAccess();
        this.propertyAccess.setIgnoreNullProperty(true);
    }

    public void startService() throws Exception {
        if (this.threadContextServiceName != null) {
            this.threadContext = (Context)ServiceManagerFactory.getServiceObject(this.threadContextServiceName);
        }
        if (this.loginPath == null) {
            throw new IllegalArgumentException("LoginPath must be specified.");
        }
        if (this.authenticatedInfoMapping == null || this.authenticatedInfoMapping.size() == 0) {
            throw new IllegalArgumentException("AuthenticatedInfoMapping must be specified.");
        }
        if (this.authenticateStoreServiceName != null) {
            this.authenticateStore = (AuthenticateStore)ServiceManagerFactory.getServiceObject(this.authenticateStoreServiceName);
        }
    }

    public void destroyService() throws Exception {
        this.propertyAccess = null;
    }

    public Object invokeFilter(ServletFilterInvocationContext context, InterceptorChain chain) throws Throwable {
        if (this.getState() != 3) {
            return chain.invokeNext(context);
        }
        HttpServletRequest request = (HttpServletRequest)context.getServletRequest();
        String reqPath = request.getPathInfo();
        if (reqPath == null) {
            reqPath = request.getServletPath();
        }
        if (this.loginPath.equals(reqPath)) {
            Object ret = chain.invokeNext(context);
            this.newAuthenticatedInfo(request);
            return ret;
        }
        if (this.logoutPath != null && this.logoutPath.equals(reqPath)) {
            this.checkAuthenticated(request);
            this.setupAuthenticatedInfo(request);
            Object ret = chain.invokeNext(context);
            this.removeAuthenticatedInfo(request);
            return ret;
        }
        this.checkAuthenticated(request);
        this.setupAuthenticatedInfo(request);
        return chain.invokeNext(context);
    }

    protected void newAuthenticatedInfo(HttpServletRequest request) throws AuthenticateException {
        Object authenticatedInfo = request.getAttribute(this.authenticatedInfoAttributeName);
        if (authenticatedInfo == null && this.threadContext != null) {
            authenticatedInfo = this.threadContext.get(this.authenticatedInfoContextKey);
        }
        if (authenticatedInfo != null) {
            HttpSession session = request.getSession(false);
            if (session == null) {
                session = request.getSession(true);
            }
            session.setAttribute(this.authenticatedInfoAttributeName, (Object)new AuthenticatedInfo(authenticatedInfo, this.authenticateStoreServiceName));
            if (this.authenticateStore != null && this.isStoreCreate) {
                this.authenticateStore.create(request, authenticatedInfo);
            }
        }
    }

    protected void setupAuthenticatedInfo(HttpServletRequest request) {
        AuthenticatedInfo authenticatedInfo;
        HttpSession session = request.getSession(false);
        if (session != null && (authenticatedInfo = (AuthenticatedInfo)session.getAttribute(this.authenticatedInfoAttributeName)) != null) {
            if (request.getAttribute(this.authenticatedInfoAttributeName) == null) {
                request.setAttribute(this.authenticatedInfoContextKey, authenticatedInfo.authenticatedInfo);
            }
            if (this.threadContext != null && !this.threadContext.containsKey(this.authenticatedInfoContextKey)) {
                this.threadContext.put(this.authenticatedInfoContextKey, authenticatedInfo.authenticatedInfo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeAuthenticatedInfo(HttpServletRequest request) throws AuthenticateException {
        Object requestObject = request.getAttribute(this.requestObjectAttributeName);
        if (requestObject == null) {
            if (this.threadContext != null) {
                requestObject = this.threadContext.get(this.requestObjectContextKey);
            }
            if (requestObject == null) {
                throw new IllegalAuthenticateException("RequestObject is null.");
            }
        }
        try {
            if (this.authenticateStore != null && this.isStoreDestroy) {
                this.authenticateStore.destroy(request, requestObject);
            }
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            HttpSession session = request.getSession(false);
            if (session != null) {
                session.removeAttribute(this.authenticatedInfoAttributeName);
            }
            throw throwable;
        }
        HttpSession session = request.getSession(false);
        if (session != null) {
            session.removeAttribute(this.authenticatedInfoAttributeName);
        }
    }

    protected void checkAuthenticated(HttpServletRequest request) throws AuthenticateException {
        Object requestObject = request.getAttribute(this.requestObjectAttributeName);
        if (requestObject == null) {
            if (this.threadContext != null) {
                requestObject = this.threadContext.get(this.requestObjectContextKey);
            }
            if (requestObject == null) {
                throw new IllegalAuthenticateException("RequestObject is null.");
            }
        }
        Object authenticatedInfo = null;
        HttpSession session = request.getSession(false);
        if (session != null && (authenticatedInfo = session.getAttribute(this.authenticatedInfoAttributeName)) != null && authenticatedInfo instanceof AuthenticatedInfo) {
            authenticatedInfo = ((AuthenticatedInfo)authenticatedInfo).authenticatedInfo;
        }
        if (authenticatedInfo == null && this.authenticateStore != null) {
            authenticatedInfo = this.authenticateStore.activate(request, requestObject);
            session.setAttribute(this.authenticatedInfoAttributeName, (Object)new AuthenticatedInfo(authenticatedInfo, this.authenticateStoreServiceName));
        }
        if (authenticatedInfo == null) {
            throw new NoAuthenticateException("AuthenticatedInfo is null.");
        }
        Iterator entries = this.authenticatedInfoMapping.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            Object requestValue = null;
            try {
                requestValue = this.propertyAccess.get(requestObject, (String)entry.getKey());
            }
            catch (IllegalArgumentException e) {
                throw new IllegalAuthenticateException("Authenticated value '" + entry.getKey() + "' cannot acquire from a request.", e);
            }
            catch (NoSuchPropertyException e) {
                throw new IllegalAuthenticateException("Authenticated value '" + entry.getKey() + "' cannot acquire from a request.", e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalAuthenticateException("Authenticated value '" + entry.getKey() + "' cannot acquire from a request.", e.getTargetException());
            }
            if (requestValue == null) {
                throw new IllegalAuthenticateException("Authenticated value '" + entry.getKey() + "' cannot acquire from a request. value=null");
            }
            Object authenticatedValue = null;
            try {
                authenticatedValue = this.propertyAccess.get(authenticatedInfo, (String)entry.getValue());
            }
            catch (IllegalArgumentException e) {
                throw new IllegalAuthenticateException("Authenticated value '" + entry.getValue() + "' cannot acquire from a session.", e);
            }
            catch (NoSuchPropertyException e) {
                throw new IllegalAuthenticateException("Authenticated value '" + entry.getValue() + "' cannot acquire from a session.", e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalAuthenticateException("Authenticated value '" + entry.getValue() + "' cannot acquire from a session.", e.getTargetException());
            }
            if (authenticatedValue == null) {
                throw new IllegalAuthenticateException("Authenticated value '" + entry.getValue() + "' cannot acquire from a session. value=null");
            }
            if (requestValue.equals(authenticatedValue)) continue;
            throw new IllegalAuthenticateException("Authenticated value '" + entry.getKey() + "' and '" + entry.getValue() + "' are not in agreement. requestValue=" + requestValue + ", authenticatedValue=" + authenticatedValue);
        }
    }

    public static class AuthenticatedInfo
    implements HttpSessionBindingListener,
    Serializable {
        private static final long serialVersionUID = -5976568672626640653L;
        public Object authenticatedInfo;
        protected ServiceName authenticateStoreServiceName;

        public AuthenticatedInfo() {
        }

        public AuthenticatedInfo(Object authInfo, ServiceName storeServiceName) {
            this.authenticatedInfo = authInfo;
            this.authenticateStoreServiceName = storeServiceName;
        }

        public void valueBound(HttpSessionBindingEvent event) {
        }

        public void valueUnbound(HttpSessionBindingEvent event) {
            if (this.authenticateStoreServiceName != null) {
                AuthenticateStore authenticateStore = (AuthenticateStore)ServiceManagerFactory.getServiceObject(this.authenticateStoreServiceName);
                authenticateStore.deactivate(event.getSession(), this.authenticatedInfo);
            }
        }
    }
}

