/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.aop.interceptor;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import jp.ossc.nimbus.beans.MethodEditor;
import jp.ossc.nimbus.beans.NoSuchPropertyException;
import jp.ossc.nimbus.beans.PropertyAccess;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.aop.Interceptor;
import jp.ossc.nimbus.service.aop.InterceptorChain;
import jp.ossc.nimbus.service.aop.InvocationContext;
import jp.ossc.nimbus.service.aop.MethodInvocationContext;
import jp.ossc.nimbus.service.aop.interceptor.TraceLoggingInterceptorServiceMBean;
import jp.ossc.nimbus.service.sequence.Sequence;

public class TraceLoggingInterceptorService
extends ServiceBase
implements Interceptor,
TraceLoggingInterceptorServiceMBean {
    private static final long serialVersionUID = -6275466936441558184L;
    private String requestMessageId = "TLIS_00001";
    private String responseMessageId = "TLIS_00002";
    private boolean isEnabled = true;
    private boolean isOutputRequestLog = true;
    private boolean isOutputResponseLog = false;
    private boolean isOutputTarget = true;
    private boolean isOutputMethod = true;
    private boolean isOutputParameter = false;
    private boolean isOutputCallStackTrace = false;
    private boolean isOutputReturn = true;
    private boolean isOutputThrowable = false;
    private boolean isOutputPerformance = false;
    private boolean isOutputTargetOnResponse = false;
    private boolean isOutputMethodOnResponse = false;
    private boolean isOutputParameterOnResponse = false;
    private String[] outputTargetProperties;
    private String[] outputParameterProperties;
    private String[] outputReturnProperties;
    private PropertyAccess propertyAccess;
    private ServiceName sequenceServiceName;
    private Sequence sequence;

    public void setEnabled(boolean enable) {
        this.isEnabled = enable;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setRequestMessageId(String id) {
        this.requestMessageId = id;
    }

    public String getRequestMessageId() {
        return this.requestMessageId;
    }

    public void setResponseMessageId(String id) {
        this.responseMessageId = id;
    }

    public String getResponseMessageId() {
        return this.responseMessageId;
    }

    public void setOutputRequestLog(boolean isOutput) {
        this.isOutputRequestLog = isOutput;
    }

    public boolean isOutputRequestLog() {
        return this.isOutputRequestLog;
    }

    public void setOutputResponseLog(boolean isOutput) {
        this.isOutputResponseLog = isOutput;
    }

    public boolean isOutputResponseLog() {
        return this.isOutputResponseLog;
    }

    public void setOutputTarget(boolean isOutput) {
        this.isOutputTarget = isOutput;
    }

    public boolean isOutputTarget() {
        return this.isOutputTarget;
    }

    public void setOutputMethod(boolean isOutput) {
        this.isOutputMethod = isOutput;
    }

    public boolean isOutputMethod() {
        return this.isOutputMethod;
    }

    public void setOutputParameter(boolean isOutput) {
        this.isOutputParameter = isOutput;
    }

    public boolean isOutputParameter() {
        return this.isOutputParameter;
    }

    public void setOutputCallStackTrace(boolean isOutput) {
        this.isOutputCallStackTrace = isOutput;
    }

    public boolean isOutputCallStackTrace() {
        return this.isOutputCallStackTrace;
    }

    public void setOutputReturn(boolean isOutput) {
        this.isOutputReturn = isOutput;
    }

    public boolean isOutputReturn() {
        return this.isOutputReturn;
    }

    public void setOutputThrowable(boolean isOutput) {
        this.isOutputThrowable = isOutput;
    }

    public boolean isOutputThrowable() {
        return this.isOutputThrowable;
    }

    public void setOutputPerformance(boolean isOutput) {
        this.isOutputPerformance = isOutput;
    }

    public boolean isOutputPerformance() {
        return this.isOutputPerformance;
    }

    public void setOutputTargetOnResponse(boolean isOutput) {
        this.isOutputTargetOnResponse = isOutput;
    }

    public boolean isOutputTargetOnResponse() {
        return this.isOutputTargetOnResponse;
    }

    public void setOutputMethodOnResponse(boolean isOutput) {
        this.isOutputMethodOnResponse = isOutput;
    }

    public boolean isOutputMethodOnResponse() {
        return this.isOutputMethodOnResponse;
    }

    public void setOutputParameterOnResponse(boolean isOutput) {
        this.isOutputParameterOnResponse = isOutput;
    }

    public boolean isOutputParameterOnResponse() {
        return this.isOutputParameterOnResponse;
    }

    public void setOutputTargetProperties(String[] props) {
        this.outputTargetProperties = props;
    }

    public String[] getOutputTargetProperties() {
        return this.outputTargetProperties;
    }

    public void setOutputParameterProperties(String[] props) {
        this.outputParameterProperties = props;
    }

    public String[] getOutputParameterProperties() {
        return this.outputParameterProperties;
    }

    public void setOutputReturnProperties(String[] props) {
        this.outputReturnProperties = props;
    }

    public String[] getOutputReturnProperties() {
        return this.outputReturnProperties;
    }

    public void setSequenceServiceName(ServiceName name) {
        this.sequenceServiceName = name;
    }

    public ServiceName getSequenceServiceName() {
        return this.sequenceServiceName;
    }

    public void setSequence(Sequence sequence) {
        this.sequence = sequence;
    }

    public void startService() throws Exception {
        if (this.outputParameterProperties != null && this.outputParameterProperties.length != 0 || this.outputReturnProperties != null && this.outputReturnProperties.length != 0 || this.outputTargetProperties != null && this.outputTargetProperties.length != 0) {
            this.propertyAccess = new PropertyAccess();
            this.propertyAccess.setIgnoreNullProperty(true);
        }
        if (this.sequenceServiceName != null) {
            this.sequence = (Sequence)ServiceManagerFactory.getServiceObject(this.sequenceServiceName);
        }
    }

    public Object invoke(InvocationContext context, InterceptorChain chain) throws Throwable {
        Object i3;
        if (this.getState() != 3 || !this.isEnabled()) {
            return chain.invokeNext(context);
        }
        long start = System.currentTimeMillis();
        StringBuffer buf = null;
        StringBuffer targetBuf = null;
        StringBuffer methodBuf = null;
        StringBuffer parameterBuf = null;
        String sequenceId = null;
        if (this.sequence != null) {
            sequenceId = this.sequence.increment();
            if (buf == null) {
                buf = new StringBuffer();
            }
            buf.append(sequenceId);
        }
        if (this.isOutputTarget || this.isOutputTargetOnResponse) {
            targetBuf = new StringBuffer();
            Object target = context.getTargetObject();
            if (this.outputTargetProperties != null && this.outputTargetProperties.length != 0) {
                targetBuf.append('[');
                for (int i2 = 0; i2 < this.outputTargetProperties.length; ++i2) {
                    Object prop = null;
                    try {
                        prop = this.propertyAccess.get(target, this.outputTargetProperties[i2]);
                    }
                    catch (IllegalArgumentException e) {
                    }
                    catch (NoSuchPropertyException e) {
                    }
                    catch (InvocationTargetException e) {
                        // empty catch block
                    }
                    this.printObject(targetBuf, prop);
                    if (i2 == this.outputTargetProperties.length - 1) continue;
                    targetBuf.append(',');
                }
                targetBuf.append(']');
            } else {
                this.printObject(targetBuf, target);
            }
            if (this.isOutputTarget) {
                if (buf == null) {
                    buf = new StringBuffer();
                } else {
                    buf.append(',');
                }
                buf.append(targetBuf);
            }
        }
        if (context instanceof MethodInvocationContext) {
            MethodInvocationContext methodContext = (MethodInvocationContext)context;
            if (this.isOutputMethod || this.isOutputMethodOnResponse) {
                methodBuf = new StringBuffer();
                Method method = methodContext.getTargetMethod();
                if (method != null) {
                    MethodEditor editor = new MethodEditor();
                    editor.setValue(method);
                    methodBuf.append(editor.getAsText());
                } else {
                    methodBuf.append("null");
                }
                if (this.isOutputMethod) {
                    if (buf == null) {
                        buf = new StringBuffer();
                    } else {
                        buf.append(',');
                    }
                    buf.append(methodBuf);
                }
            }
            if (this.isOutputParameter || this.isOutputParameterOnResponse) {
                parameterBuf = new StringBuffer();
                Object[] params = methodContext.getParameters();
                if (params != null) {
                    parameterBuf.append('[');
                    if (this.outputParameterProperties != null && this.outputParameterProperties.length != 0) {
                        for (int i3 = 0; i3 < this.outputParameterProperties.length; ++i3) {
                            Object prop = null;
                            try {
                                prop = this.propertyAccess.get(params, this.outputParameterProperties[i3]);
                            }
                            catch (IllegalArgumentException e) {
                            }
                            catch (NoSuchPropertyException e) {
                            }
                            catch (InvocationTargetException e) {
                                // empty catch block
                            }
                            this.printObject(parameterBuf, prop);
                            if (i3 == this.outputParameterProperties.length - 1) continue;
                            parameterBuf.append(',');
                        }
                    } else {
                        this.printObject(parameterBuf, params);
                    }
                    parameterBuf.append(']');
                } else {
                    parameterBuf.append("null");
                }
                if (this.isOutputParameter) {
                    if (buf == null) {
                        buf = new StringBuffer();
                    } else {
                        buf.append(',');
                    }
                    buf.append(parameterBuf);
                }
            }
        }
        if (this.isOutputRequestLog && this.getLogger().isWrite(this.requestMessageId)) {
            if (this.isOutputCallStackTrace) {
                this.getLogger().write(this.requestMessageId, (Object)(buf == null ? "" : buf.toString()), (Throwable)new Exception("Call stack"));
            } else {
                this.getLogger().write(this.requestMessageId, (Object)(buf == null ? "" : buf.toString()));
            }
        }
        if (buf != null) {
            buf.setLength(0);
        }
        Throwable throwable = null;
        Object ret = null;
        try {
            i3 = ret = chain.invokeNext(context);
            Object var16_27 = null;
        }
        catch (Throwable th) {
            try {
                throwable = th;
                throw th;
            }
            catch (Throwable throwable2) {
                block86: {
                    Object var16_28 = null;
                    long end = System.currentTimeMillis();
                    if (!this.isOutputResponseLog || !this.getLogger().isWrite(this.responseMessageId)) break block86;
                    if (buf == null) {
                        buf = new StringBuffer();
                    }
                    if (sequenceId != null) {
                        buf.append(sequenceId);
                    }
                    if (this.isOutputTargetOnResponse) {
                        if (buf.length() != 0) {
                            buf.append(',');
                        }
                        buf.append(targetBuf);
                    }
                    if (this.isOutputMethodOnResponse) {
                        if (buf.length() != 0) {
                            buf.append(',');
                        }
                        buf.append(methodBuf);
                    }
                    if (this.isOutputParameterOnResponse) {
                        if (buf.length() != 0) {
                            buf.append(',');
                        }
                        buf.append(parameterBuf);
                    }
                    if (throwable == null && this.isOutputReturn) {
                        if (buf.length() != 0) {
                            buf.append(',');
                        }
                        if (this.outputReturnProperties != null && this.outputReturnProperties.length != 0) {
                            buf.append('[');
                            for (int i4 = 0; i4 < this.outputReturnProperties.length; ++i4) {
                                Object prop = null;
                                try {
                                    prop = this.propertyAccess.get(ret, this.outputReturnProperties[i4]);
                                }
                                catch (IllegalArgumentException e) {
                                }
                                catch (NoSuchPropertyException e) {
                                }
                                catch (InvocationTargetException e) {
                                    // empty catch block
                                }
                                this.printObject(buf, prop);
                                if (i4 == this.outputReturnProperties.length - 1) continue;
                                buf.append(',');
                            }
                            buf.append(']');
                        } else {
                            this.printObject(buf, ret);
                        }
                    }
                    if (this.isOutputPerformance) {
                        if (buf.length() != 0) {
                            buf.append(',');
                        }
                        buf.append(end - start);
                    }
                    if (throwable != null && this.isOutputThrowable) {
                        this.getLogger().write(this.responseMessageId, (Object)buf.toString(), throwable);
                    } else {
                        this.getLogger().write(this.responseMessageId, (Object)buf.toString());
                    }
                }
                throw throwable2;
            }
        }
        long end = System.currentTimeMillis();
        if (this.isOutputResponseLog && this.getLogger().isWrite(this.responseMessageId)) {
            if (buf == null) {
                buf = new StringBuffer();
            }
            if (sequenceId != null) {
                buf.append(sequenceId);
            }
            if (this.isOutputTargetOnResponse) {
                if (buf.length() != 0) {
                    buf.append(',');
                }
                buf.append(targetBuf);
            }
            if (this.isOutputMethodOnResponse) {
                if (buf.length() != 0) {
                    buf.append(',');
                }
                buf.append(methodBuf);
            }
            if (this.isOutputParameterOnResponse) {
                if (buf.length() != 0) {
                    buf.append(',');
                }
                buf.append(parameterBuf);
            }
            if (throwable == null && this.isOutputReturn) {
                if (buf.length() != 0) {
                    buf.append(',');
                }
                if (this.outputReturnProperties != null && this.outputReturnProperties.length != 0) {
                    buf.append('[');
                    for (int i4 = 0; i4 < this.outputReturnProperties.length; ++i4) {
                        Object prop = null;
                        try {
                            prop = this.propertyAccess.get(ret, this.outputReturnProperties[i4]);
                        }
                        catch (IllegalArgumentException e) {
                        }
                        catch (NoSuchPropertyException e) {
                        }
                        catch (InvocationTargetException e) {
                            // empty catch block
                        }
                        this.printObject(buf, prop);
                        if (i4 == this.outputReturnProperties.length - 1) continue;
                        buf.append(',');
                    }
                    buf.append(']');
                } else {
                    this.printObject(buf, ret);
                }
            }
            if (this.isOutputPerformance) {
                if (buf.length() != 0) {
                    buf.append(',');
                }
                buf.append(end - start);
            }
            if (throwable != null && this.isOutputThrowable) {
                this.getLogger().write(this.responseMessageId, (Object)buf.toString(), throwable);
            } else {
                this.getLogger().write(this.responseMessageId, (Object)buf.toString());
            }
        }
        return i3;
    }

    private StringBuffer printObject(StringBuffer buf, Object value) {
        if (value == null) {
            buf.append(value);
        } else if (value.getClass().isArray()) {
            buf.append('[');
            int imax = Array.getLength(value);
            for (int i = 0; i < imax; ++i) {
                this.printObject(buf, Array.get(value, i));
                if (i == imax - 1) continue;
                buf.append(',');
            }
            buf.append(']');
        } else if (value.getClass().isPrimitive() || value instanceof Boolean || value instanceof Number) {
            buf.append(value);
        } else {
            buf.append('\"').append(value).append('\"');
        }
        return buf;
    }
}

