/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import jp.ossc.nimbus.core.ArgumentMetaData;
import jp.ossc.nimbus.core.DeploymentException;
import jp.ossc.nimbus.core.MetaData;
import jp.ossc.nimbus.core.ObjectMetaData;
import jp.ossc.nimbus.core.Service;
import jp.ossc.nimbus.core.ServiceRefMetaData;
import jp.ossc.nimbus.core.StaticFieldRefMetaData;
import jp.ossc.nimbus.core.StaticInvokeMetaData;
import org.w3c.dom.Element;

public class InvokeMetaData
extends MetaData
implements Serializable {
    private static final long serialVersionUID = 3183679039637608032L;
    public static final String INVOKE_TAG_NAME = "invoke";
    public static final String TARGET_TAG_NAME = "target";
    protected static final String NAME_ATTRIBUTE_NAME = "name";
    protected static final String CALL_STATE_ATTRIBUTE_NAME = "callState";
    protected String name;
    protected final List arguments = new ArrayList();
    protected String callState = Service.STATES[1];
    protected int callStateValue = 1;
    protected MetaData target;

    public InvokeMetaData(MetaData parent) {
        super(parent);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public MetaData getTarget() {
        return this.target;
    }

    public void setTarget(MetaData target) {
        this.target = target;
    }

    public Collection getArguments() {
        return this.arguments;
    }

    public void addArgument(ArgumentMetaData arg) {
        this.arguments.add(arg);
    }

    public void removeArgument(ArgumentMetaData arg) {
        this.arguments.remove(arg);
    }

    public void clearArguments() {
        this.arguments.clear();
    }

    public String getCallState() {
        return this.callState;
    }

    public void setCallState(String state) throws IllegalArgumentException {
        boolean isMatch = false;
        for (int i = 0; i < Service.STATES.length; ++i) {
            if (!Service.STATES[i].equals(state)) continue;
            this.callStateValue = i;
            this.callState = state;
            isMatch = true;
            break;
        }
        if (!isMatch) {
            throw new IllegalArgumentException("illegal call state : " + state);
        }
    }

    public int getCallStateValue() {
        return this.callStateValue;
    }

    public void importXML(Element element) throws DeploymentException {
        Element targetElement;
        super.importXML(element);
        if (!element.getTagName().equals(INVOKE_TAG_NAME)) {
            throw new DeploymentException("Tag must be invoke : " + element.getTagName());
        }
        this.name = InvokeMetaData.getUniqueAttribute(element, NAME_ATTRIBUTE_NAME);
        Iterator argElements = InvokeMetaData.getChildrenByTagName(element, "argument");
        while (argElements.hasNext()) {
            ArgumentMetaData argData = new ArgumentMetaData(this, this.getParentObjectMetaData());
            argData.importXML((Element)argElements.next());
            this.addArgument(argData);
        }
        String callStateVal = InvokeMetaData.getOptionalAttribute(element, CALL_STATE_ATTRIBUTE_NAME);
        if (callStateVal != null) {
            this.setCallState(callStateVal);
        }
        if ((targetElement = InvokeMetaData.getOptionalChild(element, TARGET_TAG_NAME)) != null) {
            ObjectMetaData parentObjData = this.getParentObjectMetaData();
            Element targetObjElement = InvokeMetaData.getOptionalChild(targetElement, "object");
            if (targetObjElement != null) {
                ObjectMetaData objData = new ObjectMetaData(parentObjData.getServiceLoader(), this, parentObjData.getManagerName());
                objData.importXML(targetObjElement);
                this.target = objData;
                return;
            }
            targetObjElement = InvokeMetaData.getOptionalChild(targetElement, "service-ref");
            if (targetObjElement != null) {
                ServiceRefMetaData serviceRefData = new ServiceRefMetaData(this, parentObjData.getManagerName());
                serviceRefData.importXML(targetObjElement);
                this.target = serviceRefData;
                return;
            }
            targetObjElement = InvokeMetaData.getOptionalChild(targetElement, "static-field-ref");
            if (targetObjElement != null) {
                StaticFieldRefMetaData staticFieldData = new StaticFieldRefMetaData(this);
                staticFieldData.importXML(targetObjElement);
                this.target = staticFieldData;
                return;
            }
            targetObjElement = InvokeMetaData.getOptionalChild(targetElement, "static-invoke");
            if (targetObjElement != null) {
                StaticInvokeMetaData staticInvokeData = new StaticInvokeMetaData(this);
                staticInvokeData.importXML(targetObjElement);
                this.target = staticInvokeData;
                return;
            }
            targetObjElement = InvokeMetaData.getOptionalChild(targetElement, INVOKE_TAG_NAME);
            if (targetObjElement != null) {
                InvokeMetaData invokeData = new InvokeMetaData(this);
                invokeData.importXML(targetObjElement);
                if (invokeData.getTarget() == null) {
                    throw new DeploymentException("Target is null." + invokeData);
                }
                this.target = invokeData;
                return;
            }
        }
    }

    public StringBuffer toXML(StringBuffer buf) {
        this.appendComment(buf);
        buf.append('<').append(INVOKE_TAG_NAME);
        if (this.name != null) {
            buf.append(' ').append(NAME_ATTRIBUTE_NAME).append("=\"").append(this.name).append("\"");
        }
        if (this.callState != null) {
            buf.append(' ').append(CALL_STATE_ATTRIBUTE_NAME).append("=\"").append(this.callState).append("\"");
        }
        if (this.target == null && this.arguments.size() == 0) {
            buf.append("/>");
        } else {
            buf.append('>');
            if (this.target != null) {
                buf.append(LINE_SEPARATOR);
                buf.append('<').append(TARGET_TAG_NAME).append('>');
                buf.append(LINE_SEPARATOR);
                buf.append(this.addIndent(this.target.toXML(new StringBuffer())));
                buf.append(LINE_SEPARATOR);
                buf.append("</").append(TARGET_TAG_NAME).append('>');
            }
            if (this.arguments.size() != 0) {
                buf.append(LINE_SEPARATOR);
                int imax = this.arguments.size();
                for (int i = 0; i < imax; ++i) {
                    buf.append(this.addIndent(((MetaData)this.arguments.get(i)).toXML(new StringBuffer())));
                    if (i == imax - 1) continue;
                    buf.append(LINE_SEPARATOR);
                }
            }
            buf.append(LINE_SEPARATOR);
            buf.append("</").append(INVOKE_TAG_NAME).append('>');
        }
        return buf;
    }

    protected ObjectMetaData getParentObjectMetaData() {
        MetaData parent;
        for (parent = this.getParent(); parent != null && !(parent instanceof ObjectMetaData); parent = parent.getParent()) {
        }
        return (ObjectMetaData)parent;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(super.toString());
        buf.append('{');
        buf.append(NAME_ATTRIBUTE_NAME);
        buf.append('=');
        buf.append(this.getName());
        if (this.arguments.size() != 0) {
            buf.append(',');
            Iterator args = this.arguments.iterator();
            while (args.hasNext()) {
                buf.append(args.next());
                if (!args.hasNext()) continue;
                buf.append(',');
            }
        }
        buf.append('}');
        return buf.toString();
    }
}

