/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jp.ossc.nimbus.core.DeploymentException;
import jp.ossc.nimbus.core.ManagerMetaData;
import jp.ossc.nimbus.core.MetaData;
import jp.ossc.nimbus.core.ServerMetaData;
import jp.ossc.nimbus.core.ServiceLoaderConfig;
import jp.ossc.nimbus.core.ServiceManager;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.Utility;
import org.w3c.dom.Element;

public class IfDefMetaData
extends MetaData
implements Serializable {
    private static final long serialVersionUID = 6757362192453652302L;
    public static final String IFDEF_TAG_NAME = "ifdef";
    protected static final String NAME_ATTRIBUTE_NAME = "name";
    protected static final String VALUE_ATTRIBUTE_NAME = "value";
    protected String name;
    protected String value;
    protected List childrenMetaData = new ArrayList();
    protected transient Element element;
    protected transient ServiceManager manager;
    protected transient ServiceLoaderConfig loaderConfig;

    public IfDefMetaData(MetaData parent) {
        super(parent);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void addChild(MetaData data) {
        this.childrenMetaData.add(data);
    }

    public void removeChild(MetaData data) {
        this.childrenMetaData.remove(data);
    }

    public void clearChild() {
        this.childrenMetaData.clear();
    }

    public List getChildren() {
        return this.childrenMetaData;
    }

    public Element getElement() {
        return this.element;
    }

    public void setElement(Element element) {
        this.element = element;
    }

    public boolean isMatch() {
        String prop = Utility.getProperty(this.name, this.getServiceLoaderConfig(), this.getServiceManager(), this);
        return this.value.equals(prop);
    }

    protected ServiceManager getServiceManager() {
        if (this.manager != null) {
            return this.manager;
        }
        MetaData parent = this;
        while ((parent = parent.getParent()) != null && !(parent instanceof ManagerMetaData)) {
        }
        if (parent == null) {
            return null;
        }
        ManagerMetaData managerData = (ManagerMetaData)parent;
        this.manager = ServiceManagerFactory.findManager(managerData.getName());
        return this.manager;
    }

    protected ServiceLoaderConfig getServiceLoaderConfig() {
        if (this.loaderConfig != null) {
            return this.loaderConfig;
        }
        MetaData parent = this;
        while ((parent = parent.getParent()) != null && !(parent instanceof ServerMetaData)) {
        }
        if (parent == null) {
            return null;
        }
        ServerMetaData serverData = (ServerMetaData)parent;
        this.loaderConfig = serverData.getServiceLoader().getConfig();
        return this.loaderConfig;
    }

    public void importXML(Element element) throws DeploymentException {
        super.importXML(element);
        if (!element.getTagName().equals(IFDEF_TAG_NAME)) {
            throw new DeploymentException("Tag must be ifdef : " + element.getTagName());
        }
        this.name = IfDefMetaData.getUniqueAttribute(element, NAME_ATTRIBUTE_NAME);
        this.value = IfDefMetaData.getUniqueAttribute(element, VALUE_ATTRIBUTE_NAME);
        this.element = element;
    }

    public StringBuffer toXML(StringBuffer buf) {
        this.appendComment(buf);
        buf.append('<').append(IFDEF_TAG_NAME);
        buf.append(' ').append(NAME_ATTRIBUTE_NAME).append("=\"").append(this.name).append("\"");
        buf.append(' ').append(VALUE_ATTRIBUTE_NAME).append("=\"").append(this.value).append("\"");
        buf.append(">");
        if (this.childrenMetaData.size() != 0) {
            buf.append(LINE_SEPARATOR);
            Iterator datas = this.childrenMetaData.iterator();
            while (datas.hasNext()) {
                buf.append(this.addIndent(((MetaData)datas.next()).toXML(new StringBuffer())));
                if (!datas.hasNext()) continue;
                buf.append(LINE_SEPARATOR);
            }
        }
        buf.append(LINE_SEPARATOR);
        buf.append("</").append(IFDEF_TAG_NAME).append('>');
        return buf;
    }
}

