/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.core;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.ReflectionException;
import jp.ossc.nimbus.beans.NoSuchPropertyException;
import jp.ossc.nimbus.beans.Property;
import jp.ossc.nimbus.beans.PropertyFactory;
import jp.ossc.nimbus.beans.SimpleProperty;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceBaseMBean;
import jp.ossc.nimbus.core.ServiceBaseSupport;
import jp.ossc.nimbus.core.ServiceProxy;

public class GenericsServiceProxy
extends ServiceBase
implements DynamicMBean {
    private static final long serialVersionUID = -2723473573128599716L;
    private static final String MBEAN_SUFFIX = "MBean";
    private static final String MXBEAN_SUFFIX = "MXBean";
    protected Set constructorInfos = new HashSet();
    protected Map attributeInfos = new HashMap();
    protected Set operationInfos = new HashSet();
    protected MBeanInfo mbeanInfo;
    protected Map attributePropCache = new HashMap();
    static /* synthetic */ Class class$javax$management$DynamicMBean;

    public GenericsServiceProxy(ServiceBaseSupport support) throws Exception {
        super(support);
        this.initConstructors();
        this.initBaseAttributes();
        this.initBaseOperations();
        if (support != null) {
            Class mbeanInterface = GenericsServiceProxy.findMBeanInterface(support.getClass());
            if (mbeanInterface == null && support instanceof ServiceProxy) {
                mbeanInterface = GenericsServiceProxy.findMBeanInterface(((ServiceProxy)((Object)support)).getTarget().getClass());
            }
            if (mbeanInterface != null) {
                this.initAttributesOf(mbeanInterface, support.getClass());
                this.initOperationsOf(mbeanInterface, support.getClass());
            }
        }
        this.initMBeanInfo();
    }

    protected void initConstructors() throws Exception {
        Constructor<?>[] constructors = this.getClass().getConstructors();
        for (int i = 0; i < constructors.length; ++i) {
            if (constructors[i].getParameterTypes().length == 0) continue;
            this.constructorInfos.add(new MBeanConstructorInfo(null, constructors[i]));
        }
    }

    protected void initBaseAttributes() throws Exception {
        this.initAttributesOf(ServiceBaseMBean.class, this.getClass());
    }

    private boolean isDeclaredMethod(Method method, Class clazz) {
        try {
            Method decMethod = clazz.getMethod(method.getName(), method.getParameterTypes());
            if (Object.class.equals(decMethod.getDeclaringClass())) {
                return false;
            }
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        return true;
    }

    protected void initAttributesOf(Class mbeanInterface, Class target) throws Exception {
        SimpleProperty[] props = SimpleProperty.getProperties(target);
        for (int i = 0; i < props.length; ++i) {
            if (this.attributeInfos.containsKey(props[i].getPropertyName()) || (!props[i].isReadable(target) || !this.isDeclaredMethod(props[i].getReadMethod(target), mbeanInterface)) && (!props[i].isWritable(target) || !this.isDeclaredMethod(props[i].getWriteMethod(target), mbeanInterface))) continue;
            String propName = props[i].getPropertyName();
            if (Character.isLowerCase(propName.charAt(0))) {
                propName = propName.length() == 1 ? Character.toString(Character.toUpperCase(propName.charAt(0))) : Character.toUpperCase(propName.charAt(0)) + propName.substring(1);
            }
            this.attributeInfos.put(propName, new MBeanAttributeInfo(propName, null, props[i].isReadable(target) ? props[i].getReadMethod(target) : null, props[i].isWritable(target) ? props[i].getWriteMethod(target) : null));
        }
    }

    protected void initBaseOperations() throws Exception {
        this.initOperationsOf(ServiceBaseMBean.class, this.getClass());
    }

    protected void initOperationsOf(Class mbeanInterface, Class target) throws Exception {
        Method[] methods = mbeanInterface.getMethods();
        SimpleProperty[] props = SimpleProperty.getProperties(target);
        for (int i = 0; i < methods.length; ++i) {
            MBeanOperationInfo oprationInfo;
            Method method = methods[i];
            boolean isOperationMethod = true;
            for (int j = 0; j < props.length; ++j) {
                if (props[j].isReadable(target)) {
                    Method readMethod = props[j].getReadMethod(target);
                    if (method.getName().equals(readMethod.getName()) && readMethod.getParameterTypes().length == 0) {
                        isOperationMethod = false;
                        break;
                    }
                }
                if (!props[j].isWritable(target)) continue;
                Method writeMethod = props[j].getWriteMethod(target);
                if (!method.getName().equals(writeMethod.getName()) || writeMethod.getParameterTypes().length != 1 || !method.getParameterTypes()[0].equals(writeMethod.getParameterTypes()[0])) continue;
                isOperationMethod = false;
                break;
            }
            if (!isOperationMethod || this.operationInfos.contains(oprationInfo = new MBeanOperationInfo("", method = target.getMethod(method.getName(), method.getParameterTypes())))) continue;
            this.operationInfos.add(oprationInfo);
        }
    }

    protected void initMBeanInfo() {
        this.mbeanInfo = new MBeanInfo(this.getClass().getName(), null, this.attributeInfos.values().toArray(new MBeanAttributeInfo[this.attributeInfos.size()]), this.constructorInfos.toArray(new MBeanConstructorInfo[this.constructorInfos.size()]), this.operationInfos.toArray(new MBeanOperationInfo[this.operationInfos.size()]), new MBeanNotificationInfo[0]);
    }

    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        MBeanAttributeInfo attributeInfo = (MBeanAttributeInfo)this.attributeInfos.get(attribute);
        if (attributeInfo != null && attributeInfo.isReadable()) {
            Property prop = (Property)this.attributePropCache.get(attribute);
            if (prop == null) {
                prop = PropertyFactory.createProperty(attribute);
                this.attributePropCache.put(attribute, prop);
            }
            try {
                if (prop.isReadable(this)) {
                    return prop.getProperty(this);
                }
                if (this.support == null) {
                    return null;
                }
                if (prop.isReadable(this.support)) {
                    return prop.getProperty(this.support);
                }
                throw new AttributeNotFoundException(attribute);
            }
            catch (NoSuchPropertyException e) {
                throw new AttributeNotFoundException(attribute);
            }
            catch (InvocationTargetException e) {
                throw new ReflectionException(e);
            }
        }
        throw new AttributeNotFoundException(attribute);
    }

    public AttributeList getAttributes(String[] attributes) {
        AttributeList list = new AttributeList();
        for (int i = 0; i < attributes.length; ++i) {
            try {
                list.add(new Attribute(attributes[i], this.getAttribute(attributes[i])));
                continue;
            }
            catch (AttributeNotFoundException e) {
                continue;
            }
            catch (MBeanException e) {
                continue;
            }
            catch (ReflectionException e) {
                // empty catch block
            }
        }
        return list;
    }

    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        block9: {
            MBeanAttributeInfo attributeInfo = (MBeanAttributeInfo)this.attributeInfos.get(attribute.getName());
            if (attributeInfo != null && attributeInfo.isWritable()) {
                SimpleProperty prop = (SimpleProperty)PropertyFactory.createProperty(attribute.getName());
                try {
                    if (prop.isWritable(this.getClass())) {
                        try {
                            prop.setProperty(this, attribute.getValue());
                            break block9;
                        }
                        catch (InvocationTargetException e) {
                            throw new ReflectionException(e);
                        }
                    }
                    if (this.support == null) {
                        return;
                    }
                    try {
                        prop.setProperty(this.support, attribute.getValue());
                    }
                    catch (InvocationTargetException e) {
                        throw new ReflectionException(e);
                    }
                }
                catch (NoSuchPropertyException e) {
                    throw new AttributeNotFoundException("name=" + attribute.getName() + ", value=" + attribute.getValue());
                }
            }
        }
    }

    public AttributeList setAttributes(AttributeList attributes) {
        AttributeList list = new AttributeList();
        int max = attributes.size();
        for (int i = 0; i < max; ++i) {
            try {
                this.setAttribute((Attribute)attributes.get(i));
                list.add(attributes.get(i));
                continue;
            }
            catch (AttributeNotFoundException e) {
                continue;
            }
            catch (InvalidAttributeValueException e) {
                continue;
            }
            catch (MBeanException e) {
                continue;
            }
            catch (ReflectionException e) {
                // empty catch block
            }
        }
        return list;
    }

    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        Class[] paramTypes = null;
        if (signature != null) {
            paramTypes = new Class[signature.length];
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            try {
                for (int i = 0; i < signature.length; ++i) {
                    paramTypes[i] = Class.forName(signature[i], false, loader);
                }
            }
            catch (ClassNotFoundException e) {
                throw new ReflectionException(e);
            }
        }
        Method method = null;
        try {
            method = this.getClass().getMethod(actionName, paramTypes);
            return method.invoke((Object)this, params);
        }
        catch (NoSuchMethodException e) {
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException(e);
        }
        catch (InvocationTargetException e) {
            throw new ReflectionException(e);
        }
        if (this.support == null) {
            return null;
        }
        Object ret = null;
        try {
            method = this.support.getClass().getMethod(actionName, paramTypes);
            ret = method.invoke((Object)this.support, params);
        }
        catch (NoSuchMethodException e) {
            throw new ReflectionException(e);
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException(e);
        }
        catch (InvocationTargetException e) {
            throw new ReflectionException(e);
        }
        return ret;
    }

    public MBeanInfo getMBeanInfo() {
        return this.mbeanInfo;
    }

    private static Class findMBeanInterface(Class clazz) {
        if (clazz == null) {
            return null;
        }
        String className = clazz.getName();
        String mbeanInterfaceName = className + MBEAN_SUFFIX;
        Class<?>[] interfaces = clazz.getInterfaces();
        int max = interfaces.length;
        for (int i = 0; i < max; ++i) {
            if (!interfaces[i].equals(class$javax$management$DynamicMBean == null ? GenericsServiceProxy.class$("javax.management.DynamicMBean") : class$javax$management$DynamicMBean) && !interfaces[i].getName().equals(mbeanInterfaceName) && !interfaces[i].getName().endsWith(MXBEAN_SUFFIX)) continue;
            return interfaces[i];
        }
        return GenericsServiceProxy.findMBeanInterface(clazz.getSuperclass());
    }
}

