/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.beans.dataset;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import jp.ossc.nimbus.beans.dataset.DataSetException;
import jp.ossc.nimbus.beans.dataset.PropertyGetException;
import jp.ossc.nimbus.beans.dataset.PropertySchema;
import jp.ossc.nimbus.beans.dataset.PropertySchemaDefineException;
import jp.ossc.nimbus.beans.dataset.PropertyValidateException;
import jp.ossc.nimbus.beans.dataset.Record;
import jp.ossc.nimbus.beans.dataset.RecordSchema;
import jp.ossc.nimbus.service.codemaster.CodeMasterUpdateKey;
import jp.ossc.nimbus.service.codemaster.PartUpdate;
import jp.ossc.nimbus.service.codemaster.PartUpdateRecords;
import org.apache.commons.jexl.Expression;
import org.apache.commons.jexl.ExpressionFactory;
import org.apache.commons.jexl.JexlContext;
import org.apache.commons.jexl.JexlHelper;

public class RecordList
implements Externalizable,
List,
Cloneable,
PartUpdate {
    private static final long serialVersionUID = 6399184480196775369L;
    public static final String PRIMARY_KEY_INDEX_NAME = "$PRIMARY_KEY";
    protected String name;
    protected String schema;
    protected Class recordClass;
    protected RecordSchema recordSchema;
    protected List records = Collections.synchronizedList(new ArrayList());
    protected Map stockSearchConditionMap;
    protected Map stockSearchResultMap;
    protected Map stockSearchKeyMap;
    protected Map stockSearchKeyResultMap;
    protected int modCount = 0;
    protected int[] partUpdateOrderBy;
    protected boolean[] partUpdateIsAsc;

    public RecordList() {
    }

    public RecordList(String name) {
        this.name = name;
    }

    public RecordList(String name, String schema) throws PropertySchemaDefineException {
        this.name = name;
        this.setSchema(schema);
    }

    public RecordList(String name, RecordSchema schema) throws PropertySchemaDefineException {
        this.name = name;
        this.setRecordSchema(schema);
    }

    public RecordList(String name, Class clazz) throws PropertySchemaDefineException {
        this.name = name;
        this.setRecordClass(clazz);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSchema(String schema) throws PropertySchemaDefineException {
        this.setRecordSchema(RecordSchema.getInstance(schema));
    }

    public String getSchema() {
        return this.schema;
    }

    public void setRecordSchema(RecordSchema schema) throws PropertySchemaDefineException {
        if (this.size() != 0) {
            throw new PropertySchemaDefineException("Record already exists.");
        }
        this.recordSchema = schema;
        this.schema = schema == null ? null : schema.getSchema();
        ArrayList<String> primaryKeyNames = null;
        PropertySchema[] primaryKeys = this.recordSchema.getPrimaryKeyPropertySchemata();
        if (primaryKeys != null) {
            for (int i = 0; i < primaryKeys.length; ++i) {
                if (primaryKeyNames == null) {
                    primaryKeyNames = new ArrayList<String>();
                }
                primaryKeyNames.add(primaryKeys[i].getName());
            }
        }
        if (primaryKeyNames == null) {
            this.removeStockKey(PRIMARY_KEY_INDEX_NAME);
        } else {
            this.setStockKeySearch(PRIMARY_KEY_INDEX_NAME, primaryKeyNames.toArray(new String[primaryKeyNames.size()]));
        }
    }

    public void replaceSchema(String schema) throws PropertySchemaDefineException {
        this.replaceRecordSchema(RecordSchema.getInstance(schema));
    }

    public void replaceRecordSchema(RecordSchema schema) throws PropertySchemaDefineException {
        if (this.recordSchema != null && schema != null && this.size() != 0) {
            int imax = this.records.size();
            for (int i = 0; i < imax; ++i) {
                Record record = (Record)this.records.get(i);
                record.replaceRecordSchema(schema);
            }
        }
        this.setRecordSchema(schema);
    }

    public void appendSchema(String schema) throws PropertySchemaDefineException {
        if (this.recordSchema == null) {
            this.setSchema(schema);
        } else {
            this.replaceRecordSchema(this.recordSchema.appendSchema(schema));
        }
    }

    public RecordSchema getRecordSchema() {
        return this.recordSchema;
    }

    public void setRecordClass(Class clazz) throws PropertySchemaDefineException {
        Record record = null;
        try {
            record = (Record)clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new PropertySchemaDefineException(null, e);
        }
        catch (IllegalAccessException e) {
            throw new PropertySchemaDefineException(null, e);
        }
        catch (ClassCastException e) {
            throw new PropertySchemaDefineException(null, e);
        }
        this.setRecordSchema(record.getRecordSchema());
        this.recordClass = clazz;
    }

    public Class getRecordClass() {
        Class clazz = this.recordClass == null ? Record.class : this.recordClass;
        return clazz;
    }

    public Record createRecord() {
        if (this.recordClass == null) {
            return new Record(this.recordSchema);
        }
        try {
            return (Record)this.recordClass.newInstance();
        }
        catch (Exception e) {
            return new Record(this.recordSchema);
        }
    }

    public Record getRecord(int index) {
        return (Record)this.get(index);
    }

    public void addRecord(Record r) {
        this.add(r);
    }

    public void addRecord(int index, Record r) {
        this.add(index, r);
    }

    public Record setRecord(int index, Record r) {
        return (Record)this.set(index, r);
    }

    public void removeRecord(Record r) {
        this.remove(r);
    }

    public Record removeRecord(int index) {
        return (Record)this.remove(index);
    }

    public void setStockKeySearch(String name, String[] propertyNames) {
        if (this.recordSchema == null) {
            throw new DataSetException("Schema not initalize.");
        }
        int[] propertyIndexes = new int[propertyNames.length];
        for (int i = 0; i < propertyNames.length; ++i) {
            propertyIndexes[i] = this.recordSchema.getPropertyIndex(propertyNames[i]);
            if (propertyIndexes[i] != -1) continue;
            throw new DataSetException("No such property " + propertyNames[i]);
        }
        this.setStockKeySearch(name, propertyIndexes);
    }

    public void setStockKeySearch(String name, int[] propertyIndexes) {
        if (this.stockSearchKeyMap == null) {
            this.stockSearchKeyMap = Collections.synchronizedMap(new HashMap());
        }
        if (this.recordSchema == null) {
            throw new DataSetException("Schema not initalize.");
        }
        int fieldSize = this.recordSchema.getPropertySize();
        for (int i = 0; i < propertyIndexes.length; ++i) {
            if (propertyIndexes[i] < fieldSize) continue;
            throw new DataSetException("No such property " + propertyIndexes[i]);
        }
        RecordKeyCondition condition = new RecordKeyCondition(propertyIndexes);
        this.stockSearchKeyMap.put(name, condition);
        if (this.stockSearchKeyResultMap == null) {
            this.stockSearchKeyResultMap = Collections.synchronizedMap(new HashMap());
        } else {
            this.stockSearchKeyResultMap.remove(name);
        }
        if (this.size() != 0) {
            this.analyzeStockKey(name);
        }
    }

    public String[] getStockKeyNames() {
        return this.stockSearchKeyMap == null || this.stockSearchKeyMap.size() == 0 ? new String[]{} : this.stockSearchKeyMap.keySet().toArray(new String[this.stockSearchKeyMap.size()]);
    }

    public String[] getStockKeyPropertyNames(String name) {
        int[] indexes = this.getStockKeyPropertyIndexes(name);
        if (indexes == null || this.recordSchema == null) {
            return null;
        }
        String[] propNames = new String[indexes.length];
        for (int i = 0; i < indexes.length; ++i) {
            propNames[i] = this.recordSchema.getPropertyName(indexes[i]);
        }
        return propNames;
    }

    public int[] getStockKeyPropertyIndexes(String name) {
        if (this.stockSearchKeyMap == null || !this.stockSearchKeyMap.containsKey(name)) {
            return null;
        }
        RecordKeyCondition condition = (RecordKeyCondition)this.stockSearchKeyMap.get(name);
        return condition.propertyIndexes;
    }

    public void removeStockKey(String name) {
        if (this.stockSearchKeyMap != null) {
            this.stockSearchKeyMap.remove(name);
        }
        if (this.stockSearchKeyResultMap != null) {
            this.stockSearchKeyResultMap.remove(name);
        }
    }

    public void clearStockKey() {
        if (this.stockSearchKeyMap != null) {
            this.stockSearchKeyMap.clear();
        }
        if (this.stockSearchKeyResultMap != null) {
            this.stockSearchKeyResultMap.clear();
        }
    }

    public void setStockSearchCondition(String name, String condition) throws DataSetException {
        if (this.stockSearchConditionMap == null) {
            this.stockSearchConditionMap = Collections.synchronizedMap(new HashMap());
        }
        if (this.recordSchema == null) {
            throw new DataSetException("Schema not initalize.");
        }
        try {
            Expression exp = ExpressionFactory.createExpression((String)condition);
            this.stockSearchConditionMap.put(name, exp);
        }
        catch (Exception e) {
            throw new DataSetException(e);
        }
        if (this.stockSearchResultMap == null) {
            this.stockSearchResultMap = Collections.synchronizedMap(new HashMap());
        } else {
            this.stockSearchResultMap.remove(name);
        }
        if (this.size() != 0) {
            this.analyzeStockSearchCondition(name);
        }
    }

    public String[] getStockSearchConditionNames() {
        return this.stockSearchConditionMap == null || this.stockSearchConditionMap.size() == 0 ? new String[]{} : this.stockSearchConditionMap.keySet().toArray(new String[this.stockSearchConditionMap.size()]);
    }

    public String getStockSearchCondition(String name) {
        if (this.stockSearchConditionMap == null) {
            return null;
        }
        Expression exp = (Expression)this.stockSearchConditionMap.get(name);
        return exp == null ? null : exp.getExpression();
    }

    public void removeStockSearchCondition(String name) {
        if (this.stockSearchConditionMap != null) {
            this.stockSearchConditionMap.remove(name);
        }
        if (this.stockSearchResultMap != null) {
            this.stockSearchResultMap.remove(name);
        }
    }

    public void clearStockSearchCondition() {
        if (this.stockSearchConditionMap != null) {
            this.stockSearchConditionMap.clear();
        }
        if (this.stockSearchResultMap != null) {
            this.stockSearchResultMap.clear();
        }
    }

    public Record primaryKeySearch(Record key) {
        Record[] records = this.stockKeySearch(PRIMARY_KEY_INDEX_NAME, key);
        return records == null || records.length == 0 ? null : records[0];
    }

    public Record[] stockKeySearch(String name, Record key) {
        if (this.stockSearchKeyResultMap == null || this.stockSearchKeyResultMap.size() == 0) {
            return new Record[0];
        }
        Map map = (Map)this.stockSearchKeyResultMap.get(name);
        if (map == null) {
            return new Record[0];
        }
        RecordKeyCondition condition = (RecordKeyCondition)this.stockSearchKeyMap.get(name);
        if (condition == null) {
            return new Record[0];
        }
        Object recKey = condition.createKey(key);
        if (recKey == null) {
            return new Record[0];
        }
        List values = (List)map.get(recKey);
        if (values == null) {
            return new Record[0];
        }
        return values.toArray(new Record[values.size()]);
    }

    public RecordList stockSearch(String name) {
        RecordList clone = this.cloneSchema();
        if (this.stockSearchResultMap == null || this.stockSearchResultMap.size() == 0) {
            return clone;
        }
        List values = (List)this.stockSearchResultMap.get(name);
        if (values == null) {
            return clone;
        }
        clone.addAll((Collection)values);
        return clone;
    }

    public void analyzeStockSearchCondition(String name) throws DataSetException {
        if (this.size() == 0 || this.stockSearchConditionMap == null || this.stockSearchConditionMap.size() == 0 || !this.stockSearchConditionMap.containsKey(name)) {
            return;
        }
        Expression exp = (Expression)this.stockSearchConditionMap.get(name);
        ArrayList<Record> values = (ArrayList<Record>)this.stockSearchResultMap.get(name);
        if (values == null) {
            values = new ArrayList<Record>();
            this.stockSearchResultMap.put(name, values);
        }
        values.clear();
        try {
            int jmax = this.records.size();
            for (int j = 0; j < jmax; ++j) {
                Record record = (Record)this.records.get(j);
                JexlContext context = JexlHelper.createContext();
                int imax = this.recordSchema.getPropertySize();
                for (int i = 0; i < imax; ++i) {
                    PropertySchema prop = this.recordSchema.getPropertySchema(i);
                    String propName = prop.getName();
                    context.getVars().put(propName, record.getProperty(propName));
                }
                Object ret = exp.evaluate(context);
                if (!(ret instanceof Boolean)) {
                    throw new DataSetException("Illegal condition : " + exp.getExpression());
                }
                boolean isMatch = (Boolean)ret;
                if (!isMatch) continue;
                values.add(record);
            }
        }
        catch (DataSetException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DataSetException(e);
        }
    }

    public void analyzeStockKey(String name) throws DataSetException {
        if (this.size() == 0 || this.stockSearchKeyMap == null || this.stockSearchKeyMap.size() == 0 || !this.stockSearchKeyMap.containsKey(name)) {
            return;
        }
        RecordKeyCondition condition = (RecordKeyCondition)this.stockSearchKeyMap.get(name);
        Map map = (Map)this.stockSearchKeyResultMap.get(name);
        if (map == null) {
            map = Collections.synchronizedMap(new HashMap());
            this.stockSearchKeyResultMap.put(name, map);
        } else {
            map.clear();
        }
        boolean isPrimaryKeyIndex = PRIMARY_KEY_INDEX_NAME.equals(name);
        int imax = this.records.size();
        for (int i = 0; i < imax; ++i) {
            Record record = (Record)this.records.get(i);
            Object key = condition.createKey(record);
            if (key == null) continue;
            ArrayList<Record> values = (ArrayList<Record>)map.get(key);
            if (values == null) {
                values = new ArrayList<Record>();
                map.put(key, values);
            }
            if (isPrimaryKeyIndex && values.size() != 0) {
                throw new DataSetException("Duplicate primary key. " + key);
            }
            values.add(record);
        }
    }

    protected void stockSearchResult(Record record) throws DataSetException {
        if (this.stockSearchConditionMap == null || this.stockSearchConditionMap.size() == 0) {
            return;
        }
        if (this.recordSchema == null) {
            throw new DataSetException("Schema not initalize.");
        }
        try {
            Iterator entries = this.stockSearchConditionMap.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                String name = (String)entry.getKey();
                Expression exp = (Expression)entry.getValue();
                JexlContext context = JexlHelper.createContext();
                int imax = this.recordSchema.getPropertySize();
                for (int i = 0; i < imax; ++i) {
                    PropertySchema prop = this.recordSchema.getPropertySchema(i);
                    String propName = prop.getName();
                    context.getVars().put(propName, record.getProperty(propName));
                }
                Object ret = exp.evaluate(context);
                if (!(ret instanceof Boolean)) {
                    throw new DataSetException("Illegal condition : " + exp.getExpression());
                }
                boolean isMatch = (Boolean)ret;
                if (!isMatch) continue;
                ArrayList<Record> values = (ArrayList<Record>)this.stockSearchResultMap.get(name);
                if (values == null) {
                    values = new ArrayList<Record>();
                    this.stockSearchResultMap.put(name, values);
                }
                values.add(record);
            }
        }
        catch (DataSetException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DataSetException(e);
        }
    }

    protected void removeStockSearchResult(Record record) throws DataSetException {
        if (this.stockSearchResultMap == null || this.stockSearchResultMap.size() == 0) {
            return;
        }
        if (this.recordSchema == null) {
            throw new DataSetException("Schema not initalize.");
        }
        Iterator lists = this.stockSearchResultMap.values().iterator();
        while (lists.hasNext()) {
            List list = (List)lists.next();
            list.remove(record);
        }
    }

    protected void stockSearchKeyResult(Record record) throws DataSetException {
        if (this.stockSearchKeyMap == null || this.stockSearchKeyMap.size() == 0) {
            return;
        }
        if (this.recordSchema == null) {
            throw new DataSetException("Schema not initalize.");
        }
        Iterator entries = this.stockSearchKeyMap.entrySet().iterator();
        while (entries.hasNext()) {
            ArrayList<Record> values;
            Map.Entry entry = entries.next();
            String name = (String)entry.getKey();
            boolean isPrimaryKeyIndex = PRIMARY_KEY_INDEX_NAME.equals(name);
            RecordKeyCondition condition = (RecordKeyCondition)entry.getValue();
            Object key = condition.createKey(record);
            if (key == null) continue;
            Map map = (Map)this.stockSearchKeyResultMap.get(name);
            if (map == null) {
                map = Collections.synchronizedMap(new HashMap());
                this.stockSearchKeyResultMap.put(name, map);
            }
            if ((values = (ArrayList<Record>)map.get(key)) == null) {
                values = new ArrayList<Record>();
                map.put(key, values);
            }
            if (isPrimaryKeyIndex && values.size() != 0) {
                throw new DataSetException("Duplicate primary key. " + key);
            }
            values.add(record);
        }
    }

    protected void removeStockSearchKeyResult(Record record) throws DataSetException {
        if (this.stockSearchKeyMap == null || this.stockSearchKeyMap.size() == 0) {
            return;
        }
        if (this.recordSchema == null) {
            throw new DataSetException("Schema not initalize.");
        }
        Iterator entries = this.stockSearchKeyMap.entrySet().iterator();
        while (entries.hasNext()) {
            List values;
            Map map;
            Map.Entry entry = entries.next();
            String name = (String)entry.getKey();
            RecordKeyCondition condition = (RecordKeyCondition)entry.getValue();
            Object key = condition.createKey(record);
            if (key == null || (map = (Map)this.stockSearchKeyResultMap.get(name)) == null || (values = (List)map.get(key)) == null) continue;
            values.remove(record);
        }
    }

    public RecordList realSearch(String condition, Map valueMap) throws DataSetException {
        RecordList result = this.cloneSchema();
        if (this.size() == 0) {
            return result;
        }
        if (this.recordSchema == null) {
            throw new DataSetException("Schema not initalize.");
        }
        try {
            Expression exp = ExpressionFactory.createExpression((String)condition);
            JexlContext context = JexlHelper.createContext();
            int imax = this.size();
            for (int i = 0; i < imax; ++i) {
                Boolean ret;
                Record rd = this.getRecord(i);
                int jmax = this.recordSchema.getPropertySize();
                for (int j = 0; j < jmax; ++j) {
                    PropertySchema prop = this.recordSchema.getPropertySchema(j);
                    String propName = prop.getName();
                    context.getVars().put(propName, rd.getProperty(propName));
                }
                if (valueMap != null) {
                    context.getVars().putAll(valueMap);
                }
                if ((ret = (Boolean)exp.evaluate(context)) == null || !ret.booleanValue()) continue;
                result.add(rd);
            }
        }
        catch (Exception e) {
            throw new DataSetException(e);
        }
        return result;
    }

    public void sort(String[] orderBy) {
        this.sort(orderBy, null);
    }

    public static void sort(Record[] records, String[] orderBy) {
        RecordList.sort(records, orderBy, null);
    }

    public void sort(int[] orderBy) {
        this.sort(orderBy, null);
    }

    public static void sort(Record[] records, int[] orderBy) {
        RecordList.sort(records, orderBy, null);
    }

    public void sort(int[] orderBy, boolean[] isAsc) {
        if (this.records.size() < 2) {
            return;
        }
        Collections.sort(this.records, new RecordComparator(this.recordSchema, orderBy, isAsc));
    }

    public static void sort(Record[] records, int[] orderBy, boolean[] isAsc) {
        if (records == null || records.length < 2) {
            return;
        }
        Arrays.sort(records, new RecordComparator(records[0].getRecordSchema(), orderBy, isAsc));
    }

    public void sort(String[] orderBy, boolean[] isAsc) {
        if (this.records.size() < 2) {
            return;
        }
        Collections.sort(this.records, new RecordComparator(this.recordSchema, orderBy, isAsc));
    }

    public static void sort(Record[] records, String[] orderBy, boolean[] isAsc) {
        if (records == null || records.length < 2) {
            return;
        }
        Arrays.sort(records, new RecordComparator(records[0].getRecordSchema(), orderBy, isAsc));
    }

    public int size() {
        return this.records.size();
    }

    public boolean isEmpty() {
        return this.records.isEmpty();
    }

    public boolean contains(Object o) {
        return this.records.contains(o);
    }

    public Iterator iterator() {
        return new RecordIterator();
    }

    public ListIterator listIterator() {
        return this.listIterator(0);
    }

    public ListIterator listIterator(int index) {
        return new RecordListIterator(index);
    }

    public List subList(int fromIndex, int toIndex) {
        return this.records.subList(fromIndex, toIndex);
    }

    public Object[] toArray() {
        return this.records.toArray();
    }

    public Object[] toArray(Object[] a) {
        return this.records.toArray(a);
    }

    public boolean add(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof Record)) {
            throw new DataSetException("Not record : " + o);
        }
        boolean isAdd = this.records.add(o);
        try {
            this.stockSearchResult((Record)o);
            this.stockSearchKeyResult((Record)o);
        }
        catch (DataSetException e) {
            this.remove(o);
            throw e;
        }
        if (isAdd) {
            ++this.modCount;
        }
        return isAdd;
    }

    public void add(int index, Object element) {
        if (element == null) {
            return;
        }
        if (!(element instanceof Record)) {
            throw new DataSetException("Not record : " + element);
        }
        this.records.add(index, element);
        try {
            this.stockSearchResult((Record)element);
            this.stockSearchKeyResult((Record)element);
        }
        catch (DataSetException e) {
            this.remove(element);
            throw e;
        }
        ++this.modCount;
    }

    public Object set(int index, Object element) {
        Object old = null;
        if (index < this.size() && (old = (Object)this.records.get(index)) != null) {
            this.removeStockSearchResult((Record)old);
            this.removeStockSearchKeyResult((Record)old);
        }
        old = this.records.set(index, element);
        try {
            this.removeStockSearchResult((Record)old);
            this.stockSearchResult((Record)element);
            this.removeStockSearchKeyResult((Record)old);
            this.stockSearchKeyResult((Record)element);
        }
        catch (DataSetException e) {
            this.set(index, old);
            throw e;
        }
        return old;
    }

    public Object get(int index) {
        return this.records.get(index);
    }

    public int indexOf(Object o) {
        return this.records.indexOf(o);
    }

    public int lastIndexOf(Object o) {
        return this.records.lastIndexOf(o);
    }

    public boolean remove(Object o) {
        boolean isRemoved = this.records.remove(o);
        if (isRemoved) {
            this.removeStockSearchResult((Record)o);
            this.removeStockSearchKeyResult((Record)o);
            ++this.modCount;
        }
        return isRemoved;
    }

    public Object remove(int index) {
        Object old = this.records.remove(index);
        if (old != null) {
            this.removeStockSearchResult((Record)old);
            this.removeStockSearchKeyResult((Record)old);
            ++this.modCount;
        }
        return old;
    }

    public boolean containsAll(Collection c) {
        return this.records.containsAll(c);
    }

    public boolean addAll(Collection c) {
        if (c == null || c.size() == 0) {
            return false;
        }
        Object[] vals = c.toArray();
        boolean result = false;
        for (int i = 0; i < vals.length; ++i) {
            result |= this.add(vals[i]);
        }
        if (result) {
            ++this.modCount;
        }
        return result;
    }

    public boolean addAll(int index, Collection c) {
        if (c == null || c.size() == 0) {
            return false;
        }
        Object[] vals = c.toArray();
        int i = vals.length;
        while (--i >= 0) {
            this.add(index, vals[i]);
        }
        ++this.modCount;
        return true;
    }

    public boolean removeAll(Collection c) {
        boolean isRemoved = false;
        Iterator itr = c.iterator();
        while (itr.hasNext()) {
            isRemoved |= this.remove(itr.next());
        }
        if (isRemoved) {
            ++this.modCount;
        }
        return isRemoved;
    }

    public boolean retainAll(Collection c) {
        boolean isRemoved = false;
        Iterator itr = this.iterator();
        while (itr.hasNext()) {
            Object record = itr.next();
            if (c.contains(record)) continue;
            itr.remove();
            isRemoved = true;
        }
        if (isRemoved) {
            ++this.modCount;
        }
        return isRemoved;
    }

    public void clear() {
        this.records.clear();
        if (this.stockSearchResultMap != null) {
            this.stockSearchResultMap.clear();
        }
        if (this.stockSearchKeyResultMap != null) {
            this.stockSearchKeyResultMap.clear();
        }
        ++this.modCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trimToSize() {
        Class<?> clazz = null;
        try {
            clazz = Class.forName("java.util.Collections$SynchronizedCollection");
        }
        catch (ClassNotFoundException e) {
            return;
        }
        Object mutex = this.records;
        try {
            Field field = clazz.getDeclaredField("mutex");
            field.setAccessible(true);
            mutex = field.get(this.records);
        }
        catch (IllegalAccessException e) {
        }
        catch (NoSuchFieldException e) {
        }
        catch (SecurityException e) {
            // empty catch block
        }
        ArrayList list = null;
        try {
            Field field = clazz.getDeclaredField("c");
            field.setAccessible(true);
            list = (ArrayList)field.get(this.records);
        }
        catch (IllegalAccessException e) {
            return;
        }
        catch (NoSuchFieldException e) {
            return;
        }
        catch (SecurityException e) {
            return;
        }
        Object object = mutex;
        synchronized (object) {
            list.trimToSize();
        }
    }

    public boolean validate() throws PropertyGetException, PropertyValidateException {
        int imax = this.records.size();
        for (int i = 0; i < imax; ++i) {
            Record record = (Record)this.records.get(i);
            if (record.validate()) continue;
            return false;
        }
        return true;
    }

    public Object clone() {
        return this.cloneRecordList();
    }

    public RecordList cloneSchema() {
        RecordList clone = null;
        try {
            clone = (RecordList)super.clone();
            clone.modCount = 0;
            clone.records = Collections.synchronizedList(new ArrayList());
            if (this.stockSearchConditionMap != null && this.stockSearchConditionMap.size() != 0) {
                clone.stockSearchConditionMap = Collections.synchronizedMap(new HashMap());
                clone.stockSearchConditionMap.putAll(this.stockSearchConditionMap);
            }
            if (this.stockSearchKeyMap != null && this.stockSearchKeyMap.size() != 0) {
                clone.stockSearchKeyMap = Collections.synchronizedMap(new HashMap());
                clone.stockSearchKeyMap.putAll(this.stockSearchKeyMap);
            }
            if (this.partUpdateOrderBy != null) {
                clone.partUpdateOrderBy = new int[this.partUpdateOrderBy.length];
                System.arraycopy(this.partUpdateOrderBy, 0, clone.partUpdateOrderBy, 0, this.partUpdateOrderBy.length);
            }
            if (this.partUpdateIsAsc != null) {
                clone.partUpdateIsAsc = new boolean[this.partUpdateIsAsc.length];
                System.arraycopy(this.partUpdateIsAsc, 0, clone.partUpdateIsAsc, 0, this.partUpdateIsAsc.length);
            }
            if (clone.stockSearchResultMap != null) {
                clone.stockSearchResultMap = Collections.synchronizedMap(new HashMap());
            }
            if (clone.stockSearchKeyResultMap != null) {
                clone.stockSearchKeyResultMap = Collections.synchronizedMap(new HashMap());
            }
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
        return clone;
    }

    public RecordList cloneRecordList() {
        RecordList recList = this.cloneSchema();
        if (this.size() == 0) {
            return recList;
        }
        for (int i = 0; i < this.records.size(); ++i) {
            Record rec = ((Record)this.records.get(i)).cloneRecord();
            recList.addRecord(rec);
        }
        return recList;
    }

    public void setPartUpdateSort(String[] orderBy, boolean[] isAsc) {
        int[] propertyIndexes = new int[orderBy.length];
        for (int i = 0; i < orderBy.length; ++i) {
            propertyIndexes[i] = this.recordSchema.getPropertyIndex(orderBy[i]);
            if (propertyIndexes[i] != -1) continue;
            throw new DataSetException("No such property " + orderBy[i]);
        }
        this.setPartUpdateSort(propertyIndexes, isAsc);
    }

    public void setPartUpdateSort(int[] orderBy, boolean[] isAsc) {
        if (orderBy == null || orderBy.length == 0) {
            throw new DataSetException("Property index array is empty.");
        }
        if (isAsc != null && orderBy.length != isAsc.length) {
            throw new DataSetException("Length of property index array and sort flag array is unmatch.");
        }
        int fieldSize = this.recordSchema.getPropertySize();
        for (int i = 0; i < orderBy.length; ++i) {
            if (orderBy[i] < fieldSize) continue;
            throw new DataSetException("No such property " + orderBy[i]);
        }
        this.partUpdateOrderBy = orderBy;
        this.partUpdateIsAsc = isAsc;
    }

    public PartUpdateRecords createPartUpdateRecords(PartUpdateRecords records, int updateType, boolean containsValue) throws DataSetException {
        if (records == null) {
            records = new PartUpdateRecords();
        }
        int imax = this.records.size();
        for (int i = 0; i < imax; ++i) {
            Record record = (Record)this.records.get(i);
            CodeMasterUpdateKey key = record.createCodeMasterUpdateKey();
            key.setUpdateType(updateType);
            if (containsValue) {
                records.addRecord(key, record);
                continue;
            }
            records.addRecord(key);
        }
        return records;
    }

    public PartUpdateRecords fillPartUpdateRecords(CodeMasterUpdateKey key) {
        PartUpdateRecords records = new PartUpdateRecords();
        records.addRecord(key);
        return this.fillPartUpdateRecords(records);
    }

    public PartUpdateRecords fillPartUpdateRecords(PartUpdateRecords records) {
        if (records == null || records.size() == 0 || !records.containsAdd() && !records.containsUpdate()) {
            return records;
        }
        records.setFilledRecord(true);
        Record rec = this.createRecord();
        CodeMasterUpdateKey[] keys = records.getKeyArray();
        for (int i = 0; i < keys.length; ++i) {
            CodeMasterUpdateKey key = keys[i];
            int updateType = key.getUpdateType();
            records.removeRecord(key);
            rec.setCodeMasterUpdateKey(key);
            key = rec.createCodeMasterUpdateKey(key);
            key.setUpdateType(updateType);
            if (key.isRemove()) {
                records.addRecord(key);
                continue;
            }
            Record searchRec = this.primaryKeySearch(rec);
            records.addRecord(key, searchRec);
        }
        return records;
    }

    public PartUpdate cloneAndUpdate(PartUpdateRecords records) {
        RecordList newRecList = this.cloneSchema();
        CodeMasterUpdateKey tmpKey = new CodeMasterUpdateKey();
        CodeMasterUpdateKey key = null;
        int imax = this.records.size();
        block6: for (int i = 0; i < imax; ++i) {
            Record oldRecord = (Record)this.records.get(i);
            tmpKey = oldRecord.createCodeMasterUpdateKey(tmpKey);
            key = records == null ? null : records.getKey(tmpKey);
            Record newRecord = null;
            if (key == null) {
                newRecord = oldRecord.cloneRecord();
            } else {
                switch (key.getUpdateType()) {
                    case 1: 
                    case 2: {
                        newRecord = (Record)records.removeRecord(key);
                        break;
                    }
                    default: {
                        records.removeRecord(key);
                        continue block6;
                    }
                }
            }
            if (newRecord == null) continue;
            newRecList.addRecord(newRecord);
        }
        if (records != null && records.size() != 0) {
            Iterator itr = records.getRecords().entrySet().iterator();
            while (itr.hasNext()) {
                Map.Entry entry = itr.next();
                switch (((CodeMasterUpdateKey)entry.getKey()).getUpdateType()) {
                    case 1: 
                    case 2: {
                        Record record = (Record)entry.getValue();
                        if (record == null) break;
                        newRecList.addRecord(record);
                        break;
                    }
                }
            }
        }
        if (this.partUpdateOrderBy != null && this.partUpdateOrderBy.length != 0) {
            newRecList.sort(this.partUpdateOrderBy, this.partUpdateIsAsc);
        }
        return newRecList;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        Map.Entry entry;
        Iterator entries;
        out.writeObject(this.name);
        out.writeObject(this.schema);
        out.writeObject(this.recordClass);
        if (this.stockSearchConditionMap == null || this.stockSearchConditionMap.size() == 0) {
            out.writeInt(0);
        } else {
            out.writeInt(this.stockSearchConditionMap.size());
            entries = this.stockSearchConditionMap.entrySet().iterator();
            while (entries.hasNext()) {
                entry = entries.next();
                out.writeObject(entry.getKey());
                out.writeObject(entry.getValue());
            }
        }
        if (this.stockSearchKeyMap == null || this.stockSearchKeyMap.size() == 0) {
            out.writeInt(0);
        } else {
            out.writeInt(this.stockSearchKeyMap.size());
            entries = this.stockSearchKeyMap.entrySet().iterator();
            while (entries.hasNext()) {
                entry = entries.next();
                out.writeObject(entry.getKey());
                out.writeObject(entry.getValue());
            }
        }
        out.writeObject(this.partUpdateOrderBy);
        out.writeObject(this.partUpdateIsAsc);
        out.writeInt(this.records.size());
        int imax = this.records.size();
        for (int i = 0; i < imax; ++i) {
            Record record = (Record)this.records.get(i);
            record.writeExternalValues(out);
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int i;
        int size;
        this.name = (String)in.readObject();
        this.schema = (String)in.readObject();
        this.recordClass = (Class)in.readObject();
        if (this.schema != null) {
            this.recordSchema = RecordSchema.getInstance(this.schema);
        }
        if ((size = in.readInt()) > 0) {
            this.stockSearchConditionMap = Collections.synchronizedMap(new HashMap());
            for (i = 0; i < size; ++i) {
                this.stockSearchConditionMap.put(in.readObject(), in.readObject());
            }
        }
        if (this.stockSearchConditionMap != null) {
            this.stockSearchResultMap = Collections.synchronizedMap(new HashMap());
        }
        if ((size = in.readInt()) > 0) {
            this.stockSearchKeyMap = Collections.synchronizedMap(new HashMap());
            for (i = 0; i < size; ++i) {
                this.stockSearchKeyMap.put(in.readObject(), in.readObject());
            }
        }
        if (this.stockSearchKeyMap != null) {
            this.stockSearchKeyResultMap = Collections.synchronizedMap(new HashMap());
        }
        this.partUpdateOrderBy = (int[])in.readObject();
        this.partUpdateIsAsc = (boolean[])in.readObject();
        int recSize = in.readInt();
        this.records = Collections.synchronizedList(new ArrayList());
        if (this.recordSchema != null) {
            for (int i2 = 0; i2 < recSize; ++i2) {
                Record record = this.createRecord();
                record.readExternalValues(in);
                this.addRecord(record);
            }
        }
    }

    protected static class RecordKeyCondition
    implements Serializable {
        private static final long serialVersionUID = 2501333319162543622L;
        protected String[] propertyNames;
        protected int[] propertyIndexes;

        public RecordKeyCondition(String[] names) {
            this.propertyNames = names;
        }

        public RecordKeyCondition(int[] indexes) {
            this.propertyIndexes = indexes;
        }

        public Object createKey(Record record) {
            ArrayList<Object> key = null;
            if (this.propertyNames != null) {
                for (int i = 0; i < this.propertyNames.length; ++i) {
                    Object val = null;
                    try {
                        val = record.getProperty(this.propertyNames[i]);
                    }
                    catch (PropertyGetException e) {
                        key = null;
                        break;
                    }
                    if (key == null) {
                        key = new ArrayList<Object>();
                    }
                    key.add(val);
                }
                return key;
            }
            if (this.propertyIndexes != null) {
                for (int i = 0; i < this.propertyIndexes.length; ++i) {
                    Object val = null;
                    try {
                        val = record.getProperty(this.propertyIndexes[i]);
                    }
                    catch (PropertyGetException e) {
                        key = null;
                        break;
                    }
                    if (key == null) {
                        key = new ArrayList();
                    }
                    key.add(val);
                }
                return key;
            }
            return key;
        }
    }

    protected static class RecordComparator
    implements Comparator {
        private String[] propNames;
        private boolean[] isAsc;
        private final RecordSchema recordSchema;

        public RecordComparator(RecordSchema schema, String[] propNames) {
            this(schema, propNames, null);
        }

        public RecordComparator(RecordSchema schema, String[] propNames, boolean[] isAsc) {
            this.recordSchema = schema;
            if (this.recordSchema == null) {
                throw new IllegalArgumentException("Schema not initalize.");
            }
            if (propNames == null || propNames.length == 0) {
                throw new IllegalArgumentException("Property name array is empty.");
            }
            if (isAsc != null && propNames.length != isAsc.length) {
                throw new IllegalArgumentException("Length of property index array and sort flag array is unmatch.");
            }
            this.propNames = propNames;
            this.isAsc = isAsc;
        }

        public RecordComparator(RecordSchema schema, int[] propIndexes) {
            this(schema, propIndexes, null);
        }

        public RecordComparator(RecordSchema schema, int[] propIndexes, boolean[] isAsc) {
            this.recordSchema = schema;
            if (this.recordSchema == null) {
                throw new IllegalArgumentException("Schema not initalize.");
            }
            if (propIndexes == null || propIndexes.length == 0) {
                throw new IllegalArgumentException("Property name array is empty.");
            }
            if (isAsc != null && propIndexes.length != isAsc.length) {
                throw new IllegalArgumentException("Length of column name array and sort flag array is unmatch.");
            }
            this.propNames = new String[propIndexes.length];
            for (int i = 0; i < propIndexes.length; ++i) {
                this.propNames[i] = this.recordSchema.getPropertyName(propIndexes[i]);
                if (this.propNames != null) continue;
                throw new IllegalArgumentException("Property not found : " + propIndexes[i]);
            }
            if (this.propNames == null || this.propNames.length == 0) {
                throw new IllegalArgumentException("Property name array is empty.");
            }
            this.isAsc = isAsc;
        }

        public int compare(Object o1, Object o2) {
            Record rd1 = (Record)o1;
            Record rd2 = (Record)o2;
            if (rd1 == null && rd2 == null) {
                return 0;
            }
            if (rd1 != null && rd2 == null) {
                return 1;
            }
            if (rd1 == null && rd2 != null) {
                return -1;
            }
            for (int i = 0; i < this.propNames.length; ++i) {
                Object val1 = rd1.getProperty(this.propNames[i]);
                Object val2 = rd2.getProperty(this.propNames[i]);
                if (val1 != null && val2 == null) {
                    return this.isAsc == null || this.isAsc[i] ? 1 : -1;
                }
                if (val1 == null && val2 != null) {
                    return this.isAsc == null || this.isAsc[i] ? -1 : 1;
                }
                if (val1 == null || val2 == null) continue;
                int comp = 0;
                comp = val1 instanceof Comparable ? ((Comparable)val1).compareTo(val2) : val1.hashCode() - val2.hashCode();
                if (comp == 0) continue;
                return this.isAsc == null || this.isAsc[i] ? comp : -1 * comp;
            }
            return 0;
        }
    }

    protected class RecordListIterator
    extends RecordIterator
    implements ListIterator {
        private static final long serialVersionUID = 1979810413080499078L;

        public RecordListIterator(int index) {
            this.cursor = index;
        }

        public boolean hasPrevious() {
            return this.cursor != 0;
        }

        public Object previous() {
            this.checkForComodification();
            try {
                int i = this.cursor - 1;
                Object previous = RecordList.this.get(i);
                this.lastRet = this.cursor = i;
                return previous;
            }
            catch (IndexOutOfBoundsException e) {
                this.checkForComodification();
                throw new NoSuchElementException();
            }
        }

        public int nextIndex() {
            return this.cursor;
        }

        public int previousIndex() {
            return this.cursor - 1;
        }

        public void set(Object o) {
            if (this.lastRet == -1) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            try {
                RecordList.this.set(this.lastRet, o);
                this.expectedModCount = RecordList.this.modCount;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }

        public void add(Object o) {
            this.checkForComodification();
            try {
                RecordList.this.add(this.cursor++, o);
                this.lastRet = -1;
                this.expectedModCount = RecordList.this.modCount;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }
    }

    protected class RecordIterator
    implements Iterator,
    Serializable {
        private static final long serialVersionUID = 200743372396432511L;
        protected int cursor = 0;
        protected int lastRet = -1;
        protected int expectedModCount;

        protected RecordIterator() {
            this.expectedModCount = RecordList.this.modCount;
        }

        public boolean hasNext() {
            return this.cursor != RecordList.this.size();
        }

        public Object next() {
            this.checkForComodification();
            try {
                Object next = RecordList.this.get(this.cursor);
                this.lastRet = this.cursor++;
                return next;
            }
            catch (IndexOutOfBoundsException e) {
                this.checkForComodification();
                throw new NoSuchElementException();
            }
        }

        public void remove() {
            if (this.lastRet == -1) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            try {
                RecordList.this.remove(this.lastRet);
                if (this.lastRet < this.cursor) {
                    --this.cursor;
                }
                this.lastRet = -1;
                this.expectedModCount = RecordList.this.modCount;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }

        final void checkForComodification() {
            if (RecordList.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

