/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.beans;

import java.beans.PropertyEditorSupport;
import java.io.Serializable;
import jp.ossc.nimbus.beans.Utility;

public class DoubleEditor
extends PropertyEditorSupport
implements Serializable {
    private static final long serialVersionUID = -978067745105543491L;

    public void setAsText(String text) {
        if (text == null) {
            this.setValue(null);
            return;
        }
        this.setValue(new Double(DoubleEditor.toDouble(text, true)));
    }

    public static final double toDouble(String text, boolean replace) throws NumberFormatException {
        String str = replace ? Utility.replaceSystemProperty(text) : text;
        double doubleValue = 0.0;
        try {
            doubleValue = Double.parseDouble(str);
        }
        catch (NumberFormatException e) {
            if ("MAX_VALUE".equals(str)) {
                doubleValue = Double.MAX_VALUE;
            }
            if ("MIN_VALUE".equals(str)) {
                doubleValue = Double.MIN_VALUE;
            }
            if ("NaN".equals(str)) {
                doubleValue = Double.NaN;
            }
            if ("NEGATIVE_INFINITY".equals(str)) {
                doubleValue = Double.NEGATIVE_INFINITY;
            }
            if ("POSITIVE_INFINITY".equals(str)) {
                doubleValue = Double.POSITIVE_INFINITY;
            }
            throw e;
        }
        return doubleValue;
    }

    public String getAsText() {
        Double val = (Double)this.getValue();
        return val == null ? null : val.toString();
    }
}

