package jp.ossc.nimbus.service.scheduler2.sample;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;

import javax.servlet.http.HttpServletRequest;

/**
 * ʃNX
 *
 */
public class CommonMethod {

    /** HttpServletRequest */
    private HttpServletRequest mRequest = null;
    /** JDBCRlNV */
    private Connection mConnection = null;

    /**
     * @return connection ߂܂B
     */
    public Connection getConnection() {
        return mConnection;
    }
    /**
     * @param connection connection ݒB
     */
    public void setConnection(Connection connection) {
        mConnection = connection;
    }

    /**
     * @return request ߂܂B
     */
    public HttpServletRequest getRequest() {
        return mRequest;
    }
    /**
     * @param request request ݒB
     */
    public void setRequest(HttpServletRequest request) {
        mRequest = request;
    }


    protected void close(Object jdbcObject){
        if (jdbcObject == null) {
            return;
        }

        if (jdbcObject instanceof Statement) {
            try
            {
                ((Statement)jdbcObject).close();
            }
            catch(Exception exception) {}
        }
        else if(jdbcObject instanceof ResultSet) {
            try
            {
                ((ResultSet)jdbcObject).close();
            }
            catch(Exception exception) {}
        }
        else if(jdbcObject instanceof Connection) {
            try
            {
                ((Connection)jdbcObject).close();
            }
            catch(Exception exception) {}
        }
    }

    /**
     * ID茎̑1ڂƍŏI̓tZo
     * @param month
     * @return String[] 0Ԗڂ1ړtA1ԖڂŏIt
     */
    public static String[] calcMonth(String inMonth){

        return calcMonth(inMonth, 0);
    }

    public static String[] calcMonth(String inMonth, int amount){

        Calendar cal = Calendar.getInstance() ;
        SimpleDateFormat sp = new SimpleDateFormat(FormatUtil.DATE_FORMAT_PATTERN_DATE8) ;
        String[] ret = new String[2] ;
        int year = Integer.parseInt(inMonth.substring(0,4)) ;
        int month = Integer.parseInt(inMonth.substring(4,6)) ;

        //̊Jn擾
        cal.set(year,month-1,1) ;

        java.util.Date d = cal.getTime() ;
        ret[0] = sp.format(d) ;

        //wԌ̌̏I擾
        cal.add(Calendar.MONTH, amount);
        cal.set(cal.get(Calendar.YEAR),cal.get(Calendar.MONTH),cal.getActualMaximum(Calendar.DATE)) ;
        d = cal.getTime() ;
        ret[1] = sp.format(d) ;

        return ret ;
    }

    /**
     * NN̑1ڂƍŏI̓tZo
     * @param year
     * @return String[] 0Ԗڂ1ړtA1ԖڂŏIt
     */
    public static String[] calcYear(String inYear){
        Calendar cal = Calendar.getInstance() ;
        SimpleDateFormat sp = new SimpleDateFormat(FormatUtil.DATE_FORMAT_PATTERN_DATE8) ;
        String[] ret = new String[2] ;
        int year = Integer.parseInt(inYear.substring(0,4)) ;

        //N̊Jn擾
        cal.set(year,0,1) ;

        java.util.Date d = cal.getTime() ;
        ret[0] = sp.format(d) ;

        //̏I擾
        cal.set(year,11,31) ;
        d = cal.getTime() ;
        ret[1] = sp.format(d) ;

        return ret ;
    }

}
