package jp.ossc.nimbus.service.scheduler2.sample;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.TreeSet;

import jp.ossc.nimbus.service.scheduler2.sample.CommonMethod;
import jp.ossc.nimbus.service.scheduler2.sample.FormatUtil;
import jp.ossc.nimbus.service.scheduler2.*;

/**
 *
 */
public class Scheduler extends CommonMethod {

    private static final long serialVersionUID = -5631968449305297257L;

    private ScheduleManager scheduleManager = null;

    public ScheduleManager getScheduleManager() {
        return scheduleManager;
    }

    public void setScheduleManager(ScheduleManager scheduleManager) {
        this.scheduleManager = scheduleManager;
    }

    /**
     * XPW[gꗗ擾܂B
     * @return HashMap
     * @throws Exception
     */
    public HashMap getScheduleTrns() throws Exception{

        String tid = getRequest().getParameter("tid");

        if (tid != null && tid.length() > 0) {
            HashMap out = getRelatedScheduleTrns();
            if (out != null) return out;
        }

        String param_from = getRequest().getParameter("from");
        String param_from_date = getRequest().getParameter("from_date");
        String param_from_time = getRequest().getParameter("from_time");
        String param_to = getRequest().getParameter("to");
        String param_to_date = getRequest().getParameter("to_date");
        String param_to_time = getRequest().getParameter("to_time");
        String param_range = getRequest().getParameter("range");

        if (param_from == null) {
            if (param_from_date != null) param_from = param_from_date;
            if (param_from_time != null) param_from += param_from_time;
        }

        if (param_to == null) {
            if (param_to_date != null) param_to = param_to_date;
            if (param_to_time != null) param_to += param_to_time;
        }

        // Jn
        Date date_from = null;
        if (param_from != null && param_from.length() > 0) {
            param_from = param_from.replaceAll("[^\\d]", "");
            for (int i=param_from.length(); i<=14; i++) {
                param_from += "0";
            }
            date_from = FormatUtil.toDate(FormatUtil.DATE_FORMAT_PATTERN_DATE8_TIME6, param_from);
        }
        if (date_from == null) {
            // ݎ
            Calendar cal_tmp = Calendar.getInstance();
            cal_tmp.set(Calendar.MINUTE, 0);
            cal_tmp.set(Calendar.SECOND, 0);
            cal_tmp.set(Calendar.MILLISECOND, 0);
            date_from = cal_tmp.getTime();
        }

        // I
        Date date_to = null;
        if (param_to != null && param_to.length() > 0) {
            param_to = param_to.replaceAll("[^\\d]", "");
            for (int i=param_to.length(); i<=14; i++) {
                param_to += "0";
            }
            date_to = FormatUtil.toDate(FormatUtil.DATE_FORMAT_PATTERN_DATE8_TIME6, param_to);
        }
        if (date_to == null) {
            // Ԃ͈̔
            int cal_range = 2;
            try {
                cal_range = Integer.parseInt(param_range);
            } catch (Exception e){
            }

            Calendar cal_tmp = Calendar.getInstance();
            cal_tmp.setTime(date_from);
            cal_tmp.add(Calendar.HOUR, cal_range);
            date_to = cal_tmp.getTime();
        }

        // XPW[g擾
        List schedules = scheduleManager.findSchedules(date_from, date_to);

        // ߋ̐IĂȂgǉ
        int state[] = {
                Schedule.STATE_ABORT,
                Schedule.STATE_ENTRY,
                Schedule.STATE_FAILED,
                Schedule.STATE_INITIAL,
                Schedule.STATE_PAUSE,
                Schedule.STATE_RUN,
                Schedule.STATE_RETRY
            };

        Date date_old = new Date();
        date_old.setTime(date_from.getTime()-1);

        List schedules2 = scheduleManager.findSchedules(null, date_old, state);
        schedules.addAll(schedules2);
        Collections.sort(schedules);

        // 
        String param_str = getRequest().getParameter("str");
        if (param_str != null && param_str.trim().length() > 0) {
            param_str = param_str.replaceAll("@", " ");
            String[] strs = param_str.trim().split(" ");

            List schedules_tmp = new ArrayList();
            for (int i=0; i<schedules.size(); i++) {
                Schedule schedule = (Schedule)schedules.get(i);

                int cnt = 0;
                for(int j=0; j<strs.length; j++) {
                    String s = strs[j];
                    if (schedule.getMasterId().toLowerCase().indexOf(s.toLowerCase()) >= 0) {
                        cnt++;
                    }
                }

                if (cnt == strs.length) {
                    schedules_tmp.add(schedule);
                }
            }
            schedules = schedules_tmp;
        }

        // response
        HashMap outMap = new HashMap();

        outMap.put("schdule",schedules);
        outMap.put("date_from", date_from);
        outMap.put("date_to", date_to);

        return outMap;
    }

    /**
     * ֘AXPW[g擾܂B
     * @return HashMap
     * @throws Exception
     */
    public HashMap getRelatedScheduleTrns() throws Exception{

        String tid = getRequest().getParameter("tid");
        String rcr = getRequest().getParameter("rcr");
        boolean f_rcr = rcr == null ? false : true;

        // XPW[g擾
        Schedule schedule = scheduleManager.findSchedule(tid);
        if (schedule == null) return null;

        List schedules = new ArrayList();
        schedules.add(schedule);

        // O24Ԃ̈ˑ擾
        Date date_from = new Date(schedule.getTime().getTime() - 86400 * 1000);
        Date date_to = new Date(schedule.getTime().getTime() + 86400 * 1000);

        // ˑXPW[ǉ
        List parents = getDependSchedules(schedule, date_from, f_rcr);
        schedules.addAll(parents);
        List children = getDependedSchedules(schedule, date_to, f_rcr);
        schedules.addAll(children);

        // \[g
        Collections.sort(schedules);
        date_from.setTime(((Schedule)schedules.get(0)).getTime().getTime());
        date_to.setTime(((Schedule)schedules.get(schedules.size()-1)).getTime().getTime());

        // Jniȉ؂̂āj
        date_from.setTime(date_from.getTime() - date_from.getTime() % (60 * 60 * 1000));
        // Iiȉ؂グj
        date_to.setTime(date_to.getTime() + 3600 * 1000 - date_to.getTime() % (60 * 60 * 1000));

        // response
        HashMap outMap = new HashMap();

        outMap.put("schdule",schedules);
        outMap.put("date_from", date_from);
        outMap.put("date_to", date_to);

        return outMap;
    }

    /**
     * ˑĂXPW[擾܂
     */
    private List getDependSchedules(Schedule schedule, Date from, boolean f_recu) throws Exception {

        List schedules = new ArrayList();

        // ˑĂXPW[
        String[] parent_ids = schedule.getDepends();
        if (parent_ids == null) return schedules;

        for (int i = 0;i < parent_ids.length; i++){
            String parent_id= parent_ids[i];
            List parents = scheduleManager.findSchedules(from, schedule.getTime(), null, parent_id);
            schedules.addAll(parents);

            // ċA
            if (f_recu) {
                for (int j=0; j<parents.size(); j++) {
                    Schedule parent = (Schedule)parents.get(j);
                    List parents2 = getDependSchedules(parent, from, f_recu);
                    schedules.addAll(parents2);
                }
            }
        }

        // }X^[IDňӂɂ
        LinkedHashMap map = new LinkedHashMap();
        for (int i=0; i<schedules.size(); i++) {
            Schedule sch = (Schedule)schedules.get(i);
            map.put(sch.getMasterId(), sch);
        }
        schedules = new ArrayList(map.values());

        return schedules;
    }

    /**
     * ˑĂXPW[擾܂
     */
    private List getDependedSchedules(Schedule schedule, Date to, boolean f_recu) throws Exception {

        ArrayList schedules = new ArrayList();

        // ˑĂXPW[
        List children = scheduleManager.findDependedSchedules(schedule.getId());
        if (children == null) return schedules;

        for (int i = 0;i < children.size(); i++){
            Schedule child = (Schedule)children.get(i);

            if (child.getTime().getTime() < schedule.getTime().getTime() || child.getTime().getTime() > to.getTime()) {
                continue;
            }
            schedules.add(child);

            // ċA
            if (f_recu) {
                List rec = getDependedSchedules(child, to, f_recu);
                schedules.addAll(rec);
            }
        }

        // }X^[IDňӂɂ
        LinkedHashMap map = new LinkedHashMap();
        for (int i=0; i<schedules.size(); i++) {
            Schedule sch = (Schedule)schedules.get(i);
            map.put(sch.getMasterId(), sch);
        }
        schedules = new ArrayList(map.values());

        return schedules;
    }

    /**
     * XPW[}X^擾܂B
     * @return HashMap
     * @throws Exception
     */
    public HashMap getScheduleMaster() throws Exception {

        String master_id = getRequest().getParameter("mid");

        // XPW[}X^
        ScheduleMaster master = getScheduleMaster(master_id);
        // XPW[g
        List schedules    = getScheduleTrnByMasterId(master_id);
        // sXPW[
        TreeSet depends1 = getDependSchedules(schedules);
        // 㑱XPW[
        TreeSet depends2 = getDependedSchedules(schedules);

        // response
        HashMap outMap = new HashMap();

        outMap.put("master", master);
        outMap.put("trans", schedules);
        outMap.put("depends1", depends1);
        outMap.put("depends2", depends2);

        return outMap;
    }

    /**
     * XPW[g擾܂B
     * @param master_id
     * @return ArrayList
     * @throws Exception
     */
    public List getScheduleTrnByMasterId(String master_id) throws Exception {

        List schedules = scheduleManager.findSchedules(master_id);
        Collections.sort(schedules);

        int max = 100; // 擾g̍ő吔

        if (schedules.size() > max) {
            // ~ōő匏܂
            schedules = new ArrayList(schedules.subList(schedules.size()-max, schedules.size()));
        }

        return schedules;
    }

    /**
     * XPW[}X^擾܂B
     * @param master_id
     * @return ScheduleMaster
     * @throws Exception
     */
    private ScheduleMaster getScheduleMaster(String master_id) throws Exception {

        ScheduleMaster master = scheduleManager.findScheduleMaster(master_id);

        return master;
    }

    /**
     * sXPW[擾܂B
     * @param master_id
     * @return TreeSet XPW[}X^ID
     * @throws Exception
     */
    private TreeSet getDependSchedules(List schedules) throws Exception {

        TreeSet set = new TreeSet();

        for(int i=0;i<schedules.size();i++){
            Schedule sch = (DefaultSchedule)schedules.get(i);

            // ˑĂXPW[
            String[] id = sch.getDepends();

            if(id != null){
                for(int j=0;j<id.length;j++){
                    set.add(id[j]);
                }
            }
        }

        return set;
    }

    /**
     * 㑱XPW[擾܂B
     * @param master_id
     * @return TreeSet XPW[}X^ID
     * @throws Exception
     */
    private TreeSet getDependedSchedules(List schedules) throws Exception {

        TreeSet set = new TreeSet();

        for (int i = 0;i < schedules.size();i++){
            Schedule schedule = (DefaultSchedule)schedules.get(i);

            if (schedule == null){
                break;
            }

            // ˑĂXPW[
            List dependedSchedules = scheduleManager.findDependedSchedules(schedule.getId());

            for (int j = 0;j < dependedSchedules.size();j++){
                Schedule dependsSchedule = (DefaultSchedule)dependedSchedules.get(j);

                if (dependsSchedule == null){
                    break;
                }

                set.add(dependsSchedule.getMasterId());
            }
        }

        return set;
    }

    /**
     * XPW[}X^擾܂B
     * @param master_id
     * @return ScheduleMaster
     * @throws Exception
     */
    public HashMap getScheduleMasters() throws Exception {

        // response
        HashMap outMap = new HashMap();

        // XPW[}X^擾
        List masters = scheduleManager.findAllScheduleMasters();

        if (masters != null){
            Collections.sort(masters);
        }

        outMap.put("masters", masters);

        String param_date = getRequest().getParameter("date");
        String param_term = getRequest().getParameter("term");

        int terms = 7;
        if (param_term != null) {
            try {
                terms = Integer.parseInt(param_term);
            } catch (Exception e) {}
        }

        ArrayList actHead = new ArrayList();
        HashMap actMap = new HashMap();
        HashMap actTmp = new HashMap();

        for (int i = 0; i < masters.size(); i++){
            ScheduleMaster master = (DefaultScheduleMaster)masters.get(i);
            ScheduleMaker maker = scheduleManager.getScheduleMaker(master.getScheduleType());
            ArrayList actList = new ArrayList();

            // wԕ[v
            Calendar cal_tmp = Calendar.getInstance();
            for (int j = 0; j < terms; j++){
                Date date = cal_tmp.getTime();

                // tꗗɒǉ
                if (i==0) {
                    actHead.add(date);
                }

                // s۔
                Boolean result = Boolean.FALSE;
                String actTmpKey = master.getScheduleType() + "-" + FormatUtil.format(FormatUtil.DATE_FORMAT_PATTERN_DATE8, date);
                if (actTmp.get(actTmpKey) == null) {
                    if (maker == null) {
                        result = Boolean.TRUE;
                    } else {
                        Schedule[] sche = maker.makeSchedule(date, master);
                        result = ( sche.length > 0 ? Boolean.TRUE : Boolean.FALSE);
                    }
                    actTmp.put(actTmpKey, result);
                } else {
                    result = (Boolean) actTmp.get(actTmpKey);
                }
                actList.add(result);

                cal_tmp.add(Calendar.DATE, 1);
            }

            actMap.put(master.getId(), actList);
       }

        outMap.put("actHead", actHead);
        outMap.put("actMap",  actMap);

        return outMap;
    }

    /**
     * XPW[g擾܂B
     * @return HashMap
     * @throws Exception
     */
    public HashMap getScheduleTrn() throws Exception{

        String tid = getRequest().getParameter("tid");

        // XPW[g擾
        Schedule schedule = scheduleManager.findSchedule(tid);

        // response
        HashMap outMap = new HashMap();

        outMap.put("schedule", schedule);

        return outMap;
    }

    /**
     * XPW[gύX܂B
     * @return String
     * @throws Exception
     */
    public String updateScheduleTrn() throws Exception{

        String[] id = getRequest().getParameterValues("id");

        String state = getRequest().getParameter("state");
        try {
            if (id != null && state != null) {
                int st = Integer.parseInt(state);
                for (int i=0; i<id.length; i++) {
                    scheduleManager.changeState(id[i], st);
                }
            }
        } catch (Exception e){
            System.out.println(e);
        }

        String contrlState = getRequest().getParameter("ctrl_state");
        try {
            if (id != null && contrlState != null) {
                int st = Integer.parseInt(contrlState);
                for (int i=0; i<id.length; i++) {
                    scheduleManager.changeControlState(id[i], st);
                }
            }
        } catch (Exception e){
            System.out.println(e);
        }

        String executorKey = getRequest().getParameter("exec_key");
        try {
            if (id != null && executorKey != null) {
                for (int i=0; i<id.length; i++) {
                    scheduleManager.setExecutorKey(id[i], executorKey);
                }
            }
        } catch (Exception e){
            System.out.println(e);
        }

        String referer = getRequest().getParameter("referer");
        if (referer == null) referer = getRequest().getHeader("referer");

        return referer;
    }

    /**
     * XPW[g폜܂B
     * @return HashMap
     * @throws Exception
     */
    public HashMap deleteScheduleTrn() throws Exception{

        String[] id = getRequest().getParameterValues("id");

        try {
            if (id != null) {
                for (int i=0; i<id.length; i++) {
                    scheduleManager.removeSchedule(id[i]);
                }
            }
        } catch (Exception e){
            System.out.println(e);
        }

        return getScheduleTrns();
    }
}
