
import java.io.*;

import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.service.publish.ServerConnectionFactory;
import jp.ossc.nimbus.service.publish.RequestServerConnection;
import jp.ossc.nimbus.service.publish.Message;
import jp.ossc.nimbus.service.publish.MessageReceiver;
import jp.ossc.nimbus.service.publish.RequestMessageListener;
import jp.ossc.nimbus.service.publish.MessageException;
import jp.ossc.nimbus.util.WaitSynchronizeMonitor;

/**
 * TvVsNXB
 */
public class Main{
    
    public static final void main(String[] args){
        
        // T[rX`t@C[h
        if(ServiceManagerFactory.loadManager("service-definition.xml")){
            System.out.println("T[rX`̓ǂݍ݂ɐ܂B");
            
            System.out.println("ʐM肪NAM郁bZ[W͂ĉB");
            
            // T[rX擾
            ServerConnectionFactory factory
                 = (ServerConnectionFactory)ServiceManagerFactory
                    .getServiceObject("RequestConnectionFactory");
            
            MessageReceiver receiver = (MessageReceiver)ServiceManagerFactory
                    .getServiceObject("RequestConnectionFactory");
            
            try{
                MyRequestMessageListener listener = new MyRequestMessageListener();
                
                Thread thread = new Thread(listener);
                thread.start();
                
                // Xi[o^
                receiver.addSubject(listener, "hoge");
                
                // T[oRlNV擾
                RequestServerConnection connection = (RequestServerConnection)factory.getServerConnection();
                
                while(true){
                    if(!listener.requestMonitor.initAndWaitMonitor(1000l)){
                        continue;
                    }
                    // bZ[W𐶐
                    Message message = connection.createMessage("hoge", null);
                    message.setObject(listener.line);
                    
                    // bZ[W𑗐M
                    Message[] responses = connection.request(message, 0, 60000l);
                    System.out.print("receive reply>");
                    for(int i = 0; i < responses.length; i++){
                        System.out.print(responses[i].getObject());
                        if(i != responses.length - 1){
                            System.out.print(", ");
                        }
                    }
                    System.out.println();
                    System.out.print("request<");
                }
            }catch(Exception e){
                e.printStackTrace();
            }
        }else{
            System.out.println("T[rX`̓ǂݍ݂Ɏs܂B");
        }
        
        // T[rX`t@CA[h
        ServiceManagerFactory.unloadManager("service-definition.xml");
    }
    
    private static class MyRequestMessageListener implements RequestMessageListener, Runnable{
        
        public String line;
        public WaitSynchronizeMonitor requestMonitor = new WaitSynchronizeMonitor();
        public WaitSynchronizeMonitor replyMonitor = new WaitSynchronizeMonitor();
        
        public void run(){
            BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
            try{
                System.out.print("request<");
                while((line = br.readLine()) != null){
                    if(replyMonitor.isWait()){
                        replyMonitor.notifyMonitor();
                    }else{
                        requestMonitor.notifyMonitor();
                    }
                }
            }catch(Exception e){e.printStackTrace();}
        }
        
        public void onMessage(Message message){
        }
        
        public Object onRequestMessage(Message message){
            try{
                System.out.println();
                System.out.println("receive request>" + message.getObject());
            }catch(MessageException e){}
            System.out.print("reply<");
            try{
                replyMonitor.initAndWaitMonitor();
                return line;
            }catch(InterruptedException e){
                return e.toString();
            }finally{
                replyMonitor.releaseMonitor();
            }
        }
    }
}