
import java.io.IOException;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.BufferedReader;

import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.service.ftp.FTPClientFactory;
import jp.ossc.nimbus.service.ftp.FTPClient;

/**
 * TvPsNXB
 */
public class Main{
    
    public static final void main(String[] args) throws IOException{
        
        // T[rX`t@C[h
        if(ServiceManagerFactory.loadManager("service-definition.xml")){
            System.out.println("T[rX`̓ǂݍ݂ɐ܂B");
            
            // T[rX擾
            final FTPClientFactory factory = (FTPClientFactory)ServiceManagerFactory.getServiceObject("FTPClientFactory");
            
            // NCAg𐶐
            final FTPClient client = factory.createFTPClient();
            try{
                // eLXgt@C[Jɍ쐬
                FileOutputStream fos = new FileOutputStream("put_test.txt");
                fos.write("test".getBytes());
                fos.close();
                
                // FTPT[õt@C̈ꗗ擾
                System.out.println("T[õt@Cꗗ");
                String[] fileNames = client.ls();
                for(int i = 0 ; i < fileNames.length; i++){
                    System.out.println(fileNames[i]);
                }
                System.out.println();
                
                // FTPT[oɃt@C]
                waitInput("T[oɃt@C]܂");
                client.put("put_test.txt", "test.txt");
                System.out.println("T[oɃt@C]܂");
                
                // FTPT[õt@C̈ꗗ擾
                System.out.println("T[õt@Cꗗ");
                fileNames = client.ls();
                for(int i = 0 ; i < fileNames.length; i++){
                    System.out.println(fileNames[i]);
                }
                System.out.println();
                
                // FTPT[ot@C擾
                waitInput("T[ot@C擾܂");
                client.get("test.txt", "get_test.txt");
                System.out.println("T[ot@C擾܂");
                
                // FTPT[õt@C폜
                waitInput("T[ot@C폜܂");
                client.delete("test.txt");
                System.out.println("T[ot@C폜܂");
                
                // FTPT[õt@C̈ꗗ擾
                System.out.println("T[õt@Cꗗ");
                fileNames = client.ls();
                for(int i = 0 ; i < fileNames.length; i++){
                    System.out.println(fileNames[i]);
                }
                System.out.println();
            }finally{
                // NCAgI
                client.close();
            }
        }else{
            System.out.println("T[rX`̓ǂݍ݂Ɏs܂B");
        }
        
        // T[rX`t@CA[h
        ServiceManagerFactory.unloadManager("service-definition.xml");
    }
    
    private static final void waitInput(String message) throws IOException{
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        do{
            System.out.println(message + " (y/n)");
            final String line = br.readLine();
            if("y".equalsIgnoreCase(line)){
                break;
            }else if("n".equalsIgnoreCase(line)){
                System.exit(0);
            }
        }while(true);
    }
}