/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.util.converter;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import jp.ossc.nimbus.util.converter.ConvertException;
import jp.ossc.nimbus.util.converter.FormatConverter;

public class DateFormatConverter
implements FormatConverter {
    private static final long serialVersionUID = -1183874197480695923L;
    public static final int DATE_FROM_STRING = 1;
    public static final int STRING_FROM_DATE = 2;
    protected int convertType;
    protected String format;

    public DateFormatConverter() {
        this(1, "yyyy/MM/dd HH:mm:ss.SSS");
    }

    public DateFormatConverter(int type, String format) {
        this.convertType = type;
        this.format = format;
        new SimpleDateFormat(format);
    }

    public void setConvertType(int type) {
        this.convertType = type;
    }

    public int getConvertType() {
        return this.convertType;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getFormat() {
        return this.format;
    }

    public Object convert(Object obj) throws ConvertException {
        switch (this.convertType) {
            case 1: {
                if (obj == null) {
                    return "";
                }
                return new SimpleDateFormat(this.format).format(obj);
            }
            case 2: {
                if (obj == null || ((String)obj).length() == 0) {
                    return null;
                }
                try {
                    return new SimpleDateFormat(this.format).parse((String)obj);
                }
                catch (ParseException e) {
                    throw new ConvertException(e);
                }
            }
        }
        throw new ConvertException("Invalid convert type : " + this.convertType);
    }
}

