/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.resource.datasource;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import jp.ossc.nimbus.service.resource.datasource.NimbusResultSet;
import jp.ossc.nimbus.service.resource.datasource.NimbusStatement;

public class NimbusPreparedStatement
extends NimbusStatement
implements PreparedStatement {
    private static final long serialVersionUID = 560537306692881035L;
    protected String originalSql;
    protected String[] originalSqlSeps;
    protected boolean bEndIsQuestion;
    protected HashMap mParameterMap = new HashMap();
    protected PreparedStatement mStatement;

    private String getCurrentSql() {
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < this.originalSqlSeps.length; ++i) {
            buff.append(this.originalSqlSeps[i]);
            if (!this.bEndIsQuestion && i == this.originalSqlSeps.length - 1) continue;
            buff.append("[");
            Object ob = this.mParameterMap.get(new Integer(i + 1));
            buff.append(ob);
            buff.append("]");
        }
        return buff.toString();
    }

    public NimbusPreparedStatement(PreparedStatement statement, String prepareSql) {
        super(statement);
        this.mStatement = statement;
        this.originalSql = prepareSql;
        boolean isStartQ = false;
        boolean isEndQ = false;
        int addItems = 0;
        if (this.originalSql.indexOf("\\?") == 0) {
            isStartQ = true;
            ++addItems;
        }
        if (this.originalSql.lastIndexOf("\\?") + 1 == this.originalSql.length()) {
            isEndQ = true;
            ++addItems;
        }
        String[] seps = this.originalSql.split("\\?");
        this.originalSqlSeps = new String[seps.length + addItems];
        int currentIndex = 0;
        if (isStartQ) {
            System.arraycopy(new String[]{""}, 0, this.originalSqlSeps, currentIndex++, 1);
        }
        System.arraycopy(seps, 0, this.originalSqlSeps, currentIndex, seps.length);
        currentIndex += seps.length;
        if (isEndQ) {
            System.arraycopy(new String[]{""}, 0, this.originalSqlSeps, currentIndex++, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate() throws SQLException {
        int n;
        long startTime = 0L;
        long endTime = 0L;
        String sqlID = null;
        if (this.journalService != null) {
            sqlID = this.getSequenceNo();
            this.journalService.addInfo(sqlID, (Object)this.getCurrentSql(), this.journalLevel);
        }
        startTime = System.currentTimeMillis();
        try {
            n = this.mStatement.executeUpdate();
            Object var8_5 = null;
        }
        catch (Throwable throwable) {
            block6: {
                Object var8_6 = null;
                endTime = System.currentTimeMillis();
                if (this.performanceService != null) {
                    this.performanceService.entry(this.originalSql, endTime - startTime);
                }
                if (this.journalService == null) break block6;
                this.journalService.addInfo(sqlID + ":Performance", (Object)(new Long(endTime - startTime) + "[ms]"), this.journalLevel);
            }
            throw throwable;
        }
        endTime = System.currentTimeMillis();
        if (this.performanceService != null) {
            this.performanceService.entry(this.originalSql, endTime - startTime);
        }
        if (this.journalService != null) {
            this.journalService.addInfo(sqlID + ":Performance", (Object)(new Long(endTime - startTime) + "[ms]"), this.journalLevel);
        }
        return n;
    }

    public void addBatch() throws SQLException {
        this.mStatement.addBatch();
        if (this.journalService != null) {
            this.mBatchArray.add(this.getCurrentSql());
        }
    }

    public void clearParameters() throws SQLException {
        this.mStatement.clearParameters();
        if (this.journalService != null) {
            this.mParameterMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute() throws SQLException {
        boolean bl;
        long startTime = 0L;
        long endTime = 0L;
        String sqlID = null;
        if (this.journalService != null) {
            sqlID = this.getSequenceNo();
            this.journalService.addInfo(sqlID, (Object)this.getCurrentSql(), this.journalLevel);
        }
        startTime = System.currentTimeMillis();
        try {
            bl = this.mStatement.execute();
            Object var8_5 = null;
        }
        catch (Throwable throwable) {
            block6: {
                Object var8_6 = null;
                endTime = System.currentTimeMillis();
                if (this.performanceService != null) {
                    this.performanceService.entry(this.originalSql, endTime - startTime);
                }
                if (this.journalService == null) break block6;
                this.journalService.addInfo(sqlID + ":Performance", (Object)(new Long(endTime - startTime) + "[ms]"), this.journalLevel);
            }
            throw throwable;
        }
        endTime = System.currentTimeMillis();
        if (this.performanceService != null) {
            this.performanceService.entry(this.originalSql, endTime - startTime);
        }
        if (this.journalService != null) {
            this.journalService.addInfo(sqlID + ":Performance", (Object)(new Long(endTime - startTime) + "[ms]"), this.journalLevel);
        }
        return bl;
    }

    public void setByte(int arg0, byte arg1) throws SQLException {
        if (this.journalService != null) {
            this.mParameterMap.put(new Integer(arg0), new Byte(arg1));
        }
        this.mStatement.setByte(arg0, arg1);
    }

    public void setDouble(int arg0, double arg1) throws SQLException {
        if (this.journalService != null) {
            this.mParameterMap.put(new Integer(arg0), new Double(arg1));
        }
        this.mStatement.setDouble(arg0, arg1);
    }

    public void setFloat(int arg0, float arg1) throws SQLException {
        if (this.journalService != null) {
            this.mParameterMap.put(new Integer(arg0), new Float(arg1));
        }
        this.mStatement.setFloat(arg0, arg1);
    }

    public void setInt(int arg0, int arg1) throws SQLException {
        if (this.journalService != null) {
            this.mParameterMap.put(new Integer(arg0), new Integer(arg1));
        }
        this.mStatement.setInt(arg0, arg1);
    }

    public void setNull(int arg0, int arg1) throws SQLException {
        if (this.journalService != null) {
            this.mParameterMap.put(new Integer(arg0), null);
        }
        this.mStatement.setNull(arg0, arg1);
    }

    public void setLong(int arg0, long arg1) throws SQLException {
        if (this.journalService != null) {
            this.mParameterMap.put(new Integer(arg0), new Long(arg1));
        }
        this.mStatement.setLong(arg0, arg1);
    }

    public void setShort(int arg0, short arg1) throws SQLException {
        if (this.journalService != null) {
            this.mParameterMap.put(new Integer(arg0), new Short(arg1));
        }
        this.mStatement.setShort(arg0, arg1);
    }

    public void setBoolean(int arg0, boolean arg1) throws SQLException {
        if (this.journalService != null) {
            this.mParameterMap.put(new Integer(arg0), new Boolean(arg1));
        }
        this.mStatement.setBoolean(arg0, arg1);
    }

    public void setBytes(int arg0, byte[] arg1) throws SQLException {
        if (this.journalService != null) {
            this.mParameterMap.put(new Integer(arg0), arg1);
        }
        this.mStatement.setBytes(arg0, arg1);
    }

    public void setAsciiStream(int arg0, InputStream arg1, int arg2) throws SQLException {
        if (this.journalService != null) {
            this.mParameterMap.put(new Integer(arg0), arg1);
        }
        this.mStatement.setAsciiStream(arg0, arg1, arg2);
    }

    public void setBinaryStream(int arg0, InputStream arg1, int arg2) throws SQLException {
        if (this.journalService != null) {
            this.mParameterMap.put(new Integer(arg0), arg1);
        }
        this.mStatement.setBinaryStream(arg0, arg1, arg2);
    }

    public void setUnicodeStream(int arg0, InputStream arg1, int arg2) throws SQLException {
        if (this.journalService != null) {
            this.mParameterMap.put(new Integer(arg0), arg1);
        }
        this.mStatement.setUnicodeStream(arg0, arg1, arg2);
    }

    public void setCharacterStream(int arg0, Reader arg1, int arg2) throws SQLException {
        this.mStatement.setCharacterStream(arg0, arg1, arg2);
    }

    public void setObject(int arg0, Object arg1) throws SQLException {
        if (this.journalService != null) {
            this.mParameterMap.put(new Integer(arg0), arg1);
        }
        this.mStatement.setObject(arg0, arg1);
    }

    public void setObjectOrNull(int arg0, Object arg1, int dataType) throws SQLException {
        if (arg1 != null) {
            this.mStatement.setObject(arg0, arg1);
        } else {
            this.mStatement.setNull(arg0, dataType);
        }
    }

    public void setObject(int arg0, Object arg1, int arg2) throws SQLException {
        if (this.journalService != null) {
            this.mParameterMap.put(new Integer(arg0), arg1);
        }
        this.mStatement.setObject(arg0, arg1, arg2);
    }

    public void setObject(int arg0, Object arg1, int arg2, int arg3) throws SQLException {
        if (this.journalService != null) {
            this.mParameterMap.put(new Integer(arg0), arg1);
        }
        this.mStatement.setObject(arg0, arg1, arg2, arg3);
    }

    public void setNull(int arg0, int arg1, String arg2) throws SQLException {
        if (this.journalService != null) {
            this.mParameterMap.put(new Integer(arg0), null);
        }
        this.mStatement.setNull(arg0, arg1, arg2);
    }

    public void setString(int arg0, String arg1) throws SQLException {
        if (this.journalService != null) {
            this.mParameterMap.put(new Integer(arg0), arg1);
        }
        this.mStatement.setString(arg0, arg1);
    }

    public void setBigDecimal(int arg0, BigDecimal arg1) throws SQLException {
        if (this.journalService != null) {
            this.mParameterMap.put(new Integer(arg0), arg1);
        }
        this.mStatement.setBigDecimal(arg0, arg1);
    }

    public void setURL(int arg0, URL arg1) throws SQLException {
        if (this.journalService != null) {
            this.mParameterMap.put(new Integer(arg0), arg1);
        }
        this.mStatement.setURL(arg0, arg1);
    }

    public void setArray(int arg0, Array arg1) throws SQLException {
        if (this.journalService != null) {
            this.mParameterMap.put(new Integer(arg0), arg1);
        }
        this.mStatement.setArray(arg0, arg1);
    }

    public void setBlob(int arg0, Blob arg1) throws SQLException {
        if (this.journalService != null) {
            this.mParameterMap.put(new Integer(arg0), arg1);
        }
        this.mStatement.setBlob(arg0, arg1);
    }

    public void setClob(int arg0, Clob arg1) throws SQLException {
        if (this.journalService != null) {
            this.mParameterMap.put(new Integer(arg0), arg1);
        }
        this.mStatement.setClob(arg0, arg1);
    }

    public void setDate(int arg0, Date arg1) throws SQLException {
        if (this.journalService != null) {
            this.mParameterMap.put(new Integer(arg0), arg1);
        }
        this.mStatement.setDate(arg0, arg1);
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        return this.mStatement.getParameterMetaData();
    }

    public void setRef(int arg0, Ref arg1) throws SQLException {
        if (this.journalService != null) {
            this.mParameterMap.put(new Integer(arg0), arg1);
        }
        this.mStatement.setRef(arg0, arg1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet executeQuery() throws SQLException {
        long startTime = 0L;
        long endTime = 0L;
        String sqlID = null;
        if (this.journalService != null) {
            sqlID = this.getSequenceNo();
            this.journalService.addInfo(sqlID, (Object)this.getCurrentSql(), this.journalLevel);
        }
        NimbusResultSet ret = null;
        startTime = System.currentTimeMillis();
        try {
            ResultSet tmp = this.mStatement.executeQuery();
            ret = new NimbusResultSet(tmp);
            this.mResultSetList.add(ret);
            Object var9_6 = null;
        }
        catch (Throwable throwable) {
            Object var9_7 = null;
            endTime = System.currentTimeMillis();
            if (this.performanceService != null) {
                this.performanceService.entry(this.originalSql, endTime - startTime);
            }
            if (this.journalService != null) {
                this.journalService.addInfo(sqlID + ":Performance", (Object)(new Long(endTime - startTime) + "[ms]"), this.journalLevel);
            }
            throw throwable;
        }
        endTime = System.currentTimeMillis();
        if (this.performanceService != null) {
            this.performanceService.entry(this.originalSql, endTime - startTime);
        }
        if (this.journalService != null) {
            this.journalService.addInfo(sqlID + ":Performance", (Object)(new Long(endTime - startTime) + "[ms]"), this.journalLevel);
        }
        return ret;
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this.mStatement.getMetaData();
    }

    public void setTime(int arg0, Time arg1) throws SQLException {
        if (this.journalService != null) {
            this.mParameterMap.put(new Integer(arg0), arg1);
        }
        this.mStatement.setTime(arg0, arg1);
    }

    public void setTimestamp(int arg0, Timestamp arg1) throws SQLException {
        if (this.journalService != null) {
            this.mParameterMap.put(new Integer(arg0), arg1);
        }
        this.mStatement.setTimestamp(arg0, arg1);
    }

    public void setDate(int arg0, Date arg1, Calendar arg2) throws SQLException {
        if (this.journalService != null) {
            this.mParameterMap.put(new Integer(arg0), arg1);
        }
        this.mStatement.setDate(arg0, arg1, arg2);
    }

    public void setTime(int arg0, Time arg1, Calendar arg2) throws SQLException {
        if (this.journalService != null) {
            this.mParameterMap.put(new Integer(arg0), arg1);
        }
        this.mStatement.setTime(arg0, arg1, arg2);
    }

    public void setTimestamp(int arg0, Timestamp arg1, Calendar arg2) throws SQLException {
        if (this.journalService != null) {
            this.mParameterMap.put(new Integer(arg0), arg1);
        }
        this.mStatement.setTimestamp(arg0, arg1, arg2);
    }

    public void cancel() throws SQLException {
        this.mStatement.cancel();
    }
}

