/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.journal.editor;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import jp.ossc.nimbus.beans.NoSuchPropertyException;
import jp.ossc.nimbus.beans.Property;
import jp.ossc.nimbus.beans.SimpleProperty;
import jp.ossc.nimbus.core.NimbusClassLoader;
import jp.ossc.nimbus.service.journal.editor.BeanJournalEditorServiceMBean;
import jp.ossc.nimbus.service.journal.editor.BlockJournalEditorServiceBase;
import jp.ossc.nimbus.service.journal.editorfinder.EditorFinder;
import jp.ossc.nimbus.util.ClassMappingTree;

public class BeanJournalEditorService
extends BlockJournalEditorServiceBase
implements BeanJournalEditorServiceMBean,
Serializable {
    private static final long serialVersionUID = 2608759992280175186L;
    protected static final String DEFAULT_SECRET_STRING = "******";
    private boolean isOutputPropertyType = true;
    protected String secretString = "******";
    protected String[] secretProperties;
    protected ClassMappingTree secretPropertyMap;
    static /* synthetic */ Class class$java$lang$Object;

    public void setOutputPropertyType(boolean isOutput) {
        this.isOutputPropertyType = isOutput;
    }

    public boolean isOutputPropertyType() {
        return this.isOutputPropertyType;
    }

    public void setSecretString(String str) {
        this.secretString = str;
    }

    public String getSecretString() {
        return this.secretString;
    }

    public void setSecretProperties(String[] names) {
        this.secretProperties = names;
    }

    public String[] getSecretProperties() {
        return this.secretProperties;
    }

    public void createService() throws Exception {
        this.secretPropertyMap = new ClassMappingTree();
    }

    public void startService() throws Exception {
        if (this.secretProperties != null) {
            for (int i = 0; i < this.secretProperties.length; ++i) {
                int index = this.secretProperties[i].indexOf(35);
                Class<?> clazz = class$java$lang$Object == null ? BeanJournalEditorService.class$("java.lang.Object") : class$java$lang$Object;
                String propName = null;
                if (index == -1) {
                    propName = this.secretProperties[i];
                } else {
                    String className = this.secretProperties[i].substring(0, index);
                    clazz = Class.forName(className, true, NimbusClassLoader.getInstance());
                    propName = this.secretProperties[i].substring(index + 1);
                }
                this.secretPropertyMap.add(clazz, propName.toUpperCase());
            }
        }
    }

    protected void startBlock(EditorFinder finder, Object key, Object value, StringBuffer buf) {
        if (this.isOutputHeader() && value != null) {
            buf.append('[').append(value.getClass().getName()).append(']');
        }
        buf.append(this.getStartBlockSeparator());
    }

    protected boolean processBlock(EditorFinder finder, Object key, Object value, StringBuffer buf) {
        if (value == null) {
            return false;
        }
        SimpleProperty[] props = SimpleProperty.getProperties(value);
        if (props == null || props.length == 0) {
            return false;
        }
        ArrayList<SimpleProperty> readProps = new ArrayList<SimpleProperty>();
        for (int i = 0; i < props.length; ++i) {
            if (!props[i].isReadable(value)) continue;
            readProps.add(props[i]);
        }
        if (readProps.size() == 0) {
            return false;
        }
        Class<?> clazz = value.getClass();
        int max = readProps.size();
        for (int i = 0; i < max; ++i) {
            Property prop = (Property)readProps.get(i);
            buf.append(prop.getPropertyName());
            if (this.isOutputPropertyType) {
                buf.append('[');
                try {
                    this.makeObjectFormat(finder, null, prop.getPropertyType(value), buf);
                }
                catch (NoSuchPropertyException e) {
                }
                catch (InvocationTargetException e) {
                    // empty catch block
                }
                buf.append(']');
            }
            buf.append('=');
            if (this.secretPropertyMap.getValueList(clazz).contains(prop.getPropertyName().toUpperCase())) {
                buf.append(this.getSecretString());
            } else {
                try {
                    this.makeObjectFormat(finder, null, prop.getProperty(value), buf);
                }
                catch (NoSuchPropertyException e) {
                }
                catch (InvocationTargetException e) {
                    // empty catch block
                }
            }
            if (i == max - 1) continue;
            buf.append(this.getLineSeparator());
        }
        return true;
    }
}

