/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.jms;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.XAQueueConnection;
import javax.jms.XAQueueSession;
import jp.ossc.nimbus.service.jms.ReconnectableConnection;
import jp.ossc.nimbus.service.jms.ReconnectableQueueReceiver;
import jp.ossc.nimbus.service.jms.ReconnectableQueueSender;
import jp.ossc.nimbus.service.jms.ReconnectableSession;

public class ReconnectableQueueSession
extends ReconnectableSession
implements QueueSession,
XAQueueSession {
    public ReconnectableQueueSession(ReconnectableConnection con) throws JMSException {
        super(con);
    }

    public ReconnectableQueueSession(ReconnectableConnection con, boolean transacted, int acknowledgeMode) throws JMSException {
        super(con, transacted, acknowledgeMode);
    }

    protected Session createSession(boolean transacted, int acknowledgeMode) throws JMSException {
        this.transacted = transacted;
        return ((QueueConnection)this.connection.getConnection()).createQueueSession(transacted, acknowledgeMode);
    }

    protected Session createXASession() throws JMSException {
        return ((XAQueueConnection)this.connection.getConnection()).createXAQueueSession();
    }

    public QueueSession getQueueSession() throws JMSException {
        return ((XAQueueSession)this.session).getQueueSession();
    }

    public QueueReceiver createReceiver(Queue queue) throws JMSException {
        ReconnectableQueueReceiver receiver = new ReconnectableQueueReceiver((ReconnectableSession)this, queue);
        this.addMessageConsumer(receiver);
        return receiver;
    }

    public QueueReceiver createReceiver(Queue queue, String messageSelector) throws JMSException {
        ReconnectableQueueReceiver receiver = new ReconnectableQueueReceiver((ReconnectableSession)this, queue, messageSelector);
        this.addMessageConsumer(receiver);
        return receiver;
    }

    public QueueSender createSender(Queue queue) throws JMSException {
        ReconnectableQueueSender sender = new ReconnectableQueueSender(this, (Destination)queue);
        this.addMessageProducer(sender);
        return sender;
    }
}

