/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.jms;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import jp.ossc.nimbus.service.jms.ReconnectableSession;

public abstract class ReconnectableMessageConsumer
implements MessageConsumer {
    protected ReconnectableSession session;
    protected MessageConsumer messageConsumer;
    protected boolean isClose;
    protected String name;
    protected boolean isDurable;
    protected boolean noLocal;
    protected Destination destination;
    protected String messageSelector;
    protected MessageListener messageListener;

    public ReconnectableMessageConsumer(ReconnectableSession session, Destination destination) throws JMSException {
        this.session = session;
        this.messageConsumer = this.createMessageConsumer(session, destination);
    }

    public ReconnectableMessageConsumer(ReconnectableSession session, Destination destination, String messageSelector) throws JMSException {
        this.session = session;
        this.messageConsumer = this.createMessageConsumer(session, destination, messageSelector);
    }

    public ReconnectableMessageConsumer(ReconnectableSession session, Destination destination, String messageSelector, boolean noLocal) throws JMSException {
        this.session = session;
        this.messageConsumer = this.createMessageConsumer(session, destination, messageSelector, noLocal);
    }

    public ReconnectableMessageConsumer(ReconnectableSession session, Topic topic, String name) throws JMSException {
        this.session = session;
        this.name = name;
        this.isDurable = true;
        this.messageConsumer = this.createDurableSubscriber(session, topic, name);
    }

    public ReconnectableMessageConsumer(ReconnectableSession session, Topic topic, String name, String messageSelector, boolean noLocal) throws JMSException {
        this.session = session;
        this.name = name;
        this.isDurable = true;
        this.messageConsumer = this.createDurableSubscriber(session, topic, name, messageSelector, noLocal);
    }

    protected abstract Destination getDestination() throws JMSException;

    protected MessageConsumer createMessageConsumer(ReconnectableSession session, Destination destination) throws JMSException {
        this.destination = destination;
        return session.getRealSession().createConsumer(destination);
    }

    protected MessageConsumer createMessageConsumer(ReconnectableSession session, Destination destination, String messageSelector) throws JMSException {
        this.destination = destination;
        this.messageSelector = messageSelector;
        return session.getRealSession().createConsumer(destination, messageSelector);
    }

    protected MessageConsumer createMessageConsumer(ReconnectableSession session, Destination destination, String messageSelector, boolean noLocal) throws JMSException {
        this.noLocal = noLocal;
        this.destination = destination;
        this.messageSelector = messageSelector;
        return session.getRealSession().createConsumer(destination, messageSelector, noLocal);
    }

    protected TopicSubscriber createDurableSubscriber(ReconnectableSession session, Topic topic, String name) throws JMSException {
        this.destination = topic;
        return session.getRealSession().createDurableSubscriber(topic, name);
    }

    protected TopicSubscriber createDurableSubscriber(ReconnectableSession session, Topic topic, String name, String messageSelector, boolean noLocal) throws JMSException {
        this.noLocal = noLocal;
        this.destination = topic;
        this.messageSelector = messageSelector;
        return session.getRealSession().createDurableSubscriber(topic, name, messageSelector, noLocal);
    }

    public String getMessageSelector() throws JMSException {
        return this.messageConsumer.getMessageSelector();
    }

    public MessageListener getMessageListener() throws JMSException {
        return this.messageConsumer.getMessageListener();
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        this.messageListener = listener;
        this.messageConsumer.setMessageListener(listener);
    }

    public Message receive() throws JMSException {
        return this.messageConsumer.receive();
    }

    public Message receive(long timeout) throws JMSException {
        return this.messageConsumer.receive(timeout);
    }

    public Message receiveNoWait() throws JMSException {
        return this.messageConsumer.receiveNoWait();
    }

    public void close() throws JMSException {
        this.isClose = true;
        this.session.removeMessageConsumer(this.messageConsumer);
        this.messageConsumer.close();
    }

    public void reconnect() throws JMSException {
        if (this.isClose) {
            return;
        }
        Object newMessageConsumer = null;
        newMessageConsumer = this.destination instanceof Queue ? (this.messageSelector == null ? this.createMessageConsumer(this.session, this.destination) : this.createMessageConsumer(this.session, this.destination, this.messageSelector)) : (this.isDurable ? (this.messageSelector == null ? this.createDurableSubscriber(this.session, (Topic)this.destination, this.name) : this.createDurableSubscriber(this.session, (Topic)this.destination, this.name, this.messageSelector, this.noLocal)) : (this.messageSelector == null ? this.createMessageConsumer(this.session, this.destination) : this.createMessageConsumer(this.session, this.destination, this.messageSelector, this.noLocal)));
        if (this.messageListener != null) {
            newMessageConsumer.setMessageListener(this.messageListener);
        }
        this.messageConsumer = newMessageConsumer;
    }
}

