/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.cache;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.service.cache.CacheAccessListener;
import jp.ossc.nimbus.service.cache.CacheRemoveListener;
import jp.ossc.nimbus.service.cache.CachedReference;
import jp.ossc.nimbus.service.cache.LRUOverflowAlgorithmServiceMBean;
import jp.ossc.nimbus.service.cache.OverflowAlgorithm;

public class LRUOverflowAlgorithmService
extends ServiceBase
implements OverflowAlgorithm,
CacheRemoveListener,
CacheAccessListener,
Serializable,
LRUOverflowAlgorithmServiceMBean {
    private static final long serialVersionUID = 2274633140923055371L;
    private List referenceList;

    public void createService() throws Exception {
        this.referenceList = Collections.synchronizedList(new ArrayList());
    }

    public void destroyService() throws Exception {
        this.reset();
        this.referenceList = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(CachedReference ref) {
        if (this.referenceList == null || ref == null) {
            return;
        }
        List list = this.referenceList;
        synchronized (list) {
            if (!this.referenceList.contains(ref)) {
                this.referenceList.add(ref);
                ref.addCacheAccessListener(this);
                ref.addCacheRemoveListener(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(CachedReference ref) {
        if (this.referenceList == null || ref == null) {
            return;
        }
        List list = this.referenceList;
        synchronized (list) {
            if (this.referenceList.contains(ref)) {
                this.referenceList.remove(ref);
                ref.removeCacheAccessListener(this);
                ref.removeCacheRemoveListener(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CachedReference overflow() {
        if (this.referenceList == null) {
            return null;
        }
        List list = this.referenceList;
        synchronized (list) {
            if (this.referenceList.size() != 0) {
                return (CachedReference)this.referenceList.remove(0);
            }
            return null;
        }
    }

    public void reset() {
        if (this.referenceList != null) {
            this.referenceList.clear();
        }
    }

    public void removed(CachedReference ref) {
        this.remove(ref);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accessed(CachedReference ref) {
        if (this.referenceList == null) {
            return;
        }
        List list = this.referenceList;
        synchronized (list) {
            if (this.referenceList != null && this.referenceList.contains(ref)) {
                this.referenceList.remove(ref);
                this.referenceList.add(ref);
            }
        }
    }
}

