/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.aop.interceptor;

import java.io.File;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import jp.ossc.nimbus.core.NimbusClassLoader;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceMetaData;
import jp.ossc.nimbus.io.ExtentionFileFilter;
import jp.ossc.nimbus.io.RecurciveSearchFile;
import jp.ossc.nimbus.service.aop.Interceptor;
import jp.ossc.nimbus.service.aop.InterceptorChain;
import jp.ossc.nimbus.service.aop.InvocationContext;
import jp.ossc.nimbus.service.aop.MethodInvocationContext;
import jp.ossc.nimbus.service.aop.SerializableMethod;
import jp.ossc.nimbus.service.aop.interceptor.NoCalledMethodMetricsInterceptorServiceMBean;
import jp.ossc.nimbus.util.StringOperator;

public class NoCalledMethodMetricsInterceptorService
extends ServiceBase
implements Interceptor,
NoCalledMethodMetricsInterceptorServiceMBean {
    private static final long serialVersionUID = -1589746522650375741L;
    private static final String MODIFIER_PUBLIC = "public";
    private static final String MODIFIER_PROTECTED = "protected";
    private static final String MODIFIER_DEFAULT = "default";
    private static final String MODIFIER_PRIVATE = "private";
    private static final String MODIFIER_FINAL = "final";
    private static final String MODIFIER_STATIC = "static";
    private static final String MODIFIER_SYNCHRONIZED = "synchronized";
    private static final String MODIFIER_ABSTRACT = "abstract";
    private static final String NOT_TRANSFORMABLE_SUFFIX = "$nimbus_aop";
    private Boolean isPublicClass;
    private Boolean isProtectedClass;
    private Boolean isDefaultClass;
    private Boolean isPrivateClass;
    private Boolean isFinalClass;
    private Boolean isStaticClass;
    private Boolean isAbstractClass;
    private String targetClassModifiers;
    private Boolean isPublicMethod;
    private Boolean isProtectedMethod;
    private Boolean isDefaultMethod;
    private Boolean isPrivateMethod;
    private Boolean isFinalMethod;
    private Boolean isStaticMethod;
    private Boolean isSynchronizedMethod;
    private String targetMethodModifiers;
    private String targetClassName;
    private String targetInstanceClassName;
    private String targetMethodName;
    private String[] targetParameterTypes;
    private boolean isDeclaringMethod;
    private String[] additionalClassPaths;
    private Set targetMethods;
    private Set noCalledMethods;

    public void setTargetClassModifiers(String modifiers) {
        Boolean isPublicClass = null;
        Boolean isProtectedClass = null;
        Boolean isDefaultClass = null;
        Boolean isPrivateClass = null;
        Boolean isFinalClass = null;
        Boolean isStaticClass = null;
        Boolean isAbstractClass = null;
        if (modifiers != null && modifiers.length() != 0) {
            StringTokenizer tokens = new StringTokenizer(modifiers, " ");
            while (tokens.hasMoreTokens()) {
                String modifier = tokens.nextToken();
                if (modifier.endsWith(MODIFIER_PUBLIC)) {
                    isPublicClass = modifier.charAt(0) == '!' ? Boolean.FALSE : Boolean.TRUE;
                    continue;
                }
                if (modifier.endsWith(MODIFIER_PROTECTED)) {
                    isProtectedClass = modifier.charAt(0) == '!' ? Boolean.FALSE : Boolean.TRUE;
                    continue;
                }
                if (modifier.endsWith(MODIFIER_DEFAULT)) {
                    isDefaultClass = modifier.charAt(0) == '!' ? Boolean.FALSE : Boolean.TRUE;
                    continue;
                }
                if (modifier.endsWith(MODIFIER_PRIVATE)) {
                    isPrivateClass = modifier.charAt(0) == '!' ? Boolean.FALSE : Boolean.TRUE;
                    continue;
                }
                if (modifier.endsWith(MODIFIER_FINAL)) {
                    isFinalClass = modifier.charAt(0) == '!' ? Boolean.FALSE : Boolean.TRUE;
                    continue;
                }
                if (modifier.endsWith(MODIFIER_STATIC)) {
                    isStaticClass = modifier.charAt(0) == '!' ? Boolean.FALSE : Boolean.TRUE;
                    continue;
                }
                if (modifier.endsWith(MODIFIER_ABSTRACT)) {
                    isAbstractClass = modifier.charAt(0) == '!' ? Boolean.FALSE : Boolean.TRUE;
                    continue;
                }
                throw new IllegalArgumentException("Invalid class modifier : " + modifier);
            }
        }
        this.targetClassModifiers = modifiers;
        this.isPublicClass = isPublicClass;
        this.isProtectedClass = isProtectedClass;
        this.isDefaultClass = isDefaultClass;
        this.isPrivateClass = isPrivateClass;
        this.isFinalClass = isFinalClass;
        this.isStaticClass = isStaticClass;
        this.isAbstractClass = isAbstractClass;
    }

    public String getTargetClassModifiers() {
        return this.targetClassModifiers;
    }

    public void setTargetClassName(String name) {
        this.targetClassName = name;
    }

    public String getTargetClassName() {
        return this.targetClassName;
    }

    public void setTargetInstanceClassName(String name) {
        this.targetInstanceClassName = name;
    }

    public String getTargetInstanceClassName() {
        return this.targetInstanceClassName;
    }

    public void setTargetMethodModifiers(String modifiers) {
        Boolean isPublicMethod = null;
        Boolean isProtectedMethod = null;
        Boolean isDefaultMethod = null;
        Boolean isPrivateMethod = null;
        Boolean isFinalMethod = null;
        Boolean isStaticMethod = null;
        Boolean isSynchronizedMethod = null;
        if (modifiers != null && modifiers.length() != 0) {
            StringTokenizer tokens = new StringTokenizer(modifiers, " ");
            while (tokens.hasMoreTokens()) {
                String modifier = tokens.nextToken();
                if (modifier.endsWith(MODIFIER_PUBLIC)) {
                    isPublicMethod = modifier.charAt(0) == '!' ? Boolean.FALSE : Boolean.TRUE;
                    continue;
                }
                if (modifier.endsWith(MODIFIER_PROTECTED)) {
                    isProtectedMethod = modifier.charAt(0) == '!' ? Boolean.FALSE : Boolean.TRUE;
                    continue;
                }
                if (modifier.endsWith(MODIFIER_DEFAULT)) {
                    isDefaultMethod = modifier.charAt(0) == '!' ? Boolean.FALSE : Boolean.TRUE;
                    continue;
                }
                if (modifier.endsWith(MODIFIER_PRIVATE)) {
                    isPrivateMethod = modifier.charAt(0) == '!' ? Boolean.FALSE : Boolean.TRUE;
                    continue;
                }
                if (modifier.endsWith(MODIFIER_FINAL)) {
                    isFinalMethod = modifier.charAt(0) == '!' ? Boolean.FALSE : Boolean.TRUE;
                    continue;
                }
                if (modifier.endsWith(MODIFIER_STATIC)) {
                    isStaticMethod = modifier.charAt(0) == '!' ? Boolean.FALSE : Boolean.TRUE;
                    continue;
                }
                if (modifier.endsWith(MODIFIER_SYNCHRONIZED)) {
                    isSynchronizedMethod = modifier.charAt(0) == '!' ? Boolean.FALSE : Boolean.TRUE;
                    continue;
                }
                throw new IllegalArgumentException("Invalid class modifier : " + modifier);
            }
        }
        this.targetMethodModifiers = modifiers;
        this.isPublicMethod = isPublicMethod;
        this.isProtectedMethod = isProtectedMethod;
        this.isDefaultMethod = isDefaultMethod;
        this.isPrivateMethod = isPrivateMethod;
        this.isFinalMethod = isFinalMethod;
        this.isStaticMethod = isStaticMethod;
        this.isSynchronizedMethod = isSynchronizedMethod;
    }

    public String getTargetMethodModifiers() {
        return this.targetMethodModifiers;
    }

    public void setTargetMethodName(String name) {
        this.targetMethodName = name;
    }

    public String getTargetMethodName() {
        return this.targetMethodName;
    }

    public void setTargetParameterTypes(String[] paramTypes) {
        this.targetParameterTypes = paramTypes;
    }

    public String[] getTargetParameterTypes() {
        return this.targetParameterTypes;
    }

    public void setDeclaringMethod(boolean isDeclaring) {
        this.isDeclaringMethod = isDeclaring;
    }

    public boolean isDeclaringMethod() {
        return this.isDeclaringMethod;
    }

    public Set getTargetMethodSet() {
        return this.getMethodSet(this.targetMethods);
    }

    public String getTargetMethodString() {
        return this.getMethodString(this.getTargetMethodSet());
    }

    public Set getNoCalledMethodSet() {
        return this.getMethodSet(this.noCalledMethods);
    }

    public String getNoCalledMethodString() {
        return this.getMethodString(this.getNoCalledMethodSet());
    }

    public void setClassPaths(String[] paths) {
        this.additionalClassPaths = paths;
    }

    public String[] getClassPaths() {
        return this.additionalClassPaths;
    }

    public void createService() throws Exception {
        this.targetMethods = new HashSet();
        this.noCalledMethods = new HashSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startService() throws Exception {
        this.createTargetMethods();
        Set set = this.noCalledMethods;
        synchronized (set) {
            this.noCalledMethods.addAll(this.targetMethods);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopService() throws Exception {
        System.out.println("************ Target method ***********");
        System.out.println(this.getTargetMethodString());
        System.out.println("************ No called method ***********");
        System.out.println(this.getNoCalledMethodString());
        this.targetMethods.clear();
        Set set = this.noCalledMethods;
        synchronized (set) {
            this.noCalledMethods.clear();
        }
    }

    public void destroyService() throws Exception {
        this.targetMethods = null;
        this.noCalledMethods = null;
    }

    private Set getMethodSet(Set methods) {
        HashSet<Method> result = new HashSet<Method>();
        if (methods == null || methods.size() == 0) {
            return result;
        }
        SerializableMethod[] serializableMethods = methods.toArray(new SerializableMethod[methods.size()]);
        for (int i = 0; i < serializableMethods.length; ++i) {
            result.add(serializableMethods[i].getMethod());
        }
        return result;
    }

    private String getMethodString(Set methodSet) {
        int i;
        Method[] methods = methodSet.toArray(new Method[methodSet.size()]);
        Object[] methodStrs = new String[methods.length];
        String separator = System.getProperty("line.separator");
        StringBuffer buf = new StringBuffer();
        for (i = 0; i < methods.length; ++i) {
            buf.setLength(0);
            Class<?> decClass = methods[i].getDeclaringClass();
            String methodName = methods[i].getName();
            Class<?>[] paramTypes = methods[i].getParameterTypes();
            buf.append(decClass.getName()).append('.');
            buf.append(methodName).append('(');
            for (int j = 0; j < paramTypes.length; ++j) {
                buf.append(paramTypes[j].getName());
                if (j == paramTypes.length - 1) continue;
                buf.append(',');
            }
            buf.append(')');
            methodStrs[i] = buf.toString();
        }
        Arrays.sort(methodStrs);
        buf.setLength(0);
        for (i = 0; i < methodStrs.length; ++i) {
            buf.append((String)methodStrs[i]);
            if (i == methodStrs.length - 1) continue;
            buf.append(separator);
        }
        return buf.toString();
    }

    private synchronized void createTargetMethods() throws Exception {
        String classpath = System.getProperty("java.class.path");
        if (!(classpath != null && classpath.length() != 0 || this.additionalClassPaths != null && this.additionalClassPaths.length != 0)) {
            return;
        }
        String pathSeparator = System.getProperty("path.separator");
        StringTokenizer tokens = new StringTokenizer(classpath, pathSeparator);
        ArrayList<String> classpaths = new ArrayList<String>();
        while (tokens.hasMoreTokens()) {
            String cp = tokens.nextToken();
            if (cp.length() == 0 || classpaths.contains(cp)) continue;
            classpaths.add(cp);
        }
        if (this.additionalClassPaths != null) {
            File servicePath;
            File parentDir;
            ServiceMetaData metaData = ServiceManagerFactory.getServiceMetaData(this.getServiceNameObject());
            File servicePathDir = null;
            if (metaData != null && (parentDir = (servicePath = new File(metaData.getServiceLoader().getServiceURL().getFile())).getParentFile()) != null && parentDir.exists()) {
                servicePathDir = parentDir;
            }
            for (int i = 0; i < this.additionalClassPaths.length; ++i) {
                File path = new File(this.additionalClassPaths[i]);
                if (path.exists()) {
                    classpaths.add(this.additionalClassPaths[i]);
                    continue;
                }
                if (servicePathDir == null || !(path = new File(servicePathDir, this.additionalClassPaths[i])).exists()) continue;
                classpaths.add(path.getCanonicalPath());
            }
        }
        Iterator paths = classpaths.iterator();
        while (paths.hasNext()) {
            String cp = (String)paths.next();
            this.createTargetMethods(cp);
        }
    }

    private void createTargetMethods(String classpath) throws Exception {
        File path = new File(classpath);
        if (!path.exists()) {
            return;
        }
        if (path.isDirectory()) {
            RecurciveSearchFile dir = new RecurciveSearchFile(classpath);
            File[] classFiles = dir.listAllTreeFiles(new ExtentionFileFilter(".class"));
            for (int i = 0; i < classFiles.length; ++i) {
                if (classFiles[i].isDirectory()) continue;
                this.addTargetMethods(this.convertClassName(dir, classFiles[i]));
            }
        } else {
            JarFile jarFile = new JarFile(path);
            Enumeration<JarEntry> jarEntries = jarFile.entries();
            while (jarEntries.hasMoreElements()) {
                String entryName;
                ZipEntry jarEntry = jarEntries.nextElement();
                if (jarEntry.isDirectory() || !(entryName = jarEntry.getName()).endsWith(".class")) continue;
                this.addTargetMethods(this.convertClassName(entryName));
            }
        }
    }

    private String convertClassName(File dir, File classFile) {
        String fileSeparator = System.getProperty("file.separator");
        String dirPath = dir.getPath();
        String path = classFile.getPath();
        if (path.startsWith(dirPath)) {
            path = path.substring(dirPath.length());
        }
        if (path.startsWith(fileSeparator)) {
            path = path.substring(fileSeparator.length());
        }
        String result = path.substring(0, path.length() - 6);
        return StringOperator.replaceString(result, fileSeparator, ".");
    }

    private String convertClassName(String jarEntry) {
        String result = jarEntry.substring(0, jarEntry.length() - 6);
        return result.replace('/', '.');
    }

    private boolean addTargetMethods(String className) throws Exception {
        if (NimbusClassLoader.isNonTranslatableClassName(className)) {
            return false;
        }
        if (this.targetClassName != null && !this.targetClassName.equals(className) && !Pattern.matches(this.targetClassName, className)) {
            return false;
        }
        NimbusClassLoader loader = NimbusClassLoader.getInstance();
        Class<?> clazz = loader.loadClass(className);
        if (clazz.isInterface()) {
            return false;
        }
        if (this.targetClassModifiers != null) {
            int modifiers = clazz.getModifiers();
            if (this.isPublicClass != null && Modifier.isPublic(modifiers) != this.isPublicClass || this.isProtectedClass != null && Modifier.isProtected(modifiers) != this.isProtectedClass || this.isDefaultClass != null && (!Modifier.isPublic(modifiers) && !Modifier.isProtected(modifiers) && !Modifier.isPrivate(modifiers)) != this.isDefaultClass || this.isPrivateClass != null && Modifier.isPrivate(modifiers) != this.isPrivateClass || this.isFinalClass != null && Modifier.isFinal(modifiers) != this.isFinalClass || this.isStaticClass != null && Modifier.isStatic(modifiers) != this.isStaticClass || this.isAbstractClass != null && Modifier.isAbstract(modifiers) != this.isAbstractClass) {
                return false;
            }
        }
        if (this.targetInstanceClassName != null) {
            Class<?> targetInstanceClass = loader.loadClass(this.targetInstanceClassName);
            if (!this.targetInstanceClassName.equals(className) && !targetInstanceClass.isAssignableFrom(clazz)) {
                return false;
            }
        }
        Class<?> target = clazz;
        HashSet<String> overwrideSignatures = new HashSet<String>();
        boolean result = false;
        do {
            if (NimbusClassLoader.isNonTranslatableClassName(target.getName())) continue;
            Method[] methods = target.getDeclaredMethods();
            StringBuffer signatureBuf = new StringBuffer();
            for (int i = 0; i < methods.length; ++i) {
                String methodName;
                int modifiers;
                int mod;
                Method method = methods[i];
                if (this.targetMethods.contains(method)) continue;
                signatureBuf.setLength(0);
                signatureBuf.append(method.getName()).append('(');
                Class<?>[] paramTypes = method.getParameterTypes();
                for (int j = 0; j < paramTypes.length; ++j) {
                    signatureBuf.append(paramTypes[j].getName()).append(',');
                }
                signatureBuf.append(')');
                String signature = signatureBuf.toString();
                if (overwrideSignatures.contains(signature)) continue;
                overwrideSignatures.add(signature);
                if (!clazz.equals(target) && (Modifier.isPrivate(mod = method.getModifiers()) || !Modifier.isPublic(mod) && !Modifier.isProtected(mod) && !clazz.getPackage().getName().equals(target.getPackage().getName())) || Modifier.isNative(modifiers = method.getModifiers()) || Modifier.isAbstract(modifiers) || (methodName = method.getName()).endsWith(NOT_TRANSFORMABLE_SUFFIX) || this.targetMethodName != null && !this.targetMethodName.equals(methodName) && !Pattern.matches(this.targetMethodName, methodName) || this.targetMethodModifiers != null && (this.isPublicMethod != null && Modifier.isPublic(modifiers) != this.isPublicMethod || this.isProtectedMethod != null && Modifier.isProtected(modifiers) != this.isProtectedMethod || this.isDefaultMethod != null && (!Modifier.isPublic(modifiers) && !Modifier.isProtected(modifiers) && !Modifier.isPrivate(modifiers)) != this.isDefaultMethod || this.isPrivateMethod != null && Modifier.isPrivate(modifiers) != this.isPrivateMethod || this.isFinalMethod != null && Modifier.isFinal(modifiers) != this.isFinalMethod || this.isStaticMethod != null && Modifier.isStatic(modifiers) != this.isStaticMethod || this.isSynchronizedMethod != null && Modifier.isAbstract(modifiers) != this.isSynchronizedMethod)) continue;
                if (this.targetParameterTypes != null) {
                    if (paramTypes.length != this.targetParameterTypes.length) continue;
                    for (int j = 0; j < this.targetParameterTypes.length; ++j) {
                        String paramName = paramTypes[j].getName();
                        if (!this.targetParameterTypes[j].equals(paramName) && Pattern.matches(this.targetParameterTypes[j], paramName)) continue;
                    }
                }
                result = true;
                this.targetMethods.add(new SerializableMethod(method));
            }
            if (this.isDeclaringMethod) break;
        } while ((target = target.getSuperclass()) != null);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(InvocationContext context, InterceptorChain chain) throws Throwable {
        MethodInvocationContext ctx;
        Method targetMethod;
        if (this.getState() == 3 && (targetMethod = (ctx = (MethodInvocationContext)context).getTargetMethod()) != null) {
            Set set = this.noCalledMethods;
            synchronized (set) {
                Iterator methods = this.noCalledMethods.iterator();
                while (methods.hasNext()) {
                    SerializableMethod method = (SerializableMethod)methods.next();
                    if (!method.equalsSignature(targetMethod)) continue;
                    methods.remove();
                    break;
                }
            }
        }
        return chain.invokeNext(context);
    }
}

