/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.writer.log4j;

import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.service.writer.WritableRecord;
import jp.ossc.nimbus.service.writer.log4j.WriterAppenderWriterServiceMBean;
import org.apache.log4j.Category;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.WriterAppender;
import org.apache.log4j.spi.LoggingEvent;

public class WriterAppenderWriterService
extends ServiceBase
implements WriterAppenderWriterServiceMBean {
    private boolean isImmediateFlush;
    private String encoding;
    private String header;
    private String footer;
    protected Logger logger;
    protected WriterAppender appender;
    protected Layout layout = new Layout(){
        private final StringBuffer sbuf = new StringBuffer(128);

        public String format(LoggingEvent event) {
            this.sbuf.setLength(0);
            this.sbuf.append(event.getRenderedMessage());
            this.sbuf.append(LINE_SEP);
            return this.sbuf.toString();
        }

        public boolean ignoresThrowable() {
            return true;
        }

        public void activateOptions() {
        }

        public String getHeader() {
            return WriterAppenderWriterService.this.header;
        }

        public String getFooter() {
            return WriterAppenderWriterService.this.footer;
        }
    };

    public void setImmediateFlush(boolean flush) {
        this.isImmediateFlush = flush;
    }

    public boolean isImmediateFlush() {
        return this.isImmediateFlush;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setHeader(String header) {
        this.header = header;
    }

    public String getHeader() {
        return this.header;
    }

    public void setFooter(String footer) {
        this.footer = footer;
    }

    public String getFooter() {
        return this.footer;
    }

    public void startService() throws Exception {
        this.logger = this.createLogger();
        this.appender = this.createWriterAppender();
        this.initWriterAppender(this.appender);
        this.appender.activateOptions();
    }

    protected Logger createLogger() {
        return Logger.getLogger((String)(this.getServiceManagerName() + '#' + this.getServiceName()));
    }

    protected WriterAppender createWriterAppender() throws Exception {
        return new WriterAppender();
    }

    protected void initWriterAppender(WriterAppender appender) throws Exception {
        appender.setLayout(this.layout);
        appender.setImmediateFlush(this.isImmediateFlush);
        if (this.encoding != null) {
            appender.setEncoding(this.encoding);
        }
    }

    public void stopService() {
        this.appender.close();
        this.appender = null;
    }

    public void setLayout(Layout layout) {
        this.layout = layout;
    }

    public void write(WritableRecord rec) {
        this.appender.append(new LoggingEvent(this.getClass().getName(), (Category)this.logger, Priority.INFO, (Object)rec.toString(), null));
    }
}

