/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.message;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import jp.ossc.nimbus.core.Service;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.core.ServiceNotFoundException;
import jp.ossc.nimbus.lang.ServiceException;
import jp.ossc.nimbus.service.message.MessageRecord;
import jp.ossc.nimbus.service.message.MessageRecordFactory;
import jp.ossc.nimbus.service.message.MessageRecordOperator;
import jp.ossc.nimbus.util.CsvArrayList;
import jp.ossc.nimbus.util.StringOperator;

public class MessageRecordImpl
implements MessageRecord,
MessageRecordOperator,
Serializable {
    protected String mMessageCode = null;
    protected HashMap mMessageHash = new HashMap();
    protected boolean mIsInitialized = false;
    protected Date mLastOccur = null;
    protected boolean mIsSecret = false;
    protected long mUsedCount = 0L;
    protected Hashtable mLocaleHash = new Hashtable();
    private transient MessageRecordFactory mFac = null;
    private ServiceName mFacName = null;
    private static final String C_DFAUTL_LOCALE = "default";
    private static final String C_UNDER_SCORE = "_";
    private static final String EMBED_STRING = "@";
    private static final String SECRET_EMBED_STRING = "#";
    private static final String SINGLE_EMBED_STRING = "@0";
    private static final String SINGLE_SECRET_EMBED_STRING = "#0";

    public void rec2Obj(String defString) {
        if (!this.mIsInitialized) {
            CsvArrayList parser = new CsvArrayList();
            parser.split(defString, ",");
            if (parser.size() < 2) {
                throw new ServiceException("MSG002001", "Message define error message is " + defString);
            }
            this.mMessageCode = parser.getStr(0);
            this.mMessageHash.put(C_DFAUTL_LOCALE, parser.getStr(1));
        }
    }

    public String getMessageCode() {
        return this.mMessageCode;
    }

    public void setMessageCode(String code) {
        this.mMessageCode = code;
    }

    public String makeMessage(Locale lo) {
        this.increment();
        return this.getMessageTemplate(lo);
    }

    public String makeMessage() {
        return this.makeMessage(Locale.getDefault());
    }

    public String makeMessage(Locale lo, Object embed) {
        this.increment();
        String tmp = this.getMessageTemplate(lo);
        String retStr = StringOperator.replaceString(tmp, SINGLE_EMBED_STRING, embed);
        if (!this.mIsSecret) {
            retStr = StringOperator.replaceString(retStr, SINGLE_SECRET_EMBED_STRING, embed);
        }
        return retStr;
    }

    public String makeMessage(Locale lo, byte embed) {
        return this.makeMessage(lo, Byte.toString(embed));
    }

    public String makeMessage(Locale lo, short embed) {
        return this.makeMessage(lo, Short.toString(embed));
    }

    public String makeMessage(Locale lo, char embed) {
        return this.makeMessage(lo, new Character(embed));
    }

    public String makeMessage(Locale lo, int embed) {
        return this.makeMessage(lo, Integer.toString(embed));
    }

    public String makeMessage(Locale lo, long embed) {
        return this.makeMessage(lo, Long.toString(embed));
    }

    public String makeMessage(Locale lo, float embed) {
        return this.makeMessage(lo, Float.toString(embed));
    }

    public String makeMessage(Locale lo, double embed) {
        return this.makeMessage(lo, Double.toString(embed));
    }

    public String makeMessage(Object embed) {
        return this.makeMessage(Locale.getDefault(), embed);
    }

    public String makeMessage(byte embed) {
        return this.makeMessage(Byte.toString(embed));
    }

    public String makeMessage(short embed) {
        return this.makeMessage(Short.toString(embed));
    }

    public String makeMessage(char embed) {
        return this.makeMessage(new Character(embed));
    }

    public String makeMessage(int embed) {
        return this.makeMessage(Integer.toString(embed));
    }

    public String makeMessage(long embed) {
        return this.makeMessage(Long.toString(embed));
    }

    public String makeMessage(float embed) {
        return this.makeMessage(Float.toString(embed));
    }

    public String makeMessage(double embed) {
        return this.makeMessage(Double.toString(embed));
    }

    public String makeMessage(Locale lo, Object[] embeds) {
        String tmp = this.getMessageTemplate(lo);
        String retStr = StringOperator.replaceString(tmp, EMBED_STRING, embeds);
        if (!this.mIsSecret) {
            retStr = StringOperator.replaceString(retStr, SECRET_EMBED_STRING, embeds);
        }
        return retStr;
    }

    public String makeMessage(Locale lo, byte[] embeds) {
        if (embeds == null) {
            return this.makeMessage(lo, (Object[])null);
        }
        Object[] strs = new String[embeds.length];
        int max = strs.length;
        for (int i = 0; i < max; ++i) {
            strs[i] = Byte.toString(embeds[i]);
        }
        return this.makeMessage(lo, strs);
    }

    public String makeMessage(Locale lo, short[] embeds) {
        if (embeds == null) {
            return this.makeMessage(lo, (Object[])null);
        }
        Object[] strs = new String[embeds.length];
        int max = strs.length;
        for (int i = 0; i < max; ++i) {
            strs[i] = Short.toString(embeds[i]);
        }
        return this.makeMessage(lo, strs);
    }

    public String makeMessage(Locale lo, char[] embeds) {
        if (embeds == null) {
            return this.makeMessage(lo, (Object[])null);
        }
        Object[] strs = new String[embeds.length];
        int max = strs.length;
        for (int i = 0; i < max; ++i) {
            strs[i] = new Character(embeds[i]);
        }
        return this.makeMessage(lo, strs);
    }

    public String makeMessage(Locale lo, int[] embeds) {
        if (embeds == null) {
            return this.makeMessage(lo, (Object[])null);
        }
        Object[] strs = new String[embeds.length];
        int max = strs.length;
        for (int i = 0; i < max; ++i) {
            strs[i] = Integer.toString(embeds[i]);
        }
        return this.makeMessage(lo, strs);
    }

    public String makeMessage(Locale lo, long[] embeds) {
        if (embeds == null) {
            return this.makeMessage(lo, (Object[])null);
        }
        Object[] strs = new String[embeds.length];
        int max = strs.length;
        for (int i = 0; i < max; ++i) {
            strs[i] = Long.toString(embeds[i]);
        }
        return this.makeMessage(lo, strs);
    }

    public String makeMessage(Locale lo, float[] embeds) {
        if (embeds == null) {
            return this.makeMessage(lo, (Object[])null);
        }
        Object[] strs = new String[embeds.length];
        int max = strs.length;
        for (int i = 0; i < max; ++i) {
            strs[i] = Float.toString(embeds[i]);
        }
        return this.makeMessage(lo, strs);
    }

    public String makeMessage(Locale lo, double[] embeds) {
        if (embeds == null) {
            return this.makeMessage(lo, (Object[])null);
        }
        Object[] strs = new String[embeds.length];
        int max = strs.length;
        for (int i = 0; i < max; ++i) {
            strs[i] = Double.toString(embeds[i]);
        }
        return this.makeMessage(lo, strs);
    }

    public String makeMessage(Object[] embeds) {
        return this.makeMessage(Locale.getDefault(), embeds);
    }

    public String makeMessage(byte[] embeds) {
        if (embeds == null) {
            return this.makeMessage((Object[])null);
        }
        Object[] strs = new String[embeds.length];
        int max = strs.length;
        for (int i = 0; i < max; ++i) {
            strs[i] = Byte.toString(embeds[i]);
        }
        return this.makeMessage(strs);
    }

    public String makeMessage(short[] embeds) {
        if (embeds == null) {
            return this.makeMessage((Object[])null);
        }
        Object[] strs = new String[embeds.length];
        int max = strs.length;
        for (int i = 0; i < max; ++i) {
            strs[i] = Short.toString(embeds[i]);
        }
        return this.makeMessage(strs);
    }

    public String makeMessage(char[] embeds) {
        if (embeds == null) {
            return this.makeMessage((Object[])null);
        }
        Object[] strs = new Character[embeds.length];
        int max = strs.length;
        for (int i = 0; i < max; ++i) {
            strs[i] = new Character(embeds[i]);
        }
        return this.makeMessage(strs);
    }

    public String makeMessage(int[] embeds) {
        if (embeds == null) {
            return this.makeMessage((Object[])null);
        }
        Object[] strs = new String[embeds.length];
        int max = strs.length;
        for (int i = 0; i < max; ++i) {
            strs[i] = Integer.toString(embeds[i]);
        }
        return this.makeMessage(strs);
    }

    public String makeMessage(long[] embeds) {
        if (embeds == null) {
            return this.makeMessage((Object[])null);
        }
        Object[] strs = new String[embeds.length];
        int max = strs.length;
        for (int i = 0; i < max; ++i) {
            strs[i] = Long.toString(embeds[i]);
        }
        return this.makeMessage(strs);
    }

    public String makeMessage(float[] embeds) {
        if (embeds == null) {
            return this.makeMessage((Object[])null);
        }
        Object[] strs = new String[embeds.length];
        int max = strs.length;
        for (int i = 0; i < max; ++i) {
            strs[i] = Float.toString(embeds[i]);
        }
        return this.makeMessage(strs);
    }

    public String makeMessage(double[] embeds) {
        if (embeds == null) {
            return this.makeMessage((Object[])null);
        }
        Object[] strs = new String[embeds.length];
        int max = strs.length;
        for (int i = 0; i < max; ++i) {
            strs[i] = Double.toString(embeds[i]);
        }
        return this.makeMessage(strs);
    }

    public String getMessageTemplate(Locale lo) {
        return this.getMessage(lo);
    }

    public String getMessageTemplate() {
        return this.getMessageTemplate(Locale.getDefault());
    }

    public synchronized long getUsedCount() {
        return this.mUsedCount;
    }

    public synchronized void clearUsedCount() {
        this.mUsedCount = 0L;
    }

    protected synchronized void increment() {
        ++this.mUsedCount;
        this.mLastOccur = new Date();
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append(this.mMessageCode).append(";");
        ret.append(this.mMessageHash.get(C_DFAUTL_LOCALE)).append(";");
        ret.append(this.mUsedCount).append(";");
        if (this.mLastOccur == null) {
            ret.append("NONE");
        } else {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd hh-mm-ss");
            ret.append(formatter.format(this.mLastOccur));
        }
        return ret.toString();
    }

    public Date getLastUsedDate() {
        return this.mLastOccur;
    }

    public void setSecret(boolean flg) {
        this.mIsSecret = flg;
    }

    public void addMessage(String message, String locale) {
        this.mMessageHash.put(locale, message);
    }

    public void addMessage(String message) {
        this.mMessageHash.put(C_DFAUTL_LOCALE, message);
    }

    protected String getMessage(Locale lo) {
        String key;
        block7: {
            block8: {
                block9: {
                    MessageRecordFactory fac = null;
                    if (this.mFac == null && this.mFacName != null) {
                        try {
                            fac = (MessageRecordFactory)ServiceManagerFactory.getServiceObject(this.mFacName);
                        }
                        catch (ServiceNotFoundException e) {
                            return null;
                        }
                    } else {
                        fac = this.mFac;
                    }
                    fac.findLocale(lo);
                    key = (String)this.mLocaleHash.get(lo);
                    if (key != null) break block7;
                    StringBuffer propKey = new StringBuffer();
                    propKey.append(lo.getLanguage()).append(C_UNDER_SCORE).append(lo.getCountry()).append(C_UNDER_SCORE).append(lo.getVariant());
                    key = (String)this.mMessageHash.get(propKey.toString());
                    if (key != null) break block8;
                    propKey = new StringBuffer();
                    propKey.append(lo.getLanguage()).append(C_UNDER_SCORE).append(lo.getCountry());
                    key = (String)this.mMessageHash.get(propKey.toString());
                    if (key != null) break block8;
                    propKey = new StringBuffer();
                    propKey.append(lo.getLanguage());
                    key = (String)this.mMessageHash.get(propKey.toString());
                    if (key != null) break block8;
                    if (lo.equals(Locale.getDefault())) break block9;
                    Locale loDafault = Locale.getDefault();
                    propKey = new StringBuffer();
                    propKey.append(loDafault.getLanguage()).append(C_UNDER_SCORE).append(loDafault.getCountry()).append(C_UNDER_SCORE).append(loDafault.getVariant());
                    key = (String)this.mMessageHash.get(propKey.toString());
                    if (key != null) break block8;
                    propKey = new StringBuffer();
                    propKey.append(loDafault.getLanguage()).append(C_UNDER_SCORE).append(loDafault.getCountry());
                    key = (String)this.mMessageHash.get(propKey.toString());
                    if (key != null) break block8;
                    propKey = new StringBuffer();
                    propKey.append(loDafault.getLanguage());
                    key = (String)this.mMessageHash.get(propKey.toString());
                    if (key != null) break block8;
                }
                key = (String)this.mMessageHash.get(C_DFAUTL_LOCALE);
            }
            this.mLocaleHash.put(lo, key);
        }
        return key;
    }

    public void setFactory(MessageRecordFactory fac) {
        this.mFac = fac;
        if (this.mFac instanceof ServiceBase) {
            this.mFacName = ((ServiceBase)((Object)this.mFac)).getServiceNameObject();
        } else if (this.mFac instanceof Service) {
            Service service = (Service)((Object)this.mFac);
            this.mFacName = new ServiceName(service.getServiceManagerName(), service.getServiceName());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        if (this.mFacName == null && this.mFac != null) {
            out.writeObject(this.mFac);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.mFacName == null) {
            this.mFac = (MessageRecordFactory)in.readObject();
        } else {
            try {
                this.mFac = (MessageRecordFactory)ServiceManagerFactory.getServiceObject(this.mFacName);
            }
            catch (ServiceNotFoundException serviceNotFoundException) {
                // empty catch block
            }
        }
    }
}

