/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.keepalive;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ListIterator;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceBaseMBean;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.daemon.Daemon;
import jp.ossc.nimbus.daemon.DaemonControl;
import jp.ossc.nimbus.daemon.DaemonRunnable;
import jp.ossc.nimbus.service.keepalive.KeepAliveChecker;
import jp.ossc.nimbus.service.keepalive.KeepAliveDaemonServiceMBean;
import jp.ossc.nimbus.service.keepalive.QueryKeepAlive;
import jp.ossc.nimbus.service.log.Logger;
import jp.ossc.nimbus.util.CsvArrayList;

public class KeepAliveDaemonService
extends ServiceBase
implements QueryKeepAlive,
KeepAliveDaemonServiceMBean,
ServiceBaseMBean,
DaemonRunnable {
    protected Hashtable mServerTbl = new Hashtable();
    protected Boolean mSyncObj = new Boolean(true);
    protected ArrayList mCheckerList = new ArrayList();
    protected volatile long mInterval = 0L;
    protected Daemon mDaemon = new Daemon(this);
    protected volatile int mRoundRobin = 0;
    protected ServiceName mLoggerName;
    protected Logger mLogger;
    private static final String C_NAME = "Server name: ";
    private static final String C_STATUS = "status : ";
    private static final String C_RUNNING = "running";
    private static final String C_STOP = "stop";
    private static final String C_ALIVEKEY = "KEEPALIVE001";
    private static final String C_DEADKEY = "KEEPALIVE002";

    public KeepAliveDaemonService() {
        this.mDaemon.setName(this.getServiceName());
    }

    public void setLogServiceName(ServiceName serviceName) {
        this.mLoggerName = serviceName;
    }

    public ServiceName getLogServiceName() {
        return this.mLoggerName;
    }

    public void startService() {
        this.mLogger = this.mLoggerName == null ? null : (Logger)ServiceManagerFactory.getServiceObject(this.mLoggerName);
        this.mDaemon.start();
    }

    public void stopService() {
        this.mDaemon.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getKeepAliveHash() {
        Boolean bl = this.mSyncObj;
        synchronized (bl) {
            return (Hashtable)this.mServerTbl.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setChekerServiceNameAry(ServiceName[] serviceNames) {
        Boolean bl = this.mSyncObj;
        synchronized (bl) {
            this.mCheckerList.clear();
            for (int cnt = 0; cnt < serviceNames.length; ++cnt) {
                this.mCheckerList.add(serviceNames[cnt]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceName[] getChekerServiceNameAry() {
        ServiceName[] ret = null;
        Boolean bl = this.mSyncObj;
        synchronized (bl) {
            ret = new ServiceName[this.mCheckerList.size()];
            for (int cnt = 0; cnt < ret.length; ++cnt) {
                ServiceName tmpName;
                ret[cnt] = tmpName = (ServiceName)this.mCheckerList.get(cnt);
            }
        }
        return ret;
    }

    public void setIntervalMiliSecods(long miliseconds) {
        this.mInterval = miliseconds;
    }

    public long getIntervalMiliSecods() {
        return this.mInterval;
    }

    public String[] getStatusString() {
        CsvArrayList ret = new CsvArrayList();
        Hashtable keepAlive = this.getKeepAliveHash();
        Enumeration enumeration = keepAlive.keys();
        while (enumeration.hasMoreElements()) {
            String serverId = (String)enumeration.nextElement();
            String servername = C_NAME + serverId;
            String status = C_STATUS;
            status = Boolean.TRUE.equals((Boolean)keepAlive.get(serverId)) ? status + C_RUNNING : status + C_STOP;
            ret.add(servername);
            ret.add(status);
        }
        return ret.toStringAry();
    }

    public boolean onStop() {
        return true;
    }

    public boolean onSuspend() {
        return true;
    }

    public boolean onResume() {
        return true;
    }

    public Object provide(DaemonControl ctrl) throws Exception {
        Thread.sleep(this.mInterval);
        return new Object();
    }

    public void consume(Object paramObj, DaemonControl ctrl) throws Exception {
        this.onStart();
    }

    public void garbage() {
    }

    public boolean onStart() {
        ListIterator iterator = this.mCheckerList.listIterator();
        while (iterator.hasNext()) {
            ServiceName name = (ServiceName)iterator.next();
            KeepAliveChecker kac = (KeepAliveChecker)ServiceManagerFactory.getServiceObject(name);
            boolean bret = kac.isAlive();
            this.updateTblStructure(name, bret);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateTblStructure(ServiceName msid, boolean keepAlive) {
        Boolean bl = this.mSyncObj;
        synchronized (bl) {
            Boolean bret = (Boolean)this.mServerTbl.get(msid);
            if (bret != null) {
                if (!bret.booleanValue() && keepAlive && this.mLogger != null) {
                    this.mLogger.write(C_ALIVEKEY, msid);
                }
                if (bret.booleanValue() && !keepAlive && this.mLogger != null) {
                    this.mLogger.write(C_DEADKEY, msid);
                }
            }
            this.mServerTbl.put(msid, new Boolean(keepAlive));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTbl(ServiceName msid, boolean keepAlive) {
        Boolean bl = this.mSyncObj;
        synchronized (bl) {
            Boolean bret = (Boolean)this.mServerTbl.get(msid);
            if (bret != null) {
                this.updateTblStructure(msid, keepAlive);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CsvArrayList getPriolityAry() {
        CsvArrayList ret = new CsvArrayList();
        Boolean bl = this.mSyncObj;
        synchronized (bl) {
            ListIterator iterator = this.mCheckerList.listIterator();
            while (iterator.hasNext()) {
                ServiceName name = (ServiceName)iterator.next();
                Boolean bret = (Boolean)this.mServerTbl.get(name);
                if (!bret.booleanValue()) continue;
                ret.add(name);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CsvArrayList getPriolityAry(Hashtable hash) {
        Boolean bl = this.mSyncObj;
        synchronized (bl) {
            CsvArrayList ret = this.getPriolityAry();
            ListIterator iterator = ret.listIterator();
            while (iterator.hasNext()) {
                String name = (String)iterator.next();
                Object tmp = hash.get(name);
                if (tmp != null) continue;
                ret.remove(name);
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CsvArrayList getRoundrobinAry() {
        CsvArrayList ret = new CsvArrayList();
        Boolean bl = this.mSyncObj;
        synchronized (bl) {
            Boolean bret;
            ServiceName name;
            int cnt;
            for (cnt = this.mRoundRobin; cnt < this.mCheckerList.size(); ++cnt) {
                name = (ServiceName)this.mCheckerList.get(cnt);
                bret = (Boolean)this.mServerTbl.get(name);
                if (!bret.booleanValue()) continue;
                ret.add(name);
            }
            for (cnt = 0; cnt < this.mRoundRobin; ++cnt) {
                name = (ServiceName)this.mCheckerList.get(cnt);
                bret = (Boolean)this.mServerTbl.get(name);
                if (!bret.booleanValue()) continue;
                ret.add(name);
            }
            ++this.mRoundRobin;
            if (this.mCheckerList.size() <= this.mRoundRobin) {
                this.mRoundRobin = 0;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CsvArrayList getRoundrobinAry(Hashtable hash) {
        Boolean bl = this.mSyncObj;
        synchronized (bl) {
            CsvArrayList ret = this.getRoundrobinAry();
            ListIterator iterator = ret.listIterator();
            while (iterator.hasNext()) {
                ServiceName name = (ServiceName)iterator.next();
                Object tmp = hash.get(name);
                if (tmp != null) continue;
                ret.remove(name);
            }
            return ret;
        }
    }
}

