/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.jms;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.Session;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.jms.JMSConnectionCreateException;
import jp.ossc.nimbus.service.jms.JMSConnectionFactory;
import jp.ossc.nimbus.service.jms.JMSSessionCreateException;
import jp.ossc.nimbus.service.jms.JMSSessionFactoryServiceMBean;

public class JMSSessionFactoryService
extends ServiceBase
implements JMSSessionFactoryServiceMBean {
    protected ServiceName jmsConnectionFactoryServiceName;
    protected JMSConnectionFactory jmsConnectionFactory;
    protected String ackModeStr = "AUTO_ACKNOWLEDGE";
    protected int ackMode = 1;
    protected boolean transactionMode;
    protected Connection connection;
    protected boolean isConnectionCreate = true;
    protected Set sessions;
    protected boolean isStopConnection;
    protected boolean isCloseConnection;
    protected boolean isSessionManagement;

    public void setSessionManagement(boolean isManaged) {
        this.isSessionManagement = isManaged;
    }

    public boolean isSessionManagement() {
        return this.isSessionManagement;
    }

    public void setJMSConnectionFactoryServiceName(ServiceName name) {
        this.jmsConnectionFactoryServiceName = name;
    }

    public ServiceName getJMSConnectionFactoryServiceName() {
        return this.jmsConnectionFactoryServiceName;
    }

    public void setAcknowledgeMode(String mode) {
        if ("AUTO_ACKNOWLEDGE".equals(this.ackModeStr)) {
            this.ackModeStr = mode;
            this.ackMode = 1;
        } else if ("CLIENT_ACKNOWLEDGE".equals(this.ackModeStr)) {
            this.ackModeStr = mode;
            this.ackMode = 2;
        } else if ("DUPS_OK_ACKNOWLEDGE".equals(this.ackModeStr)) {
            this.ackModeStr = mode;
            this.ackMode = 3;
        } else {
            throw new IllegalArgumentException(mode);
        }
    }

    public String getAcknowledgeMode() {
        return this.ackModeStr;
    }

    public void setTransactionMode(boolean isTransacted) {
        this.transactionMode = isTransacted;
    }

    public boolean getTransactionMode() {
        return this.transactionMode;
    }

    public void setConnectionCreate(boolean isCreate) {
        this.isConnectionCreate = isCreate;
    }

    public boolean isConnectionCreate() {
        return this.isConnectionCreate;
    }

    public void setStopConnection(boolean isStop) {
        this.isStopConnection = isStop;
    }

    public boolean isStopConnection() {
        return this.isStopConnection;
    }

    public void setCloseConnection(boolean isClose) {
        this.isCloseConnection = isClose;
    }

    public boolean isCloseConnection() {
        return this.isCloseConnection;
    }

    public void createService() throws Exception {
        this.sessions = new HashSet();
    }

    public void setJmsConnectionFactory(JMSConnectionFactory jmsConnectionFactory) {
        this.jmsConnectionFactory = jmsConnectionFactory;
    }

    public void startService() throws Exception {
        if (this.jmsConnectionFactoryServiceName != null) {
            this.jmsConnectionFactory = (JMSConnectionFactory)ServiceManagerFactory.getServiceObject(this.jmsConnectionFactoryServiceName);
        }
        if (this.isConnectionCreate) {
            if (this.jmsConnectionFactory == null) {
                throw new IllegalArgumentException("jmsConnectionFactoryServiceName must be specified.");
            }
            this.connection = this.jmsConnectionFactory.getConnection();
        }
    }

    public void stopService() throws Exception {
        if (this.isStopConnection && this.connection != null) {
            try {
                this.connection.stop();
            }
            catch (JMSException e) {
                // empty catch block
            }
        }
        if (this.isCloseConnection && this.connection != null) {
            try {
                this.connection.close();
            }
            catch (JMSException e) {
                // empty catch block
            }
        }
        this.connection = null;
        if (this.sessions != null && this.sessions.size() != 0) {
            Iterator ss = this.sessions.iterator();
            while (ss.hasNext()) {
                Session s = (Session)ss.next();
                try {
                    s.close();
                }
                catch (JMSException jMSException) {}
            }
            this.sessions.clear();
        }
        this.jmsConnectionFactory = null;
    }

    public void destroyService() throws Exception {
        this.sessions = null;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public JMSConnectionFactory getConnectionFactory() {
        return this.jmsConnectionFactory;
    }

    public Session getSession() throws JMSSessionCreateException {
        Connection con = this.connection;
        if (con == null) {
            try {
                con = this.jmsConnectionFactory.getConnection();
            }
            catch (JMSConnectionCreateException e) {
                throw new JMSSessionCreateException(e);
            }
        }
        return this.getSession(con);
    }

    public Session getSession(boolean transactionMode, int ackMode) throws JMSSessionCreateException {
        Connection con = this.connection;
        if (con == null) {
            try {
                con = this.jmsConnectionFactory.getConnection();
            }
            catch (JMSConnectionCreateException e) {
                throw new JMSSessionCreateException(e);
            }
        }
        return this.getSession(con, transactionMode, ackMode);
    }

    public Session getSession(Connection con) throws JMSSessionCreateException {
        return this.getSession(con, this.transactionMode, this.ackMode);
    }

    public Session getSession(Connection con, boolean transactionMode, int ackMode) throws JMSSessionCreateException {
        try {
            Session session = con.createSession(transactionMode, ackMode);
            if (this.isSessionManagement) {
                this.sessions.add(session);
            }
            return session;
        }
        catch (JMSException e) {
            throw new JMSSessionCreateException(e);
        }
    }
}

