/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.cache;

import java.util.Iterator;
import java.util.Set;
import jp.ossc.nimbus.core.Service;
import jp.ossc.nimbus.core.ServiceFactoryServiceBase;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.cache.AbstractCacheFactoryServiceMBean;
import jp.ossc.nimbus.service.cache.AbstractCacheService;

public abstract class AbstractCacheFactoryService
extends ServiceFactoryServiceBase
implements AbstractCacheFactoryServiceMBean {
    private AbstractCacheService template;

    protected abstract AbstractCacheService createAbstractCacheService() throws Exception;

    protected Service createServiceInstance() throws Exception {
        AbstractCacheService templateCache = this.getTemplate();
        if (templateCache == null) {
            return null;
        }
        AbstractCacheService cache = this.createAbstractCacheService();
        if (cache == null) {
            return null;
        }
        cache.setOverflowControllerServiceNames(templateCache.getOverflowControllerServiceNames());
        cache.setClearOnStop(templateCache.isClearOnStop());
        cache.setClearOnDestroy(templateCache.isClearOnDestroy());
        return cache;
    }

    public void setOverflowControllerServiceNames(ServiceName[] names) {
        AbstractCacheService templateCache = this.getTemplate();
        if (templateCache == null) {
            return;
        }
        templateCache.setOverflowControllerServiceNames(names);
        Set instanceSet = this.getManagedInstanceSet();
        Iterator instances = instanceSet.iterator();
        while (instances.hasNext()) {
            AbstractCacheService cache = (AbstractCacheService)instances.next();
            cache.setOverflowControllerServiceNames(names);
        }
    }

    public ServiceName[] getOverflowControllerServiceNames() {
        AbstractCacheService templateCache = this.getTemplate();
        if (templateCache == null) {
            return null;
        }
        return templateCache.getOverflowControllerServiceNames();
    }

    public void setClearOnStop(boolean isClear) {
        AbstractCacheService templateCache = this.getTemplate();
        if (templateCache == null) {
            return;
        }
        templateCache.setClearOnStop(isClear);
        Set instanceSet = this.getManagedInstanceSet();
        Iterator instances = instanceSet.iterator();
        while (instances.hasNext()) {
            AbstractCacheService cache = (AbstractCacheService)instances.next();
            cache.setClearOnStop(isClear);
        }
    }

    public boolean isClearOnStop() {
        AbstractCacheService templateCache = this.getTemplate();
        if (templateCache == null) {
            return false;
        }
        return templateCache.isClearOnStop();
    }

    public void setClearOnDestroy(boolean isClear) {
        AbstractCacheService templateCache = this.getTemplate();
        if (templateCache == null) {
            return;
        }
        templateCache.setClearOnDestroy(isClear);
        Set instanceSet = this.getManagedInstanceSet();
        Iterator instances = instanceSet.iterator();
        while (instances.hasNext()) {
            AbstractCacheService cache = (AbstractCacheService)instances.next();
            cache.setClearOnDestroy(isClear);
        }
    }

    public boolean isClearOnDestroy() {
        AbstractCacheService templateCache = this.getTemplate();
        if (templateCache == null) {
            return false;
        }
        return templateCache.isClearOnDestroy();
    }

    public void clear() {
        Set instanceSet = this.getManagedInstanceSet();
        Iterator instances = instanceSet.iterator();
        while (instances.hasNext()) {
            AbstractCacheService cache = (AbstractCacheService)instances.next();
            cache.clear();
        }
    }

    protected synchronized AbstractCacheService getTemplate() {
        if (this.template == null) {
            try {
                this.template = this.createAbstractCacheService();
            }
            catch (Exception e) {
                return null;
            }
        }
        return this.template;
    }
}

