/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.aop.interceptor;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import jp.ossc.nimbus.core.NimbusClassLoader;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.aop.Interceptor;
import jp.ossc.nimbus.service.aop.InterceptorChain;
import jp.ossc.nimbus.service.aop.InvocationContext;
import jp.ossc.nimbus.service.aop.interceptor.ExceptionWrapInterceptorServiceMBean;
import jp.ossc.nimbus.service.message.MessageRecordFactory;
import jp.ossc.nimbus.util.ClassMappingTree;

public class ExceptionWrapInterceptorService
extends ServiceBase
implements Interceptor,
ExceptionWrapInterceptorServiceMBean {
    private static final Class[] MSG_PARAM_TYPE = new Class[]{class$java$lang$String == null ? (class$java$lang$String = ExceptionWrapInterceptorService.class$("java.lang.String")) : class$java$lang$String};
    private static final Class[] CAUSE_PARAM_TYPE = new Class[]{class$java$lang$Throwable == null ? (class$java$lang$Throwable = ExceptionWrapInterceptorService.class$("java.lang.Throwable")) : class$java$lang$Throwable};
    private static final Class[] MSG_CAUSE_PARAM_TYPE = new Class[]{class$java$lang$String == null ? (class$java$lang$String = ExceptionWrapInterceptorService.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Throwable == null ? (class$java$lang$Throwable = ExceptionWrapInterceptorService.class$("java.lang.Throwable")) : class$java$lang$Throwable};
    private Properties wrapExceptionMapping;
    private ClassMappingTree wrapExceptionMappingTree;
    private String message;
    private ServiceName messageRecordFactoryServiceName;
    private MessageRecordFactory messageRecordFactory;
    private String messageKey;
    private String[] messageArgs;
    private Locale messageLocale;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Throwable;

    public void setWrapExceptionMapping(Properties mapping) {
        this.wrapExceptionMapping = mapping;
    }

    public Properties getWrapExceptionMapping() {
        return this.wrapExceptionMapping;
    }

    public void setMessage(String msg) {
        this.message = msg;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessageRecordFactoryServiceName(ServiceName name) {
        this.messageRecordFactoryServiceName = name;
    }

    public ServiceName getMessageRecordFactoryServiceName() {
        return this.messageRecordFactoryServiceName;
    }

    public void setMessageKey(String key) {
        this.messageKey = key;
    }

    public String getMessageKey() {
        return this.messageKey;
    }

    public void setMessageArgs(String[] args) {
        this.messageArgs = args;
    }

    public String[] getMessageArgs() {
        return this.messageArgs;
    }

    public void setMessageLocale(Locale locale) {
        this.messageLocale = locale;
    }

    public Locale getMessageLocale() {
        return this.messageLocale;
    }

    public void setMessageRecordFactory(MessageRecordFactory messageRecordFactory) {
        this.messageRecordFactory = messageRecordFactory;
    }

    public void startService() throws Exception {
        if (this.wrapExceptionMapping != null) {
            if (this.wrapExceptionMappingTree == null) {
                this.wrapExceptionMappingTree = new ClassMappingTree();
            }
            NimbusClassLoader loader = NimbusClassLoader.getInstance();
            Iterator<Object> keys = this.wrapExceptionMapping.keySet().iterator();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                String val = this.wrapExceptionMapping.getProperty(key);
                this.wrapExceptionMappingTree.add(Class.forName(key, true, loader), Class.forName(val, true, loader));
            }
        }
    }

    public void stopService() throws Exception {
        if (this.wrapExceptionMappingTree != null) {
            this.wrapExceptionMappingTree.clear();
        }
    }

    private Throwable createThrowable(Throwable th) {
        if (this.wrapExceptionMappingTree == null) {
            return th;
        }
        Class wrapExceptionClass = (Class)this.wrapExceptionMappingTree.getValue(th.getClass());
        if (wrapExceptionClass == null) {
            return th;
        }
        String msg = this.createMessage();
        if (msg == null) {
            Constructor c = null;
            try {
                c = wrapExceptionClass.getConstructor(CAUSE_PARAM_TYPE);
                return (Throwable)c.newInstance(th);
            }
            catch (NoSuchMethodException e) {
            }
            catch (InstantiationException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {
                // empty catch block
            }
            try {
                c = wrapExceptionClass.getConstructor(MSG_PARAM_TYPE);
                return (Throwable)c.newInstance(th.getMessage());
            }
            catch (NoSuchMethodException e) {
            }
            catch (InstantiationException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {}
        } else {
            Constructor c = null;
            try {
                c = wrapExceptionClass.getConstructor(MSG_CAUSE_PARAM_TYPE);
                return (Throwable)c.newInstance(msg, th);
            }
            catch (NoSuchMethodException e) {
            }
            catch (InstantiationException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {
                // empty catch block
            }
            try {
                c = wrapExceptionClass.getConstructor(MSG_PARAM_TYPE);
                return (Throwable)c.newInstance(msg);
            }
            catch (NoSuchMethodException e) {
            }
            catch (InstantiationException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {
                // empty catch block
            }
        }
        try {
            return (Throwable)wrapExceptionClass.newInstance();
        }
        catch (IllegalAccessException e) {
        }
        catch (InstantiationException e) {
            // empty catch block
        }
        return th;
    }

    private String createMessage() {
        if (this.message == null) {
            if (this.messageRecordFactoryServiceName != null) {
                this.messageRecordFactory = (MessageRecordFactory)ServiceManagerFactory.getServiceObject(this.messageRecordFactoryServiceName);
            }
            MessageRecordFactory factory = this.messageRecordFactory;
            if (this.messageKey != null) {
                if (this.messageArgs == null || this.messageArgs.length == 0) {
                    if (this.messageLocale == null) {
                        return factory.findMessage(this.messageKey);
                    }
                    return factory.findMessage(this.messageLocale, this.messageKey);
                }
                if (this.messageLocale == null) {
                    return factory.findEmbedMessage(this.messageKey, this.messageArgs);
                }
                return factory.findEmbedMessage(this.messageLocale, this.messageKey, this.messageArgs);
            }
        }
        return this.message;
    }

    public Object invoke(InvocationContext context, InterceptorChain chain) throws Throwable {
        if (this.getState() == 3) {
            try {
                return chain.invokeNext(context);
            }
            catch (Throwable th) {
                throw this.createThrowable(th);
            }
        }
        return chain.invokeNext(context);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

