/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.aop.interceptor;

import java.lang.reflect.InvocationTargetException;
import java.util.Locale;
import jp.ossc.nimbus.core.NimbusClassLoader;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.aop.Interceptor;
import jp.ossc.nimbus.service.aop.InterceptorChain;
import jp.ossc.nimbus.service.aop.InvocationContext;
import jp.ossc.nimbus.service.aop.interceptor.ExceptionThrowInterceptorServiceMBean;
import jp.ossc.nimbus.service.message.MessageRecordFactory;

public class ExceptionThrowInterceptorService
extends ServiceBase
implements Interceptor,
ExceptionThrowInterceptorServiceMBean {
    private String exceptionClassName = (class$java$lang$RuntimeException == null ? (class$java$lang$RuntimeException = ExceptionThrowInterceptorService.class$("java.lang.RuntimeException")) : class$java$lang$RuntimeException).getName();
    private Throwable exception;
    private String message;
    private ServiceName messageRecordFactoryServiceName;
    private MessageRecordFactory messageRecordFactory;
    private String messageKey;
    private String[] messageArgs;
    private Locale messageLocale;
    static /* synthetic */ Class class$java$lang$RuntimeException;
    static /* synthetic */ Class class$java$lang$String;

    public void setExceptionClassName(String className) {
        this.exceptionClassName = className;
    }

    public String getExceptionClassName() {
        return this.exceptionClassName;
    }

    public void setMessage(String msg) {
        this.message = msg;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessageRecordFactoryServiceName(ServiceName name) {
        this.messageRecordFactoryServiceName = name;
    }

    public ServiceName getMessageRecordFactoryServiceName() {
        return this.messageRecordFactoryServiceName;
    }

    public void setMessageKey(String key) {
        this.messageKey = key;
    }

    public String getMessageKey() {
        return this.messageKey;
    }

    public void setMessageArgs(String[] args) {
        this.messageArgs = args;
    }

    public String[] getMessageArgs() {
        return this.messageArgs;
    }

    public void setMessageLocale(Locale locale) {
        this.messageLocale = locale;
    }

    public Locale getMessageLocale() {
        return this.messageLocale;
    }

    public void setMessageRecordFactory(MessageRecordFactory factory) {
        this.messageRecordFactory = factory;
    }

    public void setException(Throwable ex) {
        this.exception = ex;
    }

    public void startService() throws Exception {
        this.createThrowable();
    }

    private Throwable createThrowable() throws Exception {
        if (this.exception != null) {
            return this.exception;
        }
        String msg = this.createMessage();
        if (msg == null) {
            return (Throwable)Class.forName(this.exceptionClassName, true, NimbusClassLoader.getInstance()).newInstance();
        }
        try {
            return (Throwable)Class.forName(this.exceptionClassName, true, NimbusClassLoader.getInstance()).getConstructor(class$java$lang$String == null ? (class$java$lang$String = ExceptionThrowInterceptorService.class$("java.lang.String")) : class$java$lang$String).newInstance(msg);
        }
        catch (InvocationTargetException e) {
            Throwable th = e.getTargetException();
            if (th instanceof Exception) {
                throw (Exception)th;
            }
            throw (Error)th;
        }
    }

    private String createMessage() {
        if (this.message == null) {
            if (this.messageRecordFactoryServiceName != null) {
                this.messageRecordFactory = (MessageRecordFactory)ServiceManagerFactory.getServiceObject(this.messageRecordFactoryServiceName);
            }
            if (this.messageRecordFactory == null) {
                return this.message;
            }
            MessageRecordFactory factory = this.messageRecordFactory;
            if (this.messageKey != null) {
                if (this.messageArgs == null || this.messageArgs.length == 0) {
                    if (this.messageLocale == null) {
                        return factory.findMessage(this.messageKey);
                    }
                    return factory.findMessage(this.messageLocale, this.messageKey);
                }
                if (this.messageLocale == null) {
                    return factory.findEmbedMessage(this.messageKey, this.messageArgs);
                }
                return factory.findEmbedMessage(this.messageLocale, this.messageKey, this.messageArgs);
            }
        }
        return this.message;
    }

    public Object invoke(InvocationContext context, InterceptorChain chain) throws Throwable {
        if (this.getState() == 3) {
            throw this.createThrowable();
        }
        return chain.invokeNext(context);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

