/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.ioc;

import java.io.Serializable;
import java.util.ArrayList;
import jp.ossc.nimbus.ioc.Command;
import jp.ossc.nimbus.ioc.CommandBase;
import jp.ossc.nimbus.ioc.UnitOfWork;

public class UnitOfWorkImpl
implements UnitOfWork,
Serializable {
    private ArrayList mCommandAry = new ArrayList();

    public boolean isCommand() {
        return false;
    }

    public int size() {
        return this.mCommandAry.size();
    }

    public CommandBase getCommand(int index) {
        return (CommandBase)this.mCommandAry.get(index);
    }

    public int getExceptionCount() {
        int ret = 0;
        for (int rcnt = 0; rcnt < this.size(); ++rcnt) {
            CommandBase tmp = this.getCommand(rcnt);
            if (tmp == null) continue;
            if (tmp.isCommand()) {
                ret += tmp.getExceptionCount();
                continue;
            }
            UnitOfWorkImpl uow = (UnitOfWorkImpl)tmp;
            for (int ccnt = 0; ccnt < uow.size(); ++ccnt) {
                CommandBase tmp1 = uow.getCommand(ccnt);
                if (tmp1 == null) continue;
                ret += tmp1.getExceptionCount();
            }
        }
        return ret;
    }

    public Throwable[] getExceptions() {
        ArrayList<Throwable> list = new ArrayList<Throwable>();
        for (int rcnt = 0; rcnt < this.size(); ++rcnt) {
            CommandBase tmp = this.getCommand(rcnt);
            if (tmp == null) continue;
            if (tmp.isCommand()) {
                Throwable[] exp = tmp.getExceptions();
                for (int ecnt = 0; ecnt < exp.length; ++ecnt) {
                    list.add(exp[ecnt]);
                }
                continue;
            }
            UnitOfWorkImpl uow = (UnitOfWorkImpl)tmp;
            for (int ccnt = 0; ccnt < uow.size(); ++ccnt) {
                CommandBase tmp1 = uow.getCommand(ccnt);
                if (tmp1 == null) continue;
                Throwable[] exp = tmp1.getExceptions();
                for (int ecnt = 0; ecnt < exp.length; ++ecnt) {
                    list.add(exp[ecnt]);
                }
            }
        }
        Throwable[] ret = new Throwable[list.size()];
        for (int lcnt = 0; lcnt < list.size(); ++lcnt) {
            ret[lcnt] = (Throwable)list.get(lcnt);
        }
        return ret;
    }

    public Command findErrorCommand(Throwable e) {
        Command ret = null;
        for (int rcnt = 0; rcnt < this.size(); ++rcnt) {
            CommandBase tmp = this.getCommand(rcnt);
            if (tmp == null) continue;
            if (tmp.isCommand()) {
                ret = tmp.findErrorCommand(e);
                if (ret == null) continue;
                break;
            }
            UnitOfWorkImpl uow = (UnitOfWorkImpl)tmp;
            for (int ccnt = 0; ccnt < uow.size() && (ret = tmp.findErrorCommand(e)) == null; ++ccnt) {
            }
            if (ret != null) break;
        }
        return ret;
    }

    public int commandSize() {
        int ret = 0;
        for (int rcnt = 0; rcnt < this.size(); ++rcnt) {
            CommandBase tmp = this.getCommand(rcnt);
            if (tmp == null) continue;
            if (tmp.isCommand()) {
                ret += tmp.commandSize();
                continue;
            }
            UnitOfWorkImpl uow = (UnitOfWorkImpl)tmp;
            for (int ccnt = 0; ccnt < uow.size(); ++ccnt) {
                ret += tmp.commandSize();
            }
        }
        return ret;
    }

    public int commandExecuteSize() {
        int ret = 0;
        for (int rcnt = 0; rcnt < this.size(); ++rcnt) {
            CommandBase tmp = this.getCommand(rcnt);
            if (tmp == null) continue;
            if (tmp.isCommand()) {
                ret += tmp.commandExecuteSize();
                continue;
            }
            UnitOfWorkImpl uow = (UnitOfWorkImpl)tmp;
            for (int ccnt = 0; ccnt < uow.size(); ++ccnt) {
                ret += tmp.commandExecuteSize();
            }
        }
        return ret;
    }

    public int getStatus() {
        int status = -1;
        for (int rcnt = 0; rcnt < this.size(); ++rcnt) {
            CommandBase tmp = this.getCommand(rcnt);
            if (tmp == null) continue;
            if (tmp.isCommand()) {
                status = tmp.getStatus();
            } else {
                UnitOfWorkImpl uow = (UnitOfWorkImpl)tmp;
                for (int ccnt = 0; ccnt < uow.size() && (status = uow.getStatus()) != -1 && status != 1; ++ccnt) {
                }
            }
            if (status == -1 || status == 1) break;
        }
        return status;
    }

    public int unitOfWorkSize() {
        int ret = 1;
        for (int rcnt = 0; rcnt < this.size(); ++rcnt) {
            CommandBase tmp = this.getCommand(rcnt);
            if (tmp == null || tmp.isCommand()) continue;
            UnitOfWorkImpl uow = (UnitOfWorkImpl)tmp;
            for (int ccnt = 0; ccnt < uow.size(); ++ccnt) {
                ret += tmp.unitOfWorkSize();
            }
        }
        return ret;
    }

    public void addUnitOfWork(UnitOfWork uow) {
        this.mCommandAry.add(uow);
    }

    public void addCommand(Command cmd) {
        this.mCommandAry.add(cmd);
    }

    public int unitOfWorkExecuteSize() {
        int ret = 0;
        for (int rcnt = 0; rcnt < this.size(); ++rcnt) {
            CommandBase tmp = this.getCommand(rcnt);
            if (tmp == null || tmp.isCommand()) continue;
            UnitOfWorkImpl uow = (UnitOfWorkImpl)tmp;
            for (int ccnt = 0; ccnt < uow.size(); ++ccnt) {
                ret += tmp.unitOfWorkSize();
            }
        }
        return ret;
    }
}

