/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import jp.ossc.nimbus.core.ArgumentMetaData;
import jp.ossc.nimbus.core.DeploymentException;
import jp.ossc.nimbus.core.MetaData;
import jp.ossc.nimbus.core.ObjectMetaData;
import org.w3c.dom.Element;

public class ConstructorMetaData
extends MetaData
implements Serializable {
    public static final String CONSTRUCTOR_TAG_NAME = "constructor";
    protected final List arguments = new ArrayList();

    public ConstructorMetaData(ObjectMetaData parent) {
        super(parent);
    }

    public Collection getArguments() {
        return this.arguments;
    }

    public void addArgument(ArgumentMetaData arg) {
        this.arguments.add(arg);
    }

    public void importXML(Element element) throws DeploymentException {
        super.importXML(element);
        if (!element.getTagName().equals(CONSTRUCTOR_TAG_NAME)) {
            throw new DeploymentException("Tag must be constructor : " + element.getTagName());
        }
        Iterator argElements = ConstructorMetaData.getChildrenByTagName(element, "argument");
        while (argElements.hasNext()) {
            ArgumentMetaData argData = new ArgumentMetaData(this, (ObjectMetaData)this.getParent());
            argData.importXML((Element)argElements.next());
            this.addArgument(argData);
        }
    }
}

